/**
 *
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) 2016 OX Software GmbH
 * Mail: info@open-xchange.com
 *
 * @author Jan Finsel <jan.finsel@open-xchange.com>
 * @author Stefan Preuss <stefan.preuss@open-xchange.com>
 *
 */

function Accordion (maxheight, width, hover) {
	this.hover = hover;
	this.speed = 12;
	this.intervalcounts = 0;
	this.interval = 10;
	this.actualcontent = 0;
	this.components = new Object();
	this.maxheight = maxheight;
	this.width = "100%";
	if (width) {
	    this.width = width + "px";
	};
	this.container = newnode("div", { width: this.width }, 0);
}

Accordion.prototype.addComponent = function (title, node, maximumheight) {
	if (this.components[title]) {
		this.container.removeChild(this.components[title].content);
	}
	this.components[title] = { title: title, content: node, maximumheight: maximumheight };
	node.style.height = "0px";
	var height = Accordion.getHeight(node, this, maximumheight);
	this.components[title].maxheight = height;
	this.container.appendChild(node);
	this.checkHeight();
};

Accordion.prototype.checkComponentHeight = function(title) {
	if (this.components[title]) {
		this.components[title].maxheight = Accordion.getHeight(this.components[title].content, this, this.components[title].maximumheight);
		this.checkHeight();
	}
};

Accordion.prototype.removeComponent=function(title) {
	if (this.components[title]) {
		try {
			this.container.removeChild(this.components[title].content);
		} catch(e) { }
		delete this.components[title];
	}
};

Accordion.prototype.clear = function () {
	this.components = new Object();
	this.getDomNode();
};

Accordion.prototype.inTree = function () {
    try {
    	var node = this.container;
    	while (node) {
    		if (node == $("body")) { 
    		    return true;
    		}
    		node = node.parentNode;
    	}
    } catch (e) {
        return false;
    } finally {
        node = null;
    }
};

Accordion.prototype.setHover = function (hover) {
	this.hover = hover;
};

Accordion.prototype.checkHeight = function () {
	if (this.intervalcounts==0) {
		if (this.maxheight && this.maxheight < this.container.offsetHeight) {
			this.container.style.height=this.maxheight+"px";
			this.container.style.overflowX="hidden";
			this.container.style.overflowY="auto";
		} else {
			this.container.style.height="";
		}
		
		if (!this.hover) {
			if (OXAppointmentHover.actualHover) {
				OXAppointmentHover.actualHover.sizeChanged();
			}
		} else {
			this.hover.sizeChanged();
		}
	}
};

Accordion.prototype.getDomNode = function () {
    try {
    	removeChildNodes(this.container);
    	var tmpintree = this.inTree();
    	if (!tmpintree) {
    	    $("body").appendChild(this.container); 
    	}
    	for (var i in this.components) {
    		var tmp = this.components[i];
    		this.container.appendChild(tmp.content);
    		this.components[i].maxheight=Accordion.getHeight(tmp.content, this);
    		this.components[i].content.style.height = "0px";
    		tmp = null;
    	}
    	if (!tmpintree) {
    	    $("body").removeChild(this.container);
    	}
    	return this.container;
    } catch (e) {
        // ignore
    } finally {
        tmpintree = null;
    }
};

Accordion.prototype.showExtraContent = function (number) {
	var tmpcontents=(""+this.actualcontent).split(",");
	tmpcontents.push(number);
	this.showContent(tmpcontents.join(","));
};

Accordion.prototype.hideExtraContent = function (number) {
	var tmpcontents = (String(this.actualcontent)).split(",");
	for (var i=0; i < tmpcontents.length; i++) {
		if (tmpcontents[i] == number) {
			tmpcontents.splice(i,1);
			break;
		}
	}
	this.showContent(tmpcontents.join(","));
};

Accordion.prototype.showContent = function (number) {
	var Self = this;
	
	var newnumbers=(""+number).split(",");
	var oldnumbers=(""+Self.actualcontent).split(",");
	var oldobject=new Object();
	var newobject=new Object();
	for(var i=0;i<oldnumbers.length;i++) {
		oldobject[oldnumbers[i]]=true;
	}
	for(var i=0;i<newnumbers.length;i++) {
		newobject[newnumbers[i]]=true;
	}
	this.container.style.height="";
	this.container.style.overflow="";
	
	for (var i2 in Self.components) {
		if (!oldobject[i2]) {
			if(!newobject[i2]) {
				Self.components[i2].content.style.height="0px";
			} else {
				Self.setDisplay(Self.components[i2],true);
			}
		} else {
			if (!newobject[i2]) {
				Self.setDisplay(Self.components[i2],false);
			} else {
				if (Self.components[i2].content.style.height == "0px") {
					Self.setDisplay(Self.components[i2],true);
				}
			} 
		}
	} 
	Self.checkHeight();
	var newnumbers = new Array();
	for (var i in newobject) {
		newnumbers.push(i);
	}
	Self.actualcontent = newnumbers;
};

Accordion.prototype.setDisplay = function (containerobject, direction) {
	var Self = this;
	var fade = configGetKey("gui.effects.fading");
	if (direction) {
		containerobject.content.style.height = "0px";
		containerobject.content.style.display = "block";
		if (!containerobject.maxheight) {
		    containerobject.tmpheight = 0;
		} else { 
		    containerobject.tmpheight = containerobject.maxheight;
		}
		if (containerobject.interval) {
		    containerobject.interval();
		}
		Self.intervalcounts++;
		function final_cb1 () {
			if (fade) {
				containerobject.content.style.opacity = "";
				containerobject.content.style.filter = "";	// IE
			}
			if (containerobject.maximumheight && containerobject.content.offsetHeight >= containerobject.maximumheight) {
				containerobject.content.style.height = containerobject.maximumheight + "px";
			} else {
				containerobject.content.style.height = "";
			}
			containerobject.interval = null;
			Self.intervalcounts--;
			if (fade) {
				Self.checkHeight();
			}
		}
		
		if (configGetKey("gui.effects.global")) {
			containerobject.interval = animate(500, 100,
			function (curr) {
				var tmpheight = containerobject.maxheight || 0 ;
				var nextheight = Math.round(tmpheight * (curr / 100));
				if (containerobject.maximumheight && nextheight > containerobject.maximumheight) {
					nextheight = containerobject.maximumheight;
				}
				if (fade) {
					containerobject.content.style.opacity = (curr/100);
					containerobject.content.style.filter = "alpha(style=0,opacity:" +(curr)+ ")"; // IE 
				}
				containerobject.content.style.height = nextheight + "px";
			}, final_cb1);
		} else {
			if (containerobject.maximumheight && containerobject.maxheight > containerobject.maximumheight) {
				containerobject.content.style.height = containerobject.maximumheight + "px";
			}
			final_cb1();
		}
	} else {
		if (containerobject.interval) {
		    containerobject.interval();
		}
		Self.intervalcounts++;
		function final_cb2() {
			if (fade) {
				containerobject.content.style.opacity = 0;
				containerobject.content.style.filter = "alpha(style=0,opacity:" +(0)+ ")";	// IE
			}
			containerobject.content.style.height = "0px";
			containerobject.interval = null;
			Self.intervalcounts--;
			if (fade) {
				Self.checkHeight();
			}
		}
		if (configGetKey("gui.effects.global")) {
			containerobject.interval = animate(500, 100,
			function (curr) {
				var tmpheight = containerobject.maxheight || 0;
				var nextheight = Math.round(tmpheight* ((100-curr)/100));
				if (containerobject.maximumheight && containerobject.maximumheight <= nextheight) {
				    nextheight=containerobject.maximumheight;
				}
				if (fade) {
					containerobject.content.style.opacity = (curr/100);
					containerobject.content.style.filter = "alpha(style=0,opacity:" +(curr)+ ")";	// IE
				} 
				containerobject.content.style.height = nextheight+"px";
			}, final_cb2);
		} else {
			if (containerobject.maximumheight && containerobject.maxheight > containerobject.maximumheight) {
				containerobject.content.style.height = containerobject.maximumheight + "px";
			}
			final_cb2();
		}
	}
};

Accordion.getHeight = function (node, accordion, maximumheight) {
    try {
    	var tmpnode = node.cloneNode(true);
    	tmpnode.style.height = "";
    	tmpnode.style.zIndex = -1;
    	body.appendChild(tmpnode);
    	var value = tmpnode.offsetHeight;
    	if (maximumheight && value > maximumheight) {
    		node.style.overflow = "auto";
    	} else {
    		node.style.overflow = "hidden";
    	}
    	body.removeChild(tmpnode);
    	return value;
    } catch (e) {
        // ignore
    } finally {
        tmpnode = null;
    }
};

function createHoverContent (innerwidth, headerheight, borderheight, imgsizes, tabnummer) {
	var mywidth = 412;
	var innerwidthtop = 392;
	var innerwidthbottom = 392;
	if (!innerwidth) {
	    innerwidth = 400;
	}
	if (!imgsizes) { 
	    imgsizes= { t: 9 , tl: 10 , tr: 10 , r: 6, l: 6 , b: 15, bl: 10, br: 10 };
	};
	if(!headerheight) { headerheight = 9 }
	if(!borderheight) { borderheight = 15 }
	var mywidthtop=innerwidth+imgsizes.tr+imgsizes.tl;
	var returnobj=new Object();
	var coreelement = newnode("div", { position: "absolute", width: "414px", zIndex: 100000, left: "300px", top: "100px", display:"none" }, 0, [
		newnode("div", { position:"relative", width: "0px", height: "0px", whiteSpace: "nowrap"}, 0, [
			newnode("div",{ position: "absolute", top: "0px", left: "0px", width: "0px", height: "0px" }, { className : "hover-header-t" }, [
				newnode("img", 0, { src: getFullImgSrc("img/dummy.gif") })
			]),
			newnode("div",{ position:"absolute",top : "0px", left: "0px",width: "0px",height : "0px" }, { className : "hover-header-tr" }, [
				newnode("img", 0, { src: getFullImgSrc("img/dummy.gif") })
			]),
			newnode("div",{ position: "absolute",top: "0px", left: "0px", width: "0px", height: "0px" }, { className : "hover-header-tl" }, [
				newnode("img", 0, { src: getFullImgSrc("img/dummy.gif") })
			]),
			newnode("div",{ position: "absolute", left: "0px", top: "0px", width: "0px", height: "0px" }, { className : "hover-header-r" }, [
				newnode("img", 0, { src: getFullImgSrc("img/dummy.gif") })
			]),
			newnode("div",{ position: "absolute", left: "0px", top: "0px", width: "0px", height: "0px" }, { className : "hover-header-l" }, [
				newnode("img", 0, { src: getFullImgSrc("img/dummy.gif") })
			]),
			newnode("div",{ position: "absolute", left: "0px", top: "0px", width:"0px" , height: "0px" }, { className : "hover-header-color" }, [
				newnode("img", 0, { src: getFullImgSrc("img/dummy.gif") })
			])
		]),
		newnode("div", { position: "relative", overflow: "hidden", width: "414px" }, 0, [
			newnode("div", { marginLeft: (imgsizes.l +2) + "px"  , width: (innerwidth) + "px", overflow: "hidden", zIndex: "1" }, { className: "hover_background" }, [
                newnode("div", { height: "100%", width: "100%", overflow: "hidden" })
            ]),
			newnode("div",{ position: "absolute", left: "408px", top: "23px", height: "1000px", width: "8px" }, { className: "hover-body-r" },[
				newnode("img", 0, { src: getFullImgSrc("img/dummy.gif") })
			]),
			newnode("div", { position: "absolute", left: "0px", top: "23px", height: "1000px", width: "8px" }, { className: "hover-body-l" },[
				newnode("img", 0, { src: getFullImgSrc("img/dummy.gif") })
			]),
			newnode("div", { position: "absolute", top: "0px", left: "0px", width: (imgsizes.tl+"px"), height: "23px" }, { className : "hover_master_background hover-header-tab-tl_ac", id: tabnummer+"hover-tabbin-corner-l" },[
				newnode("img", 0, { src: getFullImgSrc("img/dummy.gif") })
			]),
			newnode("div",{ position:"absolute",top : "0px",left: "406px",width: "10px",height : "23px"},{ className : "hover_master_background hover-header-tab-tr", id : tabnummer+"hover-tabbin-corner-r" },[
				newnode("img", 0, { src: getFullImgSrc("img/dummy.gif") })
			])
		]),
		newnode("div",{ position: "relative", width: mywidth+"px", height: borderheight + "px" }, 0, [
			newnode("div",{ position: "absolute",left : "406px", top:borderheight-imgsizes.b+"px", width: (imgsizes.br+"px"), height: (imgsizes.b +"px") }, { className : "hover_master_background hover-bottom-br" },[
				newnode("img", 0, { src: getFullImgSrc("img/dummy.gif") })
			]),
			newnode("div",{ position: "absolute",left : "0px", top: borderheight-imgsizes.b+"px", width: (imgsizes.bl+"px"), height: (imgsizes.b +"px") }, { className : "hover_master_background hover-bottom-bl" },[
				newnode("img", 0, { src: getFullImgSrc("img/dummy.gif") })
			]),
			newnode("div",{ position: "absolute",left : "0px", top:"0px" , width: (imgsizes.bl+"px"), height: ((borderheight-imgsizes.b)+"px") }, { className : "hover-bottom-l" },[
				newnode("img", 0, { src: getFullImgSrc("img/dummy.gif") })
			]),
			newnode("div",{ position: "absolute",left : (innerwidthbottom+imgsizes.bl)+"px", top:"0px", width: (imgsizes.br+"px"), height: ((borderheight-imgsizes.b)+"px") },{ className : "hover-bottom-r" },[
				newnode("img", 0, { src: getFullImgSrc("img/dummy.gif") })
			]),
			newnode("div",{ position: "absolute", left: imgsizes.bl+ "px", top: (borderheight-imgsizes.b)+"px", width: "396px" , height: (imgsizes.b)+"px" }, { className : "hover-bottom-b" },[
				newnode("img", 0, { src: getFullImgSrc("img/dummy.gif") })
			]),
			newnode("div",{ position: "absolute", left: imgsizes.bl+ "px", top: "0px" , width:(innerwidthbottom)+"px", height: (borderheight-imgsizes.b)+"px" }, { className : "hover-bottom-color" },[
				newnode("img", 0, { src: getFullImgSrc("img/dummy.gif") })
			])
		])
	]);
 
	returnobj.node = coreelement;
	returnobj.header = coreelement.getElementsByTagName("div")[6];
	returnobj.body = coreelement.getElementsByTagName("div")[9];
	returnobj.bottom = coreelement.getElementsByTagName("div")[18];
	return returnobj;
}

/* ########################################## TABS ####################################################### */

/**
 * tab container
 * @param id {String} the id of the hover which the tab container is attached to (deprecated)
 */
function Tabbing(id) {
	// @TODO: the id is just a workaround for the 'broken by design' hover layout
	// and needs to be reviewed!
	this.id = id;
	this.tabs = new Array();
	this.selected; 
}

Tabbing.prototype = {
		
	/**
	 * returns the DOMNode containing all tabs
	 * @returns {DOMNode} the DOMNode containing all tabs
	 */
	getDOMNode: function() {
	    try {
    		var trnode = newnode("tr");
    		for (var i in this.tabs) {
    			var tdnode = this.tabs[i].getDOMNode();
    			trnode.appendChild(tdnode);
    			tnode = null;
    		}
    		trnode.appendChild(
    				newnode("td", { width : "100%" }, 
    					{ className : "tabbing_border_style" },
    					[ document.createTextNode("\u00a0")] )
    				);
    		
    		return trnode;
	    } catch (e) {
	        // ignore
	    } finally {
	        trnode = null;
	    }
	},

	/**
	 * adds a new tab with the given id
	 * @param tab {Tab} the tab
	 */
	addTab : function(tab) {
	     var self = this;
		 if (this.tabs.length == 0) {
			tab.select(true);
			this.selected = 0;
		 }
		 this.tabs.push(tab);
		 var clickHandler = function(event) {
		     self.selectTabById(event.data.id);
		 };
		 jQuery(tab.getDOMNode())
		 .click({ id: tab.id }, clickHandler);
	},
	
	/**
	 * removes a tab with the given id
	 * @param id {String} the id of the tab
	 */
	removeTab : function(id) {
		for (var i in this.tabs) {
			if (this.tabs[i].id == id) {
				this.tabs.splice(i,i);
			}
		}
	},
	
	selectTabById : function(id) {
		var pos = 0;
		// iterate through tabs and select / deselect them
		for (var i in this.tabs) {
			if (id == this.tabs[i].id) {
				this.selected = pos = i;
			}
			this.tabs[i].select(id == this.tabs[i].id);
		}
		
		// do we have to trigger a callback?
		if (this.tabs[this.selected].onShow) {
			this.tabs[this.selected].onShow();
		}
		
		// ugly hack to fix the 'broken by design' hover layout
		// hover layout needs to be reviewed (again) :-|
		if (this.selected == 0) {
			// change bg image on left corner of hover if first tab is selected
			$ALL(this.id + "hover-tabbin-corner-l").className = "hover_master_background hover-header-tab-tl_ac";
		} else {
			// change bg image on left corner of hover if first tab is selected
			$ALL(this.id + "hover-tabbin-corner-l").className = "hover_master_background hover-header-tab-tl";
			// change the bg image of the td on the left of the selected td
			this.tabs[this.selected-1].getDOMNode().className="hover_master_background tabbing_tab_inactive_left";
		}
	},
	
	/**
	 * returns the requested {Tab} tab
	 * @param id {String} the id of the tab
	 * @returns {Tab} the tab object, otherwise null
	 */
	getTabById : function(id) {
		for (var i in this.tabs) {
			if (this.tabs[i].id == id) {
				return this.tabs[i];
			}
		}	
		return null;
	}
	
};

/**
* a single tab
* @param id {String} the id of the tab
* @param title {String} the tab title
* @param onShow {function} a function called when entering the tab
*/
function Tab(id, title, onShow) {
	this.id = id;
	this.title = title;
	this.onShow = onShow;
	this.enabled = true;
	this.node = newnode("td", 0, 
			{ className : "clickable hover_master_background tabbing_tab_inactive" }, 
			[ addTranslated(title) ]);
}

Tab.prototype = {
	/**
	 * show / hide the tab
	 * @param {boolean} enabled - true shows the tab, otherwise false
	 */
	show : function(enabled) {
		this.enabled = enabled;
		this.node.style.display = this.enabled ? "" : "none";
	},
	
	/**
	 * selects / highlights the tab
	 * @param {boolean} selected - true select the tab, otherwise false
	 */
	select : function(selected) {
		this.node.className = selected ? "hover_master_background tabbing_tab_active" : "hover_master_background tabbing_tab_inactive";
	},
	
	setTitle : function(title) {
		this.node.firstChild.nodeValue = title;
	},
	
	/**
	 * returns the DOM node of the tab
	 * returns {DOMNode} the dom node of the tab
	 */
	getDOMNode : function() {
		return this.node;
	}
}
