/**
 * 
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 * 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 * 
 * Copyright (C) 2016 OX Software GmbH
 * Mail: info@open-xchange.com 
 * 
 * @author Matthias Biggeleben <matthias.biggeleben@open-xchange.com>
 * 
 */

/*jslint white: true, browser: true, devel: true, evil: true, forin: true, undef: true, eqeqeq: true, immed: true */

/*global ox, showNode, triggerEvent, configuration_askforSave, configfolder : true,
configparentfolder : true, oChangedParentFolder : true, unLoadFolderProps,
loadFolderProps */

ox.api.folder.viewProperties = function (id) {
    
    // get folder
    ox.api.folder.get({
        folder: id,
        success: function (data) {
            // show folder properties
            configuration_askforSave(function () {
                configfolder = id;
                activefolder = id;
                configparentfolder = oChangedParentFolder = -1;
                triggerEvent("OX_Switch_View", "configuration/folder/overview"); 
                unLoadFolderProps();
                loadFolderProps();
            });
        }
    });
};

ox.api.folder.exportContacts = function (id, action) {
    // download via iframe
    $("dlIframe").src = AjaxRoot + "/export?action=" + action + "&folder=" + id + "&session=" + session;
};

/**
 * Experimental collection feature on top of API
**/

(function () {

    var push = Array.prototype.push,
        slice = Array.prototype.slice,
        regReflect = /^(push|sort|slice|splice|reflect)$/;
    
    // collection class
    var col = function (arr) {
        
        // start with data?
        if (arr !== undefined) {
            this.set(arr);
        }
    };
    
    // prototype
    col.fn = col.prototype = {
        
        // get folder
        get: function (id) {
            var self = this;
            ox.api.folder.get({
                folder: id,
                success: function (data) {
                    self.set(data);
                }
            });
        },
        
        // get full objects (nice for reduced selections)
        augment: function () {
            var tmp = [], i = 0, $i = this.length, self = this;
            for (; i < $i; i++) {
                tmp.push(this[i].id);
            }
            ox.api.folder.getMultiple({
                list: tmp,
                success: function (data) {
                    // inject response
                    for (i = 0, $i = tmp.length; i < $i; i++) {
                        if (data[tmp[i]] !== undefined) {
                            self[i] = data[tmp[i]];
                        }
                    }
                }
            });
        },
        
        // get sub folders
        children: function (id) {
            var self = this;
            ox.api.folder.getSubFolders({
                folder: id,
                success: function (data) {
                    self.set(data);
                }
            });
        },
        
        length: 0,
        
        set: function (arr) {
            // get args for splice
            var args = [0, this.length].concat(arr);
            // clear, set, and get length
            Array.prototype.splice.apply(this, args);
            this.length = args.length - 2;
        },
        
        is: function (type) {
            return ox.api.folder.is(type, this);
        },
        
        can: function (action) {
            return ox.api.folder.can(action, this);
        },
        
        reflect: function () {
            var id, tmp = [];
            for (id in this.__proto__) {
                if (!regReflect.test(id)) {
                    tmp.push(id);
                }
            }
            return tmp;
        },
        
        // behave like array (inspired by jQuery)
        push: push,
        sort: [].sort,
        splice: [].splice,
        slice: slice
    };
    
    // publish
    window.FolderCollection = col;
    
}());
