/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.security;

import java.net.URI;
import java.util.Arrays;
import java.util.List;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.Configuration;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.interceptor.security.AuthenticationException;
import org.apache.cxf.interceptor.security.JAASLoginInterceptor;
import org.apache.cxf.interceptor.security.NamePasswordCallbackHandler;
import org.apache.cxf.jaxrs.ext.RequestHandler;
import org.apache.cxf.jaxrs.impl.HttpHeadersImpl;
import org.apache.cxf.jaxrs.model.ClassResourceInfo;
import org.apache.cxf.jaxrs.utils.HttpUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Message;

public class JAASAuthenticationFilter
implements RequestHandler {
    private static final List<MediaType> HTML_MEDIA_TYPES = Arrays.asList(MediaType.APPLICATION_XHTML_XML_TYPE, MediaType.TEXT_HTML_TYPE);
    private URI redirectURI;
    private String realmName;
    private boolean ignoreBasePath = true;
    private JAASLoginInterceptor interceptor = new JAASLoginInterceptor(){

        protected CallbackHandler getCallbackHandler(String name, String password) {
            return JAASAuthenticationFilter.this.getCallbackHandler(name, password);
        }
    };

    public void setIgnoreBasePath(boolean ignore) {
        this.ignoreBasePath = ignore;
    }

    public void setContextName(String name) {
        this.interceptor.setContextName(name);
    }

    public void setLoginConfig(Configuration config) {
        this.interceptor.setLoginConfig(config);
    }

    @Deprecated
    public void setRolePrefix(String name) {
        this.interceptor.setRolePrefix(name);
    }

    public void setRedirectURI(String uri) {
        this.redirectURI = URI.create(uri);
    }

    public void setRealmName(String name) {
        this.realmName = name;
    }

    protected CallbackHandler getCallbackHandler(String name, String password) {
        return new NamePasswordCallbackHandler(name, password);
    }

    public Response handleRequest(Message m, ClassResourceInfo resourceClass) {
        try {
            this.interceptor.handleMessage(m);
            return null;
        }
        catch (AuthenticationException ex) {
            return this.handleAuthenticationException(ex, m);
        }
        catch (SecurityException ex) {
            return this.handleAuthenticationException(ex, m);
        }
    }

    protected Response handleAuthenticationException(SecurityException ex, Message m) {
        HttpHeadersImpl headers = new HttpHeadersImpl(m);
        if (this.redirectURI != null && this.isRedirectPossible(headers)) {
            URI finalRedirectURI = null;
            if (!this.redirectURI.isAbsolute()) {
                int index;
                String endpointAddress = HttpUtils.getEndpointAddress(m);
                Object basePathProperty = m.get(Message.BASE_PATH);
                if (this.ignoreBasePath && basePathProperty != null && !"/".equals(basePathProperty) && (index = endpointAddress.lastIndexOf(basePathProperty.toString())) != -1) {
                    endpointAddress = endpointAddress.substring(0, index);
                }
                finalRedirectURI = UriBuilder.fromUri((String)endpointAddress).path(this.redirectURI.toString()).build(new Object[0]);
            } else {
                finalRedirectURI = this.redirectURI;
            }
            return Response.status((Response.Status)this.getRedirectStatus()).header("Location", (Object)finalRedirectURI).build();
        }
        Response.ResponseBuilder builder = Response.status((Response.Status)Response.Status.UNAUTHORIZED);
        StringBuilder sb = new StringBuilder();
        List authHeader = headers.getRequestHeader("Authorization");
        if (authHeader.size() > 0) {
            String[] authValues = StringUtils.split((String)authHeader.get(0), " ");
            if (authValues.length > 0) {
                sb.append(authValues[0]);
            }
        } else {
            sb.append("Basic");
        }
        if (this.realmName != null) {
            sb.append(' ').append(this.realmName);
        }
        builder.header("WWW-Authenticate", (Object)sb.toString());
        return builder.build();
    }

    protected Response.Status getRedirectStatus() {
        return Response.Status.TEMPORARY_REDIRECT;
    }

    protected boolean isRedirectPossible(HttpHeaders headers) {
        List clientTypes = headers.getAcceptableMediaTypes();
        return !JAXRSUtils.intersectMimeTypes(clientTypes, HTML_MEDIA_TYPES, false).isEmpty();
    }
}

