/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simplesystemsmanagement.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.simplesystemsmanagement.model.AssociationFilter;
import com.amazonaws.services.simplesystemsmanagement.model.ListAssociationsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

public class ListAssociationsRequestMarshaller
implements Marshaller<Request<ListAssociationsRequest>, ListAssociationsRequest> {
    @Override
    public Request<ListAssociationsRequest> marshall(ListAssociationsRequest listAssociationsRequest) {
        if (listAssociationsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListAssociationsRequest> request = new DefaultRequest<ListAssociationsRequest>(listAssociationsRequest, "AWSSimpleSystemsManagement");
        String target = "AmazonSSM.ListAssociations";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            ListWithAutoConstructFlag associationFilterListList = (ListWithAutoConstructFlag)listAssociationsRequest.getAssociationFilterList();
            if (!(associationFilterListList == null || associationFilterListList.isAutoConstruct() && associationFilterListList.isEmpty())) {
                jsonWriter.key("AssociationFilterList");
                jsonWriter.array();
                for (AssociationFilter associationFilterListListValue : associationFilterListList) {
                    if (associationFilterListListValue == null) continue;
                    jsonWriter.object();
                    if (associationFilterListListValue.getKey() != null) {
                        jsonWriter.key("key").value(associationFilterListListValue.getKey());
                    }
                    if (associationFilterListListValue.getValue() != null) {
                        jsonWriter.key("value").value(associationFilterListListValue.getValue());
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endArray();
            }
            if (listAssociationsRequest.getMaxResults() != null) {
                jsonWriter.key("MaxResults").value(listAssociationsRequest.getMaxResults());
            }
            if (listAssociationsRequest.getNextToken() != null) {
                jsonWriter.key("NextToken").value(listAssociationsRequest.getNextToken());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

