/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.mp4.field;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.jaudiotagger.audio.mp4.atom.Mp4BoxHeader;
import org.jaudiotagger.logging.ErrorMessage;
import org.jaudiotagger.tag.mp4.Mp4FieldKey;
import org.jaudiotagger.tag.mp4.atom.Mp4DataBox;
import org.jaudiotagger.tag.mp4.field.Mp4TagTextNumberField;
import org.jaudiotagger.tag.reference.GenreTypes;

public class Mp4GenreField
extends Mp4TagTextNumberField {
    public Mp4GenreField(String id, ByteBuffer data) throws UnsupportedEncodingException {
        super(id, data);
    }

    public static boolean isValidGenre(String genreId) {
        try {
            short genreVal = Short.parseShort(genreId);
            if (genreVal - 1 <= GenreTypes.getMaxStandardGenreId()) {
                return true;
            }
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        Integer id3GenreId = GenreTypes.getInstanceOf().getIdForValue(genreId);
        return id3GenreId != null && id3GenreId <= GenreTypes.getMaxStandardGenreId();
    }

    public Mp4GenreField(String genreId) {
        super(Mp4FieldKey.GENRE.getFieldName(), genreId);
        try {
            short genreVal = Short.parseShort(genreId);
            if (genreVal <= GenreTypes.getMaxStandardGenreId()) {
                this.numbers = new ArrayList();
                genreVal = (short)(genreVal + 1);
                this.numbers.add(genreVal);
                return;
            }
            this.numbers = new ArrayList();
            this.numbers.add((short)1);
            return;
        }
        catch (NumberFormatException nfe) {
            Integer id3GenreId = GenreTypes.getInstanceOf().getIdForValue(genreId);
            if (id3GenreId != null && id3GenreId <= GenreTypes.getMaxStandardGenreId()) {
                this.numbers = new ArrayList();
                this.numbers.add((short)(id3GenreId + 1));
                return;
            }
            this.numbers = new ArrayList();
            this.numbers.add((short)1);
            return;
        }
    }

    protected void build(ByteBuffer data) throws UnsupportedEncodingException {
        Mp4BoxHeader header = new Mp4BoxHeader(data);
        Mp4DataBox databox = new Mp4DataBox(header, data);
        this.dataSize = header.getDataLength();
        this.numbers = databox.getNumbers();
        if (this.numbers.size() > 0) {
            short genreId = (Short)this.numbers.get(0);
            this.content = GenreTypes.getInstanceOf().getValueForId(genreId - 1);
            if (this.content == null) {
                logger.warning(ErrorMessage.MP4_GENRE_OUT_OF_RANGE.getMsg(genreId));
            }
        } else {
            logger.warning(ErrorMessage.MP4_NO_GENREID_FOR_GENRE.getMsg(header.getDataLength()));
        }
    }
}

