/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.id3.framebody;

import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import org.jaudiotagger.tag.InvalidTagException;
import org.jaudiotagger.tag.datatype.NumberHashMap;
import org.jaudiotagger.tag.datatype.TextEncodedStringNullTerminated;
import org.jaudiotagger.tag.datatype.TextEncodedStringSizeTerminated;
import org.jaudiotagger.tag.id3.AbstractTagFrameBody;
import org.jaudiotagger.tag.id3.ID3TextEncodingConversion;
import org.jaudiotagger.tag.id3.framebody.AbstractFrameBodyTextInfo;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTMOO;
import org.jaudiotagger.tag.id3.framebody.ID3v23FrameBody;
import org.jaudiotagger.tag.id3.framebody.ID3v24FrameBody;

public class FrameBodyTXXX
extends AbstractFrameBodyTextInfo
implements ID3v24FrameBody,
ID3v23FrameBody {
    public static final String MUSICBRAINZ_ARTISTID = "MusicBrainz Artist Id";
    public static final String MUSICBRAINZ_ALBUM_ARTISTID = "MusicBrainz Album Artist Id";
    public static final String MUSICBRAINZ_ALBUMID = "MusicBrainz Album Id";
    public static final String MUSICBRAINZ_ORIGINAL_ALBUMID = "MusicBrainz Original Album Id";
    public static final String MUSICBRAINZ_RELEASE_GROUPID = "MusicBrainz Release Group Id";
    public static final String MUSICBRAINZ_RELEASE_TRACKID = "MusicBrainz Release Track Id";
    public static final String MUSICBRAINZ_DISCID = "MusicBrainz Disc Id";
    public static final String MUSICBRAINZ_ALBUM_TYPE = "MusicBrainz Album Type";
    public static final String MUSICBRAINZ_ALBUM_STATUS = "MusicBrainz Album Status";
    public static final String MUSICBRAINZ_ALBUM_COUNTRY = "MusicBrainz Album Release Country";
    public static final String MUSICBRAINZ_WORKID = "MusicBrainz Work Id";
    public static final String AMAZON_ASIN = "ASIN";
    public static final String MUSICIP_ID = "MusicIP PUID";
    public static final String BARCODE = "BARCODE";
    public static final String CATALOG_NO = "CATALOGNUMBER";
    public static final String MOOD = "MOOD";
    public static final String TAGS = "TAGS";
    public static final String FBPM = "FBPM";
    public static final String SCRIPT = "Script";
    public static final String ARTISTS = "ARTISTS";
    public static final String ACOUSTID_FINGERPRINT = "Acoustid Fingerprint";
    public static final String ACOUSTID_ID = "Acoustid Id";
    public static final String COUNTRY = "Country";
    public static final String ALBUM_ARTIST = "ALBUM ARTIST";
    public static final String PERFORMER = "PERFORMER";

    public FrameBodyTXXX() {
        this.setObjectValue("TextEncoding", (byte)0);
        this.setObjectValue("Description", "");
        this.setObjectValue("Text", "");
    }

    public FrameBodyTXXX(FrameBodyTMOO body) {
        this.setObjectValue("TextEncoding", body.getTextEncoding());
        this.setObjectValue("TextEncoding", (byte)0);
        this.setObjectValue("Description", MOOD);
        this.setObjectValue("Text", body.getText());
    }

    public FrameBodyTXXX(FrameBodyTXXX body) {
        super(body);
    }

    public FrameBodyTXXX(byte textEncoding, String description, String text) {
        this.setObjectValue("TextEncoding", textEncoding);
        this.setObjectValue("Description", description);
        this.setObjectValue("Text", text);
    }

    public FrameBodyTXXX(ByteBuffer byteBuffer, int frameSize) throws InvalidTagException {
        super(byteBuffer, frameSize);
    }

    public void setDescription(String description) {
        this.setObjectValue("Description", description);
    }

    public String getDescription() {
        return (String)this.getObjectValue("Description");
    }

    public String getIdentifier() {
        return "TXXX";
    }

    public void write(ByteArrayOutputStream tagBuffer) {
        this.setTextEncoding(ID3TextEncodingConversion.getTextEncoding(this.getHeader(), this.getTextEncoding()));
        if (!((TextEncodedStringNullTerminated)this.getObject("Description")).canBeEncoded()) {
            this.setTextEncoding(ID3TextEncodingConversion.getUnicodeTextEncoding(this.getHeader()));
        }
        super.write(tagBuffer);
    }

    protected void setupObjectList() {
        this.objectList.add(new NumberHashMap("TextEncoding", (AbstractTagFrameBody)this, 1));
        this.objectList.add(new TextEncodedStringNullTerminated("Description", this));
        this.objectList.add(new TextEncodedStringSizeTerminated("Text", this));
    }
}

