/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.aiff;

import java.io.IOException;
import java.io.RandomAccessFile;
import org.jaudiotagger.audio.aiff.AiffAudioHeader;
import org.jaudiotagger.audio.aiff.AiffUtil;
import org.jaudiotagger.audio.aiff.AnnotationChunk;
import org.jaudiotagger.audio.aiff.ApplicationChunk;
import org.jaudiotagger.audio.aiff.AuthorChunk;
import org.jaudiotagger.audio.aiff.Chunk;
import org.jaudiotagger.audio.aiff.ChunkHeader;
import org.jaudiotagger.audio.aiff.CommentsChunk;
import org.jaudiotagger.audio.aiff.CommonChunk;
import org.jaudiotagger.audio.aiff.CopyrightChunk;
import org.jaudiotagger.audio.aiff.FormatVersionChunk;
import org.jaudiotagger.audio.aiff.ID3Chunk;
import org.jaudiotagger.audio.aiff.NameChunk;
import org.jaudiotagger.audio.exceptions.CannotReadException;
import org.jaudiotagger.audio.generic.AudioFileReader;
import org.jaudiotagger.audio.generic.GenericAudioHeader;
import org.jaudiotagger.tag.Tag;
import org.jaudiotagger.tag.aiff.AiffTag;

public class AiffFileReader
extends AudioFileReader {
    private static final int[] sigByte = new int[]{70, 79, 82, 77};
    private AiffAudioHeader aiffHeader = new AiffAudioHeader();
    private AiffTag aiffTag = new AiffTag();

    public AiffFileReader() {
    }

    public AiffFileReader(RandomAccessFile raf) {
    }

    protected GenericAudioHeader getEncodingInfo(RandomAccessFile raf) throws CannotReadException, IOException {
        logger.finest("Reading AIFF file ");
        byte[] sigBuf = new byte[4];
        raf.read(sigBuf);
        for (int i = 0; i < 4; ++i) {
            if (sigBuf[i] == sigByte[i]) continue;
            logger.finest("AIFF file has incorrect signature");
            throw new CannotReadException("Not an AIFF file: incorrect signature");
        }
        long bytesRemaining = AiffUtil.readUINT32(raf);
        if (!this.readFileType(raf)) {
            throw new CannotReadException("Invalid AIFF file: Incorrect file type info");
        }
        bytesRemaining -= 4L;
        while (bytesRemaining > 0L && this.readChunk(raf, bytesRemaining)) {
        }
        return this.aiffHeader;
    }

    protected Tag getTag(RandomAccessFile raf) throws CannotReadException, IOException {
        logger.info("getTag called");
        return this.aiffTag;
    }

    private boolean readFileType(RandomAccessFile raf) throws IOException {
        String typ = AiffUtil.read4Chars(raf);
        if ("AIFF".equals(typ)) {
            this.aiffHeader.setFileType(AiffAudioHeader.FileType.AIFFTYPE);
            return true;
        }
        if ("AIFC".equals(typ)) {
            this.aiffHeader.setFileType(AiffAudioHeader.FileType.AIFCTYPE);
            return true;
        }
        return false;
    }

    protected boolean readChunk(RandomAccessFile raf, long bytesRemaining) throws IOException {
        Chunk chunk = null;
        ChunkHeader chunkh = new ChunkHeader();
        if (!chunkh.readHeader(raf)) {
            return false;
        }
        int chunkSize = (int)chunkh.getSize();
        bytesRemaining -= (long)(chunkSize + 8);
        String id = chunkh.getID();
        if ("FVER".equals(id)) {
            chunk = new FormatVersionChunk(chunkh, raf, this.aiffHeader);
        } else if ("APPL".equals(id)) {
            chunk = new ApplicationChunk(chunkh, raf, this.aiffHeader);
        } else if ("COMM".equals(id)) {
            chunk = new CommonChunk(chunkh, raf, this.aiffHeader);
        } else if ("COMT".equals(id)) {
            chunk = new CommentsChunk(chunkh, raf, this.aiffHeader);
        } else if ("NAME".equals(id)) {
            chunk = new NameChunk(chunkh, raf, this.aiffHeader);
        } else if ("AUTH".equals(id)) {
            chunk = new AuthorChunk(chunkh, raf, this.aiffHeader);
        } else if ("(c) ".equals(id)) {
            chunk = new CopyrightChunk(chunkh, raf, this.aiffHeader);
        } else if ("ANNO".equals(id)) {
            chunk = new AnnotationChunk(chunkh, raf, this.aiffHeader);
        } else if ("ID3 ".equals(id)) {
            chunk = new ID3Chunk(chunkh, raf, this.aiffTag);
        }
        if (chunk != null) {
            if (!((Chunk)chunk).readChunk()) {
                return false;
            }
        } else {
            raf.skipBytes(chunkSize);
        }
        if ((chunkSize & 1) != 0) {
            raf.skipBytes(1);
            --bytesRemaining;
        }
        return true;
    }
}

