/*
 * Decompiled with CFR 0.152.
 */
package ezvcard.util;

import ezvcard.Messages;
import ezvcard.util.UtcOffset;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class PartialDate {
    private static final int YEAR = 0;
    private static final int MONTH = 1;
    private static final int DATE = 2;
    private static final int HOUR = 3;
    private static final int MINUTE = 4;
    private static final int SECOND = 5;
    private static final int TIMEZONE_HOUR = 6;
    private static final int TIMEZONE_MINUTE = 7;
    private static final Format[] dateFormats = new Format[]{new Format("(\\d{4})", 0), new Format("(\\d{4})-(\\d{2})", 0, 1), new Format("(\\d{4})-?(\\d{2})-?(\\d{2})", 0, 1, 2), new Format("--(\\d{2})-?(\\d{2})", 1, 2), new Format("--(\\d{2})", 1), new Format("---(\\d{2})", 2)};
    private static final String timezoneRegex = "(([-+]\\d{1,2}):?(\\d{2})?)?";
    private static final Format[] timeFormats = new Format[]{new Format("(\\d{2})(([-+]\\d{1,2}):?(\\d{2})?)?", 3, null, 6, 7), new Format("(\\d{2}):?(\\d{2})(([-+]\\d{1,2}):?(\\d{2})?)?", 3, 4, null, 6, 7), new Format("(\\d{2}):?(\\d{2}):?(\\d{2})(([-+]\\d{1,2}):?(\\d{2})?)?", 3, 4, 5, null, 6, 7), new Format("-(\\d{2}):?(\\d{2})(([-+]\\d{1,2}):?(\\d{2})?)?", 4, 5, null, 6, 7), new Format("-(\\d{2})(([-+]\\d{1,2}):?(\\d{2})?)?", 4, null, 6, 7), new Format("--(\\d{2})(([-+]\\d{1,2}):?(\\d{2})?)?", 5, null, 6, 7)};
    private final Integer[] components;
    private final UtcOffset offset;

    private PartialDate(Integer[] components, UtcOffset offset) {
        this.components = components;
        this.offset = offset;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(PartialDate orig) {
        return new Builder(orig);
    }

    public static PartialDate parse(String string) {
        boolean success;
        String afterT;
        String beforeT;
        int t = string.indexOf(84);
        if (t < 0) {
            beforeT = string;
            afterT = null;
        } else {
            beforeT = string.substring(0, t);
            afterT = t < string.length() - 1 ? string.substring(t + 1) : null;
        }
        Builder builder = new Builder();
        if (afterT == null) {
            success = PartialDate.parseDate(beforeT, builder) || PartialDate.parseTime(beforeT, builder);
        } else if (beforeT.length() == 0) {
            success = PartialDate.parseTime(afterT, builder);
        } else {
            boolean bl = success = PartialDate.parseDate(beforeT, builder) && PartialDate.parseTime(afterT, builder);
        }
        if (!success) {
            throw Messages.INSTANCE.getIllegalArgumentException(36, string);
        }
        return builder.build();
    }

    private static boolean parseDate(String value, Builder builder) {
        return PartialDate.parseFormats(value, builder, dateFormats);
    }

    private static boolean parseTime(String value, Builder builder) {
        return PartialDate.parseFormats(value, builder, timeFormats);
    }

    private static boolean parseFormats(String value, Builder builder, Format[] formats) {
        for (Format regex : formats) {
            if (!regex.parse(builder, value)) continue;
            return true;
        }
        return false;
    }

    public Integer getYear() {
        return this.components[0];
    }

    private boolean hasYear() {
        return this.getYear() != null;
    }

    public Integer getMonth() {
        return this.components[1];
    }

    private boolean hasMonth() {
        return this.getMonth() != null;
    }

    public Integer getDate() {
        return this.components[2];
    }

    private boolean hasDate() {
        return this.getDate() != null;
    }

    public Integer getHour() {
        return this.components[3];
    }

    private boolean hasHour() {
        return this.getHour() != null;
    }

    public Integer getMinute() {
        return this.components[4];
    }

    private boolean hasMinute() {
        return this.getMinute() != null;
    }

    public Integer getSecond() {
        return this.components[5];
    }

    private boolean hasSecond() {
        return this.getSecond() != null;
    }

    public UtcOffset getUtcOffset() {
        return this.offset;
    }

    private boolean hasUtcOffset() {
        return this.offset != null;
    }

    public boolean hasDateComponent() {
        return this.hasYear() || this.hasMonth() || this.hasDate();
    }

    public boolean hasTimeComponent() {
        return this.hasHour() || this.hasMinute() || this.hasSecond();
    }

    public String toISO8601(boolean extended) {
        String dash;
        StringBuilder sb = new StringBuilder();
        DecimalFormat nf = new DecimalFormat("00");
        String yearStr = this.hasYear() ? this.getYear().toString() : null;
        String monthStr = this.hasMonth() ? nf.format(this.getMonth()) : null;
        String dateStr = this.hasDate() ? nf.format(this.getDate()) : null;
        String string = dash = extended ? "-" : "";
        if (this.hasYear() && !this.hasMonth() && !this.hasDate()) {
            sb.append(yearStr);
        } else if (!this.hasYear() && this.hasMonth() && !this.hasDate()) {
            sb.append("--").append(monthStr);
        } else if (!this.hasYear() && !this.hasMonth() && this.hasDate()) {
            sb.append("---").append(dateStr);
        } else if (this.hasYear() && this.hasMonth() && !this.hasDate()) {
            sb.append(yearStr).append("-").append(monthStr);
        } else if (!this.hasYear() && this.hasMonth() && this.hasDate()) {
            sb.append("--").append(monthStr).append(dash).append(dateStr);
        } else {
            if (this.hasYear() && !this.hasMonth() && this.hasDate()) {
                throw new IllegalStateException(Messages.INSTANCE.getExceptionMessage(38, new Object[0]));
            }
            if (this.hasYear() && this.hasMonth() && this.hasDate()) {
                sb.append(yearStr).append(dash).append(monthStr).append(dash).append(dateStr);
            }
        }
        if (this.hasTimeComponent()) {
            sb.append('T');
            String hourStr = this.hasHour() ? nf.format(this.getHour()) : null;
            String minuteStr = this.hasMinute() ? nf.format(this.getMinute()) : null;
            String secondStr = this.hasSecond() ? nf.format(this.getSecond()) : null;
            String string2 = dash = extended ? ":" : "";
            if (this.hasHour() && !this.hasMinute() && !this.hasSecond()) {
                sb.append(hourStr);
            } else if (!this.hasHour() && this.hasMinute() && !this.hasSecond()) {
                sb.append("-").append(minuteStr);
            } else if (!this.hasHour() && !this.hasMinute() && this.hasSecond()) {
                sb.append("--").append(secondStr);
            } else if (this.hasHour() && this.hasMinute() && !this.hasSecond()) {
                sb.append(hourStr).append(dash).append(minuteStr);
            } else if (!this.hasHour() && this.hasMinute() && this.hasSecond()) {
                sb.append("-").append(minuteStr).append(dash).append(secondStr);
            } else {
                if (this.hasHour() && !this.hasMinute() && this.hasSecond()) {
                    throw new IllegalStateException(Messages.INSTANCE.getExceptionMessage(39, new Object[0]));
                }
                if (this.hasHour() && this.hasMinute() && this.hasSecond()) {
                    sb.append(hourStr).append(dash).append(minuteStr).append(dash).append(secondStr);
                }
            }
            if (this.hasUtcOffset()) {
                sb.append(this.offset.toString(extended));
            }
        }
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode((Object[])this.components);
        result = 31 * result + (this.offset == null ? 0 : this.offset.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PartialDate other = (PartialDate)obj;
        if (!Arrays.equals((Object[])this.components, (Object[])other.components)) {
            return false;
        }
        return !(this.offset == null ? other.offset != null : !this.offset.equals(other.offset));
    }

    public String toString() {
        return this.toISO8601(true);
    }

    public static class Builder {
        private final Integer[] components;
        private UtcOffset offset;

        public Builder() {
            this.components = new Integer[6];
        }

        public Builder(PartialDate original) {
            this.components = Arrays.copyOf(original.components, original.components.length);
            this.offset = original.offset;
        }

        public Builder year(Integer year) {
            this.components[0] = year;
            return this;
        }

        public Builder month(Integer month) {
            if (month != null && (month < 1 || month > 12)) {
                throw Messages.INSTANCE.getIllegalArgumentException(37, "Month", 1, 12);
            }
            this.components[1] = month;
            return this;
        }

        public Builder date(Integer date) {
            if (date != null && (date < 1 || date > 31)) {
                throw Messages.INSTANCE.getIllegalArgumentException(37, "Date", 1, 31);
            }
            this.components[2] = date;
            return this;
        }

        public Builder hour(Integer hour) {
            if (hour != null && (hour < 0 || hour > 23)) {
                throw Messages.INSTANCE.getIllegalArgumentException(37, "Hour", 0, 23);
            }
            this.components[3] = hour;
            return this;
        }

        public Builder minute(Integer minute) {
            if (minute != null && (minute < 0 || minute > 59)) {
                throw Messages.INSTANCE.getIllegalArgumentException(37, "Minute", 0, 59);
            }
            this.components[4] = minute;
            return this;
        }

        public Builder second(Integer second) {
            if (second != null && (second < 0 || second > 59)) {
                throw Messages.INSTANCE.getIllegalArgumentException(37, "Second", 0, 59);
            }
            this.components[5] = second;
            return this;
        }

        public Builder offset(UtcOffset offset) {
            this.offset = offset;
            return this;
        }

        public PartialDate build() {
            if (this.components[0] != null && this.components[1] == null && this.components[2] != null) {
                throw Messages.INSTANCE.getIllegalArgumentException(38, new Object[0]);
            }
            if (this.components[3] != null && this.components[4] == null && this.components[5] != null) {
                throw Messages.INSTANCE.getIllegalArgumentException(39, new Object[0]);
            }
            return new PartialDate(this.components, this.offset);
        }
    }

    private static class Format {
        private Pattern regex;
        private Integer[] componentIndexes;

        public Format(String regex, Integer ... componentIndexes) {
            this.regex = Pattern.compile('^' + regex + '$');
            this.componentIndexes = componentIndexes;
        }

        public boolean parse(Builder builder, String value) {
            Matcher m = this.regex.matcher(value);
            if (!m.find()) {
                return false;
            }
            boolean offsetPositive = false;
            Integer offsetHour = null;
            Integer offsetMinute = null;
            for (int i = 0; i < this.componentIndexes.length; ++i) {
                int group;
                String groupStr;
                Integer index = this.componentIndexes[i];
                if (index == null || (groupStr = m.group(group = i + 1)) == null) continue;
                boolean startsWithPlus = groupStr.startsWith("+");
                if (startsWithPlus) {
                    groupStr = groupStr.substring(1);
                }
                int component = Integer.parseInt(groupStr);
                if (index == 6) {
                    offsetHour = component;
                    offsetPositive = startsWithPlus;
                    continue;
                }
                if (index == 7) {
                    offsetMinute = component;
                    continue;
                }
                ((Builder)builder).components[index.intValue()] = component;
            }
            if (offsetHour != null) {
                if (offsetMinute == null) {
                    offsetMinute = 0;
                }
                builder.offset = new UtcOffset(offsetPositive, offsetHour, offsetMinute);
            }
            return true;
        }
    }
}

