/*
 * Decompiled with CFR 0.152.
 */
package ezvcard.property;

import ezvcard.VCard;
import ezvcard.VCardVersion;
import ezvcard.Warning;
import ezvcard.parameter.Pid;
import ezvcard.parameter.TelephoneType;
import ezvcard.parameter.VCardParameters;
import ezvcard.property.HasAltId;
import ezvcard.property.VCardProperty;
import ezvcard.util.TelUri;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Telephone
extends VCardProperty
implements HasAltId {
    private String text;
    private TelUri uri;

    public Telephone(String text) {
        this.setText(text);
    }

    public Telephone(TelUri uri) {
        this.setUri(uri);
    }

    public Telephone(Telephone original) {
        super(original);
        this.text = original.text;
        this.uri = original.uri;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
        this.uri = null;
    }

    public TelUri getUri() {
        return this.uri;
    }

    public void setUri(TelUri uri) {
        this.text = null;
        this.uri = uri;
    }

    public List<TelephoneType> getTypes() {
        return new VCardParameters.TypeParameterList<TelephoneType>(this.parameters){

            @Override
            protected TelephoneType _asObject(String value) {
                return TelephoneType.get(value);
            }
        };
    }

    @Override
    public List<Pid> getPids() {
        return super.getPids();
    }

    @Override
    public Integer getPref() {
        return super.getPref();
    }

    @Override
    public void setPref(Integer pref) {
        super.setPref(pref);
    }

    @Override
    public String getAltId() {
        return this.parameters.getAltId();
    }

    @Override
    public void setAltId(String altId) {
        this.parameters.setAltId(altId);
    }

    @Override
    protected void _validate(List<Warning> warnings, VCardVersion version, VCard vcard) {
        if (this.uri == null && this.text == null) {
            warnings.add(new Warning(8, new Object[0]));
        }
        if (this.uri != null && (version == VCardVersion.V2_1 || version == VCardVersion.V3_0)) {
            warnings.add(new Warning(19, new Object[0]));
        }
        for (TelephoneType type : this.getTypes()) {
            if (type == TelephoneType.PREF || type.isSupportedBy(version)) continue;
            warnings.add(new Warning(9, type.getValue()));
        }
    }

    @Override
    protected Map<String, Object> toStringValues() {
        LinkedHashMap<String, Object> values = new LinkedHashMap<String, Object>();
        values.put("uri", this.uri);
        values.put("text", this.text);
        return values;
    }

    @Override
    public Telephone copy() {
        return new Telephone(this);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.text == null ? 0 : this.text.hashCode());
        result = 31 * result + (this.uri == null ? 0 : this.uri.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        Telephone other = (Telephone)obj;
        if (this.text == null ? other.text != null : !this.text.equals(other.text)) {
            return false;
        }
        return !(this.uri == null ? other.uri != null : !this.uri.equals(other.uri));
    }
}

