/*
 * Decompiled with CFR 0.152.
 */
package ezvcard.io.text;

import ezvcard.Messages;
import ezvcard.VCardVersion;
import ezvcard.io.text.VCardParseException;
import ezvcard.io.text.VCardRawLine;
import ezvcard.parameter.Encoding;
import ezvcard.parameter.VCardParameters;
import ezvcard.util.ClearableStringBuilder;
import ezvcard.util.StringUtils;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class VCardRawReader
implements Closeable {
    private final Reader reader;
    private final ClearableStringBuilder buffer = new ClearableStringBuilder();
    private final ClearableStringBuilder unfoldedLine = new ClearableStringBuilder();
    private final Map<String, VCardVersion> versionAliases = new HashMap<String, VCardVersion>();
    private boolean eos;
    private boolean caretDecodingEnabled;
    private VCardVersion version;
    private int prevChar;
    private int propertyLineNum;
    private int lineNum;

    public VCardRawReader(Reader reader) {
        for (VCardVersion version : VCardVersion.values()) {
            this.versionAliases.put(version.getVersion(), version);
        }
        this.eos = false;
        this.caretDecodingEnabled = true;
        this.version = VCardVersion.V2_1;
        this.prevChar = -1;
        this.propertyLineNum = 1;
        this.lineNum = 1;
        this.reader = reader;
    }

    public int getLineNumber() {
        return this.propertyLineNum;
    }

    public VCardVersion getVersion() {
        return this.version;
    }

    public VCardRawLine readLine() throws IOException {
        if (this.eos) {
            return null;
        }
        this.propertyLineNum = this.lineNum;
        this.buffer.clear();
        this.unfoldedLine.clear();
        String group = null;
        String propertyName = null;
        String curParamName = null;
        VCardParameters parameters = new VCardParameters();
        char escapeChar = '\u0000';
        boolean inQuotes = false;
        boolean inValue = false;
        boolean quotedPrintableLine = false;
        char ch = '\u0000';
        while (true) {
            char prevChar = ch;
            int read = this.nextChar();
            if (read < 0) {
                this.eos = true;
                break;
            }
            ch = (char)read;
            if (prevChar == '\r' && ch == '\n') continue;
            if (this.isNewline(ch)) {
                boolean bl = quotedPrintableLine = inValue && prevChar == '=' && this.isQuotedPrintable(parameters);
                if (quotedPrintableLine) {
                    this.buffer.chop();
                    this.unfoldedLine.chop();
                }
                ++this.lineNum;
                continue;
            }
            if (this.isNewline(prevChar)) {
                if (this.isWhitespace(ch)) continue;
                if (!quotedPrintableLine) {
                    this.prevChar = ch;
                    break;
                }
            }
            this.unfoldedLine.append(ch);
            if (inValue) {
                this.buffer.append(ch);
                continue;
            }
            if (escapeChar != '\u0000') {
                if (escapeChar == '\\') {
                    if (ch == '\\') {
                        this.buffer.append(ch);
                    } else if (ch == 'n' || ch == 'N') {
                        this.buffer.append(StringUtils.NEWLINE);
                    } else if (ch == '\"' && this.version != VCardVersion.V2_1) {
                        this.buffer.append(ch);
                    } else if (ch == ';' && this.version == VCardVersion.V2_1) {
                        this.buffer.append(ch);
                    } else {
                        this.buffer.append(escapeChar).append(ch);
                    }
                } else if (escapeChar == '^') {
                    if (ch == '^') {
                        this.buffer.append(ch);
                    } else if (ch == 'n') {
                        this.buffer.append(StringUtils.NEWLINE);
                    } else if (ch == '\'') {
                        this.buffer.append('\"');
                    } else {
                        this.buffer.append(escapeChar).append(ch);
                    }
                }
                escapeChar = '\u0000';
                continue;
            }
            if (ch == '\\' || ch == '^' && this.version != VCardVersion.V2_1 && this.caretDecodingEnabled) {
                escapeChar = ch;
                continue;
            }
            if (ch == '.' && group == null && propertyName == null) {
                group = this.buffer.getAndClear();
                continue;
            }
            if (!(ch != ';' && ch != ':' || inQuotes)) {
                if (propertyName == null) {
                    propertyName = this.buffer.getAndClear();
                } else {
                    String paramValue = this.buffer.getAndClear();
                    if (this.version == VCardVersion.V2_1) {
                        paramValue = StringUtils.ltrim(paramValue);
                    }
                    parameters.put(curParamName, paramValue);
                    curParamName = null;
                }
                if (ch != ':') continue;
                inValue = true;
                continue;
            }
            if (ch == ',' && !inQuotes && this.version != VCardVersion.V2_1) {
                parameters.put(curParamName, this.buffer.getAndClear());
                continue;
            }
            if (ch == '=' && curParamName == null) {
                String paramName = this.buffer.getAndClear();
                if (this.version == VCardVersion.V2_1) {
                    paramName = StringUtils.rtrim(paramName);
                }
                curParamName = paramName;
                continue;
            }
            if (ch == '\"' && this.version != VCardVersion.V2_1) {
                inQuotes = !inQuotes;
                continue;
            }
            this.buffer.append(ch);
        }
        if (this.unfoldedLine.length() == 0) {
            return null;
        }
        if (propertyName == null) {
            throw new VCardParseException(this.unfoldedLine.get(), this.propertyLineNum, Messages.INSTANCE.getExceptionMessage(5, new Object[0]));
        }
        String value = this.buffer.getAndClear();
        if ("VERSION".equalsIgnoreCase(propertyName)) {
            VCardVersion version = this.versionAliases.get(value);
            if (version == null) {
                throw new VCardParseException(this.unfoldedLine.get(), this.propertyLineNum, Messages.INSTANCE.getExceptionMessage(6, new Object[0]));
            }
            this.version = version;
        }
        return new VCardRawLine(group, propertyName, parameters, value);
    }

    public boolean isCaretDecodingEnabled() {
        return this.caretDecodingEnabled;
    }

    public void setCaretDecodingEnabled(boolean enable) {
        this.caretDecodingEnabled = enable;
    }

    public void setVersionAlias(String version, VCardVersion parseAccordingTo) {
        this.versionAliases.put(version, parseAccordingTo);
    }

    public Charset getEncoding() {
        if (this.reader instanceof InputStreamReader) {
            InputStreamReader isr = (InputStreamReader)this.reader;
            String charsetStr = isr.getEncoding();
            return charsetStr == null ? null : Charset.forName(charsetStr);
        }
        return null;
    }

    private int nextChar() throws IOException {
        if (this.prevChar >= 0) {
            int ch = this.prevChar;
            this.prevChar = -1;
            return ch;
        }
        return this.reader.read();
    }

    private boolean isNewline(char ch) {
        return ch == '\n' || ch == '\r';
    }

    private boolean isWhitespace(char ch) {
        return ch == ' ' || ch == '\t';
    }

    private boolean isQuotedPrintable(VCardParameters parameters) {
        if (parameters.getEncoding() == Encoding.QUOTED_PRINTABLE) {
            return true;
        }
        List namelessValues = parameters.get(null);
        for (String value : namelessValues) {
            if (!"QUOTED-PRINTABLE".equalsIgnoreCase(value)) continue;
            return true;
        }
        return false;
    }

    public void close() throws IOException {
        this.reader.close();
    }
}

