/*
 * Decompiled with CFR 0.152.
 */
package ezvcard.io.json;

import com.fasterxml.jackson.core.JsonParser;
import ezvcard.VCard;
import ezvcard.VCardDataType;
import ezvcard.VCardVersion;
import ezvcard.io.CannotParseException;
import ezvcard.io.EmbeddedVCardException;
import ezvcard.io.SkipMeException;
import ezvcard.io.StreamReader;
import ezvcard.io.json.JCardRawReader;
import ezvcard.io.json.JCardValue;
import ezvcard.io.scribe.RawPropertyScribe;
import ezvcard.io.scribe.VCardPropertyScribe;
import ezvcard.parameter.VCardParameters;
import ezvcard.property.RawProperty;
import ezvcard.property.VCardProperty;
import ezvcard.util.IOUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;

public class JCardReader
extends StreamReader {
    private final JCardRawReader reader;

    public JCardReader(String json) {
        this(new StringReader(json));
    }

    public JCardReader(InputStream in) {
        this(IOUtils.utf8Reader(in));
    }

    public JCardReader(File file) throws FileNotFoundException {
        this(new BufferedReader(IOUtils.utf8Reader(file)));
    }

    public JCardReader(Reader reader) {
        this.reader = new JCardRawReader(reader);
    }

    public JCardReader(JsonParser parser) {
        this.reader = new JCardRawReader(parser, true);
    }

    protected VCard _readNext() throws IOException {
        if (this.reader.eof()) {
            return null;
        }
        this.warnings.clear();
        JCardDataStreamListenerImpl listener = new JCardDataStreamListenerImpl();
        this.reader.readNext(listener);
        VCard vcard = listener.vcard;
        if (vcard != null && !listener.versionFound) {
            this.warnings.add(this.reader.getLineNum(), null, 29, new Object[0]);
        }
        return vcard;
    }

    public void close() throws IOException {
        this.reader.close();
    }

    private class JCardDataStreamListenerImpl
    implements JCardRawReader.JCardDataStreamListener {
        private VCard vcard = null;
        private boolean versionFound = false;

        private JCardDataStreamListenerImpl() {
        }

        public void beginVCard() {
            this.vcard = new VCard();
            this.vcard.setVersion(VCardVersion.V4_0);
        }

        public void readProperty(String group, String propertyName, VCardParameters parameters, VCardDataType dataType, JCardValue value) {
            VCardPropertyScribe.Result result;
            if ("version".equalsIgnoreCase(propertyName)) {
                this.versionFound = true;
                VCardVersion version = VCardVersion.valueOfByStr(value.asSingle());
                if (version != VCardVersion.V4_0) {
                    JCardReader.this.warnings.add(JCardReader.this.reader.getLineNum(), propertyName, 30, new Object[0]);
                }
                return;
            }
            RawPropertyScribe scribe = JCardReader.this.index.getPropertyScribe(propertyName);
            if (scribe == null) {
                scribe = new RawPropertyScribe(propertyName);
            }
            try {
                result = scribe.parseJson(value, dataType, parameters);
                for (String warning : result.getWarnings()) {
                    JCardReader.this.warnings.add(JCardReader.this.reader.getLineNum(), warning, propertyName);
                }
            }
            catch (SkipMeException e) {
                JCardReader.this.warnings.add(JCardReader.this.reader.getLineNum(), propertyName, 22, e.getMessage());
                return;
            }
            catch (CannotParseException e) {
                scribe = new RawPropertyScribe(propertyName);
                result = scribe.parseJson(value, dataType, parameters);
                Object property = result.getProperty();
                String valueStr = (String)((RawProperty)property).getValue();
                JCardReader.this.warnings.add(JCardReader.this.reader.getLineNum(), propertyName, 25, valueStr, e.getMessage());
            }
            catch (EmbeddedVCardException e) {
                JCardReader.this.warnings.add(JCardReader.this.reader.getLineNum(), propertyName, 31, new Object[0]);
                return;
            }
            Object property = result.getProperty();
            ((VCardProperty)property).setGroup(group);
            this.vcard.addProperty((VCardProperty)property);
        }
    }
}

