/*
 * Decompiled with CFR 0.152.
 */
package ezvcard.io.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import ezvcard.VCardDataType;
import ezvcard.io.json.JCardParseException;
import ezvcard.io.json.JCardValue;
import ezvcard.io.json.JsonValue;
import ezvcard.parameter.VCardParameters;
import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JCardRawReader
implements Closeable {
    private final Reader reader;
    private JsonParser parser;
    private boolean eof = false;
    private JCardDataStreamListener listener;
    private boolean strict = false;

    public JCardRawReader(Reader reader) {
        this.reader = reader;
    }

    public JCardRawReader(JsonParser parser, boolean strict) {
        this.reader = null;
        this.parser = parser;
        this.strict = strict;
    }

    public int getLineNum() {
        return this.parser == null ? 0 : this.parser.getCurrentLocation().getLineNr();
    }

    public void readNext(JCardDataStreamListener listener) throws IOException {
        JsonToken cur;
        if (this.parser == null) {
            JsonFactory factory = new JsonFactory();
            this.parser = factory.createParser(this.reader);
        } else if (this.parser.isClosed()) {
            return;
        }
        this.listener = listener;
        JsonToken prev = this.parser.getCurrentToken();
        while (!((cur = this.parser.nextToken()) == null || prev == JsonToken.START_ARRAY && cur == JsonToken.VALUE_STRING && "vcard".equals(this.parser.getValueAsString()))) {
            if (this.strict) {
                if (prev != JsonToken.START_ARRAY) {
                    throw new JCardParseException(JsonToken.START_ARRAY, prev);
                }
                if (cur != JsonToken.VALUE_STRING) {
                    throw new JCardParseException(JsonToken.VALUE_STRING, cur);
                }
                throw new JCardParseException("Invalid value for first token: expected \"vcard\" , was \"" + this.parser.getValueAsString() + "\"", JsonToken.VALUE_STRING, cur);
            }
            prev = cur;
        }
        if (cur == null) {
            this.eof = true;
            return;
        }
        listener.beginVCard();
        this.parseProperties();
        this.check(JsonToken.END_ARRAY, this.parser.nextToken());
    }

    private void parseProperties() throws IOException {
        this.checkNext(JsonToken.START_ARRAY);
        while (this.parser.nextToken() != JsonToken.END_ARRAY) {
            this.checkCurrent(JsonToken.START_ARRAY);
            this.parser.nextToken();
            this.parseProperty();
        }
    }

    private void parseProperty() throws IOException {
        this.checkCurrent(JsonToken.VALUE_STRING);
        String propertyName = this.parser.getValueAsString().toLowerCase();
        VCardParameters parameters = this.parseParameters();
        List removed = parameters.removeAll("group");
        String group = removed.isEmpty() ? null : (String)removed.get(0);
        this.checkNext(JsonToken.VALUE_STRING);
        String dataTypeStr = this.parser.getText().toLowerCase();
        VCardDataType dataType = "unknown".equals(dataTypeStr) ? null : VCardDataType.get(dataTypeStr);
        List<JsonValue> values = this.parseValues();
        JCardValue value = new JCardValue(values);
        this.listener.readProperty(group, propertyName, parameters, dataType, value);
    }

    private VCardParameters parseParameters() throws IOException {
        this.checkNext(JsonToken.START_OBJECT);
        VCardParameters parameters = new VCardParameters();
        while (this.parser.nextToken() != JsonToken.END_OBJECT) {
            String parameterName = this.parser.getText();
            if (this.parser.nextToken() == JsonToken.START_ARRAY) {
                while (this.parser.nextToken() != JsonToken.END_ARRAY) {
                    parameters.put(parameterName, this.parser.getText());
                }
                continue;
            }
            parameters.put(parameterName, this.parser.getValueAsString());
        }
        return parameters;
    }

    private List<JsonValue> parseValues() throws IOException {
        ArrayList<JsonValue> values = new ArrayList<JsonValue>();
        while (this.parser.nextToken() != JsonToken.END_ARRAY) {
            JsonValue value = this.parseValue();
            values.add(value);
        }
        return values;
    }

    private Object parseValueElement() throws IOException {
        switch (this.parser.getCurrentToken()) {
            case VALUE_FALSE: 
            case VALUE_TRUE: {
                return this.parser.getBooleanValue();
            }
            case VALUE_NUMBER_FLOAT: {
                return this.parser.getDoubleValue();
            }
            case VALUE_NUMBER_INT: {
                return this.parser.getLongValue();
            }
            case VALUE_NULL: {
                return null;
            }
        }
        return this.parser.getText();
    }

    private List<JsonValue> parseValueArray() throws IOException {
        ArrayList<JsonValue> array = new ArrayList<JsonValue>();
        while (this.parser.nextToken() != JsonToken.END_ARRAY) {
            JsonValue value = this.parseValue();
            array.add(value);
        }
        return array;
    }

    private Map<String, JsonValue> parseValueObject() throws IOException {
        HashMap<String, JsonValue> object = new HashMap<String, JsonValue>();
        while (this.parser.nextToken() != JsonToken.END_OBJECT) {
            this.checkCurrent(JsonToken.FIELD_NAME);
            String key = this.parser.getText();
            this.parser.nextToken();
            JsonValue value = this.parseValue();
            object.put(key, value);
        }
        return object;
    }

    private JsonValue parseValue() throws IOException {
        switch (this.parser.getCurrentToken()) {
            case START_ARRAY: {
                return new JsonValue(this.parseValueArray());
            }
            case START_OBJECT: {
                return new JsonValue(this.parseValueObject());
            }
        }
        return new JsonValue(this.parseValueElement());
    }

    private void checkNext(JsonToken expected) throws IOException {
        JsonToken actual = this.parser.nextToken();
        this.check(expected, actual);
    }

    private void checkCurrent(JsonToken expected) throws JCardParseException {
        JsonToken actual = this.parser.getCurrentToken();
        this.check(expected, actual);
    }

    private void check(JsonToken expected, JsonToken actual) throws JCardParseException {
        if (actual != expected) {
            throw new JCardParseException(expected, actual);
        }
    }

    public boolean eof() {
        return this.eof;
    }

    @Override
    public void close() throws IOException {
        if (this.parser != null) {
            this.parser.close();
        }
        if (this.reader != null) {
            this.reader.close();
        }
    }

    public static interface JCardDataStreamListener {
        public void beginVCard();

        public void readProperty(String var1, String var2, VCardParameters var3, VCardDataType var4, JCardValue var5);
    }
}

