/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.jvm;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Map;
import liquibase.database.DatabaseConnection;
import liquibase.exception.DatabaseException;
import liquibase.exception.UnexpectedLiquibaseException;

public class JdbcConnection
implements DatabaseConnection {
    private Connection con;

    public JdbcConnection(Connection connection) {
        this.con = connection;
    }

    @Override
    public String getDatabaseProductName() throws DatabaseException {
        try {
            return this.con.getMetaData().getDatabaseProductName();
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public String getDatabaseProductVersion() throws DatabaseException {
        try {
            return this.con.getMetaData().getDatabaseProductVersion();
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public int getDatabaseMajorVersion() throws DatabaseException {
        try {
            return this.con.getMetaData().getDatabaseMajorVersion();
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public int getDatabaseMinorVersion() throws DatabaseException {
        try {
            return this.con.getMetaData().getDatabaseMinorVersion();
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public String getURL() {
        try {
            return this.con.getMetaData().getURL();
        }
        catch (SQLException e) {
            throw new UnexpectedLiquibaseException(e);
        }
    }

    @Override
    public String getConnectionUserName() {
        try {
            return this.con.getMetaData().getUserName();
        }
        catch (SQLException e) {
            throw new UnexpectedLiquibaseException(e);
        }
    }

    public Connection getWrappedConnection() {
        return this.con;
    }

    public void clearWarnings() throws DatabaseException {
        try {
            this.con.clearWarnings();
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public void close() throws DatabaseException {
        this.rollback();
        try {
            this.con.close();
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public void commit() throws DatabaseException {
        try {
            if (!this.con.getAutoCommit()) {
                this.con.commit();
            }
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    public Statement createStatement() throws DatabaseException {
        try {
            return this.con.createStatement();
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws DatabaseException {
        try {
            return this.con.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws DatabaseException {
        try {
            return this.con.createStatement(resultSetType, resultSetConcurrency);
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public boolean getAutoCommit() throws DatabaseException {
        try {
            return this.con.getAutoCommit();
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public String getCatalog() throws DatabaseException {
        try {
            return this.con.getCatalog();
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    public int getHoldability() throws DatabaseException {
        try {
            return this.con.getHoldability();
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    public DatabaseMetaData getMetaData() throws DatabaseException {
        try {
            return this.con.getMetaData();
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    public int getTransactionIsolation() throws DatabaseException {
        try {
            return this.con.getTransactionIsolation();
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    public Map<String, Class<?>> getTypeMap() throws DatabaseException {
        try {
            return this.con.getTypeMap();
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    public SQLWarning getWarnings() throws DatabaseException {
        try {
            return this.con.getWarnings();
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public boolean isClosed() throws DatabaseException {
        try {
            return this.con.isClosed();
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    public boolean isReadOnly() throws DatabaseException {
        try {
            return this.con.isReadOnly();
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public String nativeSQL(String sql) throws DatabaseException {
        try {
            return this.con.nativeSQL(sql);
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws DatabaseException {
        try {
            return this.con.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws DatabaseException {
        try {
            return this.con.prepareCall(sql, resultSetType, resultSetConcurrency);
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    public CallableStatement prepareCall(String sql) throws DatabaseException {
        try {
            return this.con.prepareCall(sql);
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws DatabaseException {
        try {
            return this.con.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws DatabaseException {
        try {
            return this.con.prepareStatement(sql, resultSetType, resultSetConcurrency);
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws DatabaseException {
        try {
            return this.con.prepareStatement(sql, autoGeneratedKeys);
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws DatabaseException {
        try {
            return this.con.prepareStatement(sql, columnIndexes);
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws DatabaseException {
        try {
            return this.con.prepareStatement(sql, columnNames);
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    public PreparedStatement prepareStatement(String sql) throws DatabaseException {
        try {
            return this.con.prepareStatement(sql);
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    public void releaseSavepoint(Savepoint savepoint) throws DatabaseException {
        try {
            this.con.releaseSavepoint(savepoint);
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public void rollback() throws DatabaseException {
        try {
            if (!this.con.getAutoCommit() && !this.con.isClosed()) {
                this.con.rollback();
            }
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    public void rollback(Savepoint savepoint) throws DatabaseException {
        try {
            if (!this.con.getAutoCommit()) {
                this.con.rollback(savepoint);
            }
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws DatabaseException {
        try {
            this.con.setAutoCommit(autoCommit);
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    public void setCatalog(String catalog) throws DatabaseException {
        try {
            this.con.setCatalog(catalog);
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    public void setHoldability(int holdability) throws DatabaseException {
        try {
            this.con.setHoldability(holdability);
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    public void setReadOnly(boolean readOnly) throws DatabaseException {
        try {
            this.con.setReadOnly(readOnly);
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    public Savepoint setSavepoint() throws DatabaseException {
        try {
            return this.con.setSavepoint();
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    public Savepoint setSavepoint(String name) throws DatabaseException {
        try {
            return this.con.setSavepoint(name);
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    public void setTransactionIsolation(int level) throws DatabaseException {
        try {
            this.con.setTransactionIsolation(level);
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    public void setTypeMap(Map<String, Class<?>> map) throws DatabaseException {
        try {
            this.con.setTypeMap(map);
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    public Connection getUnderlyingConnection() {
        return this.con;
    }

    public boolean equals(Object obj) {
        return obj instanceof JdbcConnection && this.getUnderlyingConnection().equals(((JdbcConnection)obj).getUnderlyingConnection());
    }

    public int hashCode() {
        return this.getUnderlyingConnection().hashCode();
    }
}

