/*
 * Decompiled with CFR 0.152.
 */
package org.fishwife.jrugged.interval;

public class DiscreteInterval {
    private final long min;
    private final long max;

    public DiscreteInterval(long min, long max) {
        this.min = min;
        this.max = max;
    }

    public long getMin() {
        return this.min;
    }

    public long getMax() {
        return this.max;
    }

    public long size() {
        return this.max - this.min + 1L;
    }

    public DiscreteInterval plus(DiscreteInterval other) {
        return new DiscreteInterval(this.min + other.min, this.max + other.max);
    }

    public DiscreteInterval negate() {
        return new DiscreteInterval(-1L * this.max, -1L * this.min);
    }

    public DiscreteInterval minus(DiscreteInterval other) {
        return new DiscreteInterval(this.min - other.max, this.max - other.min);
    }

    public boolean contains(DiscreteInterval other) {
        return this.min <= other.getMin() && this.max >= other.getMax();
    }

    public String toString() {
        return "[" + this.min + "," + this.max + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.max ^ this.max >>> 32);
        result = 31 * result + (int)(this.min ^ this.min >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DiscreteInterval other = (DiscreteInterval)obj;
        if (this.max != other.max) {
            return false;
        }
        return this.min == other.min;
    }
}

