/*
 * Decompiled with CFR 0.152.
 */
package org.fishwife.jrugged;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SampledQuantile {
    private static final int NUM_WINDOW_SEGMENTS = 20;
    private static final int DEFAULT_MAX_SAMPLES = 200;
    private List<Sample> samples = new ArrayList<Sample>();
    private AtomicLong samplesSeen = new AtomicLong(0L);
    private int maxSamples = 200;
    private Long windowMillis;
    private LinkedList<Sample> windowSegments;
    Random rand = new Random();

    public SampledQuantile() {
        this(200);
    }

    public SampledQuantile(int maxSamples) {
        this.maxSamples = maxSamples;
    }

    public SampledQuantile(long windowLength, TimeUnit units) {
        this(200, windowLength, units);
    }

    public SampledQuantile(int maxSamples, long windowLength, TimeUnit units) {
        this(maxSamples, windowLength, units, System.currentTimeMillis());
    }

    SampledQuantile(int maxSamples, long windowLength, TimeUnit units, long now) {
        this.maxSamples = maxSamples;
        this.setWindowMillis(windowLength, units);
        this.windowSegments = new LinkedList();
        this.windowSegments.offer(new Sample(this.samplesSeen.get(), now));
    }

    private void setWindowMillis(long windowLength, TimeUnit units) {
        switch (units) {
            case NANOSECONDS: {
                this.windowMillis = windowLength / 1000000L;
                break;
            }
            case MICROSECONDS: {
                this.windowMillis = windowLength / 1000L;
                break;
            }
            case MILLISECONDS: {
                this.windowMillis = windowLength;
                break;
            }
            case SECONDS: {
                this.windowMillis = windowLength * 1000L;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown TimeUnit specified");
            }
        }
    }

    public long getMedian() {
        return this.getPercentile(50);
    }

    public long getPercentile(int i) {
        return this.getPercentile(i, System.currentTimeMillis());
    }

    long getPercentile(int i, long now) {
        return this.getQuantile(i, 100, now);
    }

    public long getQuantile(int k, int q) {
        return this.getQuantile(k, q, System.currentTimeMillis());
    }

    long getQuantile(int k, int q, long now) {
        if (k <= 0 || k >= q) {
            throw new QuantileOutOfBoundsException();
        }
        List<Sample> validSamples = this.getValidSamples(now);
        if (validSamples.size() == 0) {
            return 0L;
        }
        Collections.sort(validSamples);
        double targetIndex = (double)(validSamples.size() * k) / ((double)q * 1.0);
        if (validSamples.size() % 2 == 1) {
            return validSamples.get((int)((int)Math.ceil((double)targetIndex) - 1)).data;
        }
        int i0 = (int)Math.floor(targetIndex) - 1;
        return (validSamples.get((int)i0).data + validSamples.get((int)(i0 + 1)).data) / 2L;
    }

    private List<Sample> getValidSamples(long now) {
        if (this.windowMillis == null) {
            return this.samples;
        }
        long deadline = now - this.windowMillis;
        ArrayList<Sample> validSamples = new ArrayList<Sample>();
        for (Sample sample : this.samples) {
            if (sample.timestamp < deadline) continue;
            validSamples.add(sample);
        }
        return validSamples;
    }

    public int getNumSamples() {
        return this.samples.size();
    }

    public void addSample(long l) {
        this.addSample(l, System.currentTimeMillis());
    }

    private synchronized void updateWindowSegments(long now) {
        long mostRecentSegmentTimestamp;
        if (this.windowMillis == null) {
            return;
        }
        long deadline = now - this.windowMillis;
        long segmentSize = this.windowMillis / 20L;
        while (this.windowSegments.size() > 0 && this.windowSegments.peek().timestamp < deadline) {
            this.windowSegments.remove();
        }
        long l = mostRecentSegmentTimestamp = this.windowSegments.size() > 0 ? this.windowSegments.getLast().timestamp : 0L;
        if (this.windowSegments.size() == 0 || now - mostRecentSegmentTimestamp > segmentSize) {
            this.windowSegments.offer(new Sample(this.samplesSeen.get(), now));
        }
    }

    private long getEffectiveSamplesSeen() {
        if (this.windowMillis == null) {
            return this.samplesSeen.get();
        }
        return this.samplesSeen.get() - this.windowSegments.getFirst().data;
    }

    void addSample(long l, long now) {
        this.samplesSeen.getAndIncrement();
        this.updateWindowSegments(now);
        if (this.samples.size() < this.maxSamples) {
            this.samples.add(new Sample(l, now));
            return;
        }
        if (this.rand.nextDouble() < (double)this.maxSamples * 1.0 / (double)this.getEffectiveSamplesSeen()) {
            int idx = this.rand.nextInt(this.maxSamples);
            this.samples.set(idx, new Sample(l, now));
        }
    }

    public static class QuantileOutOfBoundsException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Sample
    implements Comparable<Sample> {
        public long data;
        public long timestamp;

        public Sample(long data, long timestamp) {
            this.data = data;
            this.timestamp = timestamp;
        }

        @Override
        public int compareTo(Sample other) {
            if (other.data > this.data) {
                return -1;
            }
            if (other.data < this.data) {
                return 1;
            }
            if (other.timestamp > this.timestamp) {
                return -1;
            }
            if (other.timestamp < this.timestamp) {
                return 1;
            }
            return 0;
        }
    }
}

