/*
 * Decompiled with CFR 0.152.
 */
package org.fishwife.jrugged;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.fishwife.jrugged.PerformanceMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PerformanceMonitorFactory {
    private final Map<String, PerformanceMonitor> performanceMonitorMap = new ConcurrentHashMap<String, PerformanceMonitor>();

    public synchronized PerformanceMonitor createPerformanceMonitor(String name) {
        PerformanceMonitor performanceMonitor = this.findPerformanceMonitor(name);
        if (performanceMonitor == null) {
            performanceMonitor = new PerformanceMonitor();
            this.addPerformanceMonitorToMap(name, performanceMonitor);
        }
        return performanceMonitor;
    }

    public PerformanceMonitor findPerformanceMonitor(String name) {
        return this.performanceMonitorMap.get(name);
    }

    public Set<String> getPerformanceMonitorNames() {
        return this.performanceMonitorMap.keySet();
    }

    protected void addPerformanceMonitorToMap(String name, PerformanceMonitor performanceMonitor) {
        this.performanceMonitorMap.put(name, performanceMonitor);
    }
}

