/*
 * Decompiled with CFR 0.152.
 */
package org.fishwife.jrugged;

public class MovingAverage {
    private long windowMillis;
    private long lastMillis;
    private double average;

    public MovingAverage(long windowMillis) {
        this.windowMillis = windowMillis;
    }

    public synchronized void update(double sample) {
        long now = System.currentTimeMillis();
        if (this.lastMillis == 0L) {
            this.average = sample;
            this.lastMillis = now;
            return;
        }
        long deltaTime = now - this.lastMillis;
        double coeff = Math.exp(-1.0 * ((double)deltaTime / (double)this.windowMillis));
        this.average = (1.0 - coeff) * sample + coeff * this.average;
        this.lastMillis = now;
    }

    public double getAverage() {
        return this.average;
    }
}

