/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.ipv6;

import com.googlecode.ipv6.IPv6Address;
import com.googlecode.ipv6.IPv6AddressRange;
import com.googlecode.ipv6.IPv6Network;
import com.googlecode.ipv6.IPv6NetworkMask;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.SortedSet;
import java.util.TreeSet;

public final class IPv6AddressPool
implements Serializable {
    private final IPv6AddressRange underlyingRange;
    private final SortedSet<IPv6AddressRange> freeRanges;
    private final IPv6NetworkMask allocationSubnetSize;
    private final IPv6Network lastAllocated;

    public static IPv6AddressPool fromRangeAndSubnet(IPv6AddressRange range, IPv6NetworkMask allocationSubnetSize) {
        return new IPv6AddressPool(range, allocationSubnetSize, new TreeSet<IPv6AddressRange>(Arrays.asList(range)), null);
    }

    private IPv6AddressPool(IPv6AddressRange range, IPv6NetworkMask allocationSubnetSize, SortedSet<IPv6AddressRange> freeRanges, IPv6Network lastAllocated) {
        this.underlyingRange = range;
        this.allocationSubnetSize = allocationSubnetSize;
        this.freeRanges = Collections.unmodifiableSortedSet(freeRanges);
        this.lastAllocated = lastAllocated;
        this.validateFreeRanges(this.underlyingRange, freeRanges);
        this.validateRangeIsMultipleOfSubnetsOfGivenSize(this.underlyingRange, allocationSubnetSize);
    }

    private void validateFreeRanges(IPv6AddressRange range, SortedSet<IPv6AddressRange> toValidate) {
        if (!toValidate.isEmpty() && !this.checkWithinBounds(range, toValidate)) {
            throw new IllegalArgumentException("invalid free ranges: not all within bounds of overall range");
        }
    }

    private boolean checkWithinBounds(IPv6AddressRange range, SortedSet<IPv6AddressRange> toValidate) {
        return toValidate.first().getFirst().compareTo(range.getFirst()) >= 0 && toValidate.last().getLast().compareTo(range.getLast()) <= 0;
    }

    private void validateRangeIsMultipleOfSubnetsOfGivenSize(IPv6AddressRange range, IPv6NetworkMask allocationSubnetSize) {
        int allocatableBits = 128 - allocationSubnetSize.asPrefixLength();
        if (range.getFirst().numberOfTrailingZeroes() < allocatableBits) {
            throw new IllegalArgumentException("range [" + this + "] is not aligned with prefix length [" + allocationSubnetSize.asPrefixLength() + "], " + "first address should end with " + allocatableBits + " zero bits");
        }
        if (range.getLast().numberOfTrailingOnes() < allocatableBits) {
            throw new IllegalArgumentException("range [" + this + "] is not aligned with prefix length [" + allocationSubnetSize.asPrefixLength() + "], last address should end with " + allocatableBits + " one bits");
        }
    }

    public IPv6Network getLastAllocated() {
        return this.lastAllocated;
    }

    public IPv6AddressPool allocate() {
        if (!this.isExhausted()) {
            IPv6AddressRange firstFreeRange = this.freeRanges.first();
            IPv6Network allocated = IPv6Network.fromAddressAndMask(firstFreeRange.getFirst(), this.allocationSubnetSize);
            return this.doAllocate(allocated, firstFreeRange);
        }
        return null;
    }

    public IPv6AddressPool allocate(IPv6Network toAllocate) {
        if (!this.contains(toAllocate)) {
            throw new IllegalArgumentException("can not allocate network which is not contained in the pool to allocate from [" + toAllocate + "]");
        }
        if (!this.allocationSubnetSize.equals(toAllocate.getNetmask())) {
            throw new IllegalArgumentException("can not allocate network with prefix length /" + toAllocate.getNetmask().asPrefixLength() + " from a pool configured to hand out subnets with prefix length /" + this.allocationSubnetSize);
        }
        IPv6AddressRange rangeToAllocateFrom = this.findFreeRangeContaining(toAllocate);
        if (rangeToAllocateFrom != null) {
            return this.doAllocate(toAllocate, rangeToAllocateFrom);
        }
        return null;
    }

    private IPv6AddressRange findFreeRangeContaining(IPv6Network toAllocate) {
        SortedSet<IPv6AddressRange> head = this.freeRanges.headSet(toAllocate);
        SortedSet<IPv6AddressRange> tail = this.freeRanges.tailSet(toAllocate);
        if (!head.isEmpty() && head.last().contains(toAllocate)) {
            return head.last();
        }
        if (!tail.isEmpty() && tail.first().contains(toAllocate)) {
            return tail.first();
        }
        return null;
    }

    private IPv6AddressPool doAllocate(IPv6Network toAllocate, IPv6AddressRange rangeToAllocateFrom) {
        assert (this.freeRanges.contains(rangeToAllocateFrom));
        assert (rangeToAllocateFrom.contains(toAllocate));
        TreeSet<IPv6AddressRange> newFreeRanges = new TreeSet<IPv6AddressRange>(this.freeRanges);
        newFreeRanges.remove(rangeToAllocateFrom);
        List<IPv6AddressRange> newRanges = rangeToAllocateFrom.remove(toAllocate);
        newFreeRanges.addAll(newRanges);
        return new IPv6AddressPool(this.underlyingRange, this.allocationSubnetSize, newFreeRanges, toAllocate);
    }

    public IPv6AddressPool deAllocate(IPv6Network toDeAllocate) {
        if (!this.contains(toDeAllocate)) {
            throw new IllegalArgumentException("Network to de-allocate[" + toDeAllocate + "] is not contained in this allocatable range [" + this + "]");
        }
        IPv6AddressRange freeRangeBeforeNetwork = this.findFreeRangeBefore(toDeAllocate);
        IPv6AddressRange freeRangeAfterNetwork = this.findFreeRangeAfter(toDeAllocate);
        TreeSet<IPv6AddressRange> newFreeRanges = new TreeSet<IPv6AddressRange>(this.freeRanges);
        if (freeRangeBeforeNetwork == null && freeRangeAfterNetwork == null) {
            newFreeRanges.add(toDeAllocate);
        } else if (freeRangeBeforeNetwork != null && freeRangeAfterNetwork != null) {
            newFreeRanges.remove(freeRangeBeforeNetwork);
            newFreeRanges.remove(freeRangeAfterNetwork);
            newFreeRanges.add(IPv6AddressRange.fromFirstAndLast(freeRangeBeforeNetwork.getFirst(), freeRangeAfterNetwork.getLast()));
        } else if (freeRangeBeforeNetwork != null) {
            newFreeRanges.remove(freeRangeBeforeNetwork);
            newFreeRanges.add(IPv6AddressRange.fromFirstAndLast(freeRangeBeforeNetwork.getFirst(), toDeAllocate.getLast()));
        } else {
            newFreeRanges.remove(freeRangeAfterNetwork);
            newFreeRanges.add(IPv6AddressRange.fromFirstAndLast(toDeAllocate.getFirst(), freeRangeAfterNetwork.getLast()));
        }
        return new IPv6AddressPool(this.underlyingRange, this.allocationSubnetSize, newFreeRanges, this.getLastAllocated());
    }

    private IPv6AddressRange findFreeRangeBefore(IPv6Network network) {
        for (IPv6AddressRange freeRange : this.freeRanges) {
            if (!freeRange.getLast().add(1).equals(network.getFirst())) continue;
            return freeRange;
        }
        return null;
    }

    private IPv6AddressRange findFreeRangeAfter(IPv6Network network) {
        for (IPv6AddressRange freeRange : this.freeRanges) {
            if (!freeRange.getFirst().subtract(1).equals(network.getLast())) continue;
            return freeRange;
        }
        return null;
    }

    public boolean isExhausted() {
        return this.freeRanges.isEmpty();
    }

    public boolean isFree(IPv6Network network) {
        if (network == null) {
            throw new IllegalArgumentException("network invalid [null]");
        }
        if (!this.allocationSubnetSize.equals(network.getNetmask())) {
            throw new IllegalArgumentException("network of prefix length [" + network.getNetmask().asPrefixLength() + "] can not be free in a pool which uses prefix length [" + this.allocationSubnetSize + "]");
        }
        for (IPv6AddressRange freeRange : this.freeRanges) {
            if (!freeRange.contains(network)) continue;
            return true;
        }
        return false;
    }

    public Iterable<IPv6Network> freeNetworks() {
        return new Iterable<IPv6Network>(){

            @Override
            public Iterator<IPv6Network> iterator() {
                return new Iterator<IPv6Network>(){
                    private IPv6AddressPool poolInstanceUsedForIteration;
                    {
                        this.poolInstanceUsedForIteration = IPv6AddressPool.this;
                    }

                    @Override
                    public boolean hasNext() {
                        return !this.poolInstanceUsedForIteration.isExhausted();
                    }

                    @Override
                    public IPv6Network next() {
                        if (this.hasNext()) {
                            this.poolInstanceUsedForIteration = this.poolInstanceUsedForIteration.allocate();
                            return this.poolInstanceUsedForIteration.lastAllocated;
                        }
                        throw new NoSuchElementException();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("remove not supported");
                    }
                };
            }
        };
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IPv6AddressPool that = (IPv6AddressPool)o;
        if (this.allocationSubnetSize != null ? !this.allocationSubnetSize.equals(that.allocationSubnetSize) : that.allocationSubnetSize != null) {
            return false;
        }
        if (this.freeRanges != null ? !this.freeRanges.equals(that.freeRanges) : that.freeRanges != null) {
            return false;
        }
        if (this.lastAllocated != null ? !this.lastAllocated.equals(that.lastAllocated) : that.lastAllocated != null) {
            return false;
        }
        return !(this.underlyingRange != null ? !this.underlyingRange.equals(that.underlyingRange) : that.underlyingRange != null);
    }

    public int hashCode() {
        int result = this.underlyingRange != null ? this.underlyingRange.hashCode() : 0;
        result = 31 * result + (this.freeRanges != null ? this.freeRanges.hashCode() : 0);
        result = 31 * result + (this.allocationSubnetSize != null ? this.allocationSubnetSize.hashCode() : 0);
        result = 31 * result + (this.lastAllocated != null ? this.lastAllocated.hashCode() : 0);
        return result;
    }

    public boolean contains(IPv6Address address) {
        return this.underlyingRange.contains(address);
    }

    public boolean contains(IPv6AddressRange range) {
        return this.underlyingRange.contains(range);
    }

    public boolean overlaps(IPv6AddressRange range) {
        return this.underlyingRange.overlaps(range);
    }

    public IPv6Address getFirst() {
        return this.underlyingRange.getFirst();
    }

    public IPv6Address getLast() {
        return this.underlyingRange.getLast();
    }

    public String toString() {
        return this.underlyingRange.toString();
    }

    public String toLongString() {
        return this.underlyingRange.toLongString();
    }
}

