/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.task;

import com.hazelcast.client.impl.ClientEndpointImpl;
import com.hazelcast.client.impl.ReAuthenticationOperationSupplier;
import com.hazelcast.client.impl.client.ClientPrincipal;
import com.hazelcast.client.impl.protocol.AuthenticationStatus;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.task.AbstractMultiTargetMessageTask;
import com.hazelcast.config.GroupConfig;
import com.hazelcast.core.Member;
import com.hazelcast.core.MemberLeftException;
import com.hazelcast.instance.Node;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.Connection;
import com.hazelcast.nio.ConnectionType;
import com.hazelcast.security.Credentials;
import com.hazelcast.security.SecurityContext;
import com.hazelcast.security.UsernamePasswordCredentials;
import com.hazelcast.spi.Operation;
import com.hazelcast.util.UuidUtil;
import com.hazelcast.util.function.Supplier;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;

public abstract class AuthenticationBaseMessageTask<P>
extends AbstractMultiTargetMessageTask<P> {
    protected transient ClientPrincipal principal;
    protected transient Credentials credentials;
    protected transient byte clientSerializationVersion;
    protected transient String clientVersion;
    private final List<Member> cleanedUpMembers = Collections.synchronizedList(new ArrayList());

    public AuthenticationBaseMessageTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
    }

    @Override
    protected Supplier<Operation> createOperationSupplier() {
        return new ReAuthenticationOperationSupplier(this.getUuid(), this.clientMessage.getCorrelationId());
    }

    @Override
    protected Object reduce(Map<Member, Object> map) throws Throwable {
        for (Map.Entry<Member, Object> entry : map.entrySet()) {
            Member member = entry.getKey();
            Object response = entry.getValue();
            if (response instanceof Throwable) {
                if (response instanceof MemberLeftException) {
                    this.cleanedUpMembers.add(member);
                    continue;
                }
                throw (Throwable)response;
            }
            boolean isClientDisconnectOperationRun = (Boolean)response;
            if (!isClientDisconnectOperationRun) continue;
            this.cleanedUpMembers.add(member);
        }
        return this.prepareAuthenticatedClientMessage();
    }

    @Override
    public Collection<Member> getTargets() {
        return this.clientEngine.getClusterService().getMembers();
    }

    @Override
    protected ClientEndpointImpl getEndpoint() {
        return new ClientEndpointImpl(this.clientEngine, this.connection);
    }

    @Override
    protected boolean isAuthenticationMessage() {
        return true;
    }

    @Override
    public void processMessage() throws Throwable {
        byte serializationServiceVersion = this.serializationService.getVersion();
        if (this.clientSerializationVersion != serializationServiceVersion) {
            this.sendClientMessage(this.prepareSerializationVersionMismatchClientMessage());
            return;
        }
        AuthenticationStatus authenticationStatus = this.authenticate();
        if (authenticationStatus == AuthenticationStatus.CREDENTIALS_FAILED) {
            this.sendClientMessage(this.prepareUnauthenticatedClientMessage());
            return;
        }
        if (!this.isOwnerConnection()) {
            this.prepareAndSendResponse(authenticationStatus);
            return;
        }
        String uuid = this.getUuid();
        String localMemberUUID = this.clientEngine.getThisUuid();
        this.principal = new ClientPrincipal(uuid, localMemberUUID);
        super.processMessage();
    }

    private void prepareAndSendResponse(AuthenticationStatus authenticationStatus) {
        boolean isNotMember;
        boolean bl = isNotMember = this.clientEngine.getClusterService().getMember(this.principal.getOwnerUuid()) == null;
        if (isNotMember) {
            this.logger.warning("Member having uuid " + this.principal.getOwnerUuid() + " is not part of the cluster. Client Authentication rejected.");
            authenticationStatus = AuthenticationStatus.CREDENTIALS_FAILED;
        }
        switch (authenticationStatus) {
            case AUTHENTICATED: {
                this.sendClientMessage(this.prepareAuthenticatedClientMessage());
                break;
            }
            case CREDENTIALS_FAILED: {
                this.sendClientMessage(this.prepareUnauthenticatedClientMessage());
                break;
            }
            case SERIALIZATION_VERSION_MISMATCH: {
                this.sendClientMessage(this.prepareSerializationVersionMismatchClientMessage());
                break;
            }
            default: {
                this.sendClientMessage(new IllegalStateException("Unsupported authentication status :" + (Object)((Object)authenticationStatus)));
            }
        }
    }

    private AuthenticationStatus authenticate() {
        AuthenticationStatus status;
        ILogger logger = this.clientEngine.getLogger(this.getClass());
        if (this.credentials == null) {
            status = AuthenticationStatus.CREDENTIALS_FAILED;
            logger.severe("Could not retrieve Credentials object!");
        } else if (this.clientEngine.getSecurityContext() != null) {
            status = this.authenticate(this.clientEngine.getSecurityContext());
        } else if (this.credentials instanceof UsernamePasswordCredentials) {
            UsernamePasswordCredentials usernamePasswordCredentials = (UsernamePasswordCredentials)this.credentials;
            status = this.authenticate(usernamePasswordCredentials);
        } else {
            status = AuthenticationStatus.CREDENTIALS_FAILED;
            logger.severe("Hazelcast security is disabled.\nUsernamePasswordCredentials or cluster group-name and group-password should be used for authentication!\nCurrent credentials type is: " + this.credentials.getClass().getName());
        }
        return status;
    }

    private AuthenticationStatus authenticate(SecurityContext securityContext) {
        Connection connection = this.endpoint.getConnection();
        this.credentials.setEndpoint(connection.getInetAddress().getHostAddress());
        try {
            LoginContext lc = securityContext.createClientLoginContext(this.credentials);
            lc.login();
            this.endpoint.setLoginContext(lc);
            return AuthenticationStatus.AUTHENTICATED;
        }
        catch (LoginException e) {
            this.logger.warning(e);
            return AuthenticationStatus.CREDENTIALS_FAILED;
        }
    }

    private AuthenticationStatus authenticate(UsernamePasswordCredentials credentials) {
        GroupConfig groupConfig = this.nodeEngine.getConfig().getGroupConfig();
        String nodeGroupName = groupConfig.getName();
        String nodeGroupPassword = groupConfig.getPassword();
        boolean usernameMatch = nodeGroupName.equals(credentials.getUsername());
        boolean passwordMatch = nodeGroupPassword.equals(credentials.getPassword());
        return usernameMatch && passwordMatch ? AuthenticationStatus.AUTHENTICATED : AuthenticationStatus.CREDENTIALS_FAILED;
    }

    private ClientMessage prepareUnauthenticatedClientMessage() {
        Connection connection = this.endpoint.getConnection();
        ILogger logger = this.clientEngine.getLogger(this.getClass());
        logger.log(Level.WARNING, "Received auth from " + connection + " with principal " + this.principal + " , authentication failed");
        byte status = AuthenticationStatus.CREDENTIALS_FAILED.getId();
        return this.encodeAuth(status, null, null, null, this.serializationService.getVersion(), null);
    }

    private ClientMessage prepareSerializationVersionMismatchClientMessage() {
        return this.encodeAuth(AuthenticationStatus.SERIALIZATION_VERSION_MISMATCH.getId(), null, null, null, this.serializationService.getVersion(), null);
    }

    private ClientMessage prepareAuthenticatedClientMessage() {
        Connection connection = this.endpoint.getConnection();
        ILogger logger = this.clientEngine.getLogger(this.getClass());
        this.endpoint.authenticated(this.principal, this.credentials, this.isOwnerConnection(), this.clientVersion, this.clientMessage.getCorrelationId());
        this.setConnectionType();
        logger.info("Received auth from " + connection + ", successfully authenticated" + ", principal : " + this.principal + ", owner connection : " + this.isOwnerConnection() + ", client version : " + this.clientVersion);
        if (this.endpointManager.registerEndpoint(this.endpoint)) {
            this.clientEngine.bind(this.endpoint);
        }
        Address thisAddress = this.clientEngine.getThisAddress();
        byte status = AuthenticationStatus.AUTHENTICATED.getId();
        return this.encodeAuth(status, thisAddress, this.principal.getUuid(), this.principal.getOwnerUuid(), this.serializationService.getVersion(), this.cleanedUpMembers);
    }

    private void setConnectionType() {
        String type = this.getClientType();
        if ("JVM".equals(type)) {
            this.connection.setType(ConnectionType.JAVA_CLIENT);
        } else if ("CSP".equals(type)) {
            this.connection.setType(ConnectionType.CSHARP_CLIENT);
        } else if ("CPP".equals(type)) {
            this.connection.setType(ConnectionType.CPP_CLIENT);
        } else if ("PYH".equals(type)) {
            this.connection.setType(ConnectionType.PYTHON_CLIENT);
        } else if ("RBY".equals(type)) {
            this.connection.setType(ConnectionType.RUBY_CLIENT);
        } else if ("NJS".equals(type)) {
            this.connection.setType(ConnectionType.NODEJS_CLIENT);
        } else {
            this.clientEngine.getLogger(this.getClass()).info("Unknown client type: " + type);
            this.connection.setType(ConnectionType.BINARY_CLIENT);
        }
    }

    protected abstract ClientMessage encodeAuth(byte var1, Address var2, String var3, String var4, byte var5, List<Member> var6);

    protected abstract boolean isOwnerConnection();

    protected abstract String getClientType();

    private String getUuid() {
        if (this.principal != null) {
            return this.principal.getUuid();
        }
        return UuidUtil.createClientUuid(this.endpoint.getConnection().getEndPoint());
    }

    @Override
    public Permission getRequiredPermission() {
        return null;
    }
}

