/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi.impl.operationservice.impl;

import com.hazelcast.instance.Node;
import com.hazelcast.internal.partition.InternalPartition;
import com.hazelcast.internal.partition.InternalPartitionService;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.BackupAwareOperation;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.OperationAccessor;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.impl.operationservice.impl.BackpressureRegulator;
import com.hazelcast.spi.impl.operationservice.impl.OperationServiceImpl;
import com.hazelcast.spi.impl.operationservice.impl.operations.Backup;

final class OperationBackupHandler {
    private final Node node;
    private final OperationServiceImpl operationService;
    private final NodeEngineImpl nodeEngine;
    private final BackpressureRegulator backpressureRegulator;

    OperationBackupHandler(OperationServiceImpl operationService) {
        this.operationService = operationService;
        this.node = operationService.node;
        this.nodeEngine = operationService.nodeEngine;
        this.backpressureRegulator = operationService.backpressureRegulator;
    }

    public int backup(BackupAwareOperation backupAwareOp) throws Exception {
        int requestedSyncBackups = this.requestedSyncBackups(backupAwareOp);
        int requestedAsyncBackups = this.requestedAsyncBackups(backupAwareOp);
        int requestedTotalBackups = this.requestedTotalBackups(backupAwareOp);
        if (requestedTotalBackups == 0) {
            return 0;
        }
        Operation op = (Operation)((Object)backupAwareOp);
        InternalPartitionService partitionService = this.node.getPartitionService();
        long[] replicaVersions = partitionService.incrementPartitionReplicaVersions(op.getPartitionId(), requestedTotalBackups);
        boolean syncForced = this.backpressureRegulator.isSyncForced(backupAwareOp);
        int syncBackups = this.syncBackups(requestedSyncBackups, requestedAsyncBackups, syncForced);
        int asyncBackups = this.asyncBackups(requestedSyncBackups, requestedAsyncBackups, syncForced);
        if (!op.returnsResponse()) {
            asyncBackups += syncBackups;
            syncBackups = 0;
        }
        if (syncBackups + asyncBackups == 0) {
            return 0;
        }
        return this.makeBackups(backupAwareOp, op.getPartitionId(), replicaVersions, syncBackups, asyncBackups);
    }

    int syncBackups(int requestedSyncBackups, int requestedAsyncBackups, boolean syncForced) {
        if (syncForced) {
            requestedSyncBackups += requestedAsyncBackups;
        }
        InternalPartitionService partitionService = this.node.getPartitionService();
        int maxBackupCount = partitionService.getMaxAllowedBackupCount();
        return Math.min(maxBackupCount, requestedSyncBackups);
    }

    int asyncBackups(int requestedSyncBackups, int requestedAsyncBackups, boolean syncForced) {
        if (syncForced || requestedAsyncBackups == 0) {
            return 0;
        }
        InternalPartitionService partitionService = this.node.getPartitionService();
        int maxBackupCount = partitionService.getMaxAllowedBackupCount();
        return Math.min(maxBackupCount - requestedSyncBackups, requestedAsyncBackups);
    }

    private int requestedSyncBackups(BackupAwareOperation op) {
        int backups = op.getSyncBackupCount();
        if (backups < 0) {
            throw new IllegalArgumentException("Can't create backup for Operation:" + op + ", sync backup count can't be smaller than 0, but found: " + backups);
        }
        if (backups > 6) {
            throw new IllegalArgumentException("Can't create backup for Operation:" + op + ", sync backup count can't be larger than " + 6 + ", but found: " + backups);
        }
        return backups;
    }

    private int requestedAsyncBackups(BackupAwareOperation op) {
        int backups = op.getAsyncBackupCount();
        if (backups < 0) {
            throw new IllegalArgumentException("Can't create backup for Operation:" + op + ", async backup count can't be smaller than 0, but found: " + backups);
        }
        if (backups > 6) {
            throw new IllegalArgumentException("Can't create backup for Operation:" + op + ", async backup count can't be larger than " + 6 + ", but found: " + backups);
        }
        return backups;
    }

    private int requestedTotalBackups(BackupAwareOperation op) {
        int backups = op.getSyncBackupCount() + op.getAsyncBackupCount();
        if (backups > 6) {
            throw new IllegalArgumentException("Can't create backup for Operation:" + op + ", the sum of async and sync backups is larger than " + 6 + ", sync backup count is " + op.getSyncBackupCount() + ", async backup count is " + op.getAsyncBackupCount());
        }
        return backups;
    }

    private int makeBackups(BackupAwareOperation backupAwareOp, int partitionId, long[] replicaVersions, int syncBackups, int asyncBackups) {
        int totalBackups = syncBackups + asyncBackups;
        InternalPartitionService partitionService = this.node.getPartitionService();
        InternalPartition partition = partitionService.getPartition(partitionId);
        int sendSyncBackups = totalBackups == 1 ? this.sendSingleBackup(backupAwareOp, partition, replicaVersions, syncBackups) : this.sendMultipleBackups(backupAwareOp, partition, replicaVersions, syncBackups, totalBackups);
        return sendSyncBackups;
    }

    private int sendSingleBackup(BackupAwareOperation backupAwareOp, InternalPartition partition, long[] replicaVersions, int syncBackups) {
        Address target = partition.getReplicaAddress(1);
        if (target != null) {
            Operation backupOp = this.getBackupOperation(backupAwareOp);
            this.assertNoBackupOnPrimaryMember(partition, target);
            boolean isSyncBackup = syncBackups == 1;
            Backup backup = this.newBackup(backupAwareOp, backupOp, replicaVersions, 1, isSyncBackup);
            this.operationService.send(backup, target);
            if (isSyncBackup) {
                return 1;
            }
        }
        return 0;
    }

    private int sendMultipleBackups(BackupAwareOperation backupAwareOp, InternalPartition partition, long[] replicaVersions, int syncBackups, int totalBackups) {
        int sendSyncBackups = 0;
        Operation backupOp = this.getBackupOperation(backupAwareOp);
        Object backupOpData = this.nodeEngine.getSerializationService().toData(backupOp);
        for (int replicaIndex = 1; replicaIndex <= totalBackups; ++replicaIndex) {
            Address target = partition.getReplicaAddress(replicaIndex);
            if (target == null) continue;
            this.assertNoBackupOnPrimaryMember(partition, target);
            boolean isSyncBackup = replicaIndex <= syncBackups;
            Backup backup = this.newBackup(backupAwareOp, backupOpData, replicaVersions, replicaIndex, isSyncBackup);
            this.operationService.send(backup, target);
            if (!isSyncBackup) continue;
            ++sendSyncBackups;
        }
        return sendSyncBackups;
    }

    private Operation getBackupOperation(BackupAwareOperation backupAwareOp) {
        Operation backupOp = backupAwareOp.getBackupOperation();
        if (backupOp == null) {
            throw new IllegalArgumentException("Backup operation should not be null! " + backupAwareOp);
        }
        Operation op = (Operation)((Object)backupAwareOp);
        backupOp.setServiceName(op.getServiceName());
        return backupOp;
    }

    private Backup newBackup(BackupAwareOperation backupAwareOp, Object backupOp, long[] replicaVersions, int replicaIndex, boolean respondBack) {
        Backup backup;
        Operation op = (Operation)((Object)backupAwareOp);
        if (backupOp instanceof Operation) {
            backup = new Backup((Operation)backupOp, op.getCallerAddress(), replicaVersions, respondBack);
        } else if (backupOp instanceof Data) {
            backup = new Backup((Data)backupOp, op.getCallerAddress(), replicaVersions, respondBack);
        } else {
            throw new IllegalArgumentException("Only 'Data' or 'Operation' typed backup operation is supported!");
        }
        backup.setPartitionId(op.getPartitionId()).setReplicaIndex(replicaIndex);
        OperationAccessor.setCallId(backup, op.getCallId());
        return backup;
    }

    private void assertNoBackupOnPrimaryMember(InternalPartition partition, Address target) {
        if (target.equals(this.node.getThisAddress())) {
            throw new IllegalStateException("Normally shouldn't happen! Owner node and backup node are the same! " + partition);
        }
    }
}

