/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.obs.api;

import com.openexchange.obs.api.Architecture;
import com.openexchange.obs.api.BlockMode;
import com.openexchange.obs.api.BuildServiceException;
import com.openexchange.obs.api.BuildTrigger;
import com.openexchange.obs.api.Path;
import com.openexchange.obs.api.Project;
import com.openexchange.obs.api.ProjectReference;
import com.openexchange.obs.api.Repository;
import com.openexchange.obs.api.RepositoryReference;
import com.openexchange.obs.api.Tools;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class ProjectParser {
    private static final DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();

    private ProjectParser() {
    }

    public static Project parse(InputStream is) throws BuildServiceException {
        DocumentBuilder db;
        try {
            db = dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new BuildServiceException(e.getMessage(), e);
        }
        Document document = null;
        try {
            document = db.parse(is);
            NodeList childs = document.getChildNodes();
            for (int i = 0; i < childs.getLength(); ++i) {
                Node node = childs.item(i);
                if ("project".equals(node.getNodeName())) {
                    return ProjectParser.parse(node);
                }
                if (3 == node.getNodeType()) continue;
                throw new BuildServiceException("Unknown node in project meta \"" + node.getNodeName() + "\".");
            }
        }
        catch (NullPointerException e) {
            throw new BuildServiceException("Unable to parse project: " + Tools.transform(document), e);
        }
        catch (BuildServiceException e) {
            throw new BuildServiceException("Unable to parse project: " + Tools.transform(document), e);
        }
        catch (SAXException e) {
            throw new BuildServiceException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new BuildServiceException(e.getMessage(), e);
        }
        throw new BuildServiceException("Unable to parse project meta. " + Tools.transform(document));
    }

    public static boolean isDisabled(InputStream is) throws BuildServiceException {
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document document = db.parse(is);
            NodeList childs = document.getChildNodes();
            for (int i = 0; i < childs.getLength(); ++i) {
                Node node = childs.item(i);
                if (!"project".equals(node.getNodeName())) continue;
                return ProjectParser.isDisabled(node);
            }
            return false;
        }
        catch (ParserConfigurationException e) {
            throw new BuildServiceException(e.getMessage(), e);
        }
        catch (SAXException e) {
            throw new BuildServiceException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new BuildServiceException(e.getMessage(), e);
        }
    }

    private static boolean isDisabled(Node project) throws DOMException {
        NodeList childs = project.getChildNodes();
        boolean builddisabled = false;
        boolean publishdisabled = false;
        for (int i = 0; i < childs.getLength(); ++i) {
            Node node = childs.item(i);
            if ("build".equals(node.getNodeName())) {
                builddisabled = true;
            }
            if (!"publish".equals(node.getNodeName())) continue;
            publishdisabled = true;
        }
        return builddisabled && publishdisabled;
    }

    public static ProjectReference[] parseAll(InputStream is) throws BuildServiceException {
        Document document;
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            document = db.parse(is);
            NodeList childs = document.getChildNodes();
            for (int i = 0; i < childs.getLength(); ++i) {
                Node node = childs.item(i);
                if ("directory".equals(node.getNodeName())) {
                    return ProjectParser.parseProjectlist(node);
                }
                if (3 == node.getNodeType()) continue;
                throw new BuildServiceException("Unknown node in project meta \"" + node.getNodeName() + "\".");
            }
        }
        catch (ParserConfigurationException e) {
            throw new BuildServiceException(e.getMessage(), e);
        }
        catch (SAXException e) {
            throw new BuildServiceException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new BuildServiceException(e.getMessage(), e);
        }
        throw new BuildServiceException("Unable to parse project meta. " + Tools.transform(document));
    }

    private static ProjectReference[] parseProjectlist(Node projectList) throws DOMException, BuildServiceException {
        NodeList childs = projectList.getChildNodes();
        ArrayList<ProjectReference> results = new ArrayList<ProjectReference>();
        for (int i = 0; i < childs.getLength(); ++i) {
            Node node = childs.item(i);
            if ("entry".equals(node.getNodeName())) {
                results.add(ProjectParser.parseReference(node));
                continue;
            }
            if (3 == node.getNodeType()) continue;
            throw new BuildServiceException("Unknown node in project list \"" + node.getNodeName() + "\" \"" + node.getNodeValue() + "\".");
        }
        return results.toArray(new ProjectReference[results.size()]);
    }

    private static ProjectReference parseReference(Node node) {
        NamedNodeMap attributes = node.getAttributes();
        String name = attributes.getNamedItem("name").getNodeValue();
        ProjectReference project = new ProjectReference(name);
        return project;
    }

    private static Project parse(Node node) throws BuildServiceException {
        NamedNodeMap attributes = node.getAttributes();
        String name = attributes.getNamedItem("name").getNodeValue();
        NodeList childs = node.getChildNodes();
        Project project = new Project(name, ProjectParser.parseTitle(childs), ProjectParser.parseMaintainer(childs));
        for (Repository repository : ProjectParser.parseProject(project, node)) {
            project.addRepository(repository);
        }
        return project;
    }

    private static String parseTitle(NodeList childs) throws BuildServiceException {
        for (int i = 0; i < childs.getLength(); ++i) {
            Node node = childs.item(i);
            if (!"title".equals(node.getNodeName())) continue;
            return node.getNodeValue();
        }
        throw new BuildServiceException("Can not find title of project.");
    }

    private static String parseMaintainer(NodeList childs) {
        for (int i = 0; i < childs.getLength(); ++i) {
            String value;
            Node userIdAttribute;
            NamedNodeMap attributes;
            Node node = childs.item(i);
            if (!"person".equals(node.getNodeName()) || null == (attributes = node.getAttributes()) || null == (userIdAttribute = attributes.getNamedItem("userid")) || "Admin".equals(value = userIdAttribute.getNodeValue())) continue;
            return value;
        }
        return null;
    }

    private static Repository[] parseProject(Project project, Node projectNode) throws BuildServiceException {
        NodeList childs = projectNode.getChildNodes();
        ArrayList<Repository> packages = new ArrayList<Repository>();
        for (int i = 0; i < childs.getLength(); ++i) {
            Node node = childs.item(i);
            if ("repository".equals(node.getNodeName())) {
                packages.add(ProjectParser.parseRepository(node));
                continue;
            }
            if (3 == node.getNodeType() || "title".equals(node.getNodeName()) || "description".equals(node.getNodeName()) || "person".equals(node.getNodeName()) || "download".equals(node.getNodeName()) || "debuginfo".equals(node.getNodeName()) || "useforbuild".equals(node.getNodeName()) || "remoteurl".equals(node.getNodeName())) continue;
            if ("build".equals(node.getNodeName())) {
                ProjectParser.parseBuild(project, node);
                continue;
            }
            if ("publish".equals(node.getNodeName())) {
                ProjectParser.parsePublish(project, node);
                continue;
            }
            throw new BuildServiceException("Unknown node in result \"" + node.getNodeName() + "\" \"" + node.getNodeValue() + "\".");
        }
        return packages.toArray(new Repository[packages.size()]);
    }

    private static Repository parseRepository(Node repositoryNode) throws BuildServiceException {
        NamedNodeMap attributes = repositoryNode.getAttributes();
        String repositoryName = attributes.getNamedItem("name").getNodeValue();
        BuildTrigger rebuild = attributes.getNamedItem("rebuild") == null ? BuildTrigger.TRANSITIVE : BuildTrigger.parse(attributes.getNamedItem("rebuild").getNodeValue());
        BlockMode block = attributes.getNamedItem("block") == null ? BlockMode.ALL : BlockMode.parse(attributes.getNamedItem("block").getNodeValue());
        ArrayList<String> arch = new ArrayList<String>();
        NodeList childs = repositoryNode.getChildNodes();
        for (int i = 0; i < childs.getLength(); ++i) {
            Node node = childs.item(i);
            if (!"arch".equals(node.getNodeName())) continue;
            arch.add(node.getTextContent());
        }
        Collection<Architecture> architectures = Architecture.parseArchitecture(arch);
        Repository repository = new Repository(repositoryName, ProjectParser.parsePath(repositoryNode), architectures, rebuild, block);
        return repository;
    }

    private static void parseBuild(Project project, Node buildNode) {
        NodeList childs = buildNode.getChildNodes();
        for (int i = 0; i < childs.getLength(); ++i) {
            Node node = childs.item(i);
            if (!"disable".equals(node.getNodeName())) continue;
            NamedNodeMap attributes = node.getAttributes();
            if (0 == attributes.getLength()) {
                project.setBuildDisabled(true);
                continue;
            }
            Node repositoryAttribute = attributes.getNamedItem("repository");
            if (null == repositoryAttribute) continue;
            project.addDisabledRepository(repositoryAttribute.getNodeValue());
        }
    }

    private static void parsePublish(Project project, Node buildNode) {
        NodeList childs = buildNode.getChildNodes();
        for (int i = 0; i < childs.getLength(); ++i) {
            NamedNodeMap attributes;
            Node node = childs.item(i);
            if (!"disable".equals(node.getNodeName()) || 0 != (attributes = node.getAttributes()).getLength()) continue;
            project.setPublishDisabled(true);
        }
    }

    private static List<Path> parsePath(Node repositoryNode) {
        NodeList childs = repositoryNode.getChildNodes();
        ArrayList<Path> path = new ArrayList<Path>();
        for (int i = 0; i < childs.getLength(); ++i) {
            Node node = childs.item(i);
            if (!"path".equals(node.getNodeName())) continue;
            path.add(new Path(new ProjectReference(node.getAttributes().getNamedItem("project").getNodeValue()), new RepositoryReference(node.getAttributes().getNamedItem("repository").getNodeValue())));
        }
        return path;
    }
}

