/**
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 * 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 * 
 * Copyright (C) 2016 OX Software GmbH
 * Mail: info@open-xchange.com 
 * 
 * @author Viktor Pracht <viktor.pracht@open-xchange.com>
 * 
 */

var node, page;

register("Ready", function () {
    ox.api.folder.exists({
        folder: "6", 
        success: function (GAL) {
        	if (!GAL) return;
            new ox.Configuration.InnerNode("configuration/admin", _("Administration"));
            node = new ox.Configuration.LeafNode("configuration/admin/groups",
                                                     _("Groups"));
            page = new ox.Configuration.VSplit(node, _("Group Administration"),
                                                   0.5);
            page.init = initPage;
            
            // directlink access to this module
            if (url && url.view == "configuration/admin/groups") {
                ox.UIController.configJump(url.view);
            }
        }
    });
});

function initPage() {
    var selection = new Selection();
    var name, display_name;
    var grid = new LiveGrid([
        {
            text: _("Group name"),
            index: "name",
            id: "name",
            sortable: true,
            width: "50%",
            clear: LiveGrid.makeClear(""),
            set: LiveGrid.defaultSet
        }, {
            text: _("Display name"),
            index: "display_name",
            id: "display_name",
            sortable: true,
            clear: LiveGrid.makeClear(""),
            set: LiveGrid.defaultSet
        }
    ], selection);
    grid.sort = LiveGrid.localSort;
    grid.emptylivegridtext = _("No groups available");
    page.list = grid;
    var mapping = {};
    function updateMapping() {
        (new JSONX).get(AjaxRoot + "/user?action=all&columns=1,500&session=" +
            session, null, handleUsers);
        function handleUsers(data) {
            data = data.data;
            mapping = {};
            for (var i = 0; i < data.length; i++) {
                var obj = data[i];
                mapping[obj[0]] = obj[1];
            }
        }
    }
    page.enableList = function() {
        updateMapping();
        ox.JSON.get(AjaxRoot + "/group?action=all&columns=1,700,701&session=" +
            session, handleAll);
        function handleAll(reply) {
            var data = new Array(reply.data.length);
            for (var i = 0; i < data.length; i++) {
                var item = reply.data[i];
                data[i] = { id: item[0], name: item[1], display_name: item[2],
                            timestamp: reply.timestamp };
            }
            storage.remove(0, storage.ids.length);
            storage.append(data);
            grid.enable(storage);
            grid.setSort(grid.sort_id, grid.sort_order);
        }
    };
    page.load = function(cont) {
        ox.JSON.get(AjaxRoot + "/group?action=get&id=" +
            selection.getSelected()[0] + "&session=" + session, handleGet);
        function handleGet(reply) {
            reply.data.timestamp = reply.timestamp;
            cont(reply.data);
        }
    };
    page.save = function(data, cont) {
        function fail(field) {
            setTimeout(function() { 
                //#. %1$s is the field name.
                //#, c-format
                triggerEvent("OX_New_Error", 4, format(_("The mandatory field %1$s is not defined."), field)); 
            }, 0);
            return;
        }
        if (data) {
            if (trimStr(data.name || "") === "") {
                name.formnode.focus();
                return fail(_("Group name"));
            } else if (trimStr(data.display_name || "") === "") {
                display_name.formnode.focus();
                return fail(_("Displayed name"));
            }
        }
        
        if ("id" in data) {
            var d = clone(data);
            delete d.id;
            delete d.timestamp;
            ox.JSON.put(AjaxRoot + "/group/?action=update&id=" + data.id +
                        "&timestamp=" + data.timestamp +
                        "&session=" + session, d,
                        function(reply) {
                            data.timestamp = reply.timestamp;
                            storage.localUpdate([data.id],
                                function(old) { return data; });
                            cont(data);
                            // force internal cache refresh
                            if (internalCache) {
                                internalCache.reset();
                            }
                        });
        } else {
            ox.JSON.put(AjaxRoot + "/group/?action=new&session=" + session,
                        data, function(reply) {
                            data.id = reply.data.id;
                            data.timestamp = reply.timestamp;
                            storage.append([data]);
                            cont(data);
                        });
        }
    };
    
    var storage = new Storage(0, [], 0, 0, 0, 0,
        function(group) { return group.id; });
    var popup = new ParticipantsSmall(null, addMembers, true, false,
        false, false, _("Select Members"), null, true, false, true);

    var menu = MenuNodes.createSmallButtonContext("admin.groups", _("Groups"));
    MenuNodes.createSmallButton(menu, "admin.groups.new", _("New"),
        getFullImgSrc("img/dummy.gif"), getFullImgSrc("img/dummy.gif"),
        function() {
            page.addNew({
                display_name: _("New group"),
                members: []
            });
            page.listModified = true;
            name.formnode.focus();
        });
    MenuNodes.createSmallButton(menu, "admin.groups.delete", _("Delete"),
        getFullImgSrc("img/dummy.gif"), getFullImgSrc("img/dummy.gif"),
        confirmDelete);
    function confirmDelete() {
        if (!selection.count) return;
        newConfirm(ngettext("Delete Group", "Delete Groups", selection.count),
            ngettext("Are you sure you want to delete the selected group?",
                     "Are you sure you want to delete the selected groups?",
                     selection.count),
            AlertPopup.YES | AlertPopup.NO, null, null, handleDelete);
    }
    function handleDelete() {
        storage.newIterate(selection.getSelected(), emptyFunction,
            function(i, data) {
                ox.JSON.put(AjaxRoot + "/group?action=delete&timestamp=" +
                    data.timestamp + "&session=" + session, { id: data.id },
                    (function(id) {
                        return function(reply) {
                            grid.deleteIDs([id]); 
                            if (internalCache) {
                                internalCache.reset();
                                // force tasks cache refresh
                                OXCache.forceRefresh("tasks", true);
                            }
                        };
                    })(data.id));
            });
    }
    addMenuNode(menu.node, MenuNodes.FIXED, 31);
    changeDisplay(node.id, "admin.groups");

    menuarrows[node.id] = {};
    register("OX_SELECTED_ITEMS_CHANGED", function() {
        var deleteenabled = selection.count > 0;
        menuglobalzaehler = 0;
        menuarrows[node.id]["admin.groups"] = [];
        menu_display_contents(node.id, "admin.groups",
            true, "admin.groups.new");
        menu_display_contents(node.id, "admin.groups", deleteenabled,
            "admin.groups.delete");
    });

    page.addWidget(name = new ox.UI.Input(_("Group name")), "name");
    page.addWidget(display_name = new ox.UI.Input(_("Displayed name")), "display_name");
    var list = new ox.Configuration.EditableList(_("Members"), null,
                                                 _("Members"));
    list.emptyText = _("This group has no members");
    list.getText = function(elem) { return mapping[elem]; };
    var addContinuation = emptyFunction;
    list.add = function(cont) {
        addContinuation = cont;
        popup.openAddParticipantsWindow();
    };
    page.addWidget(list, "members");
    function addMembers(members) {
        var data = new Array(members.length);
        for (var i = 0; i < members.length; i++) data[i] = members[i].id;
        addContinuation(data);
    }
    var timestamp = new ox.UI.Widget();
    timestamp.set = function(value) { this.value = value; };
    timestamp.get = function() { return this.value; };
    timestamp.setVisible = emptyFunction;
    timestamp.remove = emptyFunction;
    page.addWidget(timestamp, "timestamp");
};