/**
 * 
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 * 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 * 
 * Copyright (C) 2016 OX Software GmbH
 * Mail: info@open-xchange.com 
 * 
 * @author Dirk Hartmann <dirk.hartmann@open-xchange.com>
 * @author Stefan Preuss <stefan.preuss@open-xchange.com>
 * 
 */

/*
 * TODO captain:
 *  - Usage of tmpDetailRequest may needs to be optimized, aka grid.selection vs. cache new/modified callbacks
 *    right now we use the grid selection event to get new objects, we should change that so we get them by object cache
 *    this also would give us the advantage to be informed when the selected object changed
 */

registerModule("tasks", _("Tasks"), 50);
registerModuleView("tasks", "Tasks",5,{x:1,y:1});
registerPrintView("tasks/list");
registerPrintView("tasks/split");
registerPrintView("tasks/split/overview");
var completedetailtask;
var activeTaskId = new Array();
var tasksTabsList;
var tasksPanelsList;
var tasksEventList;
var attachmentWindow = 0;
var taskTmpStorage;
var latestRenderedTask = null;
var objTaskDetailParticipants = null;
var refTaskDetailParticipantTab = null;
var taskParticipantsGrid = null;
var tasksFolderPath, tasksSearchObject = null;

var tasksSelection2= new Selection2();
var tmpDetailRequest;
var oAttachmentGridTask;
(
function() {
    function fn_add_Tag_tasks(tag){
        if (activemodule == "tasks") {
            var selected=tasksSelection2.getSelected();
            if (currentpath[1] == "detail" && completedetailtask) {
                selected[0]["timestamp"] = completedetailtask.timestamp || 0;
            }
            OXTaskMapping.setTag(tag,selected);
        }
    }
    register("Loaded",init_Tasks);
    
    register("OX_Tasks_Switch_Split_Detail",function(param) { 
        menuswitchTaskDetail(param);
    });
    
    function init_Tasks() {
        tasksFolderPath = new FolderPath("tasks");
        tasksTabsList = new Array('tasktab1','tasktab2', 
               'tasktab4');
        tasksPanelsList = new Array('taskpanel1','taskpanel2',
               'taskpanel4');
        tasksEventList = new Array(
                ['OX_Tasks_Switch_Split_Detail','overview'],
                ['OX_Tasks_Switch_Split_Detail','participant'],
                ['OX_Tasks_Switch_Split_Detail','attachment']
        );        
    }
    registerView("tasks",
            null,
            null,
            function() {
                tasksSearchObject = null;
                if (tmpDetailRequest) {
                    OXCache.unregister(tmpDetailRequest.uniqueName);
                    delete(tmpDetailRequest);
                }
            },
            function () {
                tasksSearchObject = null;
                triggerEvent('OX_Delete_Search');
                triggerEvent("Selected",[]);
            }
    );
    
    function enableDnD(grid, folder) {
        var api = ox.api.folder, data = api.get({ folder: folder }),
            canMove = api.can("delete", data) && !api.is("shared", data);
        grid.dndModule = canMove ? "tasks" : "";
    }
    
    registerView("tasks/list",
        function() {
            showNode("taskslist");
            $("taskslist").style.display="";
        }, 
        function() {
            var criteria= { "folder_id" : activefolder };
            gridlist.disablehover=!configGetKey("gui.effects.hover.tasks");
            if (tasksSearchObject !== null) {
                taskSearch(tasksSearchObject.module, tasksSearchObject.pattern);
            } else {
                enableDnD(gridlist, activefolder);
                gridlist.enable(criteria);
            }
            tasks_setFocus(gridlist);
            register("OX_Print",printTasks);
            register("OX_New_Search", taskSearch);
            register("OX_Add_Flag", fn_add_Tag_tasks);
            register("OX_Delete_Search", taskSearchDelete);
            register("OX_Task_MarkAsDone", tasks_markAsDone);
            if (corewindow.hasFocus) setFocus($("listeTasks"));
         }, 
         function() {
            if (gridlist) gridlist.disable();
            unregister("OX_Print",printTasks);
            unregister("OX_New_Search", taskSearch);
            unregister("OX_Add_Flag", fn_add_Tag_tasks);
            unregister("OX_Print",printTasks);
            unregister("OX_Delete_Search", taskSearchDelete);
            unregister("OX_Task_MarkAsDone", tasks_markAsDone);
            tasksFolderPath.clear();
         },
         function() { 
            hideNode("taskslist");
            $("taskslist").style.display="none";
            latestRenderedTask = null;
         },
         function(changeFolder) {
             if (changeFolder != undefined) {
                 var criteria = { "folder_id" : activefolder };
                 gridlist.disablehover=!configGetKey("gui.effects.hover.tasks");
                 enableDnD(gridlist, activefolder);
                 gridlist.enable(criteria, false);
                 tasks_setFocus(gridlist);
                 triggerEvent("Confirmation_Changed", 0);
             }
         }
    );
    
    registerView("tasks/split",
            function() {
                 // hide tab if property is set
                if ((ox.upsell.isVisible("infostore") && ox.upsell.isVisible("tasks-attachments")) === false) {
                    $("taskpanel4").style.display = "none";
                }
                if (!ox.upsell.isVisible("delegate")) {
                    $("taskpanel2").style.display = "none";
                }
                showNode("taskssplit");
                $("taskssplit").style.display="";
            }, 
            function() {
                setTabLists(tasksTabsList, tasksPanelsList, tasksEventList);
                var criteria= { "folder_id" : activefolder };
                gridsplit.disablehover=!configGetKey("gui.effects.hover.tasks");
                if (tasksSearchObject !== null) {
                    taskSearch(tasksSearchObject.module, tasksSearchObject.pattern);
                } else {
                    enableDnD(gridsplit, activefolder);
                    gridsplit.enable(criteria);
                }
                // reselect id if it's a direct link for example
                if (activeTaskId.length && activeTaskId[0].directLink &&
                    activeTaskId[0].id)
                {
                    delete(activeTaskId[0].directLink);
                    gridsplit.selection.selectIDs([ Key.createfromObject(activeTaskId[0]) ]);
                } else {
                    gridsplit.selection.selectIDs(
                        gridsplit.selection.getSelected());
                }
                expandTaskSplitHeader(configGetKey("gui.tasks.fullsplitheader"));
                
                register("OX_Print",printTasks);
                register("OX_Confirmation_Change", taskdetail_change_Confirm);
                //register("OX_AcceptDeny_Changed", cb_object_changed);  
                register("OX_New_Search", taskSearch);        
                register("OX_Add_Flag", fn_add_Tag_tasks);
                register("OX_Delete_Search", taskSearchDelete);
                register("OX_Task_MarkAsDone", tasks_markAsDone);
                // update confirm button
                triggerEvent("Confirmation_Changed", 0);
                if (corewindow.hasFocus) setFocus($("taskssplitgrid"));
             }, 
             function() {
                if (gridsplit) gridsplit.disable();
                if (tmpDetailRequest) {
                    OXCache.unregister(tmpDetailRequest.uniqueName);
                    delete(tmpDetailRequest);
                }
                unregister("OX_Print",printTasks);
                unregister("OX_Confirmation_Change", taskdetail_change_Confirm);
                //unregister("OX_AcceptDeny_Changed", cb_object_changed);
                unregister("OX_New_Search", taskSearch);                
                unregister("OX_Add_Flag", fn_add_Tag_tasks);
                unregister("OX_Delete_Search", taskSearchDelete);
                unregister("OX_Task_MarkAsDone", tasks_markAsDone);
                tasksFolderPath.clear();
             },
             function() {
                latestRenderedTask = null;
                hideNode("taskssplit");
                $("taskssplit").style.display="none";
             },
             function(changeFolder) {
                if (changeFolder != undefined) {
                    var criteria= { "folder_id" : activefolder };
                    gridsplit.disablehover=!configGetKey("gui.effects.hover.tasks");
                    enableDnD(gridsplit, activefolder);
                    gridsplit.enable(criteria, false);
                    tasks_setFocus(gridsplit);
                    // update confirm button
                    triggerEvent("Confirmation_Changed", 0);
                }
             }
    );
    
    registerView("tasks/split/overview",
            function() {
                $("tasktab1").style.display="block";
                $("taskpanel1").className="tabbing_tab_active";
            },
            null,
            null,
            function() {
                $("tasktab1").style.display="none";
                $("taskpanel1").className="tabbing_tab_inactive";
            }
    );
    
    registerView("tasks/split/participant",
            function() {
                $("tasktab2").style.display="block";
                $("taskpanel2").className="tabbing_tab_active";      
            }, 
            function() {
                refTaskDetailParticipantTab.enableGrid();
             }, 
            function() {
                refTaskDetailParticipantTab.disableGrid();
            },
            function() {
                $("tasktab2").style.display="none";
                $("taskpanel2").className="tabbing_tab_inactive";
            }
    );
    
    registerView("tasks/split/attachment",
            function() {
                $("tasktab4").style.display="block";
                $("taskpanel4").className="tabbing_tab_active";      
            }, 
            function() {
                if(!bAttachmentGridCreatedTask) {
                    createAttachmentGridTask();
                    bAttachmentGridCreatedTask = true;
                    ox.ToolBarController.processSelection("attachments", false,
                        [], true);
                } else {        
                    oAttachmentGridTask.enableGrid();
                    ox.ToolBarController.processSelection("attachments", false,
                        oAttachmentGridTask.liveGrid.selection.getSelected(),
                        true);
                }
                oAttachmentGridTask.getAttachments(activeTaskId[0].id,activeTaskId[0].folder_id);                   
            },
            function() {
                if (bAttachmentGridCreatedTask)              
                    oAttachmentGridTask.disableGrid();
            },
            function() {
                $("tasktab4").style.display="none";
                $("taskpanel4").className="tabbing_tab_inactive";        
            }
    );

    function taskdetail_change_Confirm() {
        var taskconfirm=new AcceptDeny(true);
        taskconfirm.showConfirmation([new AcceptDenyObject("tasks", completedetailtask)]);
    }
    
    function cb_selection_changed() {
        // get current task to prevent double selection (-> double rendering)
        var currentTask = activeTaskId.length > 0 ? activeTaskId[0].id : null;
        if (currentTask == latestRenderedTask) return;
        // remember current task
        latestRenderedTask = currentTask;
        // now process selection
        if (!tasksSelection2.getSelected().length) return;
        tasks_setFocus(gridsplit);         
        fn_tasks_getDetails(tasksSelection2.getSelected());        
    }
    
    function tasks_setFocus(grid) {
        if (grid && grid.collection && tasksSelection2.getSelected().length) {
            var index = grid.collection.getIndex(tasksSelection2.getSelected()[0]);
            grid.focus = index ? index-1 : 0;
            grid.showFocus();
        }
    }

    function switchToTaskStdView() {
        triggerEvent("OX_Switch_View", configGetKey("gui.tasks.view"));
    }
    
    function switchToTaskSplitView() {
        triggerEvent("OX_Switch_View", "tasks/split");
    }
    function switchToTaskListView() {
        triggerEvent("OX_Switch_View", "tasks/list");
    }
    
    function taskSearch(module, pattern) {
        if (module != "tasks") { return ; }
        tasksSearchObject = { module: module, pattern: pattern };
        var criteria= { "folder_id" : activefolder };
        var search= { "note" : "*"+pattern+"*" , "title" : "*"+pattern+"*", "categories" : "*"+pattern+"*" };
        if (currentpath2[1] == "split") {
          gridsplit.disablehover=!configGetKey("gui.effects.hover.tasks");
          enableDnD(gridsplit, activefolder);
          gridsplit.enable(criteria,search,false);
        } else if(currentpath2[1] == "list") {
          gridlist.disablehover=!configGetKey("gui.effects.hover.tasks");
          enableDnD(gridlist, activefolder);
          gridlist.enable(criteria,search,false);
        }
        tasksFolderPath.drawSearch(module, pattern);
    }
    
    function taskSearchDelete() {
        if (activemodule != "tasks") { return; }
        var criteria= { "folder_id" : activefolder };
        var split = gridsplit, view = "taskofsplitview";
        if(currentpath2[1] == "list") {
            split = gridlist, view = "taskoflistview";
        }    
        split.searchActive=false;
        split.disablehover=!configGetKey("gui.effects.hover.tasks");
        enableDnD(split, activefolder);
        split.enable(criteria);
        tasksFolderPath.drawDOMNode(view, activefolder);
    }
    
    var gridlist, gridsplit, gridatt;
    var tmp_participant = null;
    var id = new Array();
    var clear = LiveGrid.makeClear("");
    var portalCall = false;
    
    var bAttachmentGridCreatedTask;
    
    function createAttachmentGridTask() {
        //set id and fid for attachments here
        var nId = activeTaskId[0].id;
        var nFolder = activeTaskId[0].folder || activeTaskId[0].folder_id;
        oAttachmentGridTask = new attachmentGrid("taskAttachments",nId,nFolder,4);
        triggerEvent("OX_Tasks_AttachmentGrid_Ready", oAttachmentGridTask);
    }
    
    register("OX_Task_Delete", deleteTask);
    register("OX_Task_Edit", editTask);
    register("OX_Task_Duplicate", duplicateTask);
    register("OX_Object_Add_Attachment", addAttachment);

    register("Loaded", function() {
        gridlist = makeGrid("listeTasks",true);
        gridsplit = makeGrid("taskssplitgrid",true);
    });
        
    function tasks_markAsDone() {
        function cb_changes(object) {
            if (object["percent_completed"] && object["percent_completed"] == 100) {
                return null;
            } else {
                return { "percent_completed": 100, "status": 3 };
            }
        }
        tasks_udpateTasks(tasksSelection2.getSelected(), ["percent_completed"], cb_changes);
    }
    
    /**
     * @todo: this needs to be fairly optimized!
     * we have to decide between ... 
     * a) pre-fetch the needed columns of the selected items,
     * compare them with the changes we want to make and remove them if not changed to
     * keep the final put as small as possible
     * or b) just update all the selected items, no matter if object really changed or 
     * not, which saves all the newRequests to pre-fetch missing columns for comparision 
     * Anyway, we'll have to fix final editObjects call to update cache because right now
     * all selected items would be updated with the last changes!
     */
    function tasks_udpateTasks(ids, columns, cb_changes) {
        if (ids == undefined || !ids.length) return false;
        var collection={};
        collection.objects=ids;
        collection.columns=columns;
        OXCache.newRequest(null,"tasks",collection,null,
            function(daten) {
                if (!daten.objects) return;
                var fPutData = new Array(); 
                var fOCData = null;
                for (var i in daten.objects) {
                    var object = daten.objects[i];
                    var timestamp = object["timestamp"] || 0;
                    changes = cb_changes(object);
                    if (!changes) continue;
                    fOCData = changes;
                    fPutData.push({
                        "action": "update",
                        "module": "tasks",
                        "folder": object["folder_id"],
                        "id": object["id"],
                        "timestamp": object["timestamp"] || 0,
                        "data" : fOCData
                    });
                }
                if (!fPutData.length || fOCData == null) return;
                new JSONX().put(AjaxRoot + "/multiple?session=" + session, 
                       fPutData, null,
                       function(cb) { 
                            if (!cb.length) return;
                            fOCData["timestamp"] = cb[0]["timestamp"] || 0;
                            OXTaskMapping.editObjects(ids,fOCData);
                       }
                    );
            });
        
    }
    
    function cb_changes(object) {
        var new_pc = 100;
        var new_status = 3;
        if (object["percent_completed"] && object["percent_completed"] >= 100) {
            new_pc = 0;
            new_status = 1;
        }
        return { "percent_completed": new_pc, "status": new_status };
    }
    
    function addCheckBox(data) {
        return jQuery("<input>")
        .css({ padding: 0, margin: 0, verticalAlign: "middle"})
        .attr("type", "checkbox").addClass("noborder")
        .bind("click", { data: data }, function(evt) {
            var activeTaskId;
            if (currentpath2[1] == "list") {
                activeTaskId = gridlist.getSelectedIDs();
            } else  if (currentpath2[1]=="split") {
                activeTaskId = gridsplit.getSelectedIDs();
            }
            if (activeTaskId && activeTaskId.length > 0) {
                evt.data.data.module = "tasks";
                tasks_udpateTasks(activeTaskId, ["percent_completed"], cb_changes);
            }
            activeTaskId = null;
        })[0];
    }
    
    temporary.lists.tasks = temporary.MakeList({
        updated: function() {
            gridlist.recreate();
            gridsplit.recreate();
        },
        columns: [
            {
                sortable: false,
                name : ["recurrence_type"],
                text: "&#xa0;",
                width: "20px",
                style: { padding: 0, textAlign: "center", verticalAlign: "middle" },
                set: function(div, sequ) {
                    if (!div.firstChild)
                        div.appendChild(document.createElement("img"));
                    if (sequ < 1) {
                        div.firstChild.src = getFullImgSrc("img/tasks/tasks16x16.gif");
                        div.firstChild.alt = "";
                        div.firstChild.style.verticalAlign = "middle";
                        div.firstChild.style.width = "16px";
                        div.firstChild.style.height = "16px";
                    } else {
                        div.firstChild.src = getFullImgSrc("img/tasks/sequence.gif");
                        div.firstChild.alt = _("Recurrence");   /*i18n*/
                        div.firstChild.style.verticalAlign = "middle";
                        div.firstChild.style.width = "16px";
                        div.firstChild.style.height = "16px";
                    }
                },
                clear: function(div) {
                    if (!div.firstChild)
                        div.appendChild(document.createElement("img"));
                    div.firstChild.src = getFullImgSrc("img/tasks/tasks16x16.gif");
                    div.firstChild.alt = "";
                    div.firstChild.style.verticalAlign = "middle";
                    div.firstChild.style.width = "16px";
                    div.firstChild.style.height = "16px";
                }
            }, {
                sortable: false,
                name : ["participants"],
                text: "&#xa0;",
                width: "20px",
                style: { padding: 0, textAlign: "center", verticalAlign: "middle" },
                set: function(div, participants) {
                    if (!div.firstChild) {
                        jQuery(div).append(
                            jQuery("<img>")
                            .css({ verticalAlign: "middle"})
                            .attr({ width: 16, height: 16, alt: "", title: "" })
                        );
                    }
                    if (isGroupAppointment(participants)) {
                        jQuery("img:first", div)
                        .attr({
                            src: getFullImgSrc("img/calendar/group.gif"),
                            alt: _("Group task"),
                            title: _("Group task")
                        });
                    } else {
                        jQuery("img:first", div)
                        .attr({
                            src: getFullImgSrc("img/dummy.gif"),
                            alt: "",
                            title: ""
                        });
                    }
                },
                clear: function(div) {
                    if (!div.firstChild) {
                        jQuery(div).append(
                            jQuery("<img>")
                            .css({ verticalAlign: "middle"})
                            .attr({
                                src: getFullImgSrc("img/dummy.gif"),
                                width: 16,
                                height: 16,
                                alt: "",
                                title: ""
                            })
                        );
                    } else {
                        jQuery("img:first", div)
                        .attr({
                            src: getFullImgSrc("img/dummy.gif")
                        });
                    }
                }
            }, {
                name: ["folder_id", "id", "percent_completed"],
                text: "&#xa0;",
                style: { padding: 0, textAlign: "center", verticalAlign: "middle" },
                width: "20px",
                set: function(div, data) {
                    if (!div.firstChild) div.appendChild(addCheckBox({ folder_id: data.folder_id, id: data.id }));
                    div.firstChild.style.display = "";
                    div.firstChild.checked = (data["percent_completed"] && data["percent_completed"] >= 100);
                },
                clear: function(div, data) {
                    if (div.firstChild) removeChildNodes(div);
                }
            },{ 
                text: "&#160;",
                name : ["private_flag"],
                sortable: false,
                width: "20px",
                style: { padding: 0 },
                set: function(div, text) {
                    if (div.firstChild) {
                        div.firstChild.src = !text ? getFullImgSrc("img/dummy.gif") : getFullImgSrc("img/private_flag.gif");
                        div.firstChild.alt = !text ? "" : _("Private"); /*i18n*/
                    } else
                        div.appendChild(newnode("img", {width: "16px", height: "16px" },
                            {src: !text ? getFullImgSrc("img/dummy.gif") : getFullImgSrc("img/private_flag.gif"), alt: ""}));
                },
                clear: function(div) {
                    if (div.firstChild) {
                        div.firstChild.src = getFullImgSrc("img/dummy.gif");
                        div.firstChild.alt = "";
                    } else
                        div.appendChild(newnode("img", {width: "16px", height: "16px" },
                            {src: getFullImgSrc("img/dummy.gif"), alt: "" }));
                }
            }, {
                text: "Subject",    /*i18n*/
                i18n: true,
                sortable: true,
                name : ["title","percent_completed"],
                sort: "title",
                set: function(div, object) {
                    if (!div.firstChild) {
                        div.appendChild(document.createTextNode("\u00a0"));
                    }
                    if (object.title) {
                        div.firstChild.data = object.title;
                        if(object["percent_completed"] && object["percent_completed"] >= 100) {
                            div.className="cell font-color-disabled";                          
                            div.style.textDecoration = "line-through";
                        } else {
                            div.className="cell";
                            div.style.textDecoration = "none";
                        }
                    } else {
                        div.firstChild.data = "\u00a0";
                    }
                },
                clear: clear
            }, {
                text: "Priority",   /*i18n*/
                name : ["priority"],
                sort : "priority",
                i18n: true,
                sortable: true,
                width: "8%",
                set: function(div, prio) {
                    var src = (prio == 3) ? getFullImgSrc("img/tasks/taskprio3.gif")
                            : (prio == 1) ? getFullImgSrc("img/tasks/taskprio1.gif")
                            : getFullImgSrc("img/tasks/taskprio2.gif");
                    if (!div.firstChild)
                        div.appendChild(newnode("img", {height : "11px", width : "35px"}, {src: src, alt: ""}));
                    else
                        div.firstChild.src = src;
                }, 
                clear: function(div) {
                            if (!div.firstChild)
                                div.appendChild(newnode("img", {height : "11px", width : "35px"}, {src: getFullImgSrc("img/tasks/taskprio2.gif"), alt: ""}));
                            else
                                div.firstChild.src = getFullImgSrc("img/tasks/taskprio2.gif");
                        }
            }, {
                text: "Start date", /*i18n*/
                i18n: true,
                sortable: true,
                sort: "start_date",
                name : ["start_date","percent_completed"],
                width: "14%",
                set: function(div, object) {
                    if (!div.firstChild) {
                        div.appendChild(document.createTextNode("\u00a0"));
                    }
                    if (object.start_date) {
                        div.firstChild.data = formatDate(object.start_date, "date");
                        if(object["percent_completed"] && object["percent_completed"] >= 100) {
                            div.className="cell font-color-disabled";
                            div.style.textDecoration = "line-through";
                        } else {
                            div.className="cell";  
                            div.style.textDecoration = "none";
                        }
                    } else {
                        div.firstChild.data = "\u00a0";
                    }
                },
                clear: clear
            }, {
                text: "Due date",   /*i18n*/
                name : ["end_date","percent_completed"],
                sort: "end_date",
                i18n: true,
                sortable: true,
                width: "14%",
                set: function(div, object) {
                    if (!div.firstChild) {
                        div.appendChild(document.createTextNode("\u00a0"));
                    }
                    if (object.end_date) {
                        div.style.color = "";
                        div.firstChild.data = formatDate(object.end_date, "date");
                        if(object["percent_completed"] && object["percent_completed"] >= 100) {
                            div.className="cell font-color-disabled";
                            div.style.textDecoration = "line-through";
                        } else if (getDays(new Date()-new Date(object.end_date)) > 0) {
                            div.style.textDecoration = "none";
                            div.style.color = "red";
                        } else {
                            div.className="cell";  
                            div.style.textDecoration = "none";
                        }
                    } else {
                        div.firstChild.data = "\u00a0";
                    }
                },
                clear: clear
            }, {
                text: "% finished", /*i18n*/
                i18n: true,
                sortable: true,
                sort: "percent_completed",
                name : ["percent_completed"],
                style: {textAlign: "right"},
                width: "12%",
                set: function(div, percent_completed) {
                    if (!div.firstChild) {
                        div.appendChild(document.createTextNode("\u00a0"));
                    }
                    if (percent_completed != undefined) {
                        div.firstChild.data = percent_completed + "%";
                        if (percent_completed >= 100) {
                            div.className="cell font-color-disabled";
                            div.style.textDecoration = "line-through";
                        } else {
                            div.className="cell";
                            div.style.textDecoration = "none";
                        }
                    } else {
                        div.className="cell";
                        div.style.textDecoration = "none";
                        div.firstChild.data = "\u00a0";
                    }
                },
                clear: clear
            }, {
                text: "&#160;",
                name : ["color_label"],
                width: "4em",
                sort: "color_label",
                sortable: true,
                set: function(div,text) {
                    if (div)
                        div.innerHTML = "<img src='"+getFullImgSrc("img/menu/tag_"+(text||0)+".gif")+"' alt='' style='width:16px; height:16px'/>";
                },
                clear: clear
            }
        ]
    });

    
    function makeGrid(gridName) {
        var grid = new LiveGrid2(temporary.lists.tasks.columns, tasksSelection2, "tasks");
        
        var contextData = [];
        var count = Value(), writable = Value(), deletable = Value();
        var confirmable = Value(), markable = Value();
        var menu = grid.contextmenu = globalContextMenus.tasks = new ContextMenu();
        
        var edit = new MenuItem(_("Edit"),
            function() { triggerEvent('OX_Task_Edit'); });
        edit.setIcon("img/menu/edit.gif", "img/menu/edit_d.gif");
        edit.setEnabledF(function() { return count() == 1 && writable(); });
        menu.addItem(edit);
        
        var del = new MenuItem(_("Delete"),
            function() { triggerEvent('OX_Task_Delete'); });
        del.setIcon("img/menu/delete.gif", "img/menu/delete_d.gif");
        del.setEnabledF(function() { return count() > 0 && deletable(); });
        menu.addItem(del);
        
        var copy = new MenuItem(_("Use as template"),
            function() { triggerEvent('OX_Task_Duplicate'); });
        copy.setIcon("img/menu/task_copy.gif", "img/menu/task_copy_d.gif");
        copy.setEnabledF(function() { return count() == 1 && writable(); });
        menu.addItem(copy);
    
        var done = new MenuItem(_("Mark as Done"),
            function() { triggerEvent('OX_Task_MarkAsDone'); });
        done.setIcon("icons/16/task_mark_as_done.png", "icons/16/task_mark_as_done_dis.png");
        done.setEnabledF(function() {
            return count() > 0 && writable() && markable();
        });
        menu.addItem(done);
        
        menu.addItem(new MenuSeparator());
    
        var confirm = new MenuItem(_("Change confirmation"), function() {
            var objects = new Array(contextData.length);
            for (var i = 0; i < objects.length; i++) {
                objects[i] = new AcceptDenyObject("tasks", contextData[i]);
            }
            (new AcceptDeny(true)).showConfirmation(objects);
        });
        confirm.setIcon("img/menu/global_confirmation_change.gif",
                        "img/menu/global_conf_change_d.gif");
        confirm.setEnabledF(function() { 
            return count() > 0 && confirmable(); 
        });
        menu.addItem(confirm);
    
        menu.onShow = function() {
            var sel = this.getContext().getSelected();
            count.set(sel.length);
            writable.clear();
            deletable.clear();
            confirmable.clear();
            markable.clear();
            if (!sel.length) return;

            OXCache.newRequest(null, "tasks",
                { columns: ["created_by", "status"], objects: sel },
                null, simpleData);
            function simpleData(data) {
                contextData = data.objects;
                writable.set(menuhasRight(contextData, "WRITE"));
                deletable.set(menuhasRight(contextData, "DELETE"));
                for (var i in contextData) {
                    if (contextData[i].status != 3) {
                        markable.set(true);
                        return;
                    }
                }
                markable.set(false);
            }

            OXCache.newRequest(null, "tasks",
                { columns: ["users"], objects: sel }, null, userData);
            function userData(data) {
                contextData = data.objects;
                for(var i in contextData) {                 
                    var users = contextData[i].users;
                    var me = config.identifier;
                    CheckUsers: {
                        for(var j = 0; j < users.length; j++) {
                            if (users[j].id == me) break CheckUsers;
                        }
                        confirmable.set(false);
                        return;
                    }
                }
                confirmable.set(true);
            }
        };
        
        grid.identification = gridName; 
        
        grid.events.register("Activated", function(ids) {           
            if (ids && ids.length > 0) {
                if(menuhasRight(ids,"WRITE")) {
                    activeTaskId = ids;
                    triggerEvent("OX_Task_Edit");
                } else {
                    triggerEvent("OX_New_Error", 4, _("You do not have write permission for this object."));
                }
            } else {
                triggerEvent("OX_Before_Create_Task");
            }           
        });
        
        grid.events.register("Selected", function(ids) {
            activeTaskId = id = grid.getSelectedIDs() || [];
            if (ids == 1)  {
                cb_selection_changed();             
            } else if (currentpath2[1]=="split") {
                if (ids == 0) latestRenderedTask = null;
                clearSplitDetails();                
            }
            triggerEvent("Selected", activeTaskId);
        });
        
        grid.events.register("Delete", function() {
                if(menucheckRight("DELETE"))
                    deleteTask();
                else
                    triggerEvent("OX_New_Error", 4, _("You do not have write permission for this object."));
            }
        );
        $(gridName + "Header").appendChild(grid.getHeader());
        grid.getTable($(gridName));
        grid.events.register("Changed",tasks_HeaderUpdate);
        var hv = grid.addHover(OXTaskHover.getContent().node,
            function(id, manual) {
                OXTaskHover.actualHover=hv;
                OXTaskHover.refillContent(id.id,id.folder_id);
            });
        hv.setSize(OXTaskHover.contentobject.node);
        grid.setSort("end_date","asc");
        return grid;
    }
    
    function editTask() {
        if (currentpath2[1]=="list") {
            activeTaskId = id = gridlist.getSelectedIDs();
        } else  if (currentpath2[1]=="split") {
            activeTaskId = id = gridsplit.getSelectedIDs();
        }
        if (activeTaskId.length == 1) {
            // edit task
            ox.api.task.edit({
                params: {
                    id: activeTaskId[0].id,
                    folder: activeTaskId[0].folder_id
                },
                id: activeTaskId[0]
            });
        }
    }
    
    function duplicateTask() {
        var selected=tasksSelection2.getSelected();
        if (selected.length < 1) {
            triggerEvent("OX_New_Error", 4, _("Please select at least one task!"));
        }
        if (id.length == 1) {
            // duplicate task
            ox.api.task.duplicate({
                params: {
                    id: activeTaskId[0].id,
                    folder: activeTaskId[0].folder_id
                }
            });
        }
    }
    register("OX_Create_Object",createNewTask);
    
    function createNewTask(module,folder) {
        if(module=="tasks") {
            if(!folder) {
                folder = configGetKey("folder.tasks");
            }
            // create task
            ox.api.task.compose({
                params: {
                    folder: folder
                }
            });
        }
    }
    
    function deleteTask() {
        function cbyes() {      
            if (currentpath2[1] == "list") {
                activeTaskId = id = gridlist.getSelectedIDs();            
            } else if (currentpath2[1]=="split") {
                activeTaskId = id = gridsplit.getSelectedIDs();           
            } else if (currentpath2[1]=="search") {
                activeTaskId = id = gridlist.getSelectedIDs();
            } else {
                activeTaskId = id = [completedetailtask];
                switchToTaskStdView();
            }
            OXTaskMapping.deleteObjects(activeTaskId);   
        } 
        var confirmtexttasks=_("Are you sure you want to delete selected item?");
        if(activeTaskId.length>1) {
            confirmtexttasks=_("Are you sure you want to delete selected items?");
        }
        newConfirm(_("Delete Task"),confirmtexttasks,AlertPopup.YESNO,null,null,cbyes,null);
    }
    
    function clearSplitDetails() {
        $("tasks.split.detail_container.content").style.display="none";
        $("tasks.split.detail_container.loading").style.display="none";
        if ($("tasks.split.bottom_str").firstChild) {
            $("tasks.split.bottom_str").firstChild.data="\u00a0"; // clean bottom str
        }
    }
    
    function printTasks() {
        
        if (!tasksSelection2 || activemodule != "tasks") {
            return;
        } else if (tasksSelection2.count != 1) {
            if (currentpath2[1] == "split" && gridsplit) {
                globalprint.printLiveGrid(gridsplit);
            } else if (gridlist) {
                globalprint.printLiveGrid(gridlist);
            }
            return;
        }
        
        var aPrintDetailTask = [],
            taskData = completedetailtask,
            detailTaskPrint = new Print(taskData.title);
        
        /* Tab Details */
        aPrintDetailTask.push(Print.createTitle(taskData.title));
        aPrintDetailTask.push(Print.createLine("5px"));
        aPrintDetailTask.push(Print.createEmpty(true));
        
        if (taskData.priority) {
            aPrintDetailTask.push(Print.createPriority(taskData.priority));
        }
            
        aPrintDetailTask.push(Print.createContent(_("% done:"), taskData.percent_completed || "0"));
        
        if (taskData.start_date) {
            aPrintDetailTask.push(Print.createContent(_("Start date:"), formatDate(taskData.start_date, "dateday")));
        }
        
        if (taskData.end_date) {
            aPrintDetailTask.push(Print.createContent(_("End date:"), formatDate(taskData.end_date, "dateday")));
        }
        
        if (taskData.categories) {
            aPrintDetailTask.push(Print.createContent(_("Categories:"), taskData.categories));
        }
        
        if (taskData.note) {
            aPrintDetailTask.push(Print.createContent(_("Description:"), taskData.note));
        }
        
        /* Tab Details */
        aPrintDetailTask.push(Print.createEmpty());
        aPrintDetailTask.push(Print.createHeader(_("Details:")));
        
        if (taskData.trip_meter) {
            aPrintDetailTask.push(Print.createContent(_("Distance:"), taskData.trip_meter));
        }
        if (taskData.target_duration) {
            aPrintDetailTask.push(Print.createContent(_("Estimated Duration:"), taskData.target_duration + " " + _("minutes")));
        }
        if (taskData.actual_duration) {
            aPrintDetailTask.push(Print.createContent(_("Current Duration:"), taskData.actual_duration + " " + _("minutes")));
        }
        if (taskData.target_costs) {
            aPrintDetailTask.push(Print.createContent(_("Estimated Costs:"), (taskData.target_costs ? round(taskData.target_costs) : "") + " " + taskData.currency));
        }
        if (taskData.actual_costs) {
            aPrintDetailTask.push(Print.createContent(_("Current Costs:"), (taskData.actual_costs ? round(taskData.actual_costs) : "") + " " + taskData.currency));
        }
        
        // print
        detailTaskPrint.printDetail(aPrintDetailTask);
    }

})();

function fn_tasks_getDetails(objects, forceUpdate) {   
    if (!objects.length || activemodule != "tasks") return;
    
    
    /*
    // check if it's still the same selected object. no need to always
    // add newRequests as changes will be handled by the modified cb.
    // right now this just only work for 1 change, then the modified cb
    // of the cache won't be triggered anymore. have to check this
    if (activeTaskId.length && activeTaskId[0].calculatedHash == 
        tasksSelection2.getSelected()[0].calculatedHash &&
        forceUpdate == undefined) {
        return;
    }
    */
    
    enableTaskLoadingScreen(true);
        
    var collection={};
    collection.objects=[objects[0]];
    collection.columns=null;
    if (tmpDetailRequest) {
        OXCache.unregister(tmpDetailRequest.uniqueName);
        delete(tmpDetailRequest);
    }
    tmpDetailRequest=OXCache.newRequest(null, "tasks", collection, function(daten) {
        if (!daten || !daten.objects || !daten.objects.length) {
            enableTaskLoadingScreen(false);
            return;
        }
        updateTaskSplit(daten.objects[0]);
    }, function(daten) {
        if (!daten || !daten.objects || !daten.objects.length) {
            enableTaskLoadingScreen(false);
            return;
        }
        updateTaskSplit(daten.objects[0]);
    }, forceUpdate);
    
}

function expandTaskSplitHeader(fullHeader) {
    if (fullHeader) $('tasks.split.header_ext').style.display = "";
    $("tasks.split.expand_plus").getElementsByTagName("img")[0].src =
        getFullImgSrc("img/" + (fullHeader ? "minus" : "plus") + ".gif");
    configSetKey("gui.tasks.fullsplitheader", fullHeader);    
    var steps = 6*pxPerEm;
    animate(configGetKey("gui.effects.fading") ? 250 : 0, steps, function(stepN) { 
        var an = fullHeader ? stepN : steps-stepN;
        setTimeout(function() { resizeSplit("tasks.split.header_ext", Math.round(an/pxPerEm) + "em"); }, 0);
    }, function() { 
        if (!fullHeader) $('tasks.split.header_ext').style.display = "none";
    });    
}

function resizeTaskSplitHeader(fullHeader) {
   setTimeout(function() { resizeSplit("tasks.split.header_ext", fullHeader ? "6em" : "0em"); }, 0);
}

function enableTaskLoadingScreen(enabled) {
    if (enabled && $("tasks.split.detail_container.content").style.display != "none") {
        $("tasks.split.detail_container.content").style.display="none";
    } else if (!enabled && $("tasks.split.detail_container.content").style.display != "block") {
        $("tasks.split.detail_container.content").style.display="block";
    }
    if (!enabled && $("tasks.split.detail_container.loading").style.display != "none") {
        $("tasks.split.detail_container.loading").style.display="none";
    } else if (enabled && $("tasks.split.detail_container.loading").style.display != "block") {
        $("tasks.split.detail_container.loading").style.display="block";
    }    
}

var aStatusTask = new Array("Not started","In progress","Done","Waiting","Deferred");
function updateTaskSplit(object) {
    if (!object || activemodule != "tasks") return;
    
    // changing the selection jumps back to overview tab
    if (currentpath2[1] == "split" && currentpath2[2] != "overview") { 
        triggerEvent("OX_Switch_View", "tasks/split/overview");
    }

    if ($("tasks.split.due_today").style.display != "none") {
        $("tasks.split.due_today").style.display="none";
    }

    aPrintDetailTask = [];
    objTaskDetailParticipants = new TaskDetailParticipants();
    refTaskDetailParticipantTab = new TaskDetailParticipantTab();
    
    writeBottomString(object,"tasks.split.bottom_str");
    triggerEvent("Confirmation_Changed",0);              
    completedetailtask=object;
    
    for (idfield in object) {
        var idvalue = object[idfield];
        switch (idfield) {
            case "priority":
                  var img = idvalue && idvalue <= 3 ? idvalue : 2; 
                  $("tasks.split." + idfield).src = getFullImgSrc("img/tasks/taskprio" + img + ".gif");
                  continue;
                  break;
            case "note":
                  removeChildNodes($("tasks.split." + idfield));
                  idvalue = idvalue || "";                    
                  var nText = idvalue.split("\n");
                  for (var i in nText) {
                      $("tasks.split." + idfield).appendChild(document.createTextNode(nText[i]));
                      $("tasks.split." + idfield).appendChild(newnode("br"));
                  }
                  continue;
                  break;
            case "status": 
                  if (idvalue === null || isNaN(idvalue)) {
                      // set default status if it's not a number
                      idvalue = 1;
                      // if percent complete greater then 0 its in progress
                      if ((object.percent_completed || 0) > 0) {
                          idvalue = 2;
                      }
                  }
                  idvalue = _(aStatusTask[idvalue - 1]);
                  break; 
            case "created_by":
                  $("tasks.split." + idfield).firstChild.data = _("Unknown"); /*i18n*/
                  if (!idvalue) break;
                  var fnSetPrincipal = (function fnSetPrincipal(idfield, idvalue) {
                      return function(arg) {
                          $("tasks.split." + idfield).firstChild.data = arg[idvalue].display_name; 
                      };
                  })(idfield, idvalue);
                  internalCache.getUsers([idvalue],fnSetPrincipal);
                  continue;
                  break; 
            case "percent_completed":
                  idvalue = idvalue != undefined ? idvalue + "%" : null;
                  break;
            case "end_date":
                  var endDate = idvalue;
                  var startDate = object["start_date"];
                  if (endDate && startDate) {
                      //#. Task details of a task with start and due date.
                      //#. %1$s is the start date.
                      //#. %2$s is the due date.
                      //#, c-format
                      idvalue = format(_("Starts on %1$s, due on %2$s."), formatDate(startDate, "date"), formatDate(endDate, "date"));
                  } else if (startDate) {
                      //#. Task details of a task with only a start date.
                      //#. %s is the start date.
                      //#, c-format
                      idvalue = format(_("Starts on %s."), formatDate(startDate, "date"));
                  } else if (endDate) {
                      //#. Task details of a task with only a due date.
                      //#. %s is the due date.
                      //#, c-format
                      idvalue = format(_("Due on %s."), formatDate(endDate, "date"));
                  } else {
                      //#. Task details of a task with no start or due date.
                      idvalue = _("Not set");
                  }
                  
                  // warning headline if task is due
                  if (endDate != undefined && 
                      object["percent_completed"] != undefined && 
                      object["percent_completed"] < 100) {                          
                      var pastDays = getDays(new Date()-new Date(endDate));
                      var text = "";                          
                      switch(pastDays) {
                           case 0:
                               text = _("Due today!");
                               break;
                           case -1:
                               text = _("Due tomorrow.");
                               break;
                           case 1:
                               text = _("Overdue by yesterday.");
                               break;
                           default:
                               if (pastDays < -1) {
                                    //#. Task details (due date).
                                    //#. %d is the number of days.
                                    //#, c-format
                                    text = format(ngettext("Due in %d day.",
                                                           "Due in %d days.",
                                                           Math.abs(pastDays)),
                                                  Math.abs(pastDays));
                               } else {
                                    //#. Task details (due date).
                                    //#. %d is the number of days.
                                    //#, c-format
                                    text = format(ngettext("Overdue by %d day.",
                                                           "Overdue by %d days.",
                                                           pastDays),
                                                  pastDays);
                               }
                               break;
                      }
                      $("tasks.split.due_today.text").firstChild.data=text;        
                      $("tasks.split.due_today").style.display="";
                  }
                  break;
            case "participants":
                  objTaskDetailParticipants.popArray();
                  objTaskDetailParticipants.oParticipantResources = clone(idvalue);  
                  objTaskDetailParticipants.writeCountParticipants();
                  objTaskDetailParticipants.pushArray();
                  jQuery("#tasks\\.split\\.participants_count").text("(" + objTaskDetailParticipants.arrayLength() + ")");
                  internalCache.getUsers(objTaskDetailParticipants.idUserArr,fnSetTaskUserColumn);
                  break;
            case "users":
                  // trigger confirmation                      
                  for (var i=0; idvalue && i < idvalue.length; i++) {
                      if (idvalue[i].id == configGetKey("identifier")) { 
                        triggerEvent("Confirmation_Changed", 1); 
                        break; 
                      }
                  }
                  objTaskDetailParticipants.usersD = idvalue || "";
                  break;
            case "color_label":
                  var img = idvalue || "0";
                  $("tasks.split." + idfield).src = getFullImgSrc("img/menu/tag_"+img+".gif");
                  continue;
                  break;             
            case "private_flag":
                  var img = idvalue ? "img/private_flag.gif" : "img/dummy.gif";
                  $("tasks.split." + idfield).src = getFullImgSrc(img);
                  continue;
                  break;
            case "actual_duration":
            case "target_duration":
                  idvalue = idvalue ? getInterval(idvalue * 6e4 /* ms/min */) : _("Not set");
                  break;
            case "actual_costs":
            case "target_costs":
                  var currency = object["currency"] || "";
                  idvalue = idvalue && !isNaN(idvalue) ? round(idvalue) + " " + currency : _("Not set");
                  break;
            case "recurrence_type":
                  var img = idvalue ? "img/tasks/sequence.gif" : "img/dummy.gif"; 
                  $("tasks.split." + idfield).src = getFullImgSrc(img);
                  continue;
                  break;
            case "categories":
            	var cat = (idvalue || "");
                $("tasks.split."+idfield).style.display = cat.length ? "" : "none";
                if (cat.length) {
	                  ox.categories.ui.drawCategoriesList(ox.categories.getByString(cat), 
	                		  $("tasks.split."+idfield));
                } else {
              	  removeChildNodes($("tasks.split."+idfield));
                }
                continue;
                break;
            case "number_of_attachments":
                jQuery("#tasks\\.split\\.number_of_attachments").text("(" + idvalue + ")");
                continue;
                break;
            case "alarm":
                if (idvalue) {
                    idvalue = formatDate(idvalue, "datetime");
                } else {
                    idvalue = _("Not set");
                }
                break;
        }
        
        if ($("tasks.split." + idfield)) {
            $("tasks.split." + idfield).firstChild.data = idvalue != null ? idvalue : _("Not set");
        }
    }
    enableTaskLoadingScreen(false);
    resizeTaskSplitHeader(configGetKey("gui.tasks.fullsplitheader"));
}

function addAttachment() {
    if (activeTaskId[0]) {
        xaId = activeTaskId[0].id;
    } else if (id[0]) {
        xaId = id[0].id;
    }
    if (attachmentWindow == 0) {
        var taskAttachment = new Attachment("taskAttachment", activefolder, 4, xaId);
        attachmentWindow = 1;
    }
}

function jumpToTasksConfiguration(){
    triggerEvent("OX_Switch_View","configuration/tasks/preferences");
}

/* Participant object */
function TaskDetailParticipants() {
    this.oParticipantResources = null;
    this.idUserArr = new Array();
    this.idGroupArr = new Array();
    this.idResourceArr = new Array();
    this.sText = "";
    this.nText = null;
    this.nPart = 0;
    this.gridData = new Array();
    this.gridIndex = 0;
    this.idForExternal = 1000000000;
    this.usersD = null;
}

TaskDetailParticipants.prototype = {
    writeCountParticipants : function () {
        this.sText = this.oParticipantResources.length;
        jQuery("#tasks\\.split\\.participants_count").text("(" + this.sText + ")");
    },
    pushArray : function () {
        for(i=0; i < this.oParticipantResources.length; i++)
        {
                /*
                 * type 1 user
                 * type 2 user group
                 * type > 2 resource
                 * */
            switch (this.oParticipantResources[i].type) {
                case 1:  this.idUserArr.push(this.oParticipantResources[i].id);
                            break;
                                                        
                case 2:     this.idGroupArr.push(this.oParticipantResources[i].id);
                            break;
                            
                case 3:     this.idResourceArr.push(this.oParticipantResources[i].id);
                            break;
                            
                case 5:  this.idUserArr.push(this.oParticipantResources[i]);
                            break;                          
                                                
            }                           
        }
    },
    popArray : function () {
        this.idUserArr.length = 0;
        this.idGroupArr.length = 0;
        this.idResourceArr.length = 0;
    },
    writeMoreButton : function() {
        $("a_d_participants_more").style.display = 'inline';
        $("a_d_participants_more").style.display = 'block';
    },
    writeMoreButtonResource : function() {
        $("a_d_participants_more_resources").style.display = 'inline';
        $("a_d_participants_more_resources").style.display = 'block';
    },
    arrayLength : function() {
        var theLength = this.idUserArr.length + this.idGroupArr.length + this.idResourceArr.length;
        return theLength;
    },
    fnSetUserColumn : function (arg) {
        /*
        var i = 0;
        var j = this.gridData.length;
        while (i < j) {
            this.gridData.pop();
            i++;
        }
        */
        for(var i=0; i < this.idUserArr.length; i++) {
            if(this.nPart < 6 ) {   
                if(arg[this.idUserArr[i]]) {                            
                    this.sText = arg[this.idUserArr[i]].display_name;                                       
                    $("a_d_participants_" + (this.nPart+1)).firstChild.data = this.sText;
                    aDetailFieldsToClear["a_d_participants_" + (this.nPart+1)] = "set";
                    this.nPart++;               
                }       
            } else {
                this.writeMoreButton();
            }
            if(typeof this.idUserArr[i] == "number") {
                this.gridData[this.gridIndex] = new Array();
                this.gridData[this.gridIndex].push(arg[this.idUserArr[i]].id);
                this.gridData[this.gridIndex].push("user");
                this.gridData[this.gridIndex].push(arg[this.idUserArr[i]].display_name);        
                this.gridIndex++;   
                aPrintDetailTask.push(Print.createContent(_("Participant:"),arg[this.idUserArr[i]].display_name));
            
            } else {
                this.gridData[this.gridIndex] = new Array();
                this.gridData[this.gridIndex].push(this.idForExternal);
                this.gridData[this.gridIndex].push("user_extern");
                this.gridData[this.gridIndex].push(this.idUserArr[i].display_name || this.idUserArr[i].mail);     
                this.gridIndex++;
                this.idForExternal ++;
                aPrintDetailApp.push(Print.createContent(_("Participant:"), (this.idUserArr[i].display_name || this.idUserArr[i].mail)));
            }
        }
        var Self = this;
        setTimeout(
            function() {
                refTaskDetailParticipantTab.users= Self.usersD;
                refTaskDetailParticipantTab.makeGrid();
            },20
        );
        setTimeout(                                                 
            function() {
                internalCache.getGroups(objTaskDetailParticipants.idGroupArr,fnSetTaskGroupColumn);
            },0
        );
    },
    fnSetGroupColumn : function (arg)
    {
        var tmp_grouplength = new Array();
        var tmp_userToGet = new Array();
        for(var i=0; i < this.idGroupArr.length; i++)
        {
            if(this.nPart < 6 ) 
            {                                       
                this.sText = arg[this.idGroupArr[i]].display_name;                              
                $("a_d_participants_" + (this.nPart+1)).firstChild.data = this.sText;
                aDetailFieldsToClear["a_d_participants_" + (this.nPart+1)] = "set";     
                this.nPart++;                                   
            }
            else
            {
                this.writeMoreButton();
            }
            this.gridData[this.gridIndex] = new Array();
            this.gridData[this.gridIndex].push(arg[this.idGroupArr[i]].id);
            this.gridData[this.gridIndex].push("group");
            this.gridData[this.gridIndex].push(arg[this.idGroupArr[i]].display_name);   
            this.gridData[this.gridIndex].push("group");
            this.gridData[this.gridIndex].push(""); 
            tmp_grouplength[this.idGroupArr[i]] = this.gridIndex + 1;
            this.gridIndex += (arg[this.idGroupArr[i]].members.length + 1);
            for(tz in arg[this.idGroupArr[i]].members)
                tmp_userToGet.push({id : arg[this.idGroupArr[i]].members[tz], type : 1});
        }
        var Self = this;
        internalCache.getObjects(tmp_userToGet, function(cb){
            for(gr in tmp_grouplength){
                for(me in arg[gr].members){
                    Self.gridData[tmp_grouplength[gr]] = new Array();
                    Self.gridData[tmp_grouplength[gr]].push(arg[gr].members[me] + "gm");
                    Self.gridData[tmp_grouplength[gr]].push("groupMember");
                    Self.gridData[tmp_grouplength[gr]].push(cb[arg[gr].members[me]].display_name);
                    tmp_grouplength[gr]++;
                }
            }
        });
    },
    fnSetResourceColumn : function (arg)
    {
        for(var i=0; i < this.idResourceArr.length; i++)
        {
            if(i < 2 ) 
            {                                       
                this.sText = arg[this.idResourceArr[i]].display_name;                                   
                $("a_d_resources_" + (i+1)).firstChild.data = this.sText;
                aDetailFieldsToClear["a_d_resources_" + (i+1)] = "set";     
            }
            else
            {
                this.writeMoreButtonResource();
            }
        this.gridData[this.gridIndex] = new Array();
        this.gridData[this.gridIndex].push(arg[this.idResourceArr[i]].id);
        this.gridData[this.gridIndex].push("ressourcen");   
        this.gridData[this.gridIndex].push(arg[this.idResourceArr[i]].display_name);    
        this.gridData[this.gridIndex].push("ressourcen");   
        this.gridData[this.gridIndex].push("");
        this.gridIndex++;
        }
    }
};

function TaskDetailParticipantTab() {
    this.users = null;
    this.list = $("taskParticipants");
    this.listHeader = $("taskParticipantsHeader");
    this.myTaskPStorage = null;
    this.myTaskPStorage = new Storage(0, []);
}

TaskDetailParticipantTab.prototype = {
    
    makeGrid : function () {        
    
        if (taskParticipantsGrid) 
        {
            this.list.innerHTML = "";
            taskParticipantsGrid = null;
        }
        
        taskParticipantsGrid = new LiveGrid([{  
            text: "&#xa0;",
            sortable: true,
            width: "16px",
            style: {padding: 0},
            set: function(div,text) 
            {
                if (div) {
                    removeChildNodes(div);
                    if(text != "groupMember")
                        div.appendChild(newnode("img", 0, {src : getFullImgSrc("img/calendar/" + text + ".gif"), alt : _("Participant") }));
                    else
                        div.appendChild(newnode("img", 0, {src : getFullImgSrc("img/dummy.gif"), alt : _("Participants"), width: "16", height: "16" }));
                }
            },
            clear: LiveGrid.makeClear(""),
            index:1
        },{ 
            text: "Participants",   /*i18n*/
            i18n:true,
            sortable: true,
            width: "30%",
            set: function(div, text){               
                if (div) {
                    removeChildNodes(div);
                    if(text[1] == "groupMember"){
                        div.appendChild(newnode("img", 0, {src: getFullImgSrc("img/calendar/user.gif"), alt: "Group Member"}));
                        div.appendChild(document.createTextNode("\u00a0" + text[2]));
                    } else {
                        div.appendChild(document.createTextNode(text[2]));
                    }
                }
            },
            clear: LiveGrid.makeClear("")
        }, {
            text: "Status", /*i18n*/
            i18n:true,
            sortable: true,
            width: "10%",
            set: function(div,text) {
                if (div) {
                    removeChildNodes(div);
                    switch(text) {
                        case 0  :   div.appendChild(addTranslated(_("waiting")));
                                        break;
                                        
                        case 1  :   div.appendChild(newnode("span", 0, {className : "appointmentACCEPTED"}, [document.createTextNode(_("accepted"))]));
                                        break;
                                        
                        case 2  :   div.appendChild(newnode("span", 0, {className : "appointmentDECLINED"}, [document.createTextNode(_("declined"))])); 
                                        break;
                                        
                        case 3  :   div.appendChild(newnode("span", 0, {className : "appointmentTENTATIVE"}, [document.createTextNode(_("tentative"))]));
                                        break;
                                        
                        default :   div.appendChild(document.createTextNode("\u00a0"));
                                        break;
                    }
                }
            },
            clear: LiveGrid.makeClear(""),
            index:3
        }, {
            text: "Comment",    /*i18n*/
            i18n:true,
            sortable: true,
            set: LiveGrid.defaultSet,
            clear: LiveGrid.makeClear(""),
            index:4
        }

        ], new Selection());
        if(taskParticipantsGrid.getHeader()) {
            removeChildNodes(this.listHeader);
            this.listHeader.appendChild(taskParticipantsGrid.getHeader());
        }
        taskParticipantsGrid.getTable(this.list);
    },
    
    appendToStorage : function() {  
        // do not sort because the group members must be shown behind the groups
        /*function sort_fn(a,b)
        {
            if(a[2] < b[2])
                return -1;
            else
                return 1;                           
        }
        objTaskDetailParticipants.gridData.sort(sort_fn);
        */
        for(var i = 0; i < objTaskDetailParticipants.gridData.length; i++) {
            for(var t = 0; t < this.users.length; t++) {
                if(this.users[t].id == objTaskDetailParticipants.gridData[i][0]) {
                    objTaskDetailParticipants.gridData[i].push(this.users[t].confirmation);
                    objTaskDetailParticipants.gridData[i].push(this.users[t].confirmmessage || ""); 
                }
            }           
        }
    },
    
    enableGrid : function () {
        this.appendToStorage();
        var tmp_participants = new Array();
        for(var i = 0; i < objTaskDetailParticipants.gridData.length; i++) {
            tmp_participants[i] = objTaskDetailParticipants.gridData[i];
        }
        this.myTaskPStorage.append(tmp_participants);
        //enable the grid
        if(taskParticipantsGrid) {
            taskParticipantsGrid.enable(this.myTaskPStorage);
        }
    },
    
    disableGrid : function() {
        this.myTaskPStorage.remove(0,objTaskDetailParticipants.gridData.length);
        if(taskParticipantsGrid)
            taskParticipantsGrid.disable(); 
    }
};

function tasks_HeaderUpdate(data) {
    if (data.search) return; // do not update when search is active
    tasksFolderPath.additionalNode=document.createTextNode(" ("+ data.objects.length + ")");
    tasksFolderPath.drawDOMNode(currentpath2[1] == "split" ? "taskofsplitview" : "taskoflistview", activefolder);
}

function fnSetTaskUserColumn(arg) {
    if (arg) {
        objTaskDetailParticipants.fnSetUserColumn(arg);
    }
}

function fnSetTaskGroupColumn(arg) {
    objTaskDetailParticipants.fnSetGroupColumn(arg);
}
function fnSetTaskResourceColumn(arg) {
    objTaskDetailParticipants.fnSetResourceColumn(arg);
}
fileloaded();