
#!/bin/sh

version="OX Language Helper V. 0.4"

#####################################
# $version 
# by Ben Pahne
# Copyright (C) 2016 OX Software GmbH
#####################################

base=$(pwd)

# The Default Selection for the language select 
default_language=3
default_branch=2
default_folderhandling=1
default_starter=1

# Some variables for this script
cvspath=192.168.32.126:/var/lib/cvs


getsvndata(){    
     #svn co http://www.open-xchange.org/eve/i18n/trunk/$language $tempdir/svndata
     cd $tempdir
     cvs co -r sp4 openexchange 
     cd ..
     cp -r /tmp/svndata $tempdir/.
}

clear

echo "### $version ####################### Step 1/6 ##"
echo
echo "What do you want to do?"
echo
echo "[1] I want to work with PO files from the CVS"
echo "[2] I want to start a new translation and I requiere the POT files"
echo "[3] I want a working language packages which can be installed on a OX server"
echo "[4] I want a working language packages and POT files!"
echo "[0] Cancel"
echo
echo -n "Make a choice: (Default [$default_starter]): "
read starter

if [ -z $starter ]; then
    starter="$default_starter"
fi

if [ $starter == "0" ]; then
    echo
    echo "Thank You for using this script. Stopping now"
    exit
fi

clear

if [ $starter == "1" ]; then

    echo "### $version ####################### Step 2/6 ##"
    echo
    echo "Select a language from our CVS"
    echo "(If you want to make a new translation based on"
    echo "the english original choose [1] English)"
    echo
    echo "[1] English (en_US)"
    echo "[2] German  (de_DE)"
    echo "[3] French (fr_FR)"
    echo "[4] Spanish (es_ES)" 
    echo "[5] Spanish Catalan (ca_ES)" 
    echo "[6] Japanese (jp_JP)"
    echo "[7] Polish (pl_PL)" 
    echo "[0] Cancel"
    echo
    echo -n "Which language do you want to get? (Default [$default_language]): "
    read lang

    if [ -z $lang ]; then
	lang="$default_language"
    fi
    
    if [ $lang == "0" ]; then
	echo
	echo "Thank You for using this script. Stopping now"
	exit
    elif [ $lang == "1" ]; then
	echo
	echo "Loading language $lang which is English (en_US)"
	lase="en_US"
    elif [ $lang == "2" ]; then
	echo
	echo "Loading language $lang which is German (de_DE)"
	lase="de_DE"
    elif [ $lang == "3" ]; then
	echo
	echo "Loading language $lang which is French (fr_FR)"
	lase="fr_FR"
    elif [ $lang == "4" ]; then
	echo
	echo "Loading language $lang which is Spanish (es_ES)"
	lase="es_ES"
    elif [ $lang == "5" ]; then
	echo
	echo "Loading language $lang which is Spanish Catalan (ca_ES)"
	lase="ca_ES"
    elif [ $lang == "6" ]; then
	echo
	echo "Loading language $lang which is Japanese (jp_JP)"
	lase="jp_JP"
    elif [ $lang == "7" ]; then
	echo
	echo "Loading language $lang which is Polish (pl_PL)"
	lase="pl_PL"
    else
	echo "\"$lang\" is not known by this script. Stopping now"
	exit
    fi
fi

clear
echo "### $version ####################### Step 3/6 ##"
echo
echo -n "Now tell us the CVS server and path: (Default $cvspath) "
read cvspathe

if [ -z $cvspathe ]; then
    cvspathe="$cvspath"
fi


clear
echo "### $version ####################### Step 4/6 ##"
echo
echo -n "Now tell us your CVS username: "
read cvsuser
export CVSROOT=:pserver:$cvsuser@$cvspathe
cvs login
echo

clear

echo "### $version ####################### Step 5/6 ##"
echo

echo "Which version of this language do you want to load"
echo
echo "[1] HEAD (Not recommended ant not working)"
echo "[2] Open-Xchange HE SP3"
echo "    - open-xchange sp3_update1_rc5"
echo "    - open-xchange-gui sp3_update1_rc5"
echo "    - openexchange-common sp3_rc1"
echo "    - open-xchange-admin oxee_update2_rc3"
echo "[4] Other (Choose by yourself)"
echo
echo -n "Select an option: (Default [$default_branch])"
read branch

if [ -z $branch ]; then
    branch="$default_branch"
fi

if [ $branch == "4" ]; then
    echo -n "Which branch do you want to load for open-xchange: "
    read cvsbranch_ox
    echo
    echo -n "Which branch do you want to load for open-xchange-gui: "
    read cvsbranch_oxgui
    echo
    echo -n "Which branch do you want to load for openexchange-common: "
    read cvsbranch_oxcommon
    echo
    echo -n "Which branch do you want to load for open-xchange-admin: "
    read cvsbranch_oxadmin
    echo
elif [ $branch == "2" ]; then
    cvsbranch_ox="sp3_update1_rc5"
    cvsbranch_oxgui="sp3_update1_rc5"
    cvsbranch_oxcommon="sp3_rc1"
    cvsbranch_oxadmin="oxee_update2_rc3"
elif [ $branch == "1" ]; then
    cvsbranch_ox="HEAD"
    cvsbranch_oxgui="HEAD"
    cvsbranch_oxcommon="HEAD"
    cvsbranch_oxadmin="HEAD"
else
    echo "Don't know what you mean with \"$branch\" so i better quit here."
    exit
fi


if [ $starter == "1" ]; then

    clear
    echo "### $version ####################### Step 5.1/6 ##"
    echo

    if [ -d $lase ]; then
	echo
	echo "!!!! WARNING !!!!"
	echo "This directory already has a subfolder called $lase."
	echo "What do you want to do now?"
	echo
	echo "[1] Stop this script, I will take care about this on my own"
	echo "[2] Delete the folder and get the new one from CVS"
	echo "[3] Try an CVS update with this folder"
	echo
	echo -n "What is your option? (Default [$default_folderhandling]): "
	read whattodo
	
	if [ -z $whattodo ]; then
	    whattodo=$default_folderhandling
	fi
    fi
    
    coup="0"
    
    if [ -z $whattodo ]; then
	coup="1"
    elif [ $whattodo == "1" ]; then
	echo
	echo "For safety reason I will stop now."
	exit
    elif [ $whattodo == "2" ]; then
	
	clear
	echo "### $version ####################### Step 5.2/6 ##"
	echo
	
	echo
	echo "!!!! WARNING !!!!"
	echo "You are about do delete the folder $lase"
	echo "Are you sure?"
	echo
	echo "[1] Stop this script, I will take care about this on my own"
	echo "[2] Yes"
	echo
	echo -n "What is your option? (Default [1]): "
	read whattodonext
	
	if [ -z $whattodonext ]; then
	    whattodonext="1"
	fi
	
	if [ $whattodonext == "1" ] || [ $whattodo == "3" ]; then
	    echo
	    echo "For safety reason I will stop now."
	    exit
	elif [ $whattodonext == "2" ]; then
	    rm -r $lase
	    coup="1"
	else
	    echo "Don't know what \"$whattodonext\" is." 
	    echo "For safety reason I will stop now."
	    exit
	fi
    elif [ $whattodo == "3" ]; then
	echo
	echo "Doing CVS update with folder $lase"
	coup="2"
    else
	echo "Don't know what \"$whattodo\" is." 
	echo "For safety reason I will stop now."
	exit
    fi
    
    clear
    echo "### $version ####################### Step 6/6 ##"
    echo
    
    
    if [ $coup == "1" ]; then
	echo "Star loading files from CVS. Please wait a few seconds"
	
	mkdir $lase
	cd $lase
	cvs -Q co -r $cvsbranch_oxgui -d $lase\_gui open-xchange-gui/i18n/$lase/po/
	cvs -Q co -r $cvsbranch_ox -d $lase\_server open-xchange/i18n/$lase/
	cvs -Q co -r $cvsbranch_oxadmin -d $lase\_admin open-xchange-admin-gui-ee-ajax/i18n/$lase/po/
	cd ../
	echo
	echo
	echo "All files loaded - You find them in the folder $lase"
	echo
    elif [ $coup == "2" ]; then
	echo "Trying to update CVS repository"
	
	cd $lase\/$lase\_gui
	cvs update
	cd ../$lase\_server
	cvs update
	
	echo "Done"
    fi
fi
if [ $starter == "2" ] || [ $starter == "4" ]; then

    clear
    echo "### $version ####################### Step 5.1/6 ##"
    echo

    if [ -d "pot" ]; then
	echo
	echo "!!!! WARNING !!!!"
	echo "This directory already has a subfolder called \"pot\"."
	echo "What do you want to do now?"
	echo
	echo "[1] Stop this script, I will take care about this on my own"
	echo "[2] Delete the folder and create a  new one"
	echo
	echo -n "What is your option? (Default [$default_folderhandling]): "
	read whattodo
	
	if [ -z $whattodo ]; then
	    whattodo=$default_folderhandling
	fi
    fi
    
    coup="0"
    
    if [ -z $whattodo ]; then
	coup="1"
    elif [ $whattodo == "1" ]; then
	echo
	echo "For safety reason I will stop now."
	exit
    elif [ $whattodo == "2" ]; then
	
	clear
	echo "### $version ####################### Step 5.2/6 ##"
	echo
	
	echo
	echo "!!!! WARNING !!!!"
	echo "You are about do delete the folder \"pot\""
	echo "Are you sure?"
	echo
	echo "[1] Stop this script, I will take care about this on my own"
	echo "[2] Yes"
	echo
	echo -n "What is your option? (Default [1]): "
	read whattodonext
	
	if [ -z $whattodonext ]; then
	    whattodonext="1"
	fi
	
	if [ $whattodonext == "1" ] || [ $whattodo == "3" ]; then
	    echo
	    echo "For safety reason I will stop now."
	    exit
	elif [ $whattodonext == "2" ]; then
	    rm -r "pot"
	    coup="1"
	else
	    echo "Don't know what \"$whattodonext\" is." 
	    echo "For safety reason I will stop now."
	    exit
	fi
    else
	echo "Don't know what \"$whattodo\" is." 
	echo "For safety reason I will stop now."
	exit
    fi
    
    clear
    echo "### $version ####################### Step 6/6 ##"
    echo
    
    
    if [ $coup == "1" ]; then
	echo "Start loading files from CVS. Please wait a few seconds/minutes"
	
	mkdir pot
	cd pot
	mkdir tmp
	cd  tmp
	echo
	echo "* Loading open-xchange-gui"
	cvs -Q co -r $cvsbranch_oxgui open-xchange-gui

	echo "* Loading open-xchange-admin-gui-ee-ajax"
	cvs -Q co -r $cvsbranch_oxadmin open-xchange-admin-gui-ee-ajax

	echo "* Loading open-xchange"
	cvs -Q co -r $cvsbranch_ox open-xchange
	cd open-xchange

	echo "* Loading openexchange-common"
	cvs co -r $cvsbranch_oxcommon openexchange-common
	
	echo "* Building open-xchange"
	ant -q all-i18n -D3rdlib=openexchange-common/jars

	cd i18n

	if [ -e "errors.pot" ] && [ -e "server.pot" ]; then
	    mv errors.pot server.pot ../../../
	else
	    echo
	    echo "!!! ERROR !!!"
	    echo "The files errors.pot and server.pot was not found. Ant was unable to generate these two files."
	    echo
	    exit
	fi

	cd ../../open-xchange-gui

	echo
	echo "* Building open-xchange-gui"
	ant -q -noclasspath -Dlib.dir=../open-xchange/openexchange-common/jars pot

	cd i18n

	if [ -e "ox.pot" ]; then
	    mv ox.pot ../../../
	else
	    echo
	    echo "!!! ERROR !!!"
	    echo "The file ox.pot was not found. Ant was unable to generate this file."
	    echo
	    exit
	fi	

	cd ../../open-xchange-admin-gui-ee-ajax

	echo
	echo "* Building open-xchange-admin"
	ant -q -noclasspath -Dlib.dir=../open-xchange/openexchange-common/jars pot

	cd i18n

	if [ -e "ox.pot" ]; then
	    mv ox.pot ../../../ox_admin.pot
	else
	    echo
	    echo "!!! ERROR !!!"
	    echo "The file ox.pot was not found. Ant was unable to generate this file."
	    echo
	    exit
	fi	

	cd ..
	cd ..
	cd ..
	rm -r tmp
	echo
	echo
	echo "All Done - You find the pot files in the folder \"pot\""
	echo
	cd ..
    fi
fi

whattodo=""
whattodonext=""

if [ $starter == "3" ] || [ $starter == "4" ]; then

    clear
    echo "### $version ####################### Step 5.1/6 ##"
    echo

    if [ -d "js" ]; then
	echo
	echo "!!!! WARNING !!!!"
	echo "This directory already has a subfolder called \"js\"."
	echo "What do you want to do now?"
	echo
	echo "[1] Stop this script, I will take care about this on my own"
	echo "[2] Delete the folder and create a  new one"
	echo
	echo -n "What is your option? (Default [$default_folderhandling]): "
	read whattodo
	
	if [ -z $whattodo ]; then
	    whattodo=$default_folderhandling
	fi
    fi
    
    coup="0"
    
    if [ -z $whattodo ]; then
	coup="1"
    elif [ $whattodo == "1" ]; then
	echo
	echo "For safety reason I will stop now."
	exit
    elif [ $whattodo == "2" ]; then
	
	clear
	echo "### $version ####################### Step 5.2/6 ##"
	echo
	
	echo
	echo "!!!! WARNING !!!!"
	echo "You are about do delete the folder \"js\""
	echo "Are you sure?"
	echo
	echo "[1] Stop this script, I will take care about this on my own"
	echo "[2] Yes"
	echo
	echo -n "What is your option? (Default [1]): "
	read whattodonext
	
	if [ -z $whattodonext ]; then
	    whattodonext="1"
	fi
	
	if [ $whattodonext == "1" ] || [ $whattodo == "3" ]; then
	    echo
	    echo "For safety reason I will stop now."
	    exit
	elif [ $whattodonext == "2" ]; then
	    rm -r "js"
	    coup="1"
	else
	    echo "Don't know what \"$whattodonext\" is." 
	    echo "For safety reason I will stop now."
	    exit
	fi
    else
	echo "Don't know what \"$whattodo\" is." 
	echo "For safety reason I will stop now."
	exit
    fi
    
    clear
    echo "### $version ####################### Step 6/6 ##"
    echo
    
    
    if [ $coup == "1" ]; then
	echo "Star loading files from CVS. Please wait a few seconds/minutes"
	
	mkdir js
	cd js
	mkdir gui
	mkdir admin
	mkdir server
	mkdir tmp
	cd tmp
	echo
	echo "* Loading open-xchange-gui"
	cvs -Q co -r $cvsbranch_oxgui open-xchange-gui

	echo "* Loading open-xchange-admin-gui-ee-ajax"
	cvs -Q co -r $cvsbranch_oxadmin open-xchange-admin-gui-ee-ajax

	echo "* Loading open-xchange"
	cvs -Q co -r $cvsbranch_ox open-xchange
	cd open-xchange
	cd i18n

#	echo "* Loading openexchange-common"
#	cvs -Q co -r $cvsbranch_oxcommon openexchange-common
	
	echo "* Building open-xchange"
	ant -q create-lang-jars 

	cd tmp/i18n

	if  [ -e "de_DE.jar" ]; then
	    mv *.jar ../../../../../server/
	else
	    echo
	    echo "!!! ERROR !!!"
	    echo "The file ox_languages.jar was not found. Ant was unable to generate this file."
	    echo
	    exit
	fi	

 
	cd ../../../../open-xchange-gui

	echo
	echo "* Building open-xchange-gui"
	ant -q -noclasspath -Dlib.dir=../open-xchange/openexchange-common/jars lang

	cd lang
	mv *.js ../../../gui/

	cd ../../open-xchange-admin-gui-ee-ajax

	echo
	echo "* Building open-xchange-admin"
	ant -q -noclasspath -Dlib.dir=../open-xchange/openexchange-common/jars lang

	cd lang

	mv *.js ../../../admin/

	cd ../../../
	rm -r tmp
	echo
	echo
	echo "All Done - You find the js files in the folder \"js\""
	echo
	cd ..
    fi
fi

echo "Thank You for using this script. Stopping now"
exit
