/**
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) 2016 OX Software GmbH
 * Mail: info@open-xchange.com
 *
 * @author Matthias Biggeleben <matthias.biggeleben@open-xchange.com>
 */

register('Ready', function () {

    var $ = jQuery;

    function addLink () {

        var node = $(this.dom.node);

        if (node.find('a.add-feed').length === 0) {
            node.append(
                $('<div>')
                .css({ lineHeight: '2em', margin: '0 15px 0 15px' })
                .append(
                    $('<a>', { href: '#' })
                    .addClass('common-link add-feed')
                    .append(addTranslated(_('Add Facebook/Twitter ...')))
                    .bind('click', function (e) {
                        e.preventDefault();
                        ox.mail.addFeed();
                    })
                )
            );
        }
    }

    // defer code loading
    defineDeferredFunction(ox.mail, 'addFeed', 'com.openexchange.social.accounts');

    try {
        // add to expert tree
        addLink.call(ox.widgets.folderTree);
        ox.widgets.folderTree.addListener('widget:painted', addLink);

        // add to mail tree
        addLink.call(ox.widgets.sidepanelViews.mailTree);
        ox.widgets.sidepanelViews.mailTree.addListener('widget:painted', addLink);
    }
    catch (e) {
        if (console.error) {
            console.error(e);
        }
    }
});
