/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.xml.transform.Result;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamResult;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.Err;
import net.sf.saxon.OutputURIResolver;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.event.StandardOutputResolver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.Optimizer;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMinor;
import net.sf.saxon.functions.EscapeURI;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.om.XML11Char;
import net.sf.saxon.pattern.NoNodeTest;
import net.sf.saxon.sort.IntHashMap;
import net.sf.saxon.sort.IntIterator;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.Value;

public class ResultDocument
extends Instruction {
    private Expression href;
    private Expression formatExpression;
    private Expression content;
    private Properties globalProperties;
    private Properties localProperties;
    private String baseURI;
    private int validationAction;
    private SchemaType schemaType;
    private IntHashMap serializationAttributes;
    private NamespaceResolver nsResolver;

    public ResultDocument(Properties properties, Properties properties2, Expression expression, Expression expression2, String string, int n, SchemaType schemaType, IntHashMap intHashMap, NamespaceResolver namespaceResolver) {
        this.globalProperties = properties;
        this.localProperties = properties2;
        this.href = expression;
        this.formatExpression = expression2;
        this.baseURI = string;
        this.validationAction = n;
        this.schemaType = schemaType;
        this.serializationAttributes = intHashMap;
        this.nsResolver = namespaceResolver;
        this.adoptChildExpression(expression);
        Iterator iterator = intHashMap.valueIterator();
        while (iterator.hasNext()) {
            this.adoptChildExpression((Expression)iterator.next());
        }
    }

    public void setContent(Expression expression) {
        this.content = expression;
        this.adoptChildExpression(expression);
    }

    public Expression simplify(StaticContext staticContext) throws XPathException {
        this.content = this.content.simplify(staticContext);
        if (this.href != null) {
            this.href = this.href.simplify(staticContext);
        }
        IntIterator intIterator = this.serializationAttributes.keyIterator();
        while (intIterator.hasNext()) {
            int n = intIterator.next();
            Expression expression = (Expression)this.serializationAttributes.get(n);
            if (expression instanceof Value) continue;
            expression = expression.simplify(staticContext);
            this.serializationAttributes.put(n, expression);
        }
        return this;
    }

    public Expression typeCheck(StaticContext staticContext, ItemType itemType) throws XPathException {
        this.content = this.content.typeCheck(staticContext, itemType);
        this.adoptChildExpression(this.content);
        if (this.href != null) {
            this.href = this.href.typeCheck(staticContext, itemType);
            this.adoptChildExpression(this.href);
        }
        if (this.formatExpression != null) {
            this.formatExpression = this.formatExpression.typeCheck(staticContext, itemType);
            this.adoptChildExpression(this.formatExpression);
        }
        IntIterator intIterator = this.serializationAttributes.keyIterator();
        while (intIterator.hasNext()) {
            int n = intIterator.next();
            Expression expression = (Expression)this.serializationAttributes.get(n);
            if (expression instanceof Value) continue;
            expression = expression.typeCheck(staticContext, itemType);
            this.adoptChildExpression(expression);
            this.serializationAttributes.put(n, expression);
        }
        return this;
    }

    public Expression optimize(Optimizer optimizer, StaticContext staticContext, ItemType itemType) throws XPathException {
        this.content = this.content.optimize(optimizer, staticContext, itemType);
        this.adoptChildExpression(this.content);
        if (this.href != null) {
            this.href = this.href.optimize(optimizer, staticContext, itemType);
            this.adoptChildExpression(this.href);
        }
        if (this.formatExpression != null) {
            this.formatExpression = this.formatExpression.optimize(optimizer, staticContext, itemType);
            this.adoptChildExpression(this.formatExpression);
        }
        IntIterator intIterator = this.serializationAttributes.keyIterator();
        while (intIterator.hasNext()) {
            int n = intIterator.next();
            Expression expression = (Expression)this.serializationAttributes.get(n);
            if (expression instanceof Value) continue;
            expression = expression.optimize(optimizer, staticContext, itemType);
            this.adoptChildExpression(expression);
            this.serializationAttributes.put(n, expression);
        }
        return this;
    }

    public int getIntrinsicDependencies() {
        return 0x1000000;
    }

    protected void promoteInst(PromotionOffer promotionOffer) throws XPathException {
        this.content = this.doPromotion(this.content, promotionOffer);
        if (this.href != null) {
            this.href = this.doPromotion(this.href, promotionOffer);
        }
        IntIterator intIterator = this.serializationAttributes.keyIterator();
        while (intIterator.hasNext()) {
            int n = intIterator.next();
            Expression expression = (Expression)this.serializationAttributes.get(n);
            if (expression instanceof Value) continue;
            expression = this.doPromotion(expression, promotionOffer);
            this.serializationAttributes.put(n, expression);
        }
    }

    public int getInstructionNameCode() {
        return 174;
    }

    public ItemType getItemType(TypeHierarchy typeHierarchy) {
        return NoNodeTest.getInstance();
    }

    public Iterator iterateSubExpressions() {
        ArrayList<Expression> arrayList = new ArrayList<Expression>(6);
        arrayList.add(this.content);
        if (this.href != null) {
            arrayList.add(this.href);
        }
        Iterator iterator = this.serializationAttributes.valueIterator();
        while (iterator.hasNext()) {
            arrayList.add((Expression)iterator.next());
        }
        return arrayList.iterator();
    }

    public TailCall processLeavingTail(XPathContext xPathContext) throws XPathException {
        Object object;
        Object object2;
        String[] stringArray;
        Object object3;
        Object object4;
        Object object5;
        Result result;
        Controller controller = xPathContext.getController();
        Configuration configuration = controller.getConfiguration();
        NamePool namePool = configuration.getNamePool();
        XPathContextMinor xPathContextMinor = xPathContext.newMinorContext();
        xPathContextMinor.setOrigin(this);
        OutputURIResolver outputURIResolver = null;
        if (this.href == null) {
            result = controller.getPrincipalResult();
        } else {
            try {
                object5 = controller.getBaseOutputURI();
                if (object5 == null && configuration.isAllowExternalFunctions()) {
                    object5 = new File(System.getProperty("user.dir")).toURI().toString();
                }
                if (object5 != null) {
                    object5 = ((Object)EscapeURI.iriToUri((CharSequence)object5)).toString();
                }
                if ((result = (outputURIResolver = controller.getOutputURIResolver()).resolve((String)(object4 = ((Object)EscapeURI.iriToUri(this.href.evaluateAsString(xPathContext))).toString()), (String)object5)) == null) {
                    outputURIResolver = StandardOutputResolver.getInstance();
                    result = outputURIResolver.resolve((String)object4, (String)object5);
                }
            }
            catch (TransformerException transformerException) {
                throw DynamicError.makeDynamicError(transformerException);
            }
        }
        if (!controller.checkUniqueOutputDestination(result.getSystemId())) {
            object5 = new DynamicError("Cannot write more than one result document to the same URI: " + result.getSystemId());
            ((DynamicError)object5).setXPathContext(xPathContext);
            ((XPathException)object5).setErrorCode("XTDE1490");
            throw object5;
        }
        boolean bl = controller.getConfiguration().isTiming();
        if (bl) {
            object4 = result.getSystemId();
            if (object4 == null) {
                object4 = result instanceof StreamResult ? "anonymous output stream" : (result instanceof SAXResult ? "SAX2 ContentHandler" : (result instanceof DOMResult ? "DOM tree" : result.getClass().getName()));
            }
            System.err.println("Writing to " + (String)object4);
        }
        object4 = this.globalProperties;
        if (this.formatExpression != null) {
            object3 = this.formatExpression.evaluateAsString(xPathContext);
            try {
                stringArray = controller.getConfiguration().getNameChecker().getQNameParts((CharSequence)object3);
            }
            catch (QNameException qNameException) {
                DynamicError dynamicError = new DynamicError("The requested output format " + Err.wrap((CharSequence)object3) + " is not a valid QName");
                dynamicError.setErrorCode("XTDE1460");
                dynamicError.setXPathContext(xPathContext);
                throw dynamicError;
            }
            object2 = this.nsResolver.getURIForPrefix(stringArray[0], false);
            if (object2 == null) {
                DynamicError dynamicError = new DynamicError("The namespace prefix in the format name " + (String)object3 + " is undeclared");
                dynamicError.setErrorCode("XTDE1460");
                dynamicError.setXPathContext(xPathContext);
                throw dynamicError;
            }
            int n = namePool.allocate(stringArray[0], (String)object2, stringArray[1]) & 0xFFFFF;
            object4 = this.getExecutable().getOutputProperties(n);
            if (object4 == null) {
                DynamicError dynamicError = new DynamicError("There is no xsl:output format named " + (String)object3);
                dynamicError.setErrorCode("XTDE1460");
                dynamicError.setXPathContext(xPathContext);
                throw dynamicError;
            }
        }
        object3 = new Properties((Properties)object4);
        stringArray = configuration.getNameChecker();
        object2 = this.localProperties.keySet().iterator();
        while (object2.hasNext()) {
            String string = (String)object2.next();
            object = NamePool.parseClarkName(string);
            ResultDocument.setSerializationProperty((Properties)object3, object[0], object[1], this.localProperties.getProperty(string), this.nsResolver, true, (NameChecker)stringArray);
        }
        if (this.serializationAttributes.size() > 0) {
            object2 = this.serializationAttributes.keyIterator();
            while (object2.hasNext()) {
                int n = object2.next();
                object = (Expression)this.serializationAttributes.get(n);
                String string = object.evaluateAsString(xPathContext);
                String string2 = namePool.getLocalName(n);
                String string3 = namePool.getURI(n);
                try {
                    ResultDocument.setSerializationProperty((Properties)object3, string3, string2, string, this.nsResolver, false, (NameChecker)stringArray);
                }
                catch (DynamicError dynamicError) {
                    if ("http://saxon.sf.net/".equals(dynamicError.getErrorCodeNamespace()) && "warning".equals(dynamicError.getErrorCodeLocalPart())) {
                        try {
                            xPathContext.getController().getErrorListener().warning(dynamicError);
                            continue;
                        }
                        catch (TransformerException transformerException) {
                            throw DynamicError.makeDynamicError(transformerException);
                        }
                    }
                    dynamicError.setXPathContext(xPathContext);
                    dynamicError.setLocator(this.getSourceLocator());
                    throw dynamicError;
                }
            }
        }
        if ((object2 = ((Properties)object3).getProperty("{http://saxon.sf.net/}next-in-chain")) != null) {
            try {
                result = controller.prepareNextStylesheet((String)object2, this.baseURI, result);
            }
            catch (TransformerException transformerException) {
                throw DynamicError.makeDynamicError(transformerException);
            }
        }
        xPathContextMinor.changeOutputDestination((Properties)object3, result, true, 50, this.validationAction, this.schemaType);
        SequenceReceiver sequenceReceiver = xPathContextMinor.getReceiver();
        sequenceReceiver.startDocument(0);
        this.content.process(xPathContextMinor);
        sequenceReceiver.endDocument();
        sequenceReceiver.close();
        if (outputURIResolver != null) {
            try {
                outputURIResolver.close(result);
            }
            catch (TransformerException transformerException) {
                throw DynamicError.makeDynamicError(transformerException);
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void setSerializationProperty(Properties properties, String string, String string2, String string3, NamespaceResolver namespaceResolver, boolean bl, NameChecker nameChecker) throws XPathException {
        String string4;
        block46: {
            block45: {
                if (!string.equals("")) break block45;
                if (string2.equals("method")) {
                    if (string3.equals("xml") || string3.equals("html") || string3.equals("text") || string3.equals("xhtml") || bl) {
                        properties.put("method", string3);
                        return;
                    }
                    try {
                        String[] stringArray = nameChecker.getQNameParts(string3);
                        String string5 = stringArray[0];
                        if (string5.equals("")) {
                            DynamicError dynamicError = new DynamicError("method must be xml, html, xhtml, or text, or a prefixed name");
                            dynamicError.setErrorCode("XTSE1570");
                            throw dynamicError;
                        }
                        String string6 = namespaceResolver.getURIForPrefix(string5, false);
                        if (string6 == null) {
                            DynamicError dynamicError = new DynamicError("Namespace prefix '" + string5 + "' has not been declared");
                            dynamicError.setErrorCode("XTSE1570");
                            throw dynamicError;
                        }
                        properties.put("method", '{' + string6 + '}' + stringArray[1]);
                        return;
                    }
                    catch (QNameException qNameException) {
                        DynamicError dynamicError = new DynamicError("Invalid method name. " + qNameException.getMessage());
                        dynamicError.setErrorCode("XTSE1570");
                        throw dynamicError;
                    }
                }
                if (string2.equals("output-version")) {
                    properties.put("version", string3);
                    return;
                }
                if (string2.equals("byte-order-mark")) {
                    if (!(bl || string3.equals("yes") || string3.equals("no"))) {
                        DynamicError dynamicError = new DynamicError("byte-order-mark value must be 'yes' or 'no'");
                        dynamicError.setErrorCode("XTDE0030");
                        throw dynamicError;
                    }
                    properties.put("byte-order-mark", string3);
                    return;
                }
                if (string2.equals("indent")) {
                    if (!(bl || string3.equals("yes") || string3.equals("no"))) {
                        DynamicError dynamicError = new DynamicError("indent must be 'yes' or 'no'");
                        dynamicError.setErrorCode("XTDE0030");
                        throw dynamicError;
                    }
                    properties.put("indent", string3);
                    return;
                }
                if (string2.equals("encoding")) {
                    properties.put("encoding", string3);
                    return;
                }
                if (string2.equals("media-type")) {
                    properties.put("media-type", string3);
                    return;
                }
                if (string2.equals("doctype-system")) {
                    properties.put("doctype-system", string3);
                    return;
                }
                if (string2.equals("doctype-public")) {
                    properties.put("doctype-public", string3);
                    return;
                }
                if (string2.equals("omit-xml-declaration")) {
                    if (!(bl || string3.equals("yes") || string3.equals("no"))) {
                        DynamicError dynamicError = new DynamicError("omit-xml-declaration attribute must be 'yes' or 'no'");
                        dynamicError.setErrorCode("XTDE0030");
                        throw dynamicError;
                    }
                    properties.put("omit-xml-declaration", string3);
                    return;
                }
                if (string2.equals("standalone")) {
                    if (!(bl || string3.equals("yes") || string3.equals("no") || string3.equals("omit"))) {
                        DynamicError dynamicError = new DynamicError("standalone attribute must be 'yes' or 'no' or 'omit'");
                        dynamicError.setErrorCode("XTDE0030");
                        throw dynamicError;
                    }
                    properties.put("standalone", string3);
                    return;
                }
                if (string2.equals("cdata-section-elements")) {
                    string4 = properties.getProperty("cdata-section-elements");
                    if (string4 == null) {
                        string4 = "";
                    }
                    break block46;
                } else {
                    if (string2.equals("use-character-maps")) {
                        String string7 = properties.getProperty("use-character-maps");
                        if (string7 == null) {
                            string7 = "";
                        }
                        properties.put("use-character-maps", string7 + string3);
                        return;
                    }
                    if (string2.equals("undeclare-prefixes")) {
                        if (!(bl || string3.equals("yes") || string3.equals("no"))) {
                            DynamicError dynamicError = new DynamicError("undeclare-namespaces value must be 'yes' or 'no'");
                            dynamicError.setErrorCode("XTDE0030");
                            throw dynamicError;
                        }
                        properties.put("undeclare-prefixes", string3);
                        return;
                    }
                    if (string2.equals("include-content-type")) {
                        if (!(bl || string3.equals("yes") || string3.equals("no"))) {
                            DynamicError dynamicError = new DynamicError("include-content-type attribute must be 'yes' or 'no'");
                            dynamicError.setErrorCode("XTDE0030");
                            throw dynamicError;
                        }
                        properties.put("include-content-type", string3);
                        return;
                    }
                    if (string2.equals("escape-uri-attributes")) {
                        if (!(bl || string3.equals("yes") || string3.equals("no"))) {
                            DynamicError dynamicError = new DynamicError("escape-uri-attributes value must be 'yes' or 'no'");
                            dynamicError.setErrorCode("XTDE0030");
                            throw dynamicError;
                        }
                        properties.put("escape-uri-attibutes", string3);
                        return;
                    }
                    if (!string2.equals("normalization-form")) return;
                    if (XML11Char.isXML11ValidNmtoken(string3)) {
                        properties.put("normalization-form", string3);
                        return;
                    }
                    if (string3.equals("none")) {
                        return;
                    }
                    DynamicError dynamicError = new DynamicError("normalization-form must be a valid NMTOKEN");
                    dynamicError.setErrorCode("XTDE0030");
                    throw dynamicError;
                }
            }
            if (!string.equals("http://saxon.sf.net/")) {
                properties.put('{' + string + '}' + string2, string3);
                return;
            }
            if (string2.equals("character-representation")) {
                properties.put("{http://saxon.sf.net/}character-representation", string3);
                return;
            }
            if (string2.equals("indent-spaces")) {
                try {
                    Integer.parseInt(string3);
                    properties.put("indent", "yes");
                    properties.put("{http://saxon.sf.net/}indent-spaces", string3);
                    return;
                }
                catch (NumberFormatException numberFormatException) {
                    DynamicError dynamicError = new DynamicError("saxon:indent-spaces must be an integer");
                    dynamicError.setErrorCode("http://saxon.sf.net/", "SXWN9002");
                    throw dynamicError;
                }
            }
            if (string2.equals("next-in-chain")) {
                DynamicError dynamicError = new DynamicError("saxon:next-in-chain value cannot be specified dynamically");
                dynamicError.setErrorCode("http://saxon.sf.net/", "SXWN9004");
                throw dynamicError;
            }
            if (!string2.equals("require-well-formed")) return;
            if (!(bl || string3.equals("yes") || string3.equals("no"))) {
                DynamicError dynamicError = new DynamicError("saxon:require-well-formed value must be 'yes' or 'no'");
                dynamicError.setErrorCode("http://saxon.sf.net/", "SXWN9003");
                throw dynamicError;
            }
            properties.put("{http://saxon.sf.net/}require-well-formed", string3);
            return;
        }
        String string8 = "";
        StringTokenizer stringTokenizer = new StringTokenizer(string3);
        while (stringTokenizer.hasMoreTokens()) {
            String string9 = stringTokenizer.nextToken();
            if (bl) {
                string8 = string8 + ' ' + string9;
            } else {
                Object object;
                try {
                    String[] stringArray = nameChecker.getQNameParts(string9);
                    object = namespaceResolver.getURIForPrefix(stringArray[0], true);
                    if (object == null) {
                        DynamicError dynamicError = new DynamicError("Namespace prefix '" + stringArray[0] + "' has not been declared");
                        dynamicError.setErrorCode("XTDE0030");
                        throw dynamicError;
                    }
                    string8 = string8 + " {" + (String)object + '}' + stringArray[1];
                }
                catch (QNameException qNameException) {
                    object = new DynamicError("Invalid CDATA element name. " + qNameException.getMessage());
                    ((XPathException)object).setErrorCode("XTDE0030");
                    throw object;
                }
            }
            properties.put("cdata-section-elements", string4 + string8);
        }
    }

    public void display(int n, PrintStream printStream, Configuration configuration) {
        printStream.println(ExpressionTool.indent(n) + "result-document");
        this.content.display(n + 1, printStream, configuration);
    }
}

