/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.osgi.worker;

import com.openexchange.osgi.OSGiPlugin;
import com.openexchange.osgi.Tools;
import com.openexchange.osgi.data.Classpath;
import com.openexchange.osgi.data.ModuleDependencies;
import com.openexchange.osgi.data.OSGIManifest;
import com.openexchange.osgi.worker.AbstractWorker;
import com.openexchange.osgi.worker.ResolveDependenciesWorker;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.java.archives.Attributes;
import org.gradle.api.java.archives.Manifest;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetOutput;
import org.gradle.api.tasks.bundling.Jar;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0002J(\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\b\u0010\u0012\u001a\u00020\u0006H\u0016J1\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00032\u0012\u0010\u0017\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u0018\"\u00020\u0003H\u0002\u00a2\u0006\u0002\u0010\u0019\u00a8\u0006\u001a"}, d2={"Lcom/openexchange/osgi/worker/ResolveDependenciesWorker;", "Lcom/openexchange/osgi/worker/AbstractWorker;", "projectName", "", "(Ljava/lang/String;)V", "resolveJars", "", "project", "Lorg/gradle/api/Project;", "projectManifest", "Lcom/openexchange/osgi/data/OSGIManifest;", "resolveLocalLibraries", "compileConfiguration", "Lorg/gradle/api/artifacts/Configuration;", "resolveProjectDependencies", "testCompileConfiguration", "moduleDependencies", "Lcom/openexchange/osgi/data/ModuleDependencies;", "run", "setJavaSource", "pluginConvention", "Lorg/gradle/api/plugins/JavaPluginConvention;", "sourceSetName", "srcPaths", "", "(Lorg/gradle/api/plugins/JavaPluginConvention;Ljava/lang/String;[Ljava/lang/String;)V", "osgi"})
public final class ResolveDependenciesWorker
extends AbstractWorker {
    @Override
    public void run() {
        JavaPluginConvention pluginConvention;
        Project project = (Project)OSGiPlugin.Companion.getProjectsPool().get(this.getProjectName());
        if (project == null) {
            return;
        }
        Project project2 = project;
        OSGIManifest oSGIManifest = OSGiPlugin.Companion.getModuleDatabase().getModule(this.getProjectName());
        if (oSGIManifest == null) {
            return;
        }
        OSGIManifest projectManifest = oSGIManifest;
        JavaPluginConvention javaPluginConvention = pluginConvention = (JavaPluginConvention)project2.getConvention().getPlugin(JavaPluginConvention.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)javaPluginConvention, (String)"pluginConvention");
        this.setJavaSource(javaPluginConvention, "test", "test", "sim");
        SourceSet mainSourceSet = (SourceSet)pluginConvention.getSourceSets().getByName("main");
        SourceSet testSourceSet = (SourceSet)pluginConvention.getSourceSets().getByName("test");
        ConfigurationContainer configurationContainer = project2.getConfigurations();
        SourceSet sourceSet = mainSourceSet;
        Intrinsics.checkExpressionValueIsNotNull((Object)sourceSet, (String)"mainSourceSet");
        Configuration compileConfiguration = configurationContainer.getByName(sourceSet.getImplementationConfigurationName());
        ConfigurationContainer configurationContainer2 = project2.getConfigurations();
        SourceSet sourceSet2 = testSourceSet;
        Intrinsics.checkExpressionValueIsNotNull((Object)sourceSet2, (String)"testSourceSet");
        Configuration testCompileConfiguration = configurationContainer2.getByName(sourceSet2.getImplementationConfigurationName());
        ModuleDependencies moduleDependencies = OSGiPlugin.Companion.getModuleDatabase().getModuleDependencies(this.getProjectName());
        Configuration configuration = compileConfiguration;
        Intrinsics.checkExpressionValueIsNotNull((Object)configuration, (String)"compileConfiguration");
        Configuration configuration2 = testCompileConfiguration;
        Intrinsics.checkExpressionValueIsNotNull((Object)configuration2, (String)"testCompileConfiguration");
        this.resolveProjectDependencies(project2, configuration, configuration2, moduleDependencies);
        this.resolveLocalLibraries(project2, projectManifest, compileConfiguration);
        this.resolveJars(project2, projectManifest);
    }

    /*
     * WARNING - void declaration
     */
    private final void resolveProjectDependencies(Project project, Configuration compileConfiguration, Configuration testCompileConfiguration, ModuleDependencies moduleDependencies) {
        List list;
        Set<String> classpathBinaryArtifactPaths;
        Object it;
        Classpath classPath;
        Classpath classpath = classPath = Tools.getClasspath(project);
        Set<String> classpathProjectDependencies = classpath != null ? classpath.getProjectDependencies() : null;
        HashSet<String> moduleDatabaseProjectDependencies = moduleDependencies.getProjects();
        Set projectDependencies = classpathProjectDependencies != null ? CollectionsKt.union((Iterable)moduleDatabaseProjectDependencies, (Iterable)classpathProjectDependencies) : (Set)moduleDatabaseProjectDependencies;
        Iterable $this$forEach$iv = projectDependencies;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JavaPluginConvention depConvention;
            it = (String)element$iv;
            boolean bl = false;
            Project depProject = project.getRootProject().project((String)it);
            compileConfiguration.getDependencies().add((Object)project.getDependencies().create((Object)depProject));
            Project project2 = depProject;
            Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"depProject");
            JavaPluginConvention javaPluginConvention = depConvention = (JavaPluginConvention)project2.getConvention().getPlugin(JavaPluginConvention.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)javaPluginConvention, (String)"depConvention");
            Object object = javaPluginConvention.getSourceSets().getByName("test");
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"depConvention.sourceSets\u2026Set.TEST_SOURCE_SET_NAME)");
            SourceSetOutput depTestOut = ((SourceSet)object).getOutput();
            testCompileConfiguration.getDependencies().add((Object)project.getDependencies().create((Object)depTestOut));
        }
        Classpath classpath2 = classPath;
        Set<String> set = classpathBinaryArtifactPaths = classpath2 != null ? classpath2.getLibs() : null;
        if (set != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = set;
            boolean $i$f$map = false;
            it = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                File file;
                void it2;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                if (StringsKt.startsWith$default((String)it2, (String)"/", (boolean)false, (int)2, null)) {
                    Project project3 = project.getRootProject();
                    Intrinsics.checkExpressionValueIsNotNull((Object)project3, (String)"project.rootProject");
                    file = new File(project3.getProjectDir(), (String)it2);
                } else {
                    file = new File((String)it2);
                }
                File file2 = file;
                collection.add(file2);
            }
            list = (List)destination$iv$iv;
        } else {
            list = null;
        }
        List classpathBinaryArtifacts = list;
        HashSet<File> moduleDatabaseBinaryArtifacts = moduleDependencies.getBinaries();
        Set binaryArtifacts = classpathBinaryArtifacts != null ? CollectionsKt.union((Iterable)moduleDatabaseBinaryArtifacts, (Iterable)classpathBinaryArtifacts) : (Set)moduleDatabaseBinaryArtifacts;
        ConfigurableFileCollection binaryArtifactsFileCollection = project.files(new Object[]{binaryArtifacts});
        Dependency binaryArtifactsDependency = project.getDependencies().create((Object)binaryArtifactsFileCollection);
        compileConfiguration.getDependencies().add((Object)binaryArtifactsDependency);
    }

    /*
     * WARNING - void declaration
     */
    private final void resolveLocalLibraries(Project project, OSGIManifest projectManifest, Configuration compileConfiguration) {
        void $this$filterTo$iv$iv;
        Set<String> set = projectManifest.getListEntry("Bundle-ClassPath");
        Intrinsics.checkExpressionValueIsNotNull(set, (String)"projectManifest.getListE\u2026anifest.BUNDLE_CLASSPATH)");
        Iterable $this$filter$iv = set;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            if (!(Intrinsics.areEqual((Object)it, (Object)".") ^ true)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List localLibsPath = (List)destination$iv$iv;
        ConfigurableFileCollection localLibsFileCollection = project.files(new Object[]{localLibsPath});
        Dependency localLibsDependency = project.getDependencies().create((Object)localLibsFileCollection);
        compileConfiguration.getDependencies().add((Object)localLibsDependency);
        project.getDependencies().add("runtime", (Object)localLibsFileCollection);
    }

    private final void resolveJars(Project project, OSGIManifest projectManifest) {
        project.getTasks().named("jar", Jar.class).configure((Action)new Action<Jar>(projectManifest){
            final /* synthetic */ OSGIManifest $projectManifest;

            public final void execute(Jar jar) {
                jar.manifest((Action)new Action<Manifest>(this){
                    final /* synthetic */ resolveJars.1 this$0;

                    public final void execute(Manifest manifest) {
                        Manifest manifest2 = manifest;
                        Intrinsics.checkExpressionValueIsNotNull((Object)manifest2, (String)"manifest");
                        Attributes attributes = manifest2.getAttributes();
                        Intrinsics.checkExpressionValueIsNotNull((Object)attributes, (String)"manifest.attributes");
                        Map map = (Map)attributes;
                        Set<String> set = this.this$0.$projectManifest.getListEntry("Bundle-ClassPath");
                        Intrinsics.checkExpressionValueIsNotNull(set, (String)"projectManifest.getListE\u2026anifest.BUNDLE_CLASSPATH)");
                        map.put("Class-Path", CollectionsKt.joinToString$default((Iterable)set, (CharSequence)",", null, null, (int)0, null, null, (int)62, null));
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.$projectManifest = oSGIManifest;
            }
        });
    }

    private final void setJavaSource(JavaPluginConvention pluginConvention, String sourceSetName, String ... srcPaths) {
        SourceSet sourceSet = (SourceSet)pluginConvention.getSourceSets().getByName(sourceSetName);
        HashSet<String> sourceDir = new HashSet<String>();
        for (String srcPath : srcPaths) {
            sourceDir.add(srcPath);
        }
        SourceSet sourceSet2 = sourceSet;
        Intrinsics.checkExpressionValueIsNotNull((Object)sourceSet2, (String)"sourceSet");
        sourceSet2.getJava().srcDir(sourceDir);
    }

    @Inject
    public ResolveDependenciesWorker(@NotNull String projectName) {
        Intrinsics.checkParameterIsNotNull((Object)projectName, (String)"projectName");
        super(projectName);
    }
}

