/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.osgi.worker;

import com.openexchange.build.ProjectType;
import com.openexchange.build.projecttype.scanner.ProjectTypeExtension;
import com.openexchange.build.projecttype.scanner.ProjectTypeScannerPlugin;
import com.openexchange.osgi.OSGiPlugin;
import com.openexchange.osgi.worker.AbstractWorker;
import com.openexchange.osgi.worker.handler.ProjectHandler;
import com.openexchange.osgi.worker.handler.ProjectHandlerRegistry;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.gradle.api.logging.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/openexchange/osgi/worker/ProjectWorker;", "Lcom/openexchange/osgi/worker/AbstractWorker;", "projectName", "", "(Ljava/lang/String;)V", "run", "", "osgi"})
public final class ProjectWorker
extends AbstractWorker {
    @Override
    public void run() {
        Project project = (Project)OSGiPlugin.Companion.getProjectsPool().get(this.getProjectName());
        if (project == null) {
            return;
        }
        Project project2 = project;
        Logger logger = project2.getLogger();
        if (project2.getExtensions().findByType(ProjectTypeExtension.class) == null) {
            project2.getPlugins().apply(ProjectTypeScannerPlugin.class);
        }
        ProjectTypeExtension projectTypeExtension = (ProjectTypeExtension)project2.getExtensions().getByType(ProjectTypeExtension.class);
        ProjectType projectType = (ProjectType)projectTypeExtension.getType().get();
        ProjectHandlerRegistry registry = ProjectHandlerRegistry.Companion.getInstance();
        ProjectType projectType2 = projectType;
        Intrinsics.checkExpressionValueIsNotNull((Object)projectType2, (String)"projectType");
        ProjectHandler handler = registry.getHandler(projectType2);
        if (handler == null) {
            logger.debug("{}: No project handler found for project '{}' of type '{}'", new Object[]{"OSGi-Plugin", project2.getName(), projectType});
            return;
        }
        logger.debug("{}: Handling project '{}' of type '{}'", new Object[]{"OSGi-Plugin", project2.getName(), projectType.name()});
        handler.handle(project2);
    }

    @Inject
    public ProjectWorker(@NotNull String projectName) {
        Intrinsics.checkParameterIsNotNull((Object)projectName, (String)"projectName");
        super(projectName);
    }
}

