/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.spdy;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Cacheable;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.ThreadCache;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.http.HttpHeader;
import org.glassfish.grizzly.http.HttpResponsePacket;
import org.glassfish.grizzly.http.Protocol;
import org.glassfish.grizzly.http.util.Ascii;
import org.glassfish.grizzly.http.util.BufferChunk;
import org.glassfish.grizzly.http.util.ByteChunk;
import org.glassfish.grizzly.http.util.DataChunk;
import org.glassfish.grizzly.http.util.Header;
import org.glassfish.grizzly.http.util.HttpCodecUtils;
import org.glassfish.grizzly.http.util.MimeHeaders;
import org.glassfish.grizzly.spdy.Constants;
import org.glassfish.grizzly.spdy.SpdyHandlerFilter;
import org.glassfish.grizzly.spdy.SpdyRequest;
import org.glassfish.grizzly.spdy.SpdyResponse;
import org.glassfish.grizzly.utils.Charsets;

class SpdyDecoderUtils {
    private static final Logger LOGGER = Grizzly.logger(SpdyDecoderUtils.class);

    SpdyDecoderUtils() {
    }

    static void processSynStreamHeadersArray(SpdyRequest spdyRequest, Buffer decoded) {
        byte[] headersArray = decoded.array();
        int position = decoded.arrayOffset() + decoded.position();
        int headersCount = SpdyDecoderUtils.getInt(headersArray, position);
        position += 4;
        for (int i = 0; i < headersCount; ++i) {
            boolean isServiceHeader = headersArray[position + 4] == 58;
            position = isServiceHeader ? SpdyDecoderUtils.processServiceSynStreamHeader(spdyRequest, headersArray, position) : SpdyDecoderUtils.processNormalHeader((HttpHeader)spdyRequest, headersArray, position);
        }
    }

    static void processSynStreamHeadersBuffer(SpdyRequest spdyRequest, Buffer headersBuffer) {
        int position = headersBuffer.position();
        int headersCount = headersBuffer.getInt(position);
        position += 4;
        for (int i = 0; i < headersCount; ++i) {
            boolean isServiceHeader = headersBuffer.get(position + 4) == 58;
            position = isServiceHeader ? SpdyDecoderUtils.processServiceSynStreamHeader(spdyRequest, headersBuffer, position) : SpdyDecoderUtils.processNormalHeader((HttpHeader)spdyRequest, headersBuffer, position);
        }
    }

    static void processUSynStreamHeadersArray(SpdyRequest spdyRequest, Buffer decoded) {
        byte[] headersArray = decoded.array();
        int position = decoded.arrayOffset() + decoded.position();
        int headersCount = SpdyDecoderUtils.getInt(headersArray, position);
        position += 4;
        SpdyResponse spdyResponse = (SpdyResponse)spdyRequest.getResponse();
        for (int i = 0; i < headersCount; ++i) {
            boolean isServiceHeader = headersArray[position + 4] == 58;
            position = isServiceHeader ? SpdyDecoderUtils.processServiceUSynStreamHeader(spdyRequest, headersArray, position) : SpdyDecoderUtils.processNormalHeader((HttpHeader)spdyResponse, headersArray, position);
        }
    }

    static void processUSynStreamHeadersBuffer(SpdyRequest spdyRequest, Buffer headersBuffer) {
        int position = headersBuffer.position();
        int headersCount = headersBuffer.getInt(position);
        position += 4;
        SpdyResponse spdyResponse = (SpdyResponse)spdyRequest.getResponse();
        for (int i = 0; i < headersCount; ++i) {
            boolean isServiceHeader = headersBuffer.get(position + 4) == 58;
            position = isServiceHeader ? SpdyDecoderUtils.processServiceUSynStreamHeader(spdyRequest, headersBuffer, position) : SpdyDecoderUtils.processNormalHeader((HttpHeader)spdyResponse, headersBuffer, position);
        }
    }

    private static int processServiceSynStreamHeader(SpdyRequest spdyRequest, byte[] headersArray, int position) {
        int nameSize = SpdyDecoderUtils.getInt(headersArray, position);
        int valueSize = SpdyDecoderUtils.getInt(headersArray, position + nameSize + 4);
        int nameStart = position + 5;
        int valueStart = position + nameSize + 8;
        int valueEnd = valueStart + valueSize;
        switch (nameSize - 1) {
            case 4: {
                if (SpdyDecoderUtils.checkArraysContent(headersArray, nameStart, Constants.HOST_HEADER_BYTES, 1)) {
                    spdyRequest.getHeaders().addValue(Header.Host).setBytes(headersArray, valueStart, valueEnd);
                    return valueEnd;
                }
                if (!SpdyDecoderUtils.checkArraysContent(headersArray, nameStart, Constants.PATH_HEADER_BYTES, 1)) break;
                int questionIdx = -1;
                for (int i = 0; i < valueSize; ++i) {
                    if (headersArray[valueStart + i] != 63) continue;
                    questionIdx = i + valueStart;
                    break;
                }
                if (questionIdx == -1) {
                    spdyRequest.getRequestURIRef().init(headersArray, valueStart, valueEnd);
                } else {
                    spdyRequest.getRequestURIRef().init(headersArray, valueStart, questionIdx);
                    if (questionIdx < valueEnd - 1) {
                        spdyRequest.getQueryStringDC().setBytes(headersArray, questionIdx + 1, valueEnd);
                    }
                }
                return valueEnd;
            }
            case 6: {
                if (SpdyDecoderUtils.checkArraysContent(headersArray, nameStart, Constants.METHOD_HEADER_BYTES, 1)) {
                    spdyRequest.getMethodDC().setBytes(headersArray, valueStart, valueEnd);
                    return valueEnd;
                }
                if (!SpdyDecoderUtils.checkArraysContent(headersArray, nameStart, Constants.SCHEMA_HEADER_BYTES, 1)) break;
                spdyRequest.setSecure(valueSize == 5);
                return valueEnd;
            }
            case 7: {
                if (!SpdyDecoderUtils.checkArraysContent(headersArray, nameStart, Constants.VERSION_HEADER_BYTES, 1)) break;
                spdyRequest.getProtocolDC().setBytes(headersArray, valueStart, valueEnd);
                return valueEnd;
            }
        }
        LOGGER.log(Level.FINE, "Skipping unknown service header[{0}={1}", new Object[]{new String(headersArray, nameStart - 1, nameSize, Charsets.ASCII_CHARSET), new String(headersArray, valueStart, valueSize, Charsets.ASCII_CHARSET)});
        return valueEnd;
    }

    private static int processServiceSynStreamHeader(SpdyRequest spdyRequest, Buffer buffer, int position) {
        int nameSize = buffer.getInt(position);
        int valueSize = buffer.getInt(position + nameSize + 4);
        int nameStart = position + 5;
        int valueStart = position + nameSize + 8;
        int valueEnd = valueStart + valueSize;
        switch (nameSize - 1) {
            case 4: {
                if (SpdyDecoderUtils.checkBufferContent(buffer, nameStart, Constants.HOST_HEADER_BYTES, 1)) {
                    spdyRequest.getHeaders().addValue(Header.Host).setBuffer(buffer, valueStart, valueEnd);
                    return valueEnd;
                }
                if (!SpdyDecoderUtils.checkBufferContent(buffer, nameStart, Constants.PATH_HEADER_BYTES, 1)) break;
                int questionIdx = -1;
                for (int i = 0; i < valueSize; ++i) {
                    if (buffer.get(valueStart + i) != 63) continue;
                    questionIdx = i + valueStart;
                    break;
                }
                if (questionIdx == -1) {
                    spdyRequest.getRequestURIRef().init(buffer, valueStart, valueEnd);
                } else {
                    spdyRequest.getRequestURIRef().getOriginalRequestURIBC().setBuffer(buffer, valueStart, questionIdx);
                    if (questionIdx < valueEnd - 1) {
                        spdyRequest.getQueryStringDC().setBuffer(buffer, questionIdx + 1, valueEnd);
                    }
                }
                return valueEnd;
            }
            case 6: {
                if (SpdyDecoderUtils.checkBufferContent(buffer, nameStart, Constants.METHOD_HEADER_BYTES, 1)) {
                    spdyRequest.getMethodDC().setBuffer(buffer, valueStart, valueEnd);
                    return valueEnd;
                }
                if (!SpdyDecoderUtils.checkBufferContent(buffer, nameStart, Constants.SCHEMA_HEADER_BYTES, 1)) break;
                spdyRequest.setSecure(valueSize == 5);
                return valueEnd;
            }
            case 7: {
                if (!SpdyDecoderUtils.checkBufferContent(buffer, nameStart, Constants.VERSION_HEADER_BYTES, 1)) break;
                spdyRequest.getProtocolDC().setBuffer(buffer, valueStart, valueEnd);
                return valueEnd;
            }
        }
        LOGGER.log(Level.FINE, "Skipping unknown service header[{0}={1}", new Object[]{buffer.toStringContent(Charsets.ASCII_CHARSET, nameStart - 1, nameSize), buffer.toStringContent(Charsets.ASCII_CHARSET, valueStart, valueSize)});
        return valueEnd;
    }

    private static int processServiceUSynStreamHeader(SpdyRequest spdyRequest, byte[] headersArray, int position) {
        int nameSize = SpdyDecoderUtils.getInt(headersArray, position);
        int valueSize = SpdyDecoderUtils.getInt(headersArray, position + nameSize + 4);
        int nameStart = position + 5;
        int valueStart = position + nameSize + 8;
        int valueEnd = valueStart + valueSize;
        switch (nameSize - 1) {
            case 4: {
                if (SpdyDecoderUtils.checkArraysContent(headersArray, nameStart, Constants.HOST_HEADER_BYTES, 1)) {
                    spdyRequest.getHeaders().addValue(Header.Host).setBytes(headersArray, valueStart, valueEnd);
                    return valueEnd;
                }
                if (!SpdyDecoderUtils.checkArraysContent(headersArray, nameStart, Constants.PATH_HEADER_BYTES, 1)) break;
                int questionIdx = -1;
                for (int i = 0; i < valueSize; ++i) {
                    if (headersArray[valueStart + i] != 63) continue;
                    questionIdx = i + valueStart;
                    break;
                }
                if (questionIdx == -1) {
                    spdyRequest.getRequestURIRef().init(headersArray, valueStart, valueEnd);
                } else {
                    spdyRequest.getRequestURIRef().init(headersArray, valueStart, questionIdx);
                    if (questionIdx < valueEnd - 1) {
                        spdyRequest.getQueryStringDC().setBytes(headersArray, questionIdx + 1, valueEnd);
                    }
                }
                return valueEnd;
            }
            case 6: {
                if (SpdyDecoderUtils.checkArraysContent(headersArray, nameStart, Constants.SCHEMA_HEADER_BYTES, 1)) {
                    spdyRequest.setSecure(valueSize == 5);
                    return valueEnd;
                }
                if (!SpdyDecoderUtils.checkArraysContent(headersArray, nameStart, Constants.STATUS_HEADER_BYTES, 1)) break;
                if (valueEnd < 3) {
                    throw new IllegalStateException("Unknown status code: " + new String(headersArray, valueStart, valueEnd - valueStart, Charsets.UTF8_CHARSET));
                }
                HttpResponsePacket spdyResponse = spdyRequest.getResponse();
                spdyResponse.setStatus(Ascii.parseInt(headersArray, valueStart, 3));
                int reasonPhraseIdx = HttpCodecUtils.skipSpaces(headersArray, valueStart + 3, valueEnd, valueEnd);
                if (reasonPhraseIdx != -1) {
                    int reasonPhraseEnd = SpdyDecoderUtils.skipLastSpaces(headersArray, valueStart + 3, valueEnd) + 1;
                    if (reasonPhraseEnd == 0) {
                        reasonPhraseEnd = valueEnd;
                    }
                    spdyResponse.getReasonPhraseRawDC().setBytes(headersArray, reasonPhraseIdx, reasonPhraseEnd);
                }
                return valueEnd;
            }
            case 7: {
                if (!SpdyDecoderUtils.checkArraysContent(headersArray, nameStart, Constants.VERSION_HEADER_BYTES, 1)) break;
                spdyRequest.getProtocolDC().setBytes(headersArray, valueStart, valueEnd);
                spdyRequest.getResponse().getProtocolDC().setBytes(headersArray, valueStart, valueEnd);
                return valueEnd;
            }
        }
        LOGGER.log(Level.FINE, "Skipping unknown service header[{0}={1}", new Object[]{new String(headersArray, nameStart - 1, nameSize, Charsets.ASCII_CHARSET), new String(headersArray, valueStart, valueSize, Charsets.ASCII_CHARSET)});
        return valueEnd;
    }

    private static int processServiceUSynStreamHeader(SpdyRequest spdyRequest, Buffer buffer, int position) {
        int nameSize = buffer.getInt(position);
        int valueSize = buffer.getInt(position + nameSize + 4);
        int nameStart = position + 5;
        int valueStart = position + nameSize + 8;
        int valueEnd = valueStart + valueSize;
        switch (nameSize - 1) {
            case 4: {
                if (SpdyDecoderUtils.checkBufferContent(buffer, nameStart, Constants.HOST_HEADER_BYTES, 1)) {
                    spdyRequest.getHeaders().addValue(Header.Host).setBuffer(buffer, valueStart, valueEnd);
                    return valueEnd;
                }
                if (!SpdyDecoderUtils.checkBufferContent(buffer, nameStart, Constants.PATH_HEADER_BYTES, 1)) break;
                int questionIdx = -1;
                for (int i = 0; i < valueSize; ++i) {
                    if (buffer.get(valueStart + i) != 63) continue;
                    questionIdx = i + valueStart;
                    break;
                }
                if (questionIdx == -1) {
                    spdyRequest.getRequestURIRef().init(buffer, valueStart, valueEnd);
                } else {
                    spdyRequest.getRequestURIRef().getOriginalRequestURIBC().setBuffer(buffer, valueStart, questionIdx);
                    if (questionIdx < valueEnd - 1) {
                        spdyRequest.getQueryStringDC().setBuffer(buffer, questionIdx + 1, valueEnd);
                    }
                }
                return valueEnd;
            }
            case 6: {
                if (SpdyDecoderUtils.checkBufferContent(buffer, nameStart, Constants.SCHEMA_HEADER_BYTES, 1)) {
                    spdyRequest.setSecure(valueSize == 5);
                    return valueEnd;
                }
                if (!SpdyDecoderUtils.checkBufferContent(buffer, nameStart, Constants.STATUS_HEADER_BYTES, 1)) break;
                if (valueEnd < 3) {
                    throw new IllegalStateException("Unknown status code: " + buffer.toStringContent(Charsets.ASCII_CHARSET, valueEnd, valueEnd - valueStart));
                }
                HttpResponsePacket spdyResponse = spdyRequest.getResponse();
                spdyResponse.setStatus(Ascii.parseInt(buffer, valueStart, 3));
                int reasonPhraseIdx = HttpCodecUtils.skipSpaces(buffer, valueStart + 3, valueEnd);
                if (reasonPhraseIdx != -1) {
                    int reasonPhraseEnd = SpdyDecoderUtils.skipLastSpaces(buffer, valueStart + 3, valueEnd) + 1;
                    if (reasonPhraseEnd == 0) {
                        reasonPhraseEnd = valueEnd;
                    }
                    spdyResponse.getReasonPhraseRawDC().setBuffer(buffer, reasonPhraseIdx, reasonPhraseEnd);
                }
                return valueEnd;
            }
            case 7: {
                if (!SpdyDecoderUtils.checkBufferContent(buffer, nameStart, Constants.VERSION_HEADER_BYTES, 1)) break;
                spdyRequest.getProtocolDC().setBuffer(buffer, valueStart, valueEnd);
                spdyRequest.getResponse().getProtocolDC().setBuffer(buffer, valueStart, valueEnd);
                return valueEnd;
            }
        }
        LOGGER.log(Level.FINE, "Skipping unknown service header[{0}={1}", new Object[]{buffer.toStringContent(Charsets.ASCII_CHARSET, nameStart - 1, nameSize), buffer.toStringContent(Charsets.ASCII_CHARSET, valueStart, valueSize)});
        return valueEnd;
    }

    private static int processServiceSynReplyHeader(SpdyResponse spdyResponse, byte[] headersArray, int position, InitialLineParsingState state) {
        int nameSize = SpdyDecoderUtils.getInt(headersArray, position);
        int valueSize = SpdyDecoderUtils.getInt(headersArray, position + nameSize + 4);
        int nameStart = position + 5;
        int valueStart = position + nameSize + 8;
        int valueEnd = valueStart + valueSize;
        switch (nameSize - 1) {
            case 6: {
                if (!SpdyDecoderUtils.checkArraysContent(headersArray, nameStart, Constants.STATUS_HEADER_BYTES, 1)) break;
                if (valueEnd < 3) {
                    throw new IllegalStateException("Unknown status code: " + new String(headersArray, valueStart, valueEnd - valueStart, Charsets.UTF8_CHARSET));
                }
                spdyResponse.setStatus(Ascii.parseInt(headersArray, valueStart, 3));
                state.statusCodeParsed();
                int reasonPhraseIdx = HttpCodecUtils.skipSpaces(headersArray, valueStart + 3, valueEnd, valueEnd);
                if (reasonPhraseIdx != -1) {
                    int reasonPhraseEnd = SpdyDecoderUtils.skipLastSpaces(headersArray, valueStart + 3, valueEnd) + 1;
                    if (reasonPhraseEnd == 0) {
                        reasonPhraseEnd = valueEnd;
                    }
                    spdyResponse.getReasonPhraseRawDC().setBytes(headersArray, reasonPhraseIdx, reasonPhraseEnd);
                }
                state.reasonPhraseParsed();
                return valueEnd;
            }
            case 7: {
                if (!SpdyDecoderUtils.checkArraysContent(headersArray, nameStart, Constants.VERSION_HEADER_BYTES, 1)) break;
                spdyResponse.setProtocol(Protocol.valueOf(headersArray, valueStart, valueEnd - valueStart));
                state.protocolParsed();
                return valueEnd;
            }
        }
        LOGGER.log(Level.FINE, "Skipping unknown service header[{0}={1}", new Object[]{new String(headersArray, position, nameSize, Charsets.ASCII_CHARSET), new String(headersArray, valueStart, valueSize, Charsets.ASCII_CHARSET)});
        return valueEnd;
    }

    private static int processServiceSynReplyHeader(SpdyResponse spdyResponse, Buffer buffer, int position, InitialLineParsingState state) {
        int nameSize = buffer.getInt(position);
        int valueSize = buffer.getInt(position + nameSize + 4);
        int nameStart = position + 5;
        int valueStart = position + nameSize + 8;
        int valueEnd = valueStart + valueSize;
        switch (nameSize - 1) {
            case 6: {
                if (!SpdyDecoderUtils.checkBufferContent(buffer, nameStart, Constants.STATUS_HEADER_BYTES, 1)) break;
                if (valueEnd < 3) {
                    throw new IllegalStateException("Unknown status code: " + buffer.toStringContent(Charsets.ASCII_CHARSET, valueEnd, valueEnd - valueStart));
                }
                spdyResponse.setStatus(Ascii.parseInt(buffer, valueStart, 3));
                state.statusCodeParsed();
                int reasonPhraseIdx = HttpCodecUtils.skipSpaces(buffer, valueStart + 3, valueEnd);
                if (reasonPhraseIdx != -1) {
                    int reasonPhraseEnd = SpdyDecoderUtils.skipLastSpaces(buffer, valueStart + 3, valueEnd) + 1;
                    if (reasonPhraseEnd == 0) {
                        reasonPhraseEnd = valueEnd;
                    }
                    spdyResponse.getReasonPhraseRawDC().setBuffer(buffer, reasonPhraseIdx, reasonPhraseEnd);
                }
                state.reasonPhraseParsed();
                return valueEnd;
            }
            case 7: {
                if (!SpdyDecoderUtils.checkBufferContent(buffer, nameStart, Constants.VERSION_HEADER_BYTES, 1)) break;
                spdyResponse.setProtocol(Protocol.valueOf(buffer, valueStart, valueEnd - valueStart));
                state.protocolParsed();
                return valueEnd;
            }
        }
        LOGGER.log(Level.FINE, "Skipping unknown service header[{0}={1}", new Object[]{buffer.toStringContent(Charsets.ASCII_CHARSET, position, nameSize), buffer.toStringContent(Charsets.ASCII_CHARSET, valueStart, valueSize)});
        return valueEnd;
    }

    static void processSynReplyHeadersArray(SpdyResponse spdyResponse, Buffer decoded, FilterChainContext ctx, SpdyHandlerFilter handlerFilter) {
        byte[] headersArray = decoded.array();
        int position = decoded.arrayOffset() + decoded.position();
        int headersCount = SpdyDecoderUtils.getInt(headersArray, position);
        position += 4;
        InitialLineParsingState state = InitialLineParsingState.create();
        for (int i = 0; i < headersCount && !spdyResponse.isSkipRemainder(); ++i) {
            boolean isServiceHeader;
            boolean bl = isServiceHeader = headersArray[position + 4] == 58;
            if (isServiceHeader) {
                position = SpdyDecoderUtils.processServiceSynReplyHeader(spdyResponse, headersArray, position, state);
                if (state == null || !state.isParseComplete()) continue;
                handlerFilter.onInitialLineParsed(spdyResponse, ctx);
                state.recycle();
                state = null;
                continue;
            }
            position = SpdyDecoderUtils.processNormalHeader((HttpHeader)spdyResponse, headersArray, position);
        }
        handlerFilter.onHttpHeadersParsed(spdyResponse, ctx);
    }

    static void processSynReplyHeadersBuffer(SpdyResponse spdyResponse, Buffer decoded, FilterChainContext ctx, SpdyHandlerFilter handlerFilter) {
        int position = decoded.position();
        int headersCount = decoded.getInt(position);
        position += 4;
        InitialLineParsingState state = InitialLineParsingState.create();
        for (int i = 0; i < headersCount && !spdyResponse.isSkipRemainder(); ++i) {
            boolean isServiceHeader;
            boolean bl = isServiceHeader = decoded.get(position + 4) == 58;
            if (isServiceHeader) {
                position = SpdyDecoderUtils.processServiceSynReplyHeader(spdyResponse, decoded, position, state);
                if (state == null || !state.isParseComplete()) continue;
                handlerFilter.onInitialLineParsed(spdyResponse, ctx);
                state = null;
                continue;
            }
            position = SpdyDecoderUtils.processNormalHeader((HttpHeader)spdyResponse, decoded, position);
        }
        handlerFilter.onHttpHeadersParsed(spdyResponse, ctx);
    }

    private static int processNormalHeader(HttpHeader httpHeader, byte[] headersArray, int position) {
        MimeHeaders mimeHeaders = httpHeader.getHeaders();
        int headerNameSize = SpdyDecoderUtils.getInt(headersArray, position);
        int headerNamePosition = position += 4;
        DataChunk valueChunk = mimeHeaders.addValue(headersArray, headerNamePosition, headerNameSize);
        int headerValueSize = SpdyDecoderUtils.getInt(headersArray, position += headerNameSize);
        position += 4;
        for (int i = 0; i < headerValueSize; ++i) {
            byte b = headersArray[position + i];
            if (b != 0) continue;
            headersArray[position + i] = 44;
        }
        int end = position + headerValueSize;
        valueChunk.setBytes(headersArray, position, end);
        SpdyDecoderUtils.finalizeKnownHeader(httpHeader, headersArray, headerNamePosition, headerNameSize, position, end - position);
        return end;
    }

    private static int processNormalHeader(HttpHeader httpHeader, Buffer headerBuffer, int position) {
        MimeHeaders mimeHeaders = httpHeader.getHeaders();
        int headerNameSize = headerBuffer.getInt(position);
        int headerNamePosition = position += 4;
        DataChunk valueChunk = mimeHeaders.addValue(headerBuffer, headerNamePosition, headerNameSize);
        int headerValueSize = headerBuffer.getInt(position += headerNameSize);
        position += 4;
        for (int i = 0; i < headerValueSize; ++i) {
            byte b = headerBuffer.get(position + i);
            if (b != 0) continue;
            headerBuffer.put(position + i, (byte)44);
        }
        int end = position + headerValueSize;
        valueChunk.setBuffer(headerBuffer, position, end);
        SpdyDecoderUtils.finalizeKnownHeader(httpHeader, headerBuffer, headerNamePosition, headerNameSize, position, end - position);
        return end;
    }

    private static void finalizeKnownHeader(HttpHeader httpHeader, byte[] array, int nameStart, int nameLen, int valueStart, int valueLen) {
        int nameEnd = nameStart + nameLen;
        if (nameLen == Header.ContentLength.getLowerCaseBytes().length) {
            if (httpHeader.getContentLength() == -1L && ByteChunk.equalsIgnoreCaseLowerCase(array, nameStart, nameEnd, Header.ContentLength.getLowerCaseBytes())) {
                httpHeader.setContentLengthLong(Ascii.parseLong(array, valueStart, valueLen));
            }
        } else if (nameLen == Header.Upgrade.getLowerCaseBytes().length) {
            if (ByteChunk.equalsIgnoreCaseLowerCase(array, nameStart, nameEnd, Header.Upgrade.getLowerCaseBytes())) {
                httpHeader.getUpgradeDC().setBytes(array, valueStart, valueStart + valueLen);
            }
        } else if (nameLen == Header.Expect.getLowerCaseBytes().length && ByteChunk.equalsIgnoreCaseLowerCase(array, nameStart, nameEnd, Header.Expect.getLowerCaseBytes())) {
            ((SpdyRequest)httpHeader).requiresAcknowledgement(true);
        }
    }

    private static void finalizeKnownHeader(HttpHeader httpHeader, Buffer buffer, int nameStart, int nameLen, int valueStart, int valueLen) {
        int nameEnd = nameStart + nameLen;
        if (nameLen == Header.ContentLength.getLowerCaseBytes().length) {
            if (httpHeader.getContentLength() == -1L && BufferChunk.equalsIgnoreCaseLowerCase(buffer, nameStart, nameEnd, Header.ContentLength.getLowerCaseBytes())) {
                httpHeader.setContentLengthLong(Ascii.parseLong(buffer, valueStart, valueLen));
            }
        } else if (nameLen == Header.Upgrade.getLowerCaseBytes().length) {
            if (BufferChunk.equalsIgnoreCaseLowerCase(buffer, nameStart, nameEnd, Header.Upgrade.getLowerCaseBytes())) {
                httpHeader.getUpgradeDC().setBuffer(buffer, valueStart, valueStart + valueLen);
            }
        } else if (nameLen == Header.Expect.getLowerCaseBytes().length && BufferChunk.equalsIgnoreCaseLowerCase(buffer, nameStart, nameEnd, Header.Expect.getLowerCaseBytes())) {
            ((SpdyRequest)httpHeader).requiresAcknowledgement(true);
        }
    }

    private static int getInt(byte[] array, int position) {
        return ((array[position] & 0xFF) << 24) + ((array[position + 1] & 0xFF) << 16) + ((array[position + 2] & 0xFF) << 8) + (array[position + 3] & 0xFF);
    }

    private static boolean checkArraysContent(byte[] b1, int pos1, byte[] control, int pos2) {
        int len = control.length - pos2;
        for (int i = 0; i < len; ++i) {
            if (b1[pos1 + i] == control[pos2 + i]) continue;
            return false;
        }
        return true;
    }

    private static boolean checkBufferContent(Buffer toTest, int pos, byte[] control, int pos2) {
        int len = control.length - pos2;
        for (int i = 0; i < len; ++i) {
            if (toTest.get(pos + i) == control[pos2 + i]) continue;
            return false;
        }
        return true;
    }

    private static int skipLastSpaces(byte[] array, int start, int end) {
        for (int i = end - 1; i >= start; --i) {
            if (!HttpCodecUtils.isNotSpaceAndTab(array[i])) continue;
            return i;
        }
        return -1;
    }

    private static int skipLastSpaces(Buffer buffer, int start, int end) {
        for (int i = end - 1; i >= start; --i) {
            if (!HttpCodecUtils.isNotSpaceAndTab(buffer.get(i))) continue;
            return i;
        }
        return -1;
    }

    private static final class InitialLineParsingState
    implements Cacheable {
        private static final ThreadCache.CachedTypeIndex<InitialLineParsingState> CACHE_IDX = ThreadCache.obtainIndex(InitialLineParsingState.class, 8);
        private byte parseState;

        private InitialLineParsingState() {
        }

        static InitialLineParsingState create() {
            InitialLineParsingState state = ThreadCache.getFromCache(CACHE_IDX);
            if (state == null) {
                state = new InitialLineParsingState();
            }
            return state;
        }

        void protocolParsed() {
            this.parseState = (byte)(this.parseState | 4);
        }

        void reasonPhraseParsed() {
            this.parseState = (byte)(this.parseState | 2);
        }

        void statusCodeParsed() {
            this.parseState = (byte)(this.parseState | 1);
        }

        boolean isParseComplete() {
            return this.parseState == 7;
        }

        @Override
        public void recycle() {
            this.parseState = 0;
            ThreadCache.putToCache(CACHE_IDX, this);
        }
    }
}

