/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http.multipart;

import java.io.IOException;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.ReadHandler;
import org.glassfish.grizzly.http.io.NIOInputStream;
import org.glassfish.grizzly.http.multipart.ContentDisposition;
import org.glassfish.grizzly.http.multipart.MultipartContext;
import org.glassfish.grizzly.http.multipart.MultipartEntry;
import org.glassfish.grizzly.http.multipart.MultipartEntryHandler;
import org.glassfish.grizzly.http.server.Request;
import org.glassfish.grizzly.http.util.Ascii;
import org.glassfish.grizzly.http.util.Header;

public class MultipartReadHandler
implements ReadHandler {
    private final Request request;
    private final CompletionHandler<Request> requestCompletionHandler;
    private final MultipartEntry multipartMixedEntry;
    private final CompletionHandler<MultipartEntry> multipartMixedCompletionHandler;
    private final NIOInputStream parentInputStream;
    private final MultipartEntryHandler multipartHandler;
    private final MultipartContext multipartContext;
    private final String boundary;
    private final Line line = new Line();
    private final MultipartEntry multipartEntry;
    private State state = State.PREAMBLE;
    private boolean isFinished;
    private boolean isMultipartMixed;

    public MultipartReadHandler(Request request, MultipartEntryHandler multipartHandler, CompletionHandler<Request> completionHandler, MultipartContext multipartContext) {
        this.request = request;
        this.multipartHandler = multipartHandler;
        this.requestCompletionHandler = completionHandler;
        this.multipartContext = multipartContext;
        this.boundary = multipartContext.getBoundary();
        this.parentInputStream = request.getNIOInputStream();
        this.multipartMixedCompletionHandler = null;
        this.multipartMixedEntry = null;
        this.multipartEntry = new MultipartEntry(multipartContext);
    }

    public MultipartReadHandler(MultipartEntry parentMultipartEntry, MultipartEntryHandler multipartHandler, CompletionHandler<MultipartEntry> completionHandler, MultipartContext multipartContext) {
        this.multipartMixedEntry = parentMultipartEntry;
        this.multipartHandler = multipartHandler;
        this.multipartMixedCompletionHandler = completionHandler;
        this.multipartContext = multipartContext;
        this.boundary = multipartContext.getBoundary();
        this.parentInputStream = parentMultipartEntry.getNIOInputStream();
        this.request = null;
        this.requestCompletionHandler = null;
        this.isMultipartMixed = true;
        this.multipartEntry = new MultipartEntry(multipartContext);
    }

    @Override
    public void onDataAvailable() throws Exception {
        if (!this.process()) {
            int totalBytesAvailable = this.multipartEntry.getReservedBytes() + this.multipartEntry.availableBytes() + this.line.len;
            this.parentInputStream.notifyAvailable(this, totalBytesAvailable + 1);
        } else {
            this.checkComplete();
        }
    }

    @Override
    public void onAllDataRead() throws Exception {
        this.process();
        this.checkComplete();
    }

    private void checkComplete() {
        if (this.isFinished) {
            if (this.isMultipartMixed) {
                this.checkMultipartMixedComplete(this.multipartMixedCompletionHandler);
            } else {
                this.checkRequestComplete(this.requestCompletionHandler);
            }
        }
    }

    private void checkMultipartMixedComplete(CompletionHandler<MultipartEntry> multipartMixedCompletionHandler) {
        if (multipartMixedCompletionHandler != null) {
            multipartMixedCompletionHandler.completed(this.multipartMixedEntry);
        }
    }

    private void checkRequestComplete(CompletionHandler<Request> requestCompletionHandler) {
        if (requestCompletionHandler != null) {
            requestCompletionHandler.completed(this.request);
        }
    }

    @Override
    public void onError(Throwable t) {
        CompletionHandler<Request> localCompletionHandler = this.requestCompletionHandler;
        if (localCompletionHandler != null) {
            localCompletionHandler.failed(t);
        }
    }

    private boolean process() throws Exception {
        while (true) {
            switch (this.state) {
                case PREAMBLE: {
                    if (!this.skipPreamble()) {
                        return false;
                    }
                    if (this.isFinished) {
                        return true;
                    }
                }
                case PARSE_MULTIPART_ENTRY_HEADERS: {
                    if (!this.parseHeaders()) {
                        return false;
                    }
                    this.finishHeadersParsing();
                }
                case START_BODY: {
                    this.state = State.BODY;
                    this.multipartHandler.handle(this.multipartEntry);
                }
                case BODY: {
                    this.feedMultipartEntry();
                    if (!this.multipartEntry.isFinished()) {
                        return false;
                    }
                    this.state = State.RESET;
                    break;
                }
                case RESET: {
                    this.multipartEntry.reset();
                    if (this.isFinished) {
                        return true;
                    }
                    this.state = State.PARSE_MULTIPART_ENTRY_HEADERS;
                }
            }
        }
    }

    private void feedMultipartEntry() throws Exception {
        boolean isComplete;
        do {
            this.line.offset = this.multipartEntry.availableBytes() + this.multipartEntry.getReservedBytes();
            this.readLine();
            isComplete = this.line.isComplete;
            if (isComplete) {
                if (this.line.isBoundary()) {
                    this.isFinished = this.line.isFinalBoundary;
                    this.multipartEntry.onFinished();
                    try {
                        this.parentInputStream.skip(this.multipartEntry.availableBytes() + this.multipartEntry.getReservedBytes() + this.line.len);
                    }
                    catch (IOException ignored) {
                        // empty catch block
                    }
                    this.line.reset();
                    return;
                }
                int lineTerminatorLength = this.line.getLineTerminatorLength();
                this.multipartEntry.addAvailableBytes(this.line.len + this.multipartEntry.getReservedBytes() - lineTerminatorLength);
                this.multipartEntry.setReservedBytes(lineTerminatorLength);
                this.line.reset();
                continue;
            }
            if (this.line.len <= 1 || this.line.couldBeBoundary()) continue;
            this.multipartEntry.addAvailableBytes(this.line.len - 1 + this.multipartEntry.getReservedBytes());
            this.line.len = 1;
            this.multipartEntry.setReservedBytes(0);
        } while (isComplete);
        this.multipartEntry.onDataReceived();
    }

    private boolean skipPreamble() {
        block1: {
            boolean isSectionBoundary;
            do {
                this.readLine();
                if (!this.line.isComplete) break block1;
                isSectionBoundary = this.line.isBoundary();
                this.isFinished = this.line.isFinalBoundary;
                this.line.skip();
                this.line.reset();
            } while (!isSectionBoundary);
            this.state = State.PARSE_MULTIPART_ENTRY_HEADERS;
            return true;
        }
        return false;
    }

    private boolean parseHeaders() {
        while (true) {
            this.readLine();
            if (!this.line.isComplete) {
                return false;
            }
            if (!this.line.hasContent()) {
                this.line.skip();
                this.line.reset();
                return true;
            }
            this.setHeader();
            this.line.skip();
            this.line.reset();
        }
    }

    private void finishHeadersParsing() {
        String contentDisposition;
        this.state = State.START_BODY;
        if (this.isMultipartMixed) {
            this.multipartEntry.initialize(this.multipartMixedEntry.getNIOInputStream());
        } else {
            this.multipartEntry.initialize(this.request.getNIOInputStream());
        }
        String contentType = this.multipartEntry.getHeader(Header.ContentType);
        if (contentType != null) {
            this.multipartEntry.setContentType(contentType);
        }
        if ((contentDisposition = this.multipartEntry.getHeader(Header.ContentDisposition)) != null) {
            this.multipartEntry.setContentDisposition(new ContentDisposition(contentDisposition));
        }
    }

    private void setHeader() {
        String value;
        String name;
        int contentLength;
        int position;
        Buffer buffer = this.parentInputStream.getBuffer();
        int colonIdx = this.findEndOfHeaderName(buffer, position = buffer.position(), position + (contentLength = this.line.len - this.line.getLineTerminatorLength()));
        if (colonIdx == -1) {
            name = this.trim(buffer, position, position + contentLength);
            value = null;
        } else {
            name = this.trim(buffer, position, colonIdx);
            value = this.trim(buffer, colonIdx + 1, position + contentLength);
        }
        if (name == null) {
            return;
        }
        this.multipartEntry.setHeader(name, value);
    }

    void readLine() {
        Buffer buffer = this.parentInputStream.getBuffer();
        int position = buffer.position() + this.line.offset;
        int limit = buffer.position() + this.parentInputStream.readyData();
        int offset = position + this.line.len;
        while (offset < limit) {
            byte b;
            if ((b = buffer.get(offset++)) != 10) continue;
            this.line.isCrLf = position <= offset - 2 && buffer.get(offset - 2) == 13;
            this.line.isComplete = true;
            break;
        }
        this.line.len = offset - position;
    }

    private int findEndOfHeaderName(Buffer buffer, int position, int limit) {
        while (position < limit) {
            byte b = buffer.get(position);
            if (b == 58) {
                return position;
            }
            buffer.put(position, (byte)Ascii.toLower(b));
            ++position;
        }
        return -1;
    }

    private String trim(Buffer buffer, int position, int limit) {
        while (position < limit && buffer.get(position) <= 32) {
            ++position;
        }
        while (position < limit && buffer.get(limit - 1) <= 32) {
            --limit;
        }
        if (position == limit) {
            return null;
        }
        return buffer.toStringContent(null, position, limit);
    }

    private class Line {
        boolean isCrLf;
        boolean isComplete;
        int len;
        int offset;
        int couldBeBoundaryOffset;
        boolean isBoundary;
        boolean isFinalBoundary;

        private Line() {
        }

        public void reset() {
            this.isCrLf = false;
            this.isComplete = false;
            this.len = 0;
            this.offset = 0;
            this.couldBeBoundaryOffset = 0;
            this.isBoundary = false;
            this.isFinalBoundary = false;
        }

        public boolean hasContent() {
            return this.isCrLf && this.len > 2 || !this.isCrLf && this.len > 1;
        }

        private boolean isBoundary() {
            return this.isBoundary || this.parseBoundary();
        }

        private boolean parseBoundary() {
            boolean isLookingFinalBoundary;
            int lineTerminatorLength = this.getLineTerminatorLength();
            int boundaryLength = MultipartReadHandler.this.boundary.length();
            boolean isLookingSectionBoundary = this.len == boundaryLength + 2 + lineTerminatorLength;
            boolean bl = isLookingFinalBoundary = this.len == boundaryLength + 2 + lineTerminatorLength + 2;
            if (!isLookingSectionBoundary && !isLookingFinalBoundary) {
                return false;
            }
            Buffer buffer = MultipartReadHandler.this.parentInputStream.getBuffer();
            int position = buffer.position() + this.offset;
            int checkIdx = this.couldBeBoundaryOffset;
            if (checkIdx < 2) {
                if (buffer.get(position) != 45 || buffer.get(position + 1) != 45) {
                    return false;
                }
                checkIdx = 2;
            }
            for (int i = checkIdx; i < boundaryLength + 2; ++i) {
                if (buffer.get(position + i) == MultipartReadHandler.this.boundary.charAt(i - 2)) continue;
                return false;
            }
            this.isBoundary = true;
            if (isLookingFinalBoundary && buffer.get(position + 2 + boundaryLength) == 45 && buffer.get(position + 2 + boundaryLength + 1) == 45) {
                this.isFinalBoundary = true;
            }
            return true;
        }

        private boolean couldBeBoundary() {
            if (this.len > MultipartReadHandler.this.boundary.length() + 2 + 4) {
                return false;
            }
            Buffer buffer = MultipartReadHandler.this.parentInputStream.getBuffer();
            int position = buffer.position();
            while (this.couldBeBoundaryOffset < 2 && this.couldBeBoundaryOffset < this.len) {
                if (buffer.get(this.offset + position + this.couldBeBoundaryOffset) != 45) {
                    return false;
                }
                ++this.couldBeBoundaryOffset;
            }
            int boundaryLength = MultipartReadHandler.this.boundary.length();
            while (this.couldBeBoundaryOffset < ((MultipartReadHandler)MultipartReadHandler.this).line.len && this.couldBeBoundaryOffset < boundaryLength) {
                if (buffer.get(this.offset + position + this.couldBeBoundaryOffset) != MultipartReadHandler.this.boundary.charAt(this.couldBeBoundaryOffset - 2)) {
                    return false;
                }
                ++this.couldBeBoundaryOffset;
            }
            return true;
        }

        private int getLineTerminatorLength() {
            return 1 + (this.isCrLf ? 1 : 0);
        }

        private void skip() {
            try {
                MultipartReadHandler.this.parentInputStream.skip(((MultipartReadHandler)MultipartReadHandler.this).line.len);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.len > 0) {
                Buffer buffer = MultipartReadHandler.this.parentInputStream.getBuffer();
                int start = buffer.position() + this.offset;
                sb.append(buffer.toStringContent(null, start, start + this.len));
            }
            return sb.toString();
        }
    }

    private static enum State {
        PREAMBLE,
        PARSE_MULTIPART_ENTRY_HEADERS,
        START_BODY,
        BODY,
        RESET;

    }
}

