/*
 * Decompiled with CFR 0.152.
 */
package org.magicwerk.brownies.collections.primitive;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.magicwerk.brownies.collections.helper.primitive.BooleanBinarySearch;
import org.magicwerk.brownies.collections.helper.primitive.BooleanMergeSort;
import org.magicwerk.brownies.collections.primitive.BooleanGapList;
import org.magicwerk.brownies.collections.primitive.IBooleanList;

public class BooleanBigList
extends IBooleanList {
    private static final long serialVersionUID = 3715838828540564836L;
    private static final int DEFAULT_BLOCK_SIZE = 1000;
    private static final float MERGE_THRESHOLD = 0.35f;
    private static final float FILL_THRESHOLD = 0.95f;
    private static final boolean CHECK = false;
    private static final BooleanBigList EMPTY = BooleanBigList.create().unmodifiableList();
    private int blockSize;
    private int size;
    private BooleanBlockNode rootNode;
    private BooleanBlockNode currNode;
    private int currBooleanBlockStart;
    private int currBooleanBlockEnd;
    private int currModify;

    public static IBooleanList of(boolean[] values) {
        return new ImmutableBooleanListArrayPrimitive(values);
    }

    public static IBooleanList of(Boolean[] values) {
        return new ImmutableBooleanListArrayWrapper(values);
    }

    public static IBooleanList of(List<Boolean> values) {
        return new ImmutableBooleanListList(values);
    }

    public static BooleanBigList EMPTY() {
        return EMPTY;
    }

    protected BooleanBigList(boolean copy, BooleanBigList that) {
        if (copy) {
            this.blockSize = that.blockSize;
            this.currBooleanBlockStart = that.currBooleanBlockStart;
            this.currBooleanBlockEnd = that.currBooleanBlockEnd;
            this.currNode = that.currNode;
            this.rootNode = that.rootNode;
            this.size = that.size;
        }
    }

    public static BooleanBigList create() {
        return new BooleanBigList();
    }

    public static BooleanBigList create(Collection<Boolean> coll) {
        return new BooleanBigList(coll);
    }

    public static BooleanBigList create(boolean ... elems) {
        BooleanBigList list = new BooleanBigList();
        for (boolean elem : elems) {
            list.add(elem);
        }
        return list;
    }

    public BooleanBigList() {
        this(1000);
    }

    public BooleanBigList(int blockSize) {
        if (blockSize < 2) {
            throw new IndexOutOfBoundsException("Invalid blockSize: " + blockSize);
        }
        this.doInit(blockSize, -1);
    }

    public BooleanBigList(Collection<Boolean> coll) {
        if (coll instanceof BooleanBigList) {
            this.doAssign((BooleanBigList)((Object)coll));
            this.doClone((BooleanBigList)((Object)coll));
        } else {
            this.blockSize = 1000;
            this.addBooleanBlock(0, new BooleanBlock());
            for (Object obj : coll.toArray()) {
                this.add((Boolean)obj);
            }
            assert (this.size() == coll.size());
        }
    }

    public int blockSize() {
        return this.blockSize;
    }

    private BooleanBigList(int blockSize, int firstBooleanBlockSize) {
        this.doInit(blockSize, firstBooleanBlockSize);
    }

    private void doInit(int blockSize, int firstBooleanBlockSize) {
        this.blockSize = blockSize;
        BooleanBlock block = firstBooleanBlockSize <= 1 ? new BooleanBlock() : new BooleanBlock(firstBooleanBlockSize);
        this.addBooleanBlock(0, block);
    }

    @Override
    public BooleanBigList copy() {
        return (BooleanBigList)super.copy();
    }

    @Override
    public Object clone() {
        return super.clone();
    }

    @Override
    protected void doAssign(IBooleanList that) {
        BooleanBigList list = (BooleanBigList)that;
        this.blockSize = list.blockSize;
        this.currBooleanBlockEnd = list.currBooleanBlockEnd;
        this.currBooleanBlockStart = list.currBooleanBlockStart;
        this.currNode = list.currNode;
        this.rootNode = list.rootNode;
        this.size = list.size;
    }

    @Override
    protected void doClone(IBooleanList that) {
        BooleanBigList bigList = (BooleanBigList)that;
        bigList.releaseBooleanBlock();
        this.rootNode = this.copy(bigList.rootNode);
        this.currNode = null;
        this.currModify = 0;
    }

    private BooleanBlockNode copy(BooleanBlockNode node) {
        BooleanBlockNode newNode = node.min();
        int index = newNode.block.size();
        BooleanBlockNode newRoot = new BooleanBlockNode(null, index, newNode.block.ref(), null, null);
        while ((newNode = newNode.next()) != null) {
            newRoot = newRoot.insert(index += newNode.block.size(), newNode.block.ref());
            newRoot.parent = null;
        }
        return newRoot;
    }

    @Override
    public boolean getDefaultElem() {
        return false;
    }

    protected void finalize() {
        BooleanBlockNode node = this.rootNode.min();
        while (node != null) {
            node.block.unref();
            node = node.next();
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public int capacity() {
        return -1;
    }

    @Override
    protected boolean doGet(int index) {
        int pos = this.getBooleanBlockIndex(index, false, 0);
        return this.currNode.block.doGet(pos);
    }

    @Override
    protected boolean doSet(int index, boolean elem) {
        int pos = this.getBooleanBlockIndex(index, true, 0);
        boolean oldElem = this.currNode.block.doGet(pos);
        this.currNode.block.doSet(pos, elem);
        return oldElem;
    }

    @Override
    protected boolean doReSet(int index, boolean elem) {
        int pos = this.getBooleanBlockIndex(index, true, 0);
        boolean oldElem = this.currNode.block.doGet(pos);
        this.currNode.block.doSet(pos, elem);
        return oldElem;
    }

    private void releaseBooleanBlock() {
        if (this.currModify != 0) {
            int modify = this.currModify;
            this.currModify = 0;
            this.modify(this.currNode, modify);
        }
        this.currNode = null;
    }

    private int getBooleanBlockIndex(int index, boolean write, int modify) {
        if (this.currNode != null) {
            if (index >= this.currBooleanBlockStart && (index < this.currBooleanBlockEnd || index == this.currBooleanBlockEnd && this.size == index)) {
                if (write && this.currNode.block.isShared()) {
                    this.currNode.block.unref();
                    this.currNode.setBooleanBlock(new BooleanBlock(this.currNode.block));
                }
                this.currModify += modify;
                return index - this.currBooleanBlockStart;
            }
            this.releaseBooleanBlock();
        }
        if (index == this.size) {
            if (this.currNode == null || this.currBooleanBlockEnd != this.size) {
                this.currNode = this.rootNode.max();
                this.currBooleanBlockEnd = this.size;
                this.currBooleanBlockStart = this.size - this.currNode.block.size();
            }
            if (modify != 0) {
                this.currNode.relPos += modify;
                BooleanBlockNode leftNode = this.currNode.getLeftSubTree();
                if (leftNode != null) {
                    leftNode.relPos -= modify;
                }
            }
        } else if (index == 0) {
            if (this.currNode == null || this.currBooleanBlockStart != 0) {
                this.currNode = this.rootNode.min();
                this.currBooleanBlockEnd = this.currNode.block.size();
                this.currBooleanBlockStart = 0;
            }
            if (modify != 0) {
                this.rootNode.relPos += modify;
            }
        }
        if (this.currNode == null) {
            this.doGetBooleanBlock(index, modify);
        }
        assert (index >= this.currBooleanBlockStart && index <= this.currBooleanBlockEnd);
        if (write && this.currNode.block.isShared()) {
            this.currNode.block.unref();
            this.currNode.setBooleanBlock(new BooleanBlock(this.currNode.block));
        }
        return index - this.currBooleanBlockStart;
    }

    private boolean isOnlyRootBooleanBlock() {
        return this.rootNode.left == null && this.rootNode.right == null;
    }

    private void doGetBooleanBlock(int index, int modify) {
        this.currNode = this.rootNode;
        this.currBooleanBlockEnd = this.rootNode.relPos;
        if (this.currNode.relPos == 0) {
            if (modify != 0) {
                this.currNode.relPos += modify;
            }
        } else {
            boolean wasLeft = false;
            while (true) {
                BooleanBlockNode nextNode;
                assert (index >= 0);
                int leftIndex = this.currBooleanBlockEnd - this.currNode.block.size();
                assert (leftIndex >= 0);
                if (index >= leftIndex && index < this.currBooleanBlockEnd) {
                    if (modify == 0) break;
                    BooleanBlockNode leftNode = this.currNode.getLeftSubTree();
                    if (this.currNode.relPos > 0) {
                        this.currNode.relPos += modify;
                        if (leftNode == null) break;
                        leftNode.relPos -= modify;
                        break;
                    }
                    if (leftNode == null) break;
                    leftNode.relPos -= modify;
                    break;
                }
                if (index < this.currBooleanBlockEnd) {
                    nextNode = this.currNode.getLeftSubTree();
                    if (!(modify == 0 || nextNode != null && wasLeft)) {
                        this.currNode.relPos = this.currNode.relPos > 0 ? (this.currNode.relPos += modify) : (this.currNode.relPos -= modify);
                        wasLeft = true;
                    }
                    if (nextNode == null) {
                        break;
                    }
                } else {
                    nextNode = this.currNode.getRightSubTree();
                    if (modify != 0 && (nextNode == null || wasLeft)) {
                        if (this.currNode.relPos > 0) {
                            this.currNode.relPos += modify;
                            BooleanBlockNode left = this.currNode.getLeftSubTree();
                            if (left != null) {
                                left.relPos -= modify;
                            }
                        } else {
                            this.currNode.relPos -= modify;
                        }
                        wasLeft = false;
                    }
                    if (nextNode == null) break;
                }
                this.currBooleanBlockEnd += nextNode.relPos;
                this.currNode = nextNode;
            }
        }
        this.currBooleanBlockStart = this.currBooleanBlockEnd - this.currNode.block.size();
    }

    private void addBooleanBlock(int index, BooleanBlock obj) {
        if (this.rootNode == null) {
            this.rootNode = new BooleanBlockNode(null, index, obj, null, null);
        } else {
            this.rootNode = this.rootNode.insert(index, obj);
            this.rootNode.parent = null;
        }
    }

    @Override
    protected boolean doAdd(int index, boolean element) {
        int maxSize;
        if (index == -1) {
            index = this.size;
        }
        int pos = this.getBooleanBlockIndex(index, true, 1);
        int n = maxSize = index == this.size || index == 0 ? (int)((float)this.blockSize * 0.95f) : this.blockSize;
        if (this.currNode.block.size() < maxSize || this.currNode.block.size() == 1 && this.currNode.block.size() < this.blockSize) {
            this.currNode.block.doAdd(pos, element);
            ++this.currBooleanBlockEnd;
        } else {
            BooleanBlock newBooleanBlock = new BooleanBlock(this.blockSize);
            if (index == this.size) {
                BooleanBlockNode lastNode;
                newBooleanBlock.doAdd(0, element);
                this.modify(this.currNode, -1);
                this.addBooleanBlock(this.size + 1, newBooleanBlock);
                this.currNode = lastNode = this.currNode.next();
                this.currBooleanBlockStart = this.currBooleanBlockEnd++;
            } else if (index == 0) {
                BooleanBlockNode firstNode;
                newBooleanBlock.doAdd(0, element);
                this.modify(this.currNode, -1);
                this.addBooleanBlock(1, newBooleanBlock);
                this.currNode = firstNode = this.currNode.previous();
                this.currBooleanBlockStart = 0;
                this.currBooleanBlockEnd = 1;
            } else {
                int nextBooleanBlockLen = this.blockSize / 2;
                int blockLen = this.blockSize - nextBooleanBlockLen;
                BooleanGapList.transferRemove(this.currNode.block, blockLen, nextBooleanBlockLen, newBooleanBlock, 0, 0);
                this.modify(this.currNode, -nextBooleanBlockLen - 1);
                this.addBooleanBlock(this.currBooleanBlockEnd - nextBooleanBlockLen, newBooleanBlock);
                if (pos < blockLen) {
                    this.currNode.block.doAdd(pos, element);
                    this.currBooleanBlockEnd = this.currBooleanBlockStart + blockLen + 1;
                    this.modify(this.currNode, 1);
                } else {
                    this.currNode = this.currNode.next();
                    this.modify(this.currNode, 1);
                    this.currNode.block.doAdd(pos - blockLen, element);
                    this.currBooleanBlockStart += blockLen;
                    ++this.currBooleanBlockEnd;
                }
            }
        }
        ++this.size;
        return true;
    }

    private void modify(BooleanBlockNode node, int modify) {
        if (node == this.currNode) {
            modify += this.currModify;
            this.currModify = 0;
        } else {
            this.releaseBooleanBlock();
        }
        if (modify == 0) {
            return;
        }
        if (node.relPos < 0) {
            BooleanBlockNode p;
            BooleanBlockNode leftNode = node.getLeftSubTree();
            if (leftNode != null) {
                leftNode.relPos -= modify;
            }
            BooleanBlockNode pp = node.parent;
            assert (pp.getLeftSubTree() == node);
            boolean parentRight = true;
            while ((p = pp.parent) != null) {
                boolean pRight;
                boolean bl = pRight = p.getLeftSubTree() == pp;
                if (parentRight != pRight) {
                    pp.relPos = pp.relPos > 0 ? (pp.relPos += modify) : (pp.relPos -= modify);
                }
                pp = p;
                parentRight = pRight;
            }
            if (parentRight) {
                this.rootNode.relPos += modify;
            }
        } else {
            BooleanBlockNode parent;
            node.relPos += modify;
            BooleanBlockNode leftNode = node.getLeftSubTree();
            if (leftNode != null) {
                leftNode.relPos -= modify;
            }
            if ((parent = node.parent) != null) {
                BooleanBlockNode p;
                assert (parent.getRightSubTree() == node);
                boolean parentLeft = true;
                while ((p = parent.parent) != null) {
                    boolean pLeft;
                    boolean bl = pLeft = p.getRightSubTree() == parent;
                    if (parentLeft != pLeft) {
                        parent.relPos = parent.relPos > 0 ? (parent.relPos += modify) : (parent.relPos -= modify);
                    }
                    parent = p;
                    parentLeft = pLeft;
                }
                if (!parentLeft) {
                    this.rootNode.relPos += modify;
                }
            }
        }
    }

    private BooleanBlockNode doRemove(BooleanBlockNode node) {
        BooleanBlockNode newNode;
        BooleanBlockNode p = node.parent;
        BooleanBlockNode n = newNode = node.removeSelf();
        while (p != null) {
            assert (p.left == node || p.right == node);
            if (p.left == node) {
                p.left = newNode;
            } else {
                p.right = newNode;
            }
            node = p;
            node.recalcHeight();
            newNode = node.balance();
            p = newNode.parent;
        }
        this.rootNode = newNode;
        return n;
    }

    @Override
    protected boolean doAddAll(int index, IBooleanList list) {
        if (list.size() == 0) {
            return false;
        }
        if (index == -1) {
            index = this.size;
        }
        int oldSize = this.size;
        if (list.size() == 1) {
            return this.doAdd(index, list.get(0));
        }
        int addPos = this.getBooleanBlockIndex(index, true, 0);
        BooleanBlock addBooleanBlock = this.currNode.block;
        int space = this.blockSize - addBooleanBlock.size();
        int addLen = list.size();
        if (addLen <= space) {
            this.currNode.block.addAll(addPos, list);
            this.modify(this.currNode, addLen);
            this.size += addLen;
            this.currBooleanBlockEnd += addLen;
        } else if (index == this.size) {
            int add;
            for (int i = 0; i < space; ++i) {
                this.currNode.block.add(addPos + i, list.get(i));
            }
            this.modify(this.currNode, space);
            int done = space;
            for (int todo = addLen - space; todo > 0; todo -= add) {
                BooleanBlock nextBooleanBlock = new BooleanBlock(this.blockSize);
                add = Math.min(todo, this.blockSize);
                for (int i = 0; i < add; ++i) {
                    nextBooleanBlock.add(i, list.get(done + i));
                }
                this.addBooleanBlock(this.size + (done += add), nextBooleanBlock);
                this.currNode = this.currNode.next();
            }
            this.size += addLen;
            this.currBooleanBlockEnd = this.size;
            this.currBooleanBlockStart = this.currBooleanBlockEnd - this.currNode.block.size();
        } else if (index == 0) {
            int add;
            assert (addPos == 0);
            for (int i = 0; i < space; ++i) {
                this.currNode.block.add(addPos + i, list.get(addLen - space + i));
            }
            this.modify(this.currNode, space);
            int done = space;
            for (int todo = addLen - space; todo > 0; todo -= add) {
                BooleanBlock nextBooleanBlock = new BooleanBlock(this.blockSize);
                add = Math.min(todo, this.blockSize);
                for (int i = 0; i < add; ++i) {
                    nextBooleanBlock.add(i, list.get(addLen - done - add + i));
                }
                done += add;
                this.addBooleanBlock(0, nextBooleanBlock);
                this.currNode = this.currNode.previous();
            }
            this.size += addLen;
            this.currBooleanBlockStart = 0;
            this.currBooleanBlockEnd = this.currNode.block.size();
        } else {
            BooleanGapList sublist;
            int add;
            BooleanGapList list2 = BooleanGapList.create();
            list2.addAll(list);
            int remove = this.currNode.block.size() - addPos;
            if (remove > 0) {
                list2.addAll(this.currNode.block.getAll(addPos, remove));
                this.currNode.block.remove(addPos, remove);
                this.modify(this.currNode, -remove);
                this.size -= remove;
                this.currBooleanBlockEnd -= remove;
            }
            int numElems = this.currNode.block.size() + list2.size();
            int numBooleanBlocks = (numElems - 1) / this.blockSize + 1;
            assert (numBooleanBlocks > 1);
            int has = this.currNode.block.size();
            int should = numElems / numBooleanBlocks;
            int listPos = 0;
            if (has < should) {
                add = should - has;
                sublist = list2.getAll(0, add);
                listPos += add;
                this.currNode.block.addAll(addPos, sublist);
                this.modify(this.currNode, add);
                assert (this.currNode.block.size() == should);
                numElems -= should;
                --numBooleanBlocks;
                this.size += add;
                this.currBooleanBlockEnd += add;
            } else if (has > should) {
                BooleanBlock nextBooleanBlock = new BooleanBlock(this.blockSize);
                int move = has - should;
                nextBooleanBlock.addAll(this.currNode.block.getAll(this.currNode.block.size() - move, move));
                this.currNode.block.remove(this.currNode.block.size() - move, move);
                this.modify(this.currNode, -move);
                assert (this.currNode.block.size() == should);
                numElems -= should;
                this.currBooleanBlockEnd -= move;
                should = numElems / --numBooleanBlocks;
                int add2 = should - move;
                assert (add2 >= 0);
                BooleanGapList sublist2 = list2.getAll(0, add2);
                nextBooleanBlock.addAll(move, sublist2);
                listPos += add2;
                assert (nextBooleanBlock.size() == should);
                numElems -= should;
                --numBooleanBlocks;
                this.size += add2;
                this.addBooleanBlock(this.currBooleanBlockEnd, nextBooleanBlock);
                this.currNode = this.currNode.next();
                assert (this.currNode.block == nextBooleanBlock);
                assert (this.currNode.block.size() == add2 + move);
                this.currBooleanBlockStart = this.currBooleanBlockEnd;
                this.currBooleanBlockEnd += add2 + move;
            } else {
                numElems -= should;
                --numBooleanBlocks;
            }
            while (numBooleanBlocks > 0) {
                add = numElems / numBooleanBlocks;
                assert (add > 0);
                sublist = list2.getAll(listPos, add);
                listPos += add;
                BooleanBlock nextBooleanBlock = new BooleanBlock();
                nextBooleanBlock.addAll(sublist);
                assert (nextBooleanBlock.size() == add);
                numElems -= add;
                this.addBooleanBlock(this.currBooleanBlockEnd, nextBooleanBlock);
                this.currNode = this.currNode.next();
                assert (this.currNode.block == nextBooleanBlock);
                assert (this.currNode.block.size() == add);
                this.currBooleanBlockStart = this.currBooleanBlockEnd;
                this.currBooleanBlockEnd += add;
                this.size += add;
                --numBooleanBlocks;
            }
        }
        assert (oldSize + addLen == this.size);
        return true;
    }

    @Override
    protected void doClear() {
        this.finalize();
        this.rootNode = null;
        this.currBooleanBlockStart = 0;
        this.currBooleanBlockEnd = 0;
        this.currModify = 0;
        this.currNode = null;
        this.size = 0;
        this.doInit(this.blockSize, 0);
    }

    @Override
    protected void doRemoveAll(int index, int len) {
        if (len == 0) {
            return;
        }
        if (index == 0 && len == this.size) {
            this.doClear();
            return;
        }
        if (len == 1) {
            this.doRemove(index);
            return;
        }
        int startPos = this.getBooleanBlockIndex(index, true, 0);
        BooleanBlockNode startNode = this.currNode;
        int endPos = this.getBooleanBlockIndex(index + len - 1, true, 0);
        BooleanBlockNode endNode = this.currNode;
        if (startNode == endNode) {
            this.getBooleanBlockIndex(index, true, -len);
            this.currNode.block.remove(startPos, len);
            if (this.currNode.block.isEmpty()) {
                BooleanBlockNode oldCurrNode = this.currNode;
                this.releaseBooleanBlock();
                BooleanBlockNode node = this.doRemove(oldCurrNode);
                this.merge(node);
            } else {
                this.currBooleanBlockEnd -= len;
                this.merge(this.currNode);
            }
            this.size -= len;
        } else {
            int startLen = startNode.block.size() - startPos;
            this.getBooleanBlockIndex(index, true, -startLen);
            startNode.block.remove(startPos, startLen);
            assert (startNode == this.currNode);
            if (this.currNode.block.isEmpty()) {
                this.releaseBooleanBlock();
                this.doRemove(startNode);
                startNode = null;
            }
            len -= startLen;
            this.size -= startLen;
            while (len > 0) {
                this.currNode = null;
                this.getBooleanBlockIndex(index, true, 0);
                int s = this.currNode.block.size();
                if (s <= len) {
                    this.modify(this.currNode, -s);
                    BooleanBlockNode oldCurrNode = this.currNode;
                    this.releaseBooleanBlock();
                    this.doRemove(oldCurrNode);
                    if (oldCurrNode == endNode) {
                        endNode = null;
                    }
                    len -= s;
                    this.size -= s;
                    continue;
                }
                this.modify(this.currNode, -len);
                this.currNode.block.remove(0, len);
                this.size -= len;
                break;
            }
            this.releaseBooleanBlock();
            this.getBooleanBlockIndex(index, false, 0);
            this.merge(this.currNode);
        }
    }

    private void merge(BooleanBlockNode node) {
        if (node == null) {
            return;
        }
        int minBooleanBlockSize = Math.max((int)((float)this.blockSize * 0.35f), 1);
        if (node.block.size() >= minBooleanBlockSize) {
            return;
        }
        BooleanBlockNode oldCurrNode = node;
        BooleanBlockNode leftNode = node.previous();
        if (leftNode != null && leftNode.block.size() < minBooleanBlockSize) {
            int len = node.block.size();
            int dstSize = leftNode.getBooleanBlock().size();
            for (int i = 0; i < len; ++i) {
                leftNode.block.add(false);
            }
            BooleanGapList.transferCopy(node.block, 0, len, leftNode.block, dstSize, len);
            assert (leftNode.block.size() <= this.blockSize);
            this.modify(leftNode, len);
            this.modify(oldCurrNode, -len);
            this.releaseBooleanBlock();
            this.doRemove(oldCurrNode);
        } else {
            BooleanBlockNode rightNode = node.next();
            if (rightNode != null && rightNode.block.size() < minBooleanBlockSize) {
                int len = node.block.size();
                for (int i = 0; i < len; ++i) {
                    rightNode.block.add(0, false);
                }
                BooleanGapList.transferCopy(node.block, 0, len, rightNode.block, 0, len);
                assert (rightNode.block.size() <= this.blockSize);
                this.modify(rightNode, len);
                this.modify(oldCurrNode, -len);
                this.releaseBooleanBlock();
                this.doRemove(oldCurrNode);
            }
        }
    }

    @Override
    protected boolean doRemove(int index) {
        int pos = this.getBooleanBlockIndex(index, true, -1);
        boolean oldElem = this.currNode.block.doRemove(pos);
        --this.currBooleanBlockEnd;
        int minBooleanBlockSize = Math.max(this.blockSize / 3, 1);
        if (this.currNode.block.size() < minBooleanBlockSize) {
            if (this.currNode.block.size() == 0) {
                if (!this.isOnlyRootBooleanBlock()) {
                    BooleanBlockNode oldCurrNode = this.currNode;
                    this.releaseBooleanBlock();
                    this.doRemove(oldCurrNode);
                }
            } else if (index != 0 && index != this.size - 1) {
                this.merge(this.currNode);
            }
        }
        --this.size;
        return oldElem;
    }

    @Override
    public BooleanBigList unmodifiableList() {
        return new ImmutableBooleanBigList(this);
    }

    @Override
    protected void doEnsureCapacity(int minCapacity) {
        if (this.isOnlyRootBooleanBlock()) {
            if (minCapacity > this.blockSize) {
                minCapacity = this.blockSize;
            }
            this.rootNode.block.doEnsureCapacity(minCapacity);
        }
    }

    @Override
    public void trimToSize() {
        this.doModify();
        if (this.isOnlyRootBooleanBlock()) {
            this.rootNode.block.trimToSize();
        } else {
            BooleanBigList newList = new BooleanBigList(this.blockSize);
            BooleanBlockNode node = this.rootNode.min();
            while (node != null) {
                newList.addAll(node.block);
                this.remove(0, node.block.size());
                node = node.next();
            }
            this.doAssign(newList);
        }
    }

    @Override
    protected IBooleanList doCreate(int capacity) {
        if (capacity <= this.blockSize) {
            return new BooleanBigList(this.blockSize);
        }
        return new BooleanBigList(this.blockSize, capacity);
    }

    @Override
    public void sort(int index, int len) {
        this.checkRange(index, len);
        if (this.isOnlyRootBooleanBlock()) {
            this.rootNode.block.sort(index, len);
        } else {
            BooleanMergeSort.sort(this, index, index + len);
        }
    }

    @Override
    public int binarySearch(int index, int len, boolean key) {
        this.checkRange(index, len);
        if (this.isOnlyRootBooleanBlock()) {
            return this.rootNode.block.binarySearch(key);
        }
        return BooleanBinarySearch.binarySearch(this, key, 0, this.size());
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.writeInt(this.blockSize);
        int size = this.size();
        oos.writeInt(size);
        for (int i = 0; i < size; ++i) {
            oos.writeBoolean(this.doGet(i));
        }
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        int blockSize = ois.readInt();
        int size = ois.readInt();
        int firstBooleanBlockSize = size <= blockSize ? size : -1;
        this.doInit(blockSize, firstBooleanBlockSize);
        for (int i = 0; i < size; ++i) {
            this.add(ois.readBoolean());
        }
    }

    private void checkNode(BooleanBlockNode node) {
        assert ((node.block.size() > 0 || node == this.rootNode) && node.block.size() <= this.blockSize);
        BooleanBlockNode child = node.getLeftSubTree();
        assert (child == null || child.parent == node);
        child = node.getRightSubTree();
        assert (child == null || child.parent == node);
    }

    private void checkHeight(BooleanBlockNode node) {
        BooleanBlockNode left = node.getLeftSubTree();
        BooleanBlockNode right = node.getRightSubTree();
        if (left == null) {
            if (right == null) {
                assert (node.height == 0);
            } else {
                assert (right.height == node.height - 1);
                this.checkHeight(right);
            }
        } else {
            if (right == null) {
                assert (left.height == node.height - 1);
            } else {
                assert (left.height == node.height - 1 || left.height == node.height - 2);
                assert (right.height == node.height - 1 || right.height == node.height - 2);
                assert (right.height == node.height - 1 || left.height == node.height - 1);
            }
            this.checkHeight(left);
        }
    }

    private void check() {
        if (this.currNode != null) {
            assert (this.currBooleanBlockStart >= 0 && this.currBooleanBlockEnd <= this.size && this.currBooleanBlockStart <= this.currBooleanBlockEnd);
            assert (this.currBooleanBlockStart + this.currNode.block.size() == this.currBooleanBlockEnd);
        }
        if (this.rootNode == null) {
            assert (this.size == 0);
            return;
        }
        this.checkHeight(this.rootNode);
        BooleanBlockNode oldCurrNode = this.currNode;
        int oldCurrModify = this.currModify;
        if (this.currModify != 0) {
            this.currNode = null;
            this.currModify = 0;
            this.modify(oldCurrNode, oldCurrModify);
        }
        BooleanBlockNode node = this.rootNode;
        this.checkNode(node);
        int index = node.relPos;
        while (node.left != null) {
            node = node.left;
            this.checkNode(node);
            assert (node.relPos < 0);
            index += node.relPos;
        }
        BooleanBlock block = node.getBooleanBlock();
        assert (block.size() == index);
        int lastIndex = index;
        while (lastIndex < this.size()) {
            node = this.rootNode;
            index = node.relPos;
            int searchIndex = lastIndex + 1;
            while (true) {
                this.checkNode(node);
                block = node.getBooleanBlock();
                assert (block.size() > 0);
                if (searchIndex > index - block.size() && searchIndex <= index) break;
                if (searchIndex < index) {
                    if (node.left == null || node.left.height >= node.height) break;
                    node = node.left;
                } else {
                    if (node.right == null || node.right.height >= node.height) break;
                    node = node.right;
                }
                index += node.relPos;
            }
            block = node.getBooleanBlock();
            assert (block.size() == index - lastIndex);
            lastIndex = index;
        }
        assert (index == this.size());
        if (oldCurrModify != 0) {
            this.modify(oldCurrNode, -oldCurrModify);
        }
        this.currNode = oldCurrNode;
        this.currModify = oldCurrModify;
    }

    protected static class ImmutableBooleanBigList
    extends BooleanBigList {
        private static final long serialVersionUID = -1352274047348922584L;

        protected ImmutableBooleanBigList(BooleanBigList that) {
            super(true, that);
        }

        @Override
        protected boolean doAdd(int index, boolean elem) {
            this.error();
            return false;
        }

        @Override
        protected boolean doSet(int index, boolean elem) {
            this.error();
            return false;
        }

        @Override
        protected boolean doReSet(int index, boolean elem) {
            this.error();
            return false;
        }

        @Override
        protected boolean doRemove(int index) {
            this.error();
            return false;
        }

        @Override
        protected void doRemoveAll(int index, int len) {
            this.error();
        }

        @Override
        protected void doClear() {
            this.error();
        }

        @Override
        protected void doModify() {
            this.error();
        }

        private void error() {
            throw new UnsupportedOperationException("list is immutable");
        }
    }

    static class BooleanBlockNode {
        BooleanBlockNode parent;
        BooleanBlockNode left;
        boolean leftIsPrevious;
        BooleanBlockNode right;
        boolean rightIsNext;
        int height;
        int relPos;
        BooleanBlock block;

        private BooleanBlockNode(BooleanBlockNode parent, int relPos, BooleanBlock block, BooleanBlockNode rightFollower, BooleanBlockNode leftFollower) {
            this.parent = parent;
            this.relPos = relPos;
            this.block = block;
            this.rightIsNext = true;
            this.leftIsPrevious = true;
            this.right = rightFollower;
            this.left = leftFollower;
        }

        private BooleanBlock getBooleanBlock() {
            return this.block;
        }

        private void setBooleanBlock(BooleanBlock block) {
            this.block = block;
        }

        private BooleanBlockNode next() {
            if (this.rightIsNext || this.right == null) {
                return this.right;
            }
            return this.right.min();
        }

        private BooleanBlockNode previous() {
            if (this.leftIsPrevious || this.left == null) {
                return this.left;
            }
            return this.left.max();
        }

        private BooleanBlockNode insert(int index, BooleanBlock obj) {
            assert (this.relPos != 0);
            int relIndex = index - this.relPos;
            if (relIndex < 0) {
                return this.insertOnLeft(relIndex, obj);
            }
            return this.insertOnRight(relIndex, obj);
        }

        private BooleanBlockNode insertOnLeft(int relIndex, BooleanBlock obj) {
            if (this.getLeftSubTree() == null) {
                int pos = this.relPos >= 0 ? -this.relPos : -this.block.size();
                this.setLeft(new BooleanBlockNode(this, pos, obj, this, this.left), null);
            } else {
                this.setLeft(this.left.insert(relIndex, obj), null);
            }
            if (this.relPos >= 0) {
                this.relPos += obj.size();
            }
            BooleanBlockNode ret = this.balance();
            this.recalcHeight();
            return ret;
        }

        private BooleanBlockNode insertOnRight(int relIndex, BooleanBlock obj) {
            if (this.getRightSubTree() == null) {
                this.setRight(new BooleanBlockNode(this, obj.size(), obj, this.right, this), null);
            } else {
                this.setRight(this.right.insert(relIndex, obj), null);
            }
            if (this.relPos < 0) {
                this.relPos -= obj.size();
            }
            BooleanBlockNode ret = this.balance();
            this.recalcHeight();
            return ret;
        }

        private BooleanBlockNode getLeftSubTree() {
            return this.leftIsPrevious ? null : this.left;
        }

        private BooleanBlockNode getRightSubTree() {
            return this.rightIsNext ? null : this.right;
        }

        private BooleanBlockNode max() {
            return this.getRightSubTree() == null ? this : this.right.max();
        }

        private BooleanBlockNode min() {
            return this.getLeftSubTree() == null ? this : this.left.min();
        }

        private BooleanBlockNode removeMax() {
            if (this.getRightSubTree() == null) {
                return this.removeSelf();
            }
            this.setRight(this.right.removeMax(), this.right.right);
            this.recalcHeight();
            return this.balance();
        }

        private BooleanBlockNode removeMin(int size) {
            if (this.getLeftSubTree() == null) {
                return this.removeSelf();
            }
            this.setLeft(this.left.removeMin(size), this.left.left);
            if (this.relPos > 0) {
                this.relPos -= size;
            }
            this.recalcHeight();
            return this.balance();
        }

        private BooleanBlockNode removeSelf() {
            BooleanBlockNode p = this.parent;
            BooleanBlockNode n = this.doRemoveSelf();
            if (n != null) {
                assert (p != n);
                n.parent = p;
            }
            return n;
        }

        private BooleanBlockNode doRemoveSelf() {
            if (this.getRightSubTree() == null && this.getLeftSubTree() == null) {
                return null;
            }
            if (this.getRightSubTree() == null) {
                this.left.relPos = this.relPos > 0 ? this.left.relPos + (this.relPos + (this.relPos > 0 ? 0 : 1)) : (this.left.relPos += this.relPos);
                this.left.max().setRight(null, this.right);
                return this.left;
            }
            if (this.getLeftSubTree() == null) {
                if (this.relPos < 0) {
                    this.right.relPos = this.right.relPos + (this.relPos - (this.relPos < 0 ? 0 : 1));
                }
                this.right.min().setLeft(null, this.left);
                return this.right;
            }
            if (this.heightRightMinusLeft() > 0) {
                BooleanBlockNode rightMin = this.right.min();
                this.block = rightMin.block;
                int bs = this.block.size();
                if (this.leftIsPrevious) {
                    this.left = rightMin.left;
                }
                this.right = this.right.removeMin(bs);
                this.relPos += bs;
                this.left.relPos -= bs;
            } else {
                BooleanBlockNode leftMax = this.left.max();
                this.block = leftMax.block;
                if (this.rightIsNext) {
                    this.right = leftMax.right;
                }
                BooleanBlockNode leftPrevious = this.left.left;
                this.left = this.left.removeMax();
                if (this.left == null) {
                    this.left = leftPrevious;
                    this.leftIsPrevious = true;
                } else if (this.left.relPos == 0) {
                    this.left.relPos = -1;
                }
            }
            this.recalcHeight();
            return this;
        }

        private BooleanBlockNode balance() {
            switch (this.heightRightMinusLeft()) {
                case -1: 
                case 0: 
                case 1: {
                    return this;
                }
                case -2: {
                    if (this.left.heightRightMinusLeft() > 0) {
                        this.setLeft(this.left.rotateLeft(), null);
                    }
                    return this.rotateRight();
                }
                case 2: {
                    if (this.right.heightRightMinusLeft() < 0) {
                        this.setRight(this.right.rotateRight(), null);
                    }
                    return this.rotateLeft();
                }
            }
            throw new RuntimeException("tree inconsistent!");
        }

        private int getOffset(BooleanBlockNode node) {
            if (node == null) {
                return 0;
            }
            return node.relPos;
        }

        private int setOffset(BooleanBlockNode node, int newOffest) {
            if (node == null) {
                return 0;
            }
            int oldOffset = this.getOffset(node);
            node.relPos = newOffest;
            return oldOffset;
        }

        private void recalcHeight() {
            this.height = Math.max(this.getLeftSubTree() == null ? -1 : this.getLeftSubTree().height, this.getRightSubTree() == null ? -1 : this.getRightSubTree().height) + 1;
        }

        private int getHeight(BooleanBlockNode node) {
            return node == null ? -1 : node.height;
        }

        private int heightRightMinusLeft() {
            return this.getHeight(this.getRightSubTree()) - this.getHeight(this.getLeftSubTree());
        }

        private BooleanBlockNode rotateLeft() {
            assert (!this.rightIsNext);
            BooleanBlockNode newTop = this.right;
            BooleanBlockNode movedNode = this.getRightSubTree().getLeftSubTree();
            int newTopPosition = this.relPos + this.getOffset(newTop);
            int myNewPosition = -newTop.relPos;
            int movedPosition = this.getOffset(newTop) + this.getOffset(movedNode);
            BooleanBlockNode p = this.parent;
            this.setRight(movedNode, newTop);
            newTop.setLeft(this, null);
            newTop.parent = p;
            this.parent = newTop;
            this.setOffset(newTop, newTopPosition);
            this.setOffset(this, myNewPosition);
            this.setOffset(movedNode, movedPosition);
            assert (newTop.getLeftSubTree() == null || newTop.getLeftSubTree().relPos < 0);
            assert (newTop.getRightSubTree() == null || newTop.getRightSubTree().relPos > 0);
            return newTop;
        }

        private BooleanBlockNode rotateRight() {
            assert (!this.leftIsPrevious);
            BooleanBlockNode newTop = this.left;
            BooleanBlockNode movedNode = this.getLeftSubTree().getRightSubTree();
            int newTopPosition = this.relPos + this.getOffset(newTop);
            int myNewPosition = -newTop.relPos;
            int movedPosition = this.getOffset(newTop) + this.getOffset(movedNode);
            BooleanBlockNode p = this.parent;
            this.setLeft(movedNode, newTop);
            newTop.setRight(this, null);
            newTop.parent = p;
            this.parent = newTop;
            this.setOffset(newTop, newTopPosition);
            this.setOffset(this, myNewPosition);
            this.setOffset(movedNode, movedPosition);
            assert (newTop.getLeftSubTree() == null || newTop.getLeftSubTree().relPos < 0);
            assert (newTop.getRightSubTree() == null || newTop.getRightSubTree().relPos > 0);
            return newTop;
        }

        private void setLeft(BooleanBlockNode node, BooleanBlockNode previous) {
            assert (node != this && previous != this);
            boolean bl = this.leftIsPrevious = node == null;
            if (this.leftIsPrevious) {
                this.left = previous;
            } else {
                this.left = node;
                this.left.parent = this;
            }
            this.recalcHeight();
        }

        private void setRight(BooleanBlockNode node, BooleanBlockNode next) {
            assert (node != this && next != this);
            boolean bl = this.rightIsNext = node == null;
            if (this.rightIsNext) {
                this.right = next;
            } else {
                this.right = node;
                this.right.parent = this;
            }
            this.recalcHeight();
        }

        public String toString() {
            return "BooleanBlockNode(" + this.relPos + ',' + (this.getRightSubTree() != null) + ',' + this.block + ',' + (this.getRightSubTree() != null) + ", height " + this.height + " )";
        }
    }

    static class BooleanBlock
    extends BooleanGapList {
        private AtomicInteger refCount = new AtomicInteger(1);

        public BooleanBlock() {
        }

        public BooleanBlock(int capacity) {
            super(capacity);
        }

        public BooleanBlock(BooleanBlock that) {
            super(that.capacity());
            this.addAll(that);
        }

        public boolean isShared() {
            return this.refCount.get() > 1;
        }

        public BooleanBlock ref() {
            this.refCount.incrementAndGet();
            return this;
        }

        public void unref() {
            this.refCount.decrementAndGet();
        }
    }

    protected static abstract class ImmutableBooleanList
    extends IBooleanList {
        protected ImmutableBooleanList() {
        }

        @Override
        public int capacity() {
            return this.size();
        }

        @Override
        public int binarySearch(int index, int len, boolean key) {
            return BooleanBinarySearch.binarySearch(this, key, index, index + len);
        }

        @Override
        public IBooleanList unmodifiableList() {
            return this;
        }

        @Override
        protected boolean getDefaultElem() {
            return false;
        }

        private void error() {
            throw new UnsupportedOperationException("list is immutable");
        }

        @Override
        protected void doRemoveAll(int index, int len) {
            this.error();
        }

        @Override
        protected void doClear() {
            this.error();
        }

        @Override
        protected void doModify() {
            this.error();
        }

        @Override
        protected void doClone(IBooleanList that) {
            this.error();
        }

        @Override
        protected boolean doSet(int index, boolean elem) {
            this.error();
            return false;
        }

        @Override
        protected boolean doReSet(int index, boolean elem) {
            this.error();
            return false;
        }

        @Override
        protected boolean doAdd(int index, boolean elem) {
            this.error();
            return false;
        }

        @Override
        protected void doEnsureCapacity(int minCapacity) {
            this.error();
        }

        @Override
        public void trimToSize() {
            this.error();
        }

        @Override
        protected IBooleanList doCreate(int capacity) {
            this.error();
            return null;
        }

        @Override
        protected void doAssign(IBooleanList that) {
            this.error();
        }

        @Override
        protected boolean doRemove(int index) {
            this.error();
            return false;
        }

        @Override
        public void sort(int index, int len) {
            this.error();
        }
    }

    static class ImmutableBooleanListList
    extends ImmutableBooleanList {
        List<Boolean> values;

        public ImmutableBooleanListList(List<Boolean> values) {
            this.values = values;
        }

        @Override
        public int size() {
            return this.values.size();
        }

        @Override
        protected boolean doGet(int index) {
            return this.values.get(index);
        }
    }

    static class ImmutableBooleanListArrayWrapper
    extends ImmutableBooleanList {
        Boolean[] values;

        public ImmutableBooleanListArrayWrapper(Boolean[] values) {
            this.values = values;
        }

        @Override
        public int size() {
            return this.values.length;
        }

        @Override
        protected boolean doGet(int index) {
            return this.values[index];
        }
    }

    static class ImmutableBooleanListArrayPrimitive
    extends ImmutableBooleanList {
        boolean[] values;

        public ImmutableBooleanListArrayPrimitive(boolean[] values) {
            this.values = values;
        }

        @Override
        public int size() {
            return this.values.length;
        }

        @Override
        protected boolean doGet(int index) {
            return this.values[index];
        }
    }
}

