/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.aiff;

import java.io.IOException;
import java.io.RandomAccessFile;
import org.jaudiotagger.audio.aiff.AiffAudioHeader;
import org.jaudiotagger.audio.aiff.AiffUtil;
import org.jaudiotagger.audio.aiff.Chunk;
import org.jaudiotagger.audio.aiff.ChunkHeader;
import org.jaudiotagger.audio.generic.Utils;

public class ApplicationChunk
extends Chunk {
    private AiffAudioHeader aiffHeader;

    public ApplicationChunk(ChunkHeader hdr, RandomAccessFile raf, AiffAudioHeader aHdr) {
        super(raf, hdr);
        this.aiffHeader = aHdr;
    }

    public boolean readChunk() throws IOException {
        String applicationSignature = Utils.readString(this.raf, 4);
        String applicationName = null;
        byte[] data = new byte[(int)(this.bytesLeft - 4L)];
        this.raf.readFully(data);
        if ("stoc".equals(applicationSignature) || "pdos".equals(applicationSignature)) {
            applicationName = AiffUtil.bytesToPascalString(data);
        }
        this.aiffHeader.addApplicationIdentifier(applicationSignature + ": " + applicationName);
        return true;
    }
}

