/*
 * Decompiled with CFR 0.152.
 */
package ezvcard.property;

import ezvcard.VCard;
import ezvcard.VCardVersion;
import ezvcard.Warning;
import ezvcard.parameter.AddressType;
import ezvcard.parameter.Pid;
import ezvcard.parameter.VCardParameters;
import ezvcard.property.HasAltId;
import ezvcard.property.VCardProperty;
import ezvcard.util.GeoUri;
import ezvcard.util.StringUtils;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Address
extends VCardProperty
implements HasAltId {
    private final List<String> poBoxes;
    private final List<String> extendedAddresses;
    private final List<String> streetAddresses;
    private final List<String> localities;
    private final List<String> regions;
    private final List<String> postalCodes;
    private final List<String> countries;

    public Address() {
        this.poBoxes = new ArrayList<String>(1);
        this.extendedAddresses = new ArrayList<String>(1);
        this.streetAddresses = new ArrayList<String>(1);
        this.localities = new ArrayList<String>(1);
        this.regions = new ArrayList<String>(1);
        this.postalCodes = new ArrayList<String>(1);
        this.countries = new ArrayList<String>(1);
    }

    public Address(Address original) {
        super(original);
        this.poBoxes = new ArrayList<String>(original.poBoxes);
        this.extendedAddresses = new ArrayList<String>(original.extendedAddresses);
        this.streetAddresses = new ArrayList<String>(original.streetAddresses);
        this.localities = new ArrayList<String>(original.localities);
        this.regions = new ArrayList<String>(original.regions);
        this.postalCodes = new ArrayList<String>(original.postalCodes);
        this.countries = new ArrayList<String>(original.countries);
    }

    public String getPoBox() {
        return Address.first(this.poBoxes);
    }

    public List<String> getPoBoxes() {
        return this.poBoxes;
    }

    public void setPoBox(String poBox) {
        Address.set(this.poBoxes, poBox);
    }

    public String getExtendedAddress() {
        return Address.first(this.extendedAddresses);
    }

    public List<String> getExtendedAddresses() {
        return this.extendedAddresses;
    }

    public String getExtendedAddressFull() {
        return Address.getAddressFull(this.extendedAddresses);
    }

    public void setExtendedAddress(String extendedAddress) {
        Address.set(this.extendedAddresses, extendedAddress);
    }

    public String getStreetAddress() {
        return Address.first(this.streetAddresses);
    }

    public List<String> getStreetAddresses() {
        return this.streetAddresses;
    }

    public String getStreetAddressFull() {
        return Address.getAddressFull(this.streetAddresses);
    }

    public void setStreetAddress(String streetAddress) {
        Address.set(this.streetAddresses, streetAddress);
    }

    public String getLocality() {
        return Address.first(this.localities);
    }

    public List<String> getLocalities() {
        return this.localities;
    }

    public void setLocality(String locality) {
        Address.set(this.localities, locality);
    }

    public String getRegion() {
        return Address.first(this.regions);
    }

    public List<String> getRegions() {
        return this.regions;
    }

    public void setRegion(String region) {
        Address.set(this.regions, region);
    }

    public String getPostalCode() {
        return Address.first(this.postalCodes);
    }

    public List<String> getPostalCodes() {
        return this.postalCodes;
    }

    public void setPostalCode(String postalCode) {
        Address.set(this.postalCodes, postalCode);
    }

    public String getCountry() {
        return Address.first(this.countries);
    }

    public List<String> getCountries() {
        return this.countries;
    }

    public void setCountry(String country) {
        Address.set(this.countries, country);
    }

    public List<AddressType> getTypes() {
        return new VCardParameters.TypeParameterList<AddressType>(this.parameters){

            @Override
            protected AddressType _asObject(String value) {
                return AddressType.get(value);
            }
        };
    }

    @Override
    public String getLanguage() {
        return super.getLanguage();
    }

    @Override
    public void setLanguage(String language) {
        super.setLanguage(language);
    }

    public String getLabel() {
        return this.parameters.getLabel();
    }

    public void setLabel(String label) {
        this.parameters.setLabel(label);
    }

    public GeoUri getGeo() {
        return this.parameters.getGeo();
    }

    public void setGeo(GeoUri uri) {
        this.parameters.setGeo(uri);
    }

    @Override
    public List<Pid> getPids() {
        return super.getPids();
    }

    @Override
    public Integer getPref() {
        return super.getPref();
    }

    @Override
    public void setPref(Integer pref) {
        super.setPref(pref);
    }

    @Override
    public String getAltId() {
        return this.parameters.getAltId();
    }

    @Override
    public void setAltId(String altId) {
        this.parameters.setAltId(altId);
    }

    public String getTimezone() {
        return this.parameters.getTimezone();
    }

    public void setTimezone(String timezone) {
        this.parameters.setTimezone(timezone);
    }

    @Override
    protected void _validate(List<Warning> warnings, VCardVersion version, VCard vcard) {
        for (AddressType type : this.getTypes()) {
            if (type == AddressType.PREF || type.isSupportedBy(version)) continue;
            warnings.add(new Warning(9, type.getValue()));
        }
    }

    @Override
    protected Map<String, Object> toStringValues() {
        LinkedHashMap<String, Object> values = new LinkedHashMap<String, Object>();
        values.put("poBoxes", this.poBoxes);
        values.put("extendedAddresses", this.extendedAddresses);
        values.put("streetAddresses", this.streetAddresses);
        values.put("localities", this.localities);
        values.put("regions", this.regions);
        values.put("postalCodes", this.postalCodes);
        values.put("countries", this.countries);
        return values;
    }

    @Override
    public Address copy() {
        return new Address(this);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.countries.hashCode();
        result = 31 * result + this.extendedAddresses.hashCode();
        result = 31 * result + this.localities.hashCode();
        result = 31 * result + this.poBoxes.hashCode();
        result = 31 * result + this.postalCodes.hashCode();
        result = 31 * result + this.regions.hashCode();
        result = 31 * result + this.streetAddresses.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        Address other = (Address)obj;
        if (!this.countries.equals(other.countries)) {
            return false;
        }
        if (!this.extendedAddresses.equals(other.extendedAddresses)) {
            return false;
        }
        if (!this.localities.equals(other.localities)) {
            return false;
        }
        if (!this.poBoxes.equals(other.poBoxes)) {
            return false;
        }
        if (!this.postalCodes.equals(other.postalCodes)) {
            return false;
        }
        if (!this.regions.equals(other.regions)) {
            return false;
        }
        return this.streetAddresses.equals(other.streetAddresses);
    }

    private static String first(List<String> list) {
        return list.isEmpty() ? null : list.get(0);
    }

    private static void set(List<String> list, String value) {
        list.clear();
        if (value != null) {
            list.add(value);
        }
    }

    private static String getAddressFull(List<String> list) {
        return list.isEmpty() ? null : StringUtils.join(list, ",");
    }
}

