/*
 * Decompiled with CFR 0.152.
 */
package ezvcard.io.html;

import ezvcard.Ezvcard;
import ezvcard.VCard;
import ezvcard.io.scribe.ScribeIndex;
import ezvcard.parameter.ImageType;
import ezvcard.property.Photo;
import ezvcard.util.DataUri;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;

public class HCardPage {
    private static final Template template;
    private final List<VCard> vcards = new ArrayList<VCard>();

    public void add(VCard vcard) {
        this.vcards.add(vcard);
    }

    public String write() {
        StringWriter sw = new StringWriter();
        try {
            this.write(sw);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return sw.toString();
    }

    public void write(OutputStream out) throws IOException {
        this.write(new OutputStreamWriter(out));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(File file) throws IOException {
        FileWriter writer = new FileWriter(file);
        try {
            this.write(writer);
        }
        finally {
            writer.close();
        }
    }

    public void write(Writer writer) throws IOException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("vcards", this.vcards);
        map.put("utils", new TemplateUtils());
        map.put("translucentBg", this.readImage("translucent-bg.png", ImageType.PNG));
        map.put("noProfile", this.readImage("no-profile.png", ImageType.PNG));
        map.put("ezVCardVersion", Ezvcard.VERSION);
        map.put("ezVCardUrl", Ezvcard.URL);
        map.put("scribeIndex", new ScribeIndex());
        try {
            template.process(map, writer);
        }
        catch (TemplateException e) {
            throw new RuntimeException(e);
        }
        writer.flush();
    }

    private Photo readImage(String name, ImageType mediaType) throws IOException {
        return new Photo(this.getClass().getResourceAsStream(name), mediaType);
    }

    static {
        Configuration cfg = new Configuration(Configuration.VERSION_2_3_23);
        cfg.setClassForTemplateLoading(HCardPage.class, "");
        cfg.setWhitespaceStripping(true);
        try {
            template = cfg.getTemplate("hcard-template.html");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static class TemplateUtils {
        private final Pattern newlineRegex = Pattern.compile("\\r\\n|\\r|\\n");

        public String base64(String contentType, byte[] data) {
            return new DataUri(contentType, data).toString();
        }

        public String lineBreaks(String value) {
            return this.newlineRegex.matcher(value).replaceAll("<br />");
        }
    }
}

