/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.core;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import liquibase.CatalogAndSchema;
import liquibase.change.CheckSum;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.changelog.RanChangeSet;
import liquibase.changelog.filter.ContextChangeSetFilter;
import liquibase.changelog.filter.DbmsChangeSetFilter;
import liquibase.database.AbstractJdbcDatabase;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.exception.DatabaseException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.executor.Executor;
import liquibase.executor.ExecutorService;
import liquibase.logging.LogFactory;
import liquibase.snapshot.SnapshotControl;
import liquibase.snapshot.SnapshotGeneratorFactory;
import liquibase.statement.AbstractSqlStatement;
import liquibase.statement.ColumnConstraint;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.AddColumnStatement;
import liquibase.statement.core.CreateDatabaseChangeLogTableStatement;
import liquibase.statement.core.GetViewDefinitionStatement;
import liquibase.statement.core.ModifyDataTypeStatement;
import liquibase.statement.core.RawSqlStatement;
import liquibase.statement.core.SelectFromDatabaseChangeLogStatement;
import liquibase.statement.core.SetNullableStatement;
import liquibase.statement.core.UpdateChangeSetChecksumStatement;
import liquibase.statement.core.UpdateStatement;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Column;
import liquibase.structure.core.Table;

public class InformixDatabase
extends AbstractJdbcDatabase {
    private static final String PRODUCT_NAME = "Informix Dynamic Server";
    private static final String INTERVAL_FIELD_QUALIFIER = "HOUR TO FRACTION(5)";
    private static final String DATETIME_FIELD_QUALIFIER = "YEAR TO FRACTION(5)";
    private Set<String> systemTablesAndViews = new HashSet<String>();
    private static final Pattern CREATE_VIEW_AS_PATTERN = Pattern.compile("^CREATE\\s+.*?VIEW\\s+.*?AS\\s+", 34);

    public InformixDatabase() {
        super.setCurrentDateTimeFunction("CURRENT YEAR TO FRACTION(5)");
        this.sequenceNextValueFunction = "%s.NEXTVAL";
        this.systemTablesAndViews.add("systables");
        this.systemTablesAndViews.add("syscolumns");
        this.systemTablesAndViews.add("sysindices");
        this.systemTablesAndViews.add("systabauth");
        this.systemTablesAndViews.add("syscolauth");
        this.systemTablesAndViews.add("sysviews");
        this.systemTablesAndViews.add("sysusers");
        this.systemTablesAndViews.add("sysdepend");
        this.systemTablesAndViews.add("syssynonyms");
        this.systemTablesAndViews.add("syssyntable");
        this.systemTablesAndViews.add("sysconstraints");
        this.systemTablesAndViews.add("sysreferences");
        this.systemTablesAndViews.add("syschecks");
        this.systemTablesAndViews.add("sysdefaults");
        this.systemTablesAndViews.add("syscoldepend");
        this.systemTablesAndViews.add("sysprocedures");
        this.systemTablesAndViews.add("sysprocbody");
        this.systemTablesAndViews.add("sysprocplan");
        this.systemTablesAndViews.add("sysprocauth");
        this.systemTablesAndViews.add("sysblobs");
        this.systemTablesAndViews.add("sysopclstr");
        this.systemTablesAndViews.add("systriggers");
        this.systemTablesAndViews.add("systrigbody");
        this.systemTablesAndViews.add("sysdistrib");
        this.systemTablesAndViews.add("sysfragments");
        this.systemTablesAndViews.add("sysobjstate");
        this.systemTablesAndViews.add("sysviolations");
        this.systemTablesAndViews.add("sysfragauth");
        this.systemTablesAndViews.add("sysroleauth");
        this.systemTablesAndViews.add("sysxtdtypes");
        this.systemTablesAndViews.add("sysattrtypes");
        this.systemTablesAndViews.add("sysxtddesc");
        this.systemTablesAndViews.add("sysinherits");
        this.systemTablesAndViews.add("syscolattribs");
        this.systemTablesAndViews.add("syslogmap");
        this.systemTablesAndViews.add("syscasts");
        this.systemTablesAndViews.add("sysxtdtypeauth");
        this.systemTablesAndViews.add("sysroutinelangs");
        this.systemTablesAndViews.add("syslangauth");
        this.systemTablesAndViews.add("sysams");
        this.systemTablesAndViews.add("systabamdata");
        this.systemTablesAndViews.add("sysopclasses");
        this.systemTablesAndViews.add("syserrors");
        this.systemTablesAndViews.add("systraceclasses");
        this.systemTablesAndViews.add("systracemsgs");
        this.systemTablesAndViews.add("sysaggregates");
        this.systemTablesAndViews.add("syssequences");
        this.systemTablesAndViews.add("sysdirectives");
        this.systemTablesAndViews.add("sysxasourcetypes");
        this.systemTablesAndViews.add("sysxadatasources");
        this.systemTablesAndViews.add("sysseclabelcomponents");
        this.systemTablesAndViews.add("sysseclabelcomponentelements");
        this.systemTablesAndViews.add("syssecpolicies");
        this.systemTablesAndViews.add("syssecpolicycomponents");
        this.systemTablesAndViews.add("syssecpolicyexemptions");
        this.systemTablesAndViews.add("sysseclabels");
        this.systemTablesAndViews.add("sysseclabelnames");
        this.systemTablesAndViews.add("sysseclabelauth");
        this.systemTablesAndViews.add("syssurrogateauth");
        this.systemTablesAndViews.add("sysproccolumns");
        this.systemTablesAndViews.add("sysdomains");
        this.systemTablesAndViews.add("sysindexes");
        this.sequenceNextValueFunction = "%s.NEXTVAL";
        this.sequenceCurrentValueFunction = "%s.CURRVAL";
    }

    @Override
    protected Set<String> getSystemViews() {
        return this.systemTablesAndViews;
    }

    @Override
    public int getPriority() {
        return 1;
    }

    @Override
    protected String getDefaultDatabaseProductName() {
        return "Informix";
    }

    @Override
    public Integer getDefaultPort() {
        return 1526;
    }

    @Override
    public String getDefaultSchemaName() {
        return null;
    }

    @Override
    public void setConnection(DatabaseConnection connection) {
        super.setConnection(connection);
        try {
            ExecutorService.getInstance().getExecutor(this).execute(new RawSqlStatement("EXECUTE PROCEDURE IFX_ALLOW_NEWLINE('T');"));
        }
        catch (Exception e) {
            throw new UnexpectedLiquibaseException("Could not allow newline characters in quoted strings with IFX_ALLOW_NEWLINE", e);
        }
    }

    @Override
    public String getDefaultDriver(String url) {
        if (url.startsWith("jdbc:informix-sqli")) {
            return "com.informix.jdbc.IfxDriver";
        }
        return null;
    }

    @Override
    public String getShortName() {
        return "informix";
    }

    @Override
    public boolean isCorrectDatabaseImplementation(DatabaseConnection conn) throws DatabaseException {
        return PRODUCT_NAME.equals(conn.getDatabaseProductName());
    }

    @Override
    public boolean supportsInitiallyDeferrableColumns() {
        return false;
    }

    @Override
    public boolean supportsTablespaces() {
        return true;
    }

    @Override
    public void checkDatabaseChangeLogTable(boolean updateExistingNullChecksums, DatabaseChangeLog databaseChangeLog, String ... contexts) throws DatabaseException {
        Executor executor = ExecutorService.getInstance().getExecutor(this);
        Table changeLogTable = SnapshotGeneratorFactory.getInstance().getDatabaseChangeLogTable(new SnapshotControl((Database)this, Table.class, Column.class), this);
        ArrayList<AbstractSqlStatement> statementsToExecute = new ArrayList<AbstractSqlStatement>();
        boolean changeLogCreateAttempted = false;
        if (changeLogTable != null) {
            String md5sum;
            List<Map> md5sumRS;
            boolean hasExecTypeColumn;
            boolean hasDescription = changeLogTable.getColumn("DESCRIPTION") != null;
            boolean bl = changeLogTable.getColumn("COMMENTS") != null;
            boolean hasTag = changeLogTable.getColumn("TAG") != null;
            boolean hasLiquibase = changeLogTable.getColumn("LIQUIBASE") != null;
            boolean liquibaseColumnNotRightSize = false;
            if (!this.getConnection().getDatabaseProductName().equals("SQLite")) {
                liquibaseColumnNotRightSize = changeLogTable.getColumn("LIQUIBASE").getType().getColumnSize() != 20;
            }
            boolean hasOrderExecuted = changeLogTable.getColumn("ORDEREXECUTED") != null;
            boolean checksumNotRightSize = false;
            boolean bl2 = hasExecTypeColumn = changeLogTable.getColumn("EXECTYPE") != null;
            if (!hasDescription) {
                executor.comment("Adding missing databasechangelog.description column");
                statementsToExecute.add(new AddColumnStatement(this.getLiquibaseCatalogName(), this.getLiquibaseSchemaName(), this.getDatabaseChangeLogTableName(), "DESCRIPTION", "VARCHAR(255)", null, new ColumnConstraint[0]));
            }
            if (!hasTag) {
                executor.comment("Adding missing databasechangelog.tag column");
                statementsToExecute.add(new AddColumnStatement(this.getLiquibaseCatalogName(), this.getLiquibaseSchemaName(), this.getDatabaseChangeLogTableName(), "TAG", "VARCHAR(255)", null, new ColumnConstraint[0]));
            }
            if (!bl) {
                executor.comment("Adding missing databasechangelog.comments column");
                statementsToExecute.add(new AddColumnStatement(this.getLiquibaseCatalogName(), this.getLiquibaseSchemaName(), this.getDatabaseChangeLogTableName(), "COMMENTS", "VARCHAR(255)", null, new ColumnConstraint[0]));
            }
            if (!hasLiquibase) {
                executor.comment("Adding missing databasechangelog.liquibase column");
                statementsToExecute.add(new AddColumnStatement(this.getLiquibaseCatalogName(), this.getLiquibaseSchemaName(), this.getDatabaseChangeLogTableName(), "LIQUIBASE", "VARCHAR(255)", null, new ColumnConstraint[0]));
            }
            if (!hasOrderExecuted) {
                executor.comment("Adding missing databasechangelog.orderexecuted column");
                statementsToExecute.add(new AddColumnStatement(this.getLiquibaseCatalogName(), this.getLiquibaseSchemaName(), this.getDatabaseChangeLogTableName(), "ORDEREXECUTED", "INT", null, new ColumnConstraint[0]));
                statementsToExecute.add(new UpdateStatement(this.getLiquibaseCatalogName(), this.getLiquibaseSchemaName(), this.getDatabaseChangeLogTableName()).addNewColumnValue("ORDEREXECUTED", -1));
                statementsToExecute.add(new SetNullableStatement(this.getLiquibaseCatalogName(), this.getLiquibaseSchemaName(), this.getDatabaseChangeLogTableName(), "ORDEREXECUTED", "INT", false));
            }
            if (checksumNotRightSize) {
                executor.comment("Modifying size of databasechangelog.md5sum column");
                statementsToExecute.add(new ModifyDataTypeStatement(this.getLiquibaseCatalogName(), this.getLiquibaseSchemaName(), this.getDatabaseChangeLogTableName(), "MD5SUM", "VARCHAR(35)"));
            }
            if (liquibaseColumnNotRightSize) {
                executor.comment("Modifying size of databasechangelog.liquibase column");
                statementsToExecute.add(new ModifyDataTypeStatement(this.getLiquibaseCatalogName(), this.getLiquibaseSchemaName(), this.getDatabaseChangeLogTableName(), "LIQUIBASE", "VARCHAR(20)"));
            }
            if (!hasExecTypeColumn) {
                executor.comment("Adding missing databasechangelog.exectype column");
                statementsToExecute.add(new AddColumnStatement(this.getLiquibaseCatalogName(), this.getLiquibaseSchemaName(), this.getDatabaseChangeLogTableName(), "EXECTYPE", "VARCHAR(10)", null, new ColumnConstraint[0]));
                statementsToExecute.add(new UpdateStatement(this.getLiquibaseCatalogName(), this.getLiquibaseSchemaName(), this.getDatabaseChangeLogTableName()).addNewColumnValue("EXECTYPE", "EXECUTED"));
                statementsToExecute.add(new SetNullableStatement(this.getLiquibaseCatalogName(), this.getLiquibaseSchemaName(), this.getDatabaseChangeLogTableName(), "EXECTYPE", "VARCHAR(10)", false));
            }
            if ((md5sumRS = ExecutorService.getInstance().getExecutor(this).queryForList(new SelectFromDatabaseChangeLogStatement(new SelectFromDatabaseChangeLogStatement.ByNotNullCheckSum(), "MD5SUM"))).size() > 0 && !(md5sum = md5sumRS.get(0).get("MD5SUM").toString()).startsWith(CheckSum.getCurrentVersion() + ":")) {
                executor.comment("DatabaseChangeLog checksums are an incompatible version.  Setting them to null so they will be updated on next database update");
                statementsToExecute.add(new RawSqlStatement("UPDATE " + this.escapeTableName(this.getLiquibaseCatalogName(), this.getLiquibaseSchemaName(), this.getDatabaseChangeLogTableName()) + " SET MD5SUM=null"));
            }
        } else if (!changeLogCreateAttempted) {
            executor.comment("Create Database Change Log Table");
            CreateDatabaseChangeLogTableStatement createTableStatement = new CreateDatabaseChangeLogTableStatement();
            if (!this.canCreateChangeLogTable()) {
                throw new DatabaseException("Cannot create " + this.escapeTableName(this.getLiquibaseCatalogName(), this.getLiquibaseSchemaName(), this.getDatabaseChangeLogTableName()) + " table for your database.\n\n" + "Please construct it manually using the following SQL as a base and re-run Liquibase:\n\n" + createTableStatement);
            }
            statementsToExecute.add(createTableStatement);
            LogFactory.getLogger().info("Creating database history table with name: " + this.escapeTableName(this.getLiquibaseCatalogName(), this.getLiquibaseSchemaName(), this.getDatabaseChangeLogTableName()));
        }
        for (SqlStatement sqlStatement : statementsToExecute) {
            executor.execute(sqlStatement);
            this.commit();
        }
        if (updateExistingNullChecksums) {
            for (RanChangeSet ranChangeSet : this.getRanChangeSetList()) {
                ChangeSet changeSet;
                if (ranChangeSet.getLastCheckSum() != null || (changeSet = databaseChangeLog.getChangeSet(ranChangeSet)) == null || !new ContextChangeSetFilter(contexts).accepts(changeSet) || !new DbmsChangeSetFilter(this).accepts(changeSet)) continue;
                LogFactory.getLogger().info("Updating null or out of date checksum on changeSet " + changeSet + " to correct value");
                executor.execute(new UpdateChangeSetChecksumStatement(changeSet));
            }
            this.commit();
            this.resetRanChangeSetList();
        }
    }

    @Override
    public String getViewDefinition(CatalogAndSchema schema, String viewName) throws DatabaseException {
        schema = this.correctSchema(schema);
        List<Map> retList = ExecutorService.getInstance().getExecutor(this).queryForList(new GetViewDefinitionStatement(schema.getCatalogName(), schema.getSchemaName(), viewName));
        StringBuilder sb = new StringBuilder();
        for (Map rowMap : retList) {
            String s = (String)rowMap.get("VIEWTEXT");
            sb.append(s);
        }
        return CREATE_VIEW_AS_PATTERN.matcher(sb.toString()).replaceFirst("");
    }

    @Override
    public String getAutoIncrementClause(BigInteger startWith, BigInteger incrementBy) {
        return "";
    }

    @Override
    public String getDateLiteral(String isoDate) {
        if (this.isTimeOnly(isoDate)) {
            return "INTERVAL (" + super.getDateLiteral(isoDate).replaceAll("'", "") + ") " + INTERVAL_FIELD_QUALIFIER;
        }
        if (this.isDateOnly(isoDate)) {
            return super.getDateLiteral(isoDate);
        }
        return "DATETIME (" + super.getDateLiteral(isoDate).replaceAll("'", "") + ") " + DATETIME_FIELD_QUALIFIER;
    }

    @Override
    public boolean supportsRestrictForeignKeys() {
        return false;
    }

    @Override
    public boolean supportsSchemas() {
        return false;
    }

    @Override
    public String escapeObjectName(String catalogName, String schemaName, String objectName, Class<? extends DatabaseObject> objectType) {
        String name = super.escapeObjectName(catalogName, schemaName, objectName, objectType);
        if (name == null) {
            return null;
        }
        if (name.matches(".*\\..*\\..*")) {
            name = name.replaceFirst("\\.", ":");
        }
        return name;
    }

    @Override
    public boolean supportsPrimaryKeyNames() {
        return false;
    }
}

