/*
 * Decompiled with CFR 0.152.
 */
package liquibase.changelog;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.changelog.RanChangeSet;
import liquibase.changelog.filter.ChangeSetFilter;
import liquibase.changelog.visitor.ChangeSetVisitor;
import liquibase.database.Database;
import liquibase.exception.LiquibaseException;
import liquibase.logging.LogFactory;
import liquibase.logging.Logger;

public class ChangeLogIterator {
    private DatabaseChangeLog databaseChangeLog;
    private List<ChangeSetFilter> changeSetFilters;

    public ChangeLogIterator(DatabaseChangeLog databaseChangeLog, ChangeSetFilter ... changeSetFilters) {
        this.databaseChangeLog = databaseChangeLog;
        this.changeSetFilters = Arrays.asList(changeSetFilters);
    }

    public ChangeLogIterator(List<RanChangeSet> changeSetList, DatabaseChangeLog changeLog, ChangeSetFilter ... changeSetFilters) {
        final ArrayList<ChangeSet> changeSets = new ArrayList<ChangeSet>();
        for (RanChangeSet ranChangeSet : changeSetList) {
            ChangeSet changeSet = changeLog.getChangeSet(ranChangeSet);
            if (changeSet == null) continue;
            changeSets.add(changeSet);
        }
        this.databaseChangeLog = new DatabaseChangeLog(){

            @Override
            public List<ChangeSet> getChangeSets() {
                return changeSets;
            }
        };
        this.changeSetFilters = Arrays.asList(changeSetFilters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(ChangeSetVisitor visitor, Database database) throws LiquibaseException {
        Logger log = LogFactory.getLogger();
        log.setChangeLog(this.databaseChangeLog);
        try {
            List<ChangeSet> changeSetList = this.databaseChangeLog.getChangeSets();
            if (visitor.getDirection().equals((Object)ChangeSetVisitor.Direction.REVERSE)) {
                Collections.reverse(changeSetList);
            }
            for (ChangeSet changeSet : changeSetList) {
                boolean shouldVisit = true;
                if (this.changeSetFilters != null) {
                    for (ChangeSetFilter filter : this.changeSetFilters) {
                        if (filter.accepts(changeSet)) continue;
                        shouldVisit = false;
                        break;
                    }
                }
                if (!shouldVisit) continue;
                log.setChangeSet(changeSet);
                visitor.visit(changeSet, this.databaseChangeLog, database);
                log.setChangeSet(null);
            }
        }
        finally {
            log.setChangeLog(null);
        }
    }
}

