/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.projectset.data;

import com.openexchange.projectset.data.Repository;
import com.openexchange.projectset.data.RepositoryType;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.tools.ant.BuildException;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\bR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0012"}, d2={"Lcom/openexchange/projectset/data/CVSRepository;", "Lcom/openexchange/projectset/data/Repository;", "cvsRoot", "", "repositoryLocation", "projectName", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "branch", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getBranch", "()Ljava/lang/String;", "getCvsRoot", "getRepositoryLocation", "repositoryType", "Lcom/openexchange/projectset/data/RepositoryType;", "getRepositoryType", "()Lcom/openexchange/projectset/data/RepositoryType;", "Companion", "projectset"})
public final class CVSRepository
extends Repository {
    @NotNull
    private final String cvsRoot;
    @NotNull
    private final String repositoryLocation;
    @NotNull
    private final String branch;
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public RepositoryType getRepositoryType() {
        return RepositoryType.CVS;
    }

    @NotNull
    public final String getCvsRoot() {
        return this.cvsRoot;
    }

    @NotNull
    public final String getRepositoryLocation() {
        return this.repositoryLocation;
    }

    @NotNull
    public final String getBranch() {
        return this.branch;
    }

    public CVSRepository(@NotNull String cvsRoot, @NotNull String repositoryLocation, @NotNull String projectName, @NotNull String branch) {
        Intrinsics.checkParameterIsNotNull((Object)cvsRoot, (String)"cvsRoot");
        Intrinsics.checkParameterIsNotNull((Object)repositoryLocation, (String)"repositoryLocation");
        Intrinsics.checkParameterIsNotNull((Object)projectName, (String)"projectName");
        Intrinsics.checkParameterIsNotNull((Object)branch, (String)"branch");
        super(projectName);
        this.cvsRoot = cvsRoot;
        this.repositoryLocation = repositoryLocation;
        this.branch = branch;
    }

    public CVSRepository(@NotNull String cvsRoot, @NotNull String repositoryLocation, @NotNull String projectName) {
        Intrinsics.checkParameterIsNotNull((Object)cvsRoot, (String)"cvsRoot");
        Intrinsics.checkParameterIsNotNull((Object)repositoryLocation, (String)"repositoryLocation");
        Intrinsics.checkParameterIsNotNull((Object)projectName, (String)"projectName");
        this(cvsRoot, repositoryLocation, projectName, "HEAD");
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/openexchange/projectset/data/CVSRepository$Companion;", "", "()V", "parseCVSReference", "Lcom/openexchange/projectset/data/CVSRepository;", "reference", "", "projectset"})
    public static final class Companion {
        @NotNull
        public final CVSRepository parseCVSReference(@NotNull String reference) {
            CVSRepository cVSRepository;
            Intrinsics.checkParameterIsNotNull((Object)reference, (String)"reference");
            List parts = StringsKt.split$default((CharSequence)reference, (String[])new String[]{","}, (boolean)false, (int)0, (int)6, null);
            if (Intrinsics.areEqual((Object)((String)parts.get(0)), (Object)"1.0") ^ true) {
                throw (Throwable)new BuildException("Unknown CVS reference version " + (String)parts.get(0));
            }
            switch (parts.size()) {
                case 4: {
                    cVSRepository = new CVSRepository((String)parts.get(1), (String)parts.get(2), (String)parts.get(3));
                    break;
                }
                case 5: {
                    cVSRepository = new CVSRepository((String)parts.get(1), (String)parts.get(2), (String)parts.get(3), (String)parts.get(4));
                    break;
                }
                default: {
                    throw (Throwable)new BuildException("Unknown number of CVS reference definition parts.");
                }
            }
            return cVSRepository;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

