/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.ConvictionPolicy;
import com.datastax.driver.core.ExecutionInfo;
import com.datastax.driver.core.Token;
import com.datastax.driver.core.VersionNumber;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Host {
    private static final Logger logger = LoggerFactory.getLogger(Host.class);
    static final Logger statesLogger = LoggerFactory.getLogger((String)(Host.class.getName() + ".STATES"));
    private final InetSocketAddress address;
    private volatile InetAddress broadcastAddress;
    private volatile InetAddress listenAddress;
    volatile State state;
    final ReentrantLock notificationsLock = new ReentrantLock(true);
    final ConvictionPolicy convictionPolicy;
    private final Cluster.Manager manager;
    final AtomicReference<ListenableFuture<?>> reconnectionAttempt = new AtomicReference();
    final ExecutionInfo defaultExecutionInfo;
    private volatile String datacenter;
    private volatile String rack;
    private volatile VersionNumber cassandraVersion;
    private volatile Set<Token> tokens;
    private volatile String dseWorkload;
    private volatile boolean dseGraphEnabled;
    private volatile VersionNumber dseVersion;

    Host(InetSocketAddress address, ConvictionPolicy.Factory convictionPolicyFactory, Cluster.Manager manager) {
        if (address == null || convictionPolicyFactory == null) {
            throw new NullPointerException();
        }
        this.address = address;
        this.convictionPolicy = convictionPolicyFactory.create(this, manager.reconnectionPolicy());
        this.manager = manager;
        this.defaultExecutionInfo = new ExecutionInfo((List<Host>)ImmutableList.of((Object)this));
        this.state = State.ADDED;
    }

    void setLocationInfo(String datacenter, String rack) {
        this.datacenter = datacenter;
        this.rack = rack;
    }

    void setVersion(String cassandraVersion) {
        VersionNumber versionNumber = null;
        try {
            if (cassandraVersion != null) {
                versionNumber = VersionNumber.parse(cassandraVersion);
            }
        }
        catch (IllegalArgumentException e) {
            logger.warn("Error parsing Cassandra version {}. This shouldn't have happened", (Object)cassandraVersion);
        }
        this.cassandraVersion = versionNumber;
    }

    void setBroadcastAddress(InetAddress broadcastAddress) {
        this.broadcastAddress = broadcastAddress;
    }

    void setListenAddress(InetAddress listenAddress) {
        this.listenAddress = listenAddress;
    }

    void setDseVersion(String dseVersion) {
        VersionNumber versionNumber = null;
        try {
            if (dseVersion != null) {
                versionNumber = VersionNumber.parse(dseVersion);
            }
        }
        catch (IllegalArgumentException e) {
            logger.warn("Error parsing DSE version {}. This shouldn't have happened", (Object)dseVersion);
        }
        this.dseVersion = versionNumber;
    }

    void setDseWorkload(String dseWorkload) {
        this.dseWorkload = dseWorkload;
    }

    void setDseGraphEnabled(boolean dseGraphEnabled) {
        this.dseGraphEnabled = dseGraphEnabled;
    }

    public InetAddress getAddress() {
        return this.address.getAddress();
    }

    public InetSocketAddress getSocketAddress() {
        return this.address;
    }

    public InetAddress getBroadcastAddress() {
        return this.broadcastAddress;
    }

    public InetAddress getListenAddress() {
        return this.listenAddress;
    }

    public String getDatacenter() {
        return this.datacenter;
    }

    public String getRack() {
        return this.rack;
    }

    public VersionNumber getCassandraVersion() {
        return this.cassandraVersion;
    }

    public VersionNumber getDseVersion() {
        return this.dseVersion;
    }

    public String getDseWorkload() {
        return this.dseWorkload;
    }

    public boolean isDseGraphEnabled() {
        return this.dseGraphEnabled;
    }

    public Set<Token> getTokens() {
        return this.tokens;
    }

    void setTokens(Set<Token> tokens) {
        this.tokens = tokens;
    }

    public boolean isUp() {
        return this.state == State.UP;
    }

    public String getState() {
        return this.state.name();
    }

    public ListenableFuture<?> getReconnectionAttemptFuture() {
        return this.reconnectionAttempt.get();
    }

    public void tryReconnectOnce() {
        this.manager.startSingleReconnectionAttempt(this);
    }

    public boolean equals(Object other) {
        if (other instanceof Host) {
            Host that = (Host)other;
            return this.address.equals(that.address);
        }
        return false;
    }

    public int hashCode() {
        return this.address.hashCode();
    }

    boolean wasJustAdded() {
        return this.state == State.ADDED;
    }

    public String toString() {
        return this.address.toString();
    }

    void setDown() {
        this.state = State.DOWN;
    }

    void setUp() {
        this.state = State.UP;
    }

    public static interface LifecycleAwareStateListener
    extends StateListener {
        @Override
        public void onRegister(Cluster var1);

        @Override
        public void onUnregister(Cluster var1);
    }

    public static interface StateListener {
        public void onAdd(Host var1);

        public void onUp(Host var1);

        public void onDown(Host var1);

        public void onRemove(Host var1);

        public void onRegister(Cluster var1);

        public void onUnregister(Cluster var1);
    }

    static enum State {
        ADDED,
        DOWN,
        UP;

    }
}

