package com.openexchange.usm.clt;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import javax.management.remote.JMXConnectorServer;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.ParseException;


public class CLToolsUtility {
    
    
    public static String getOptionStringValue(CommandLine cmd, char opt) throws ParseException {
        String val = cmd.getOptionValue(opt);
        if (!provided(val))
            throw new ParseException("Option \"" + opt + "\" requires a non-empty string value");
        return val;
    }

    public static int getOptionIntValue(CommandLine cmd, char opt, int minValue, int maxValue) throws ParseException {
        String val = cmd.getOptionValue(opt);
        if (val != null) {
            try {
                int intVal = Integer.parseInt(val);
                if (intVal >= minValue && intVal <= maxValue)
                    return intVal;
            } catch (NumberFormatException ignored) {
                // fall through
            }
        }
        throw new ParseException("Option \"" + opt + "\" requires an integer value between " + minValue + " and " + maxValue);
    }

    public static int parseIntegerValue(String part) {
        return provided(part) ? Integer.parseInt(part) : 0;
    }

    public static boolean provided(String s) {
        return s != null && s.length() > 0;
    }
    
    
    public static Map<String, String> extractURLParameters(String data) {
        Map<String, String> result = new HashMap<String, String>();
        String params = cropToParameters(data);
        for (String entry : params.split("&")) {
            String[] parts = entry.split("=", 2);
            if (parts.length >= 2) {
                try {
                    result.put(parts[0], URLDecoder.decode(parts[1], "UTF-8"));
                } catch (UnsupportedEncodingException e) {
                    throw new IllegalStateException("Required encoding UTF-8 is not supported", e);
                }
            } else if (parts.length >= 1) {
                result.put(parts[0], "");
            }
        }
        return result;
    }

    public static String cropToParameters(String data) {
        int paramStart = data.indexOf('?');
        if (paramStart >= 0)
            data = data.substring(paramStart + 1);
        int paramEnd1 = data.indexOf('#');
        int paramEnd2 = data.indexOf(' ');
        if (paramEnd1 >= 0 && paramEnd2 >= paramEnd1)
            return data.substring(0, paramEnd1);
        if (paramEnd2 < 0)
            return data;
        return data.substring(0, paramEnd2);
    }

    public static Map<String, Object> createJMXEnvironment(String jmxLogin, String jmxPassword) {
        Map<String, Object> environment = new HashMap<String, Object>();
        if (jmxLogin != null && jmxPassword != null)
            environment.put(JMXConnectorServer.AUTHENTICATOR, new JMXAuthenticatorImpl(jmxLogin, jmxPassword));
        return environment;
    }

}
