/**
 * 
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 * 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 * 
 * Copyright (C) Open-Xchange Inc., 2006-2012
 * Mail: info@open-xchange.com 
 * 
 * @author Matthias Biggeleben <matthias.biggeleben@open-xchange.com>
 * 
 */

/*jslint bitwise: false, nomen: false, onevar: false, plusplus: false, regexp: false, white: true, browser: true, devel: true, evil: true, forin: true, undef: true, eqeqeq: true, immed: true */

/*global ox, jQuery, window, console */

ox.mail = {};

/**
 * Draw contact image based on email address
 */
ox.mail.drawContactImage = (function ($) {
    
    var current = "";
    
    return function (from) {
        // lower case!
        from = current = (from || "").toLowerCase();
        // getting currentpath
        var path = currentpath[1];
        // have to do some ugly mappings for the popup window
        if (path === "detail") {
            path = "detail\\.pop";
        }
        
        // get div and hide it
        var div = $("#mail-" + path + "-image").hide();
        if (div.length) {
            // searching on OXCache is too buggy, so...
            ox.api.contact.searchByMail({
                data: [from],
                success: function (data) {
                    var map, url = null, i, key, contact;
                    // still of interest?
                    if (from === current) {
                        // iterating through response and check for image
                        map = data.map[from] || [];
                        for (i in map) {
                            key = map[i];
                            contact = data.contacts[key];
                            if (contact && contact.image1_url) {
                                url = contact.image1_url + "&width=90&height=90&scaleType=contain";
                                if (url && contact.folder_id === 6) {
                                    // global address-book always first
                                    break;
                                }
                            }
                        }
                        // found an url?
                        if (url) {
                            url += "&width=90&height=90&scaleType=contain";
                            // same url, no redraw required
                            if ($("img", div).attr("src") != url) {
                                // get proper protocol/hostname
                                url = url.replace(/https?:\/\/[^\/]+\//, location.protocol + "//" + location.host + "/");
                                // update
                                div.css({
                                    width: "100px",
                                    height: "80px",
                                    overflow: "hidden",
                                    margin: "0px 5px 0px 10px"
                                });
                                div.empty();
                                div.append(
                                    $("<img/>", {
                                        src: url,
                                        alt: ""
                                    }).css({
                                        width: "auto",
                                        height: "auto",
                                        "float": "right"
                                    })
                                );
                            }
                            div.show();
                            // adjust height
                            var height = $("#mail\\." + path + "\\.detail\\.attachments").height();
                            resizeSplit("mail." + path.replace("\\", "") + ".detail.attachments", height + "px");
                        }
                    }
                }
            });
        }
    };
    
}(jQuery));

defineDeferredFunction(ox.mail, "addAccount", "com.openexchange.mail.accounts");
