/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.Optimizer;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.StackFrame;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.instruct.InstructionDetails;
import net.sf.saxon.instruct.ParameterSet;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.instruct.Template;
import net.sf.saxon.instruct.WithParam;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.trace.InstructionInfo;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;

public class CallTemplate
extends Instruction {
    private Template template = null;
    private WithParam[] actualParams = null;
    private WithParam[] tunnelParams = null;
    private boolean useTailRecursion = false;
    private Expression calledTemplateExpression;
    private NamespaceResolver nsContext;

    public CallTemplate(Template template, boolean bl, Expression expression, NamespaceResolver namespaceResolver) {
        this.template = template;
        this.useTailRecursion = bl;
        this.calledTemplateExpression = expression;
        this.nsContext = namespaceResolver;
        this.adoptChildExpression(expression);
    }

    public void setActualParameters(WithParam[] withParamArray, WithParam[] withParamArray2) {
        int n;
        this.actualParams = withParamArray;
        this.tunnelParams = withParamArray2;
        for (n = 0; n < withParamArray.length; ++n) {
            this.adoptChildExpression(withParamArray[n]);
        }
        for (n = 0; n < withParamArray2.length; ++n) {
            this.adoptChildExpression(withParamArray2[n]);
        }
    }

    public int getInstructionNameCode() {
        return 133;
    }

    public InstructionInfo getInstructionInfo() {
        InstructionDetails instructionDetails = (InstructionDetails)super.getInstructionInfo();
        if (this.template != null) {
            instructionDetails.setProperty("template", this.template);
        }
        return instructionDetails;
    }

    public Expression simplify(StaticContext staticContext) throws XPathException {
        WithParam.simplify(this.actualParams, staticContext);
        WithParam.simplify(this.tunnelParams, staticContext);
        if (this.calledTemplateExpression != null) {
            this.calledTemplateExpression = this.calledTemplateExpression.simplify(staticContext);
        }
        return this;
    }

    public Expression typeCheck(StaticContext staticContext, ItemType itemType) throws XPathException {
        WithParam.typeCheck(this.actualParams, staticContext, itemType);
        WithParam.typeCheck(this.tunnelParams, staticContext, itemType);
        if (this.calledTemplateExpression != null) {
            this.calledTemplateExpression = this.calledTemplateExpression.typeCheck(staticContext, itemType);
            this.adoptChildExpression(this.calledTemplateExpression);
        }
        return this;
    }

    public Expression optimize(Optimizer optimizer, StaticContext staticContext, ItemType itemType) throws XPathException {
        WithParam.optimize(optimizer, this.actualParams, staticContext, itemType);
        WithParam.optimize(optimizer, this.tunnelParams, staticContext, itemType);
        if (this.calledTemplateExpression != null) {
            this.calledTemplateExpression = this.calledTemplateExpression.optimize(optimizer, staticContext, itemType);
            this.adoptChildExpression(this.calledTemplateExpression);
        }
        return this;
    }

    public int getIntrinsicDependencies() {
        return 127;
    }

    public final boolean createsNewNodes() {
        return true;
    }

    public Iterator iterateSubExpressions() {
        ArrayList<Expression> arrayList = new ArrayList<Expression>(10);
        if (this.calledTemplateExpression != null) {
            arrayList.add(this.calledTemplateExpression);
        }
        WithParam.getXPathExpressions(this.actualParams, arrayList);
        WithParam.getXPathExpressions(this.tunnelParams, arrayList);
        return arrayList.iterator();
    }

    protected void promoteInst(PromotionOffer promotionOffer) throws XPathException {
        if (this.calledTemplateExpression != null) {
            this.calledTemplateExpression = this.doPromotion(this.calledTemplateExpression, promotionOffer);
        }
        WithParam.promoteParams(this.actualParams, promotionOffer);
        WithParam.promoteParams(this.tunnelParams, promotionOffer);
    }

    public void process(XPathContext xPathContext) throws XPathException {
        Template template = this.getTargetTemplate(xPathContext);
        XPathContextMajor xPathContextMajor = xPathContext.newContext();
        xPathContextMajor.setOrigin(this);
        xPathContextMajor.openStackFrame(template.getStackFrameMap());
        xPathContextMajor.setLocalParameters(CallTemplate.assembleParams(xPathContext, this.actualParams));
        xPathContextMajor.setTunnelParameters(CallTemplate.assembleTunnelParams(xPathContext, this.tunnelParams));
        try {
            for (TailCall tailCall = template.expand(xPathContextMajor); tailCall != null; tailCall = tailCall.processLeavingTail()) {
            }
        }
        catch (StackOverflowError stackOverflowError) {
            DynamicError dynamicError = new DynamicError("Too many nested template or function calls. The stylesheet may be looping.");
            dynamicError.setLocator(this);
            dynamicError.setXPathContext(xPathContext);
            throw dynamicError;
        }
    }

    public TailCall processLeavingTail(XPathContext xPathContext) throws XPathException {
        if (!this.useTailRecursion) {
            this.process(xPathContext);
            return null;
        }
        Template template = this.getTargetTemplate(xPathContext);
        ParameterSet parameterSet = CallTemplate.assembleParams(xPathContext, this.actualParams);
        ParameterSet parameterSet2 = CallTemplate.assembleTunnelParams(xPathContext, this.tunnelParams);
        if (parameterSet == null) {
            parameterSet = ParameterSet.EMPTY_PARAMETER_SET;
        }
        StackFrame stackFrame = xPathContext.getStackFrame();
        ValueRepresentation[] valueRepresentationArray = stackFrame.getStackFrameValues();
        for (int i = 0; i < valueRepresentationArray.length; ++i) {
            valueRepresentationArray[i] = null;
        }
        return new CallTemplatePackage(template, parameterSet, parameterSet2, xPathContext);
    }

    public Template getTargetTemplate(XPathContext xPathContext) throws XPathException {
        if (this.calledTemplateExpression != null) {
            String string;
            String string2;
            Object object;
            Controller controller = xPathContext.getController();
            String string3 = this.calledTemplateExpression.evaluateAsString(xPathContext);
            try {
                object = controller.getConfiguration().getNameChecker().getQNameParts(string3);
                string2 = object[0];
                string = object[1];
            }
            catch (QNameException qNameException) {
                this.dynamicError("Invalid template name. " + qNameException.getMessage(), "XTSE0650", xPathContext);
                return null;
            }
            object = this.nsContext.getURIForPrefix(string2, false);
            if (object == null) {
                this.dynamicError("Namespace prefix " + string2 + " has not been declared", "XTSE0650", xPathContext);
            }
            int n = controller.getNamePool().getFingerprint((String)object, string);
            Template template = controller.getExecutable().getNamedTemplate(n);
            if (template == null) {
                this.dynamicError("Template " + string3 + " has not been defined", "XTSE0650", xPathContext);
            }
            return template;
        }
        return this.template;
    }

    public void display(int n, PrintStream printStream, Configuration configuration) {
        printStream.println(ExpressionTool.indent(n) + "call-template");
    }

    private class CallTemplatePackage
    implements TailCall {
        private Template target;
        private ParameterSet params;
        private ParameterSet tunnelParams;
        private XPathContext evaluationContext;

        public CallTemplatePackage(Template template, ParameterSet parameterSet, ParameterSet parameterSet2, XPathContext xPathContext) {
            this.target = template;
            this.params = parameterSet;
            this.tunnelParams = parameterSet2;
            this.evaluationContext = xPathContext;
        }

        public TailCall processLeavingTail() throws XPathException {
            XPathContextMajor xPathContextMajor = this.evaluationContext.newContext();
            xPathContextMajor.setOrigin(CallTemplate.this);
            xPathContextMajor.setLocalParameters(this.params);
            xPathContextMajor.setTunnelParameters(this.tunnelParams);
            xPathContextMajor.openStackFrame(this.target.getStackFrameMap());
            TailCall tailCall = this.target.expand(xPathContextMajor);
            return tailCall;
        }
    }
}

