/**
 * 
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 * 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 * 
 * Copyright (C) Open-Xchange Inc., 2006-2012
 * Mail: info@open-xchange.com 
 * 
 * @author Andreas Mayer <andreas.mayer@open-xchange.com>
 * 
 */

var oMiniCalendar;
var b3xViewLoaded;
var calendarMiniJson = new JSONX();

function cAnimMiniCalendar(actionFunction, oDOMHeader, nodes) {
		this.initDate = new Date(now());
		this.actionFunction = actionFunction;
		this.MiniRefer = null;
		this.selectedDate = this.initDate.getUTCDate();
		this.selectedMonth = this.initDate.getUTCMonth();
		this.selectedYear = this.initDate.getUTCFullYear();
		this.animationInProgress = false;
		this.todayYear = this.selectedYear;
		this.selectedTime = this.initDate.getTime();
		this.selectedId;
		this.header = oDOMHeader;
		this.header0;
		this.nodes = nodes;
		this.enable_action = configGetKey("modules.calendar.module");
		var bDisplayApps = configGetKey("modules.calendar.module");		
		if (!this.enable_action) {
			actionFunction = function () { 
				triggerEvent("Feature_Not_Available", "modules/calendar/mini_calender", window); 
			};
		}
		
		if (this.nodes == undefined) {
			this.nodes = [ $("container_mini"), $("header_mini_month"), $("header_mini_year") ];
		}
		
		this.MiniRefer = new cMiniCalendar(oDOMHeader,
				nodes[0], actionFunction,bDisplayApps,
				'mini_subcontainer_0', nodes[1], nodes[2], this.initDate);
		this.MiniRefer.dnd_enabled = true;
		this.MiniRefer.enable_action = this.enable_action;
		var Self = this;
		
		function fn_KWAction(arg) {
			var DOMTarget = (arg.target) ? arg.target : arg.srcElement;
			var sId = DOMTarget.id, aInf;
			for (var indx in Self.MiniRefer.miniCalendarAssoc) {
				aInf = Self.MiniRefer.miniCalendarAssoc[indx];
				if (aInf[3] == sId.split('_')[1]) {
					break;
				}
			}	
			var nDate = aInf[0];
            var oDate = new Date(Date.UTC(Self.MiniRefer.currentYear,
                                          Self.MiniRefer.currentMonth));
			if (aInf[1] == 0) {
				oDate.setUTCMonth(oDate.getUTCMonth() - 1);
			} else if (aInf[1] == 2) {
				oDate.setUTCMonth(oDate.getUTCMonth() + 1);
			}			
			oDate.setUTCDate(nDate);
				    
		    if (currentpath2[1] !== "team") {
		        activeDay = oDate.getUTCDate();
		        activeMonth = oDate.getUTCMonth();
		        activeYear = oDate.getUTCFullYear();
		        Self.MiniRefer.setSelectedByDate(activeYear, activeMonth, activeDay);
                ox.UIController.setModule({
                    module: "calendar", 
                    folder: "auto", 
                    view: "calendar/calendar/week",
                    force: "module",
                    succes: function() {
                      // notify via event
                      triggerEvent("OX_Mini_Calendar_Date_Picked", oDate.getUTCFullYear(),
                              oDate.getUTCMonth(), oDate.getUTCDate());
                    }
                });
                oDate = nDate = DOMTarget = sId = null;
		    }
		}
		function fn_DBLAction(arg) {
		    Self.MiniRefer.setSelectedByDate(Self.selectedYear, Self.selectedMonth, Self.selectedDate);
			triggerEvent("OX_Before_Create_Calendar");
		}
		// don't implement functions for CW clicks and double clicks; simple clicks are disabled in the constructor
		if (this.enable_action) {
			this.MiniRefer.setfnKWAction(fn_KWAction);
			this.MiniRefer.setfnDBLAction(fn_DBLAction);
		} else {
			this.MiniRefer.setfnKWAction(function() {
			    triggerEvent("Feature_Not_Available", "modules/calendar/mini_calender", window);
			});
		}
}
cAnimMiniCalendar.prototype = {
	destroy: function() {
		this.MiniRefer.destroy();
	},
	
	load: function() {
		this.MiniRefer.load(this.MiniRefer);		
	},
	
	setSelectedByDate: function (year, month, day) {
		this.MiniRefer.setSelectedByDate(year, month, day);
	},
	
	update: function () {
		this.MiniRefer.update();
		this.MiniRefer.setToday();
	},	
	
	setSelected: function(sId) {
		this.MiniRefer.setUnselected();	
		//find calendar where id is defined
		if (this.MiniRefer.miniCalendarAssoc[sId]) {
			this.MiniRefer.setSelected(sId);
			this.selectedDate = this.MiniRefer.selectedDate;
			this.selectedMonth = this.MiniRefer.selectedMonth;
			this.selectedYear  = this.MiniRefer.selectedYear;
			this.selectedTime = Date.UTC(this.MiniRefer.selectedYear,
												this.MiniRefer.selectedMonth,
														this.MiniRefer.selectedDate);		
		}
	},	
	
	checkloaded: function() {		
		return this.MiniRefer.loaded;		
	},
	
	scroll: function(nDirection,cb_fn) {		
		var Self = this;
		var nStart = jQuery(Self.nodes[0]).parent()[0].scrollLeft;
		function do_scroll(nStep) {
			if (nDirection > 0)
				jQuery(Self.nodes[0]).parent()[0].scrollLeft = Math.log(Math.pow(nStep,0.66))*66;
			else
				jQuery(Self.nodes[0]).parent()[0].scrollLeft = nStart - Math.log(Math.pow(nStep,0.66))*66;
		}
		animate(0, 245, do_scroll,cb_fn);
	},
	
	next: function (num) {
		var Self = this;
		if (!this.checkloaded() || this.animationInProgress) return;
        var NextDate = new Date(Date.UTC(this.MiniRefer.currentYear,
                                         this.MiniRefer.currentMonth + num));
		Self.MiniRefer.set_header(NextDate);
		this.MiniRefer.appointmentList = new Array();
		Self.MiniRefer.currentMonth = NextDate.getUTCMonth();
		Self.MiniRefer.currentYear = NextDate.getUTCFullYear();
		Self.MiniRefer.oCalendar = new cCalendar(NextDate.getUTCMonth(),NextDate.getUTCFullYear());
		var oNextTable = this.MiniRefer.getTable(Self.MiniRefer.oCalendar);
		var switchsubContainer = newnode('div',{ left:"239px", position:"absolute" });
		switchsubContainer.appendChild(oNextTable);
		this.nodes[0].appendChild(switchsubContainer);
		this.animationInProgress = true;
		jQuery(this.nodes[0]).parent()[0].scrollLeft = 0;
		this.MiniRefer.subcontainer.style.left = "0px";	
		this.scroll(1, function() {
		    jQuery(Self.MiniRefer.subcontainer).remove();
			Self.MiniRefer.subcontainer = switchsubContainer;
			jQuery(Self.MiniRefer.subcontainer).css({ left: 0 });
			jQuery(Self.nodes[0]).parent().css({ width: "" }).first().css({ left: 0 });
			Self.animationInProgress = false;
			if (Self.MiniRefer.displayAppointments) {
				Self.MiniRefer.update();
			}
		});
	},
	
	back: function(num) {
		var Self = this;
		if (!this.checkloaded() || this.animationInProgress) return;
        var NextDate = new Date(Date.UTC(this.MiniRefer.currentYear,
                                         this.MiniRefer.currentMonth - num));
		Self.MiniRefer.set_header(NextDate);	
		this.MiniRefer.appointmentList = new Array();
		Self.MiniRefer.currentMonth = NextDate.getUTCMonth();
		Self.MiniRefer.currentYear = NextDate.getUTCFullYear();
		Self.MiniRefer.oCalendar = new cCalendar(NextDate.getUTCMonth(),NextDate.getUTCFullYear());
		var oNextTable = this.MiniRefer.getTable(Self.MiniRefer.oCalendar);
		var switchsubContainer = newnode('div',{ left:"0px", position:"absolute" });
		switchsubContainer.appendChild(oNextTable);
		this.nodes[0].insertBefore(switchsubContainer, this.MiniRefer.subcontainer);
		this.animationInProgress = true;
		jQuery(this.nodes[0]).parent()[0].scrollLeft = "245px";
		this.MiniRefer.subcontainer.style.left = "239px";
		this.scroll(-1, function() {
            jQuery(Self.MiniRefer.subcontainer).remove();
            Self.MiniRefer.subcontainer = switchsubContainer;
            jQuery(Self.MiniRefer.subcontainer).css({ left: 0 });
            jQuery(Self.nodes[0]).parent().css({ width: "" }).first().css({ left: 0 });
            Self.animationInProgress = false;
            if (Self.MiniRefer.displayAppointments) {
                Self.MiniRefer.update();
            }
        });
	},
	
	go_to: function (oDate){
		this.MiniRefer.go_to(oDate);
	},
	
	today: function() {
	    
	    if (!this.checkloaded() || this.animationInProgress) return;
        
		// get current date
	    var today = new Date(now());
	    // see Bug 17397 - [L3] 'Today' button in calendar only works for GMT
	    activeDay = today.getUTCDate();
        activeMonth = today.getUTCMonth();
        activeYear = today.getUTCFullYear();
        
        // notify via event
        triggerEvent("OX_Mini_Calendar_Date_Picked", activeYear, activeMonth, activeDay);
        
        if (currentpath2[0] == "calendar") {
        	switch(currentpath2[2]) {
        		case "week":
        		    objWeekCalendarTool.init(activeYear,activeMonth,activeDay);
	                objWeekCalendarTool.setKW();
	                break;
                case "month":
                    loadMonthView();
                    break;
        	}
            triggerEvent("OX_Switch_View", currentpath.join("/"));
            
        } else if (configContainsKey("folder.calendar")) {
	        ox.api.ui.setFolder(configGetKey("folder.calendar"), function () {
	            triggerEvent("OX_Switch_View","calendar/calendar/day"); 
	        });
        }
        this.setSelectedByDate(activeYear, activeMonth, activeDay);
		this.MiniRefer.go_to(today);		
	},
	
	addView: function() {
		this.initDate.setUTCMonth(this.initDate.getUTCMonth() + 1);		
		if(!this.header0)	
		{
			var oHeader0 = newnode('div',0,{id:'DOMHeaderMini0'});	
			this.header0  = oHeader0;
			this.MiniCalWidgets[0].header = oHeader0;			
			this.MiniCalWidgets[0].subcontainer.insertBefore(oHeader0,this.MiniCalWidgets[0].table);
			this.MiniCalWidgets[0].updateHeaderMini();	
			//this.header.innerHTML = this.MiniCalWidgets[0].currentYear;
		}
		var oHeader = newnode('div',0,{id:'DOMHeaderMini' + this.MiniCalWidgets.length});			
		var oMiniCalendarNext = new cMiniCalendar(oHeader,
	 			this.nodes[0], this.actionFunction,true,'mini_subcontainer_'+this.MiniCalWidgets.length,
	 			this.nodes[1],this.nodes[2],this.initDate);
		if (oMiniCalendarNext.table)	 
			oMiniCalendarNext.subcontainer.insertBefore(oHeader
															,oMiniCalendarNext.table);
		else
			oMiniCalendarNext.subcontainer.appendChild(oHeader);
		this.MiniCalWidgets.push(oMiniCalendarNext);
	},
	
	removeView: function() {
		if(this.header0) {
			this.MiniCalWidgets[0].subcontainer.removeChild(this.header0);			
			this.MiniCalWidgets[0].header = this.header;
			this.header0 = null;
			this.MiniCalWidgets[0].updateHeaderMini();				
		}
		this.initDate.setUTCMonth(this.initDate.getUTCMonth() - 1);
		var oMonthView = this.MiniCalWidgets.pop();
		if (oMonthView) {
			oMonthView.subcontainer.removeChild(oMonthView.header);
			oMonthView.destroy();
		}
	}	
}


function comboMonthChanged(param,minical)
{
    minical.go_to(new Date(Date.UTC(minical.currentYear, param)));
}
function comboYearChanged(param,minical)
{
    minical.go_to(new Date(Date.UTC(param, minical.currentMonth)));
}

/**
 * Our current mini-calendar
 * @param {DOMNode} displayPanelContainer Used by cAnimMiniCalendar.removeView,
 * which in turn is not used (anymore). 
 * @param {DOMNode} container The container for the calendar contents.
 * @param {Function} actionFunction A callback function which is called when
 * the user clicks on a day. It should call setSelected(this.id) to process
 * the selection.
 * @param {Boolean} bDisplayAppointments Specifies whether days with
 * appointments should be marked.
 * @param {String} subcontainerid Not used.
 * @param {DOMNode} displayPanelContainerM container of the month selection
 * ComboBox.
 * @param {DOMNode} displayPanelContainerY container of the year selection
 * ComboBox.
 * @param {Date} initDate Specifies a date to display initially.
 * Defaults to the current month.
 * @param {Date} selectedDate The selected date. Defaults to today.
 */
function cMiniCalendar(displayPanelContainer, container, actionFunction,
			bDisplayAppointments, subcontainerid, displayPanelContainerM,
				displayPanelContainerY, initDate, selectedDate) {
	this.enable_action = true;
	this.aMonthNames = [_("January"), _("February"), _("March"), _("April"),
        _("May"), _("June"), _("July"), _("August"), _("September"),
        _("October"), _("November"), _("December")];
	this.container = container;
	this.table;
	this.loaded = false;
	this.dnd_enabled = false;
	this.subcontainerid = subcontainerid || "min_subcontainer_default";
	this.subcontainer = newnode('div', { left:"0px", right:"0px",position:"absolute" });
	jQuery(this.container).parent()[0].scrollLeft = 0;
	this.container.appendChild(this.subcontainer);
	addTMPId(this.subcontainer);
	this.header = displayPanelContainer;
	this.header_month = displayPanelContainerM;
	this.header_year = displayPanelContainerY;	
	this.actionFN = actionFunction;
	this.displayAppointments = bDisplayAppointments;
	// get today (see bug #17397)
	var odat = new Date(now());
	this.todayYear = odat.getUTCFullYear();
	this.todayMonth = odat.getUTCMonth();
	this.todayDate = odat.getUTCDate();
	if (initDate) {
		this.currentMonth = initDate.getUTCMonth();
		this.currentYear = initDate.getUTCFullYear();
	} else {
		this.currentMonth = this.todayMonth;
		this.currentYear = this.todayYear;
	}
	this.selectedDate = (selectedDate)?selectedDate.getUTCDate():this.todayDate;
	this.selectedMonth = (selectedDate)?selectedDate.getUTCMonth():this.todayMonth;
	this.selectedYear = (selectedDate)?selectedDate.getUTCFullYear():this.todayYear;
	this.selectedTime = Date.UTC(this.todayYear,this.todayMonth,this.todayDate);
	this.appointmentList = new Array();	
	this.selectedID;
	this.miniCalendarAssoc = new Object();
	this.load(this);
	this.oCalendar;
	this.oComboMonth;
	this.oComboYear;	
	this.fnKWAction = null;
	this.actionDBLFN = null;
	
	this.open_in_calendar = newnode("img", { verticalAlign:"middle" }, 
			{ src:getFullImgSrc("img/toolbar/calnder.png"), 
			  alt: _("Show in Calendar"), title: _("Show in Calendar")});
	register("LanguageChanged",(function(Self) {
		return function() {
			Self.open_in_calendar.title = _("Show in Calendar");
			Self.open_in_calendar.alt = _("Show in Calendar");
		}
	})(this));
}	

cMiniCalendar.prototype = {
	/**
	 * Specifies a callback for the double-click on a day.
	 */
    setfnDBLAction: function (fn) {
		this.actionDBLFN = fn;
	},
	
	/**
	 * Specifies a callback for the click on a week number.
	 */
	setfnKWAction: function(fn) {
		this.fnKWAction = fn;
	},
	
	setDate: function (year, month, date) { },
	
	destroy: function() {	
		this.selectedID = undefined;	
		this.subcontainer.removeChild(this.table);
		removeTMPId(this.subcontainer.id+"_table");
		for (var i=0; $2(this.subcontainer.id+"mc_"+i+"_0"); i++) {
			for (var i2=0; $2(this.subcontainer.id+"mc_"+i+"_"+i2); i2++) {
				removeTMPId(this.subcontainer.id+"mc_"+i+"_"+i2);
			}
		}	
		for (var i=0; i<54; i++) {
			if ($2("kw_month_"+i)) {
				removeTMPId("kw_month_"+i);
			}
		}
		//TODO REMOVE FROM TMPIDS
		this.loaded = false;
	},
	
	/**
	 * Jumps to the next month.
     * Does not change the selection.
	 */
	next: function(num) {
		if(num == undefined) num = 1;
		if(!this.loaded) return;
		this.destroy();
		var oDateLoc = new Date(Date.UTC(this.currentYear,
		                                 this.currentMonth + num));
		this.oComboYear.setDynamicKey(oDateLoc.getUTCFullYear());		
		this.oComboMonth.setKey(oDateLoc.getUTCMonth());

		this.currentMonth = oDateLoc.getUTCMonth();
		this.currentYear = oDateLoc.getUTCFullYear();		
		this.load(this);
	},
	
    /**
     * Jumps to the previous month.
     * Does not change the selection.
     */
	back: function(num) {
		if(num == undefined) num = 1;
		if(!this.loaded) return;
		this.destroy();
		var oDateLoc = new Date(Date.UTC(this.currentYear,
		                                 this.currentMonth - num));
		this.oComboYear.setDynamicKey(oDateLoc.getUTCFullYear());
		this.oComboMonth.setKey(oDateLoc.getUTCMonth());
		
		this.currentMonth = oDateLoc.getUTCMonth();
		this.currentYear = oDateLoc.getUTCFullYear();		
		this.load(this);
	},
	
    /**
     * Jumps to the specified month.
     * Does not change the selection.
     */
	go_to: function(oDateLoc) {
		if (!this.loaded) return;
		this.destroy();
		this.set_header(oDateLoc);
		this.currentMonth = oDateLoc.getUTCMonth();
		this.currentYear = oDateLoc.getUTCFullYear();		
		this.load(this);
	},
	
	set_header: function(oDateLoc){
		unregister('OX_Select_MiniMonth',comboMonthChanged);
		unregister('OX_Select_MiniYear',comboYearChanged);
		this.oComboYear.setDynamicKey(oDateLoc.getUTCFullYear());
		this.oComboMonth.setKey(oDateLoc.getUTCMonth());		
		register('OX_Select_MiniMonth',comboMonthChanged);
		register('OX_Select_MiniYear',comboYearChanged);		
	},
	
	load: function(obj) {
		this.oCalendar = new cCalendar(this.currentMonth,this.currentYear);
		if (this.header_month && !this.oComboMonth && !this.oComboYear) {
			this.oComboMonth = new ComboBoxSpecial(
			    window, this.header_month, '7em', this.todayMonth, 
			    false, 'OX_Select_MiniMonth', 6, this
			);
			this.oComboYear = new ComboBoxSpecial(
			    window, this.header_year, '3em', 3, 
				false, 'OX_Select_MiniYear', 6, this
			);
			this.oComboYear.optWidth = "4em";
			this.oComboYear.show_buttons = true;
			for (var nKeyIndx=-3; nKeyIndx < 3; nKeyIndx++){
				this.oComboYear.addElement(noI18n(this.todayYear+nKeyIndx),
				                           this.todayYear+nKeyIndx);
			}
			for (var nKeyIndx=0;nKeyIndx<this.aMonthNames.length;nKeyIndx++) {
				this.oComboMonth.addElement(this.aMonthNames[nKeyIndx], nKeyIndx);
			}
			this.oComboYear.getDomNode();
			this.oComboMonth.getDomNode();
			register('OX_Select_MiniMonth', comboMonthChanged);
			register('OX_Select_MiniYear', comboYearChanged);			
		}
        var oFirstDayDate = new Date(Date.UTC(this.currentYear,
                                              this.currentMonth));
        var oLastDayDate = new Date(Date.UTC(this.currentYear,
                                             this.currentMonth));

		var aDay = this.oCalendar.aWeeks[0].aDays[0];
		var aDay2 = this.oCalendar.aWeeks[(this.oCalendar.aWeeks.length-1)].aDays[6];		

		if (aDay.nCurrMonth == 0) {
			oFirstDayDate.setUTCMonth(oFirstDayDate.getUTCMonth()-1);
		}
		if (aDay2.nCurrMonth == 2) {
			oLastDayDate.setUTCMonth(oLastDayDate.getUTCMonth()+1);
		}
			
		oFirstDayDate.setUTCDate(aDay.nDate);
		oLastDayDate.setUTCDate(aDay2.nDate);

		oLastDayDate.setUTCDate(oLastDayDate.getUTCDate()+1);
		
		if (!this.displayAppointments){
			this.create();
		} else {
			function cb_fkt_mc(cbobjCalendar)  {						
				if (cbobjCalendar && cbobjCalendar.data) {
					obj.appointmentList = cbobjCalendar.data;					
				} else if(cbobjCalendar && cbobjCalendar.error) {
					newServerError(cbobjCalendar,4);
				}
				obj.create();
			}
			this.getCalObjMC(oFirstDayDate,oLastDayDate,cb_fkt_mc);					
		}
	},
	
	getCalObjMC: function(oFirstDayDate,oLastDayDate,callback) {
		var start = oFirstDayDate.getTime();
		var end = oLastDayDate.getTime();		
		var sAjaxRequest = AjaxRoot + "/calendar?action=has&session=" + session +"&start=" + start + "&end=" + end;
		calendarMiniJson.get(sAjaxRequest, null, callback);
	},	
	
    /**
     * Updates the markings of days with appointments, if
     * the bDisplayAppointments parameter to the constructor was true.
     */
	update: function() {
		//TODO
        var oFirstDayDate = new Date(Date.UTC(this.currentYear,
                                              this.currentMonth));
        var oLastDayDate = new Date(Date.UTC(this.currentYear,
                                             this.currentMonth));		
		this.loaded = false;

		var aDay = this.oCalendar.aWeeks[0].aDays[0];
		var aDay2 = this.oCalendar.aWeeks[(this.oCalendar.aWeeks.length-1)].aDays[6];		
		
		if(aDay.nCurrMonth == 0)
			oFirstDayDate.setUTCMonth(oFirstDayDate.getUTCMonth()-1);
		if(aDay2.nCurrMonth == 2)
			oLastDayDate.setUTCMonth(oLastDayDate.getUTCMonth()+1);
			
		oFirstDayDate.setUTCDate(aDay.nDate);
		oLastDayDate.setUTCDate(aDay2.nDate);
		oLastDayDate.setUTCDate(oLastDayDate.getUTCDate()+1);		
		var Self = this;
		function fn_refreshCurrentMiniCal(cbobjCalendar) {
			if (cbobjCalendar && cbobjCalendar.data) {
				Self.appointmentList = cbobjCalendar.data;					
			} else if(cbobjCalendar && cbobjCalendar.error) {
				newServerError(cbobjCalendar);
			}
			Self.refreshView();
		}
		if (this.displayAppointments) {
			this.getCalObjMC(oFirstDayDate,oLastDayDate,fn_refreshCurrentMiniCal);
		}
	},	
	
	refreshView: function() {		
		var nAllDaysCount=0;
		//loop weeks
		for (var indexWeek=0; indexWeek<this.oCalendar.aWeeks.length; indexWeek++){
				var currentWeek = this.oCalendar.aWeeks[indexWeek];
				//loop days
				for (var indexDay=0; indexDay<7; indexDay++) {
					var bAppExist = false;
					if (this.displayAppointments) {
						bAppExist = this.appointmentList[nAllDaysCount];
					}
					var oTD = $2(this.subcontainer.id + 'mc_' + indexWeek + '_' + indexDay);
					oTD.className = removeClass(oTD.className,"font-style-lable");
	 				if(bAppExist) {
	 					oTD.className += " font-style-lable";		 			
	 				}
	 				nAllDaysCount++;
				}
				this.loaded = true;
		}	
	},	
	
	create: function() {
		var oCalminiMain = this.subcontainer;
		oCalminiMain.appendChild(this.getTable());
		this.updateHeaderMini();
	},
	
	getTable: function(oCalObj){
		var Self = this;
		var nAllDaysCount = 0;
		var oTable = newnode("table", {}, { 
			className: "CalMiniMainTable1", 
				cellPadding: 0, cellSpacing: 0, border: 0 });
		this.table = oTable;
		var oTableBody = newnode('tbody');	// IE specific
		var oTRHead = newnode('tr');
		var weekDays = [pgettext("monday", "M"), pgettext("tuesday", "T"),
                        pgettext("wednesday", "W"), pgettext("thursday", "T"),
                        pgettext("friday", "F"), pgettext("saturday", "S"),
                        pgettext("sunday", "S")];
        
		var _nTd = newnode('td', { height:"2em", padding:"0px" });
		oTRHead.appendChild(_nTd);
        if (this.fnKWAction && this.enable_action === true) {
            _nTd.className = "cursorPointer";
            _nTd.appendChild(Self.open_in_calendar);
            _nTd.onclick = function(e) {
                activeDay=1;
	            activeMonth=Self.currentMonth;
	            activeYear=Self.currentYear;
	            Self.setSelectedByDate(activeYear, activeMonth, activeDay);
                ox.UIController.setModule({module: "calendar", folder:"auto", view:"calendar/calendar/week",force: "module"});
            };
        }
        
        for (var i=0; i<weekDays.length; i++) {
            var HeadTD = newnode('td', { height:"2em", padding:"0px" }, 0,
                [addTranslated(weekDays[i])]);
			oTRHead.appendChild(HeadTD);
		}
		oTRHead.className = "miniCalendarTRHead dateCalendarFontSize background-color-additional-content font-style-headline";
		oTableBody.appendChild(oTRHead);
		var locCalObj = (oCalObj != undefined) ? oCalObj : this.oCalendar;
		//loop weeks
		for (var indexWeek=0; indexWeek<locCalObj.aWeeks.length; indexWeek++) {
				var oTR = newnode('tr', { border:"0" });
				var currentWeek = locCalObj.aWeeks[indexWeek];
				var oKWTD = newnode('td', 0, { height:"1.5em", padding:"0px", verticalAlign:"middle",
								className:"miniCalendarTDKW background-color-additional-content font-size-footer border-color-default",
								id:'kw_'+currentWeek.nKW });			
				var KWTDText = document.createTextNode(currentWeek.nKW);							
				oKWTD.appendChild(KWTDText);
				if (!this.enable_action || !this.fnKWAction) {
 					oKWTD.className += " cursorReset";		 			
 				}
				
				if (this.fnKWAction != null) {	
					addDOMEvent(oKWTD, "click", this.fnKWAction);
					
				}
				oTR.appendChild(oKWTD);
				addTMPId(oKWTD);
				//loop days
				for (var indexDay=0; indexDay<7; indexDay++) {
					var bAppExist = false;
					if(this.displayAppointments) {
						var bAppExist = this.appointmentList[nAllDaysCount];
					}
					var oTD = newnode('td', { height:"1.5em", padding:"0px" });
					sID = this.subcontainer.id+'mc_' + indexWeek + '_' + indexDay;				
	 				var cDay = currentWeek.aDays[indexDay];	
					var TDText = document.createTextNode(cDay.nDate);			
	 				oTD.appendChild(TDText);
	 				//save id, date  & appointments info in assoc array
					this.miniCalendarAssoc[sID] = new Array(cDay.nDate, cDay.nCurrMonth, bAppExist, currentWeek.nKW);
	 				if (cDay.nCurrMonth==0 || cDay.nCurrMonth==2) {
						oTD.className = "miniCalendarTDNotCurr dateCalendarFontSize font-color-disabled";
	 				} else {
						oTD.className = "miniCalendarTD dateCalendarFontSize";
	 				}
	 				if (bAppExist) {
	 					oTD.className += " font-style-lable";		 			
	 				}
	 				if (!this.enable_action) {
	 					oTD.className += " cursorReset";		 			
	 				}
	 				
                    var t = Date.UTC(this.currentYear,
                        this.currentMonth + cDay.nCurrMonth - 1, cDay.nDate);
                    
					if (t === Date.UTC(this.todayYear, this.todayMonth,
					                   this.todayDate))
					{
		 				oTD.className += " miniCalendarToday todaySelectionBorder";
		 			
		 			}
					if (t === Date.UTC(this.selectedYear, this.selectedMonth,
					                   this.selectedDate))										
	 				{
	 					oTD.className += ' background-color-PMG-selection-elements';
 						this.selectedID = sID;
	 				}	 				
					oTD.id = sID;
					if (this.actionDBLFN != null) {
						oTD.onselectstart = function() { return false; };
						oTD.style.MozUserSelect = "none";
						oTD.ondblclick = this.actionDBLFN;
					}

					oTD.onclick = this.actionFN;
								
					oTR.appendChild(oTD);
					addTMPId(oTD);
					function fnOver(node) {
						return function(e, dragType, draggedObjects, mouseposition, targetNode) {
							    minicalenable(e,dragType,draggedObjects,mouseposition,targetNode,node);
                                var mynode = e.currentTarget || e.srcElement || false;
								mynode.className += " dndOver";
							};
					}
					function clearOpenNOdeOver(e, dragType, draggedObjects, mouseposition, OutOpen, dropNode) {
						if (dropNode) {
							dropNode.className = removeClass(dropNode.className,'dndOver');
						} else if(e) {
							var mynode = e.currentTarget || e.srcElement || false;
							if (mynode) { 
								mynode.className = removeClass(mynode.className,'dndOver'); 
							}
						}
					}
					if (this.dnd_enabled) {
						var tObj = new Object();
						tObj["mail"] = function (event,dragType,draggedObjects,mouseposition,targetNode,dropNode) {
								clearOpenNOdeOver(event,dragType,draggedObjects,mouseposition,null,dropNode);
								openMailToApp(Self.getDateByID(dropNode.id),draggedObjects.currentObjects,"mail");
						};
						tObj["contacts"] = function (event, dragType, draggedObjects, mouseposition, targetNode, dropNode) {
								clearOpenNOdeOver(event, dragType, draggedObjects, mouseposition, null, dropNode);
								if (draggedObjects && draggedObjects.currentObjects) {
								    OXCache.newRequest(null,"contacts", {
							            objects: draggedObjects.currentObjects,
							            columns: ["folder_id", "id", "display_name", "first_name", "last_name","email1","email2"]
							        }, null, function (daten) {
							            if (!daten || !daten.objects) {
							                return false;
							            }
							            var found = false;
							            for (var i=0; i < daten.objects.length; i++) {
							                var obj = daten.objects[i];
							                if (obj["email1"] || obj["email2"]) {
							                    found = true;
							                    break;
							                }
							                obj = null;
							            }
							            if (found === true) {
							                openMailToApp(Self.getDateByID(dropNode.id), daten.objects, "contacts");
							            }
							        });
							    }
						};
						tObj["calendar"] = function (event,dragType,draggedObjects,mouseposition,targetNode,dropNode) {
							clearOpenNOdeOver(event,dragType,draggedObjects,mouseposition,null,dropNode);
							var collection={};     
							collection.columns = null;
				            collection.objects = [];
				            for (var i in draggedObjects.currentObjects) {
				            	var myObj = draggedObjects.currentObjects[i];
				            	collection.objects.push(
				            			OXCalendarMapping.createKeyFromObject(
					                      { module: "calendar", 
					                        folder_id: myObj.folder || myObj.folder_id, 
					                        id: myObj.id,
					                        recurrence_position: myObj.recurrence_position || 0 }
					                  )
				            	);
				            }
				            OXCache.newRequest(null, "calendar", collection, null,
				                function(daten) {
				                    for (var j in daten.objects) {
				                    	
				                    	var oDate = Self.getDateByID(dropNode.id);
				                    	var myObj = daten.objects[j];
				                    	myObj.start_date = new Date(myObj.start_date);
										myObj.end_date = new Date(myObj.end_date);
										oDate.setUTCHours(myObj.start_date.getUTCHours());
										oDate.setUTCMinutes(myObj.start_date.getUTCMinutes());
										var changes=oDate.getTime()-myObj.start_date.getTime();
										var oDateEnd=new Date(myObj.end_date.getTime()+changes);
										moveAppToNewStart(myObj, oDate, oDateEnd, function () { Self.update(); });
				                    }	
				                },
				                true
				            );
						};
						registerTarget(oTD, tObj,null,null,fnOver(oTD),fnOver(oTD),clearOpenNOdeOver,true);
					}
					nAllDaysCount++;
				}
				oTableBody.appendChild(oTR);
				this.loaded = true;
		}
		//display 6 rows in any case
		for(var indexWeek=0; indexWeek< 6; indexWeek++) {
			var oTR = newnode('tr');
			var oTD = newnode('td', { height:"1.5em", padding:"0px" }, { colspan:"8", className:"miniCalendarTDNotCurr dateCalendarFontSize font-color-disabled minicalendar6thline"});			
			oTD.innerHTML = '&#xa0;';
			oTR.appendChild(oTD);
			oTableBody.appendChild(oTR);
		}
		oTable.appendChild(oTableBody);		
		addTMPId(oTable);		
		return oTable;
	},
	
	/**
	 * Selects the specified day, switching to the appropriate month view if
	 * necessary.
	 * @param {Number} year The year of the day to select.
	 * @param {Number} month The month of the day to select.
	 * @param {Number} day The date of the day to select.
	 */
	setSelectedByDate: function(year, month, day) {
		this.selectedDate = day;
		this.selectedMonth = month;		
		this.selectedYear = year;
		this.selectedTime = Date.UTC(year,month,day);
		this.setUnselected(this.selectedID);
		if (this.selectedYear == this.currentYear && this.selectedMonth == this.currentMonth) {
			for (var sId in this.miniCalendarAssoc) {					
				var nCurrMonthFlag = this.miniCalendarAssoc[sId][1];
				var nDay = this.miniCalendarAssoc[sId][0];
                var t = Date.UTC(this.currentYear,
                    this.currentMonth + nCurrMonthFlag - 1, nDay);
                
                if (t === Date.UTC(this.selectedYear, this.selectedMonth,
                                   this.selectedDate))
				{
					this.selectedID = sId;
					var markTDSelected = $2(sId);
					if(markTDSelected != undefined)
						markTDSelected.className += " background-color-PMG-selection-elements";
					break;
				}
			}
		} else {
			this.go_to(new Date(Date.UTC(this.selectedYear,
			                             this.selectedMonth)));
		}
		calendar_activedate = new Date(this.selectedTime);
	},
	
	/**
	 * Updates the today marking.
	 * Just in case the user was logged in past midnight...
	 */
	setToday: function() {
		var todayDate = new Date(now());
		this.todayDate = todayDate.getUTCDate();
		this.todayMonth = todayDate.getUTCMonth();	
		this.todayYear = todayDate.getUTCFullYear();
		for(var sId in this.miniCalendarAssoc)
		{
			//deselect today selection
			var currDayDate = $2(sId);
			/*
			 * should not happen. however, results in some strange errors if not
			 * set and prevent executing updates within the calender views so we
			 * better check this.
			 */
			if (!currDayDate) {
				return;
			}
			currDayDate.className = removeClass(currDayDate.className,"todaySelectionBorder");
			currDayDate.className = removeClass(currDayDate.className,"miniCalendarToday");			
			
			var nCurrMonthFlag = this.miniCalendarAssoc[sId][1];
			var nDay = this.miniCalendarAssoc[sId][0];
            var t = Date.UTC(this.currentYear,
                this.currentMonth + nCurrMonthFlag - 1, nDay);
            
            if (t === Date.UTC(this.todayYear, this.todayMonth, this.todayDate))
			{
				currDayDate.className += " miniCalendarToday todaySelectionBorder";	
 			} 				 			
		}
	},	
	/**
	 * Selects a day by its internal DOM node ID.
	 * Used by the actionFunction constructor parameter to actually process
	 * the selection.
	 */
	setSelected: function (sId) {
		//deselect
		if (this.selectedID) {
		    this.setUnselected();
		}
		
		//select
		this.selectedID = sId;
        var back = this.miniCalendarAssoc[sId][1];
        var oDateOthMonth = new Date(Date.UTC(this.currentYear,
            this.currentMonth + back - 1, this.miniCalendarAssoc[sId][0]));
        this.selectedMonth = oDateOthMonth.getUTCMonth();
        this.selectedYear = oDateOthMonth.getUTCFullYear();
        this.selectedDate = oDateOthMonth.getUTCDate();
        this.selectedTime = oDateOthMonth.getTime();
		
		jQuery("#" + this.selectedID, this.subcontainer).addClass("background-color-PMG-selection-elements");
		
		if (back==0) {
		    this.back();
		} else if (back==2) {
		    this.next();
		}
	},
	
	/**
	 * Returns the date of the day with the specified internal DOM node ID.
	 * @protected
	 * @param {String} sId The internal DOM node ID of the day.
	 * @type Date
	 * @return A Date object with the date of the specified day and
	 * with the current time of day.
	 */
	getDateByID : function (sId)
	{
        return new Date(Date.UTC(this.currentYear,
            this.currentMonth + this.miniCalendarAssoc[sId][1] - 1,
            this.miniCalendarAssoc[sId][0]));
	},
	/**
	 * Hides the selection temporarily.
	 */
    // Bug: Navigation calls like next/back show the selection again.
	setUnselected: function ()
	{
		var oTD = $2(this.selectedID);
		if(!oTD) return;
		sClassName = oTD.className;
		var aSplited = sClassName.split(' ');
		var sDeseletedClassName = '';
		for(var nInd=0;nInd < aSplited.length;nInd++)
		{
			if(aSplited[nInd].length>0 && aSplited[nInd] != "background-color-PMG-selection-elements")
			{
				sDeseletedClassName += ' '+aSplited[nInd];
			}
		}			
		oTD.className = sDeseletedClassName;
	},
	
	updateHeaderMini: function ()
	{
		//var showHeader = _(this.aMonthNames[this.currentMonth]) + ' ' + this.currentYear;
		//this.header.innerHTML = showHeader;	
	}	
}
fileloaded();
