/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.QNameValue;
import net.sf.saxon.value.ValidationErrorValue;

public final class NotationValue
extends QNameValue {
    public NotationValue(String string, String string2, String string3, NameChecker nameChecker) throws XPathException {
        super(string, string2, string3, nameChecker);
    }

    public AtomicValue convertPrimitive(BuiltInAtomicType builtInAtomicType, boolean bl, XPathContext xPathContext) {
        switch (builtInAtomicType.getPrimitiveType()) {
            case 88: 
            case 513: 
            case 530: 
            case 642: 
            case 643: {
                return super.convertPrimitive(builtInAtomicType, bl, xPathContext);
            }
        }
        ValidationException validationException = new ValidationException("Cannot convert NOTATION to " + builtInAtomicType.getDisplayName());
        validationException.setErrorCode("XPTY0004");
        validationException.setIsTypeError(true);
        return new ValidationErrorValue(validationException);
    }

    public ItemType getItemType(TypeHierarchy typeHierarchy) {
        return Type.NOTATION_TYPE;
    }

    public String toString() {
        return "NOTATION(" + this.getClarkName() + ')';
    }
}

