/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gbase.client;

import com.google.api.gbase.client.GoogleBaseAttributeId;
import com.google.api.gbase.client.GoogleBaseAttributeType;
import com.google.api.gbase.client.GoogleBaseNamespaces;
import com.google.gdata.data.AttributeHelper;
import com.google.gdata.data.Extension;
import com.google.gdata.data.ExtensionDescription;
import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.util.ParseException;
import com.google.gdata.util.XmlParser;
import com.google.gdata.util.common.xml.XmlNamespace;
import com.google.gdata.util.common.xml.XmlWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.xml.sax.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ExtensionDescription.Default(nsAlias="gm", nsUri="http://base.google.com/ns-metadata/1.0", localName="attribute")
public class AttributeHistogram
implements Extension {
    private GoogleBaseAttributeId attributeId;
    private int totalValueCount;
    private final List<UniqueValue> values = new ArrayList<UniqueValue>();

    public AttributeHistogram() {
    }

    public AttributeHistogram(String attributeName, GoogleBaseAttributeType attributeType) {
        this.attributeId = new GoogleBaseAttributeId(attributeName, attributeType);
    }

    public AttributeHistogram(GoogleBaseAttributeId attributeId) {
        this.attributeId = attributeId;
    }

    public String getAttributeName() {
        return this.attributeId.getName();
    }

    public GoogleBaseAttributeType getAttributeType() {
        return this.attributeId.getType();
    }

    public GoogleBaseAttributeId getAttributeId() {
        return this.attributeId;
    }

    public int getTotalValueCount() {
        return this.totalValueCount;
    }

    public List<? extends UniqueValue> getValues() {
        return this.values;
    }

    public List<? extends UniqueValue> getValues(int minimumCount) {
        if (minimumCount <= 0) {
            return this.values;
        }
        ArrayList<UniqueValue> retval = new ArrayList<UniqueValue>(this.values.size());
        for (UniqueValue value : this.values) {
            if (value.getCount() < minimumCount) continue;
            retval.add(value);
        }
        return retval;
    }

    public void addValue(int count, String stringRepresentation) {
        this.values.add(new UniqueValue(count, stringRepresentation));
    }

    public void setTotalValueCount(int count) {
        this.totalValueCount = count;
    }

    public void setAttributeId(String name, GoogleBaseAttributeType type) {
        this.setAttributeId(new GoogleBaseAttributeId(name, type));
    }

    public void setAttributeId(GoogleBaseAttributeId attributeId) {
        this.attributeId = attributeId;
    }

    public void generate(XmlWriter w, ExtensionProfile extProfile) throws IOException {
        if (this.attributeId == null) {
            return;
        }
        ArrayList<XmlWriter.Attribute> attrs = new ArrayList<XmlWriter.Attribute>();
        attrs.add(new XmlWriter.Attribute("name", this.attributeId.getName()));
        if (this.attributeId.getType() != null) {
            attrs.add(new XmlWriter.Attribute("type", this.attributeId.getType().toString()));
        }
        if (this.totalValueCount > 0) {
            attrs.add(new XmlWriter.Attribute("count", Integer.toString(this.totalValueCount)));
        }
        w.startElement((XmlNamespace)GoogleBaseNamespaces.GM, "attribute", attrs, null);
        if (this.values != null) {
            w.startRepeatingElement();
            for (UniqueValue value : this.values) {
                value.generate(w);
            }
            w.endRepeatingElement();
        }
        w.endElement();
    }

    public XmlParser.ElementHandler getHandler(ExtensionProfile extProfile, String namespace, String localName, Attributes attrs) throws ParseException, IOException {
        AttributeHelper helper = new AttributeHelper(attrs);
        GoogleBaseAttributeType type = GoogleBaseAttributeType.getInstance(helper.consume("type", true));
        this.setAttributeId(new GoogleBaseAttributeId(helper.consume("name", true), type));
        this.setTotalValueCount(helper.consumeInteger("count", false, 0));
        helper.assertAllConsumed();
        return new XmlParser.ElementHandler(){

            public XmlParser.ElementHandler getChildHandler(String namespace, String localName, Attributes attrs) throws ParseException, IOException {
                if (namespace.equals("http://base.google.com/ns-metadata/1.0") && localName.equals("value")) {
                    return new AddValueHandler(attrs);
                }
                return super.getChildHandler(namespace, localName, attrs);
            }
        };
    }

    private class AddValueHandler
    extends XmlParser.ElementHandler {
        private final int count;

        private AddValueHandler(Attributes attrs) throws IOException, ParseException {
            AttributeHelper helper = new AttributeHelper(attrs);
            this.count = helper.consumeInteger("count", false, 0);
            helper.assertAllConsumed();
        }

        public void processEndElement() throws ParseException {
            String value = this.value;
            if ("".equals(value)) {
                value = null;
            }
            AttributeHistogram.this.addValue(this.count, value);
        }
    }

    public static class UniqueValue {
        private final int count;
        private final String value;

        private UniqueValue(int count, String value) {
            this.count = count;
            this.value = value;
        }

        public int getCount() {
            return this.count;
        }

        public String getValueAsString() {
            return this.value;
        }

        public String toString() {
            return this.value;
        }

        void generate(XmlWriter w) throws IOException {
            List<XmlWriter.Attribute> attrs = null;
            if (this.count > 0) {
                attrs = Collections.singletonList(new XmlWriter.Attribute("count", Integer.toString(this.count)));
            }
            w.simpleElement((XmlNamespace)GoogleBaseNamespaces.GM, "value", attrs, this.value);
        }
    }
}

