/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Query;
import org.apache.solr.analysis.ReversedWildcardFilter;
import org.apache.solr.analysis.ReversedWildcardFilterFactory;
import org.apache.solr.analysis.TokenFilterFactory;
import org.apache.solr.analysis.TokenizerChain;
import org.apache.solr.common.SolrException;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.schema.TextField;
import org.apache.solr.search.QParser;

public class SolrQueryParser
extends QueryParser {
    protected final IndexSchema schema;
    protected final QParser parser;
    protected final String defaultField;
    private Map<FieldType, ReversedWildcardFilterFactory> leadingWildcards;

    public SolrQueryParser(IndexSchema schema, String defaultField) {
        super(schema.getSolrConfig().luceneMatchVersion, defaultField == null ? schema.getDefaultSearchFieldName() : defaultField, schema.getQueryAnalyzer());
        this.schema = schema;
        this.parser = null;
        this.defaultField = defaultField;
        this.setLowercaseExpandedTerms(false);
        this.setEnablePositionIncrements(true);
        this.setLowercaseExpandedTerms(false);
        this.setAllowLeadingWildcard(true);
    }

    public SolrQueryParser(QParser parser, String defaultField) {
        this(parser, defaultField, parser.getReq().getSchema().getQueryAnalyzer());
    }

    public SolrQueryParser(QParser parser, String defaultField, Analyzer analyzer) {
        super(parser.getReq().getSchema().getSolrConfig().luceneMatchVersion, defaultField, analyzer);
        this.schema = parser.getReq().getSchema();
        this.parser = parser;
        this.defaultField = defaultField;
        this.setLowercaseExpandedTerms(false);
        this.setEnablePositionIncrements(true);
        this.setLowercaseExpandedTerms(false);
        this.setAllowLeadingWildcard(true);
    }

    protected ReversedWildcardFilterFactory getReversedWildcardFilterFactory(FieldType fieldType) {
        ReversedWildcardFilterFactory fac;
        if (this.leadingWildcards == null) {
            this.leadingWildcards = new HashMap<FieldType, ReversedWildcardFilterFactory>();
        }
        if ((fac = this.leadingWildcards.get(fieldType)) == null && this.leadingWildcards.containsKey(fac)) {
            return fac;
        }
        Analyzer a = fieldType.getAnalyzer();
        if (a instanceof TokenizerChain) {
            TokenFilterFactory[] factories;
            TokenizerChain tc = (TokenizerChain)a;
            for (TokenFilterFactory factory : factories = tc.getTokenFilterFactories()) {
                if (!(factory instanceof ReversedWildcardFilterFactory)) continue;
                fac = (ReversedWildcardFilterFactory)factory;
                break;
            }
        }
        this.leadingWildcards.put(fieldType, fac);
        return fac;
    }

    private void checkNullField(String field) throws SolrException {
        if (field == null && this.defaultField == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "no field name specified in query and no default specified via 'df' param");
        }
    }

    protected String analyzeIfMultitermTermText(String field, String part, FieldType fieldType) {
        if (part == null) {
            return part;
        }
        SchemaField sf = this.schema.getFieldOrNull(field);
        if (sf == null || !(fieldType instanceof TextField)) {
            return part;
        }
        return ((TextField)fieldType).analyzeMultiTerm(field, part, ((TextField)fieldType).getMultiTermAnalyzer());
    }

    protected Query getFieldQuery(String field, String queryText, boolean quoted) throws ParseException {
        MagicFieldName magic;
        this.checkNullField(field);
        if (field.charAt(0) == '_' && this.parser != null && null != (magic = MagicFieldName.get(field))) {
            QParser nested = this.parser.subQuery(queryText, magic.subParser);
            return nested.getQuery();
        }
        SchemaField sf = this.schema.getFieldOrNull(field);
        if (sf != null) {
            FieldType ft = sf.getType();
            if (ft instanceof TextField) {
                return super.getFieldQuery(field, queryText, quoted || ((TextField)ft).getAutoGeneratePhraseQueries());
            }
            return sf.getType().getFieldQuery(this.parser, sf, queryText);
        }
        return super.getFieldQuery(field, queryText, quoted);
    }

    protected Query getRangeQuery(String field, String part1, String part2, boolean inclusive) throws ParseException {
        this.checkNullField(field);
        SchemaField sf = this.schema.getField(field);
        return sf.getType().getRangeQuery(this.parser, sf, part1, part2, inclusive, inclusive);
    }

    protected Query getPrefixQuery(String field, String termStr) throws ParseException {
        this.checkNullField(field);
        if (this.getLowercaseExpandedTerms()) {
            termStr = termStr.toLowerCase();
        }
        termStr = this.analyzeIfMultitermTermText(field, termStr, this.schema.getFieldType(field));
        return this.newPrefixQuery(new Term(field, termStr));
    }

    protected Query getWildcardQuery(String field, String termStr) throws ParseException {
        if ("*".equals(field) && "*".equals(termStr)) {
            return this.newMatchAllDocsQuery();
        }
        FieldType fieldType = this.schema.getFieldType(field);
        termStr = this.analyzeIfMultitermTermText(field, termStr, fieldType);
        ReversedWildcardFilterFactory factory = this.getReversedWildcardFilterFactory(fieldType);
        if (factory != null && factory.shouldReverse(termStr)) {
            int len = termStr.length();
            char[] chars = new char[len + 1];
            chars[0] = factory.getMarkerChar();
            termStr.getChars(0, len, chars, 1);
            ReversedWildcardFilter.reverse(chars, 1, len);
            termStr = new String(chars);
        }
        return this.newWildcardQuery(new Term(field, termStr));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MagicFieldName {
        VAL("_val_", "func"),
        QUERY("_query_", null);

        public final String field;
        public final String subParser;
        private static final Map<String, MagicFieldName> lookup;

        private MagicFieldName(String field, String subParser) {
            this.field = field;
            this.subParser = subParser;
        }

        public String toString() {
            return this.field;
        }

        public static MagicFieldName get(String field) {
            return lookup.get(field);
        }

        static {
            lookup = new HashMap<String, MagicFieldName>();
            for (MagicFieldName s : EnumSet.allOf(MagicFieldName.class)) {
                lookup.put(s.toString(), s);
            }
        }
    }
}

