/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl;

import com.hazelcast.cluster.AbstractRemotelyProcessable;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.logging.Level;

public class MergeClusters
extends AbstractRemotelyProcessable {
    private Address newTargetAddress = null;

    public MergeClusters() {
    }

    public MergeClusters(Address newTargetAddress) {
        this.newTargetAddress = newTargetAddress;
    }

    @Override
    public void process() {
        if (this.conn == null) {
            return;
        }
        Address endpoint = this.conn.getEndPoint();
        final Address masterAddress = this.node.getMasterAddress();
        final ILogger logger = this.node.loggingService.getLogger(this.getClass().getName());
        if (endpoint == null || !endpoint.equals(masterAddress)) {
            logger.log(Level.WARNING, "Merge instruction sent from non-master endpoint: " + endpoint);
            return;
        }
        this.node.getExecutorManager().executeNow(new Runnable(){

            @Override
            public void run() {
                logger.log(Level.WARNING, ((MergeClusters)MergeClusters.this).node.address + " is merging to " + MergeClusters.this.newTargetAddress + ", because: instructed by master " + masterAddress);
                MergeClusters.this.node.getJoiner().setTargetAddress(MergeClusters.this.newTargetAddress);
                ((MergeClusters)MergeClusters.this).node.factory.restart();
            }
        });
    }

    @Override
    public void readData(DataInput in) throws IOException {
        super.readData(in);
        this.newTargetAddress = new Address();
        this.newTargetAddress.readData(in);
    }

    @Override
    public void writeData(DataOutput out) throws IOException {
        super.writeData(out);
        this.newTargetAddress.writeData(out);
    }
}

