/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl.management;

import com.hazelcast.impl.management.ThreadDumpGenerator;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.Method;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;

class ThreadDumpGeneratorImpl_16
extends ThreadDumpGenerator {
    private static final String ThreadMXBean_isObjectMonitorUsageSupported = "isObjectMonitorUsageSupported";
    private static final String ThreadMXBean_isSynchronizerUsageSupported = "isSynchronizerUsageSupported";
    private static final String ThreadMXBean_dumpAllThreads = "dumpAllThreads";
    private static final String ThreadMXBean_getThreadInfo = "getThreadInfo";
    private static final String ThreadMXBean_findDeadlockedThreads = "findDeadlockedThreads";
    private static final String ThreadInfo_getLockInfo = "getLockInfo";
    private static final String ThreadInfo_getLockedSynchronizers = "getLockedSynchronizers";
    private static final String ThreadInfo_getLockedMonitors = "getLockedMonitors";
    private static final String MonitorInfo_getLockedStackDepth = "getLockedStackDepth";
    private static final ConcurrentMap<String, Method> methods = new ConcurrentHashMap<String, Method>();

    public ThreadDumpGeneratorImpl_16(ThreadMXBean bean) {
        super(bean);
    }

    @Override
    public ThreadInfo[] getAllThreads() {
        if (ThreadDumpGeneratorImpl_16.booleanCall(this.threadMxBean, ThreadMXBean_isObjectMonitorUsageSupported) && ThreadDumpGeneratorImpl_16.booleanCall(this.threadMxBean, ThreadMXBean_isSynchronizerUsageSupported)) {
            return (ThreadInfo[])ThreadDumpGeneratorImpl_16.parameterizedObjectCall(this.threadMxBean, ThreadMXBean_dumpAllThreads, new Class[]{Boolean.TYPE, Boolean.TYPE}, new Object[]{true, true});
        }
        return super.getAllThreads();
    }

    @Override
    public ThreadInfo[] findDeadlockedThreads() {
        if (ThreadDumpGeneratorImpl_16.booleanCall(this.threadMxBean, ThreadMXBean_isSynchronizerUsageSupported)) {
            long[] tids = (long[])ThreadDumpGeneratorImpl_16.objectCall(this.threadMxBean, ThreadMXBean_findDeadlockedThreads);
            if (tids == null || tids.length == 0) {
                return null;
            }
            return (ThreadInfo[])ThreadDumpGeneratorImpl_16.parameterizedObjectCall(this.threadMxBean, ThreadMXBean_getThreadInfo, new Class[]{long[].class, Boolean.TYPE, Boolean.TYPE}, new Object[]{tids, true, true});
        }
        return super.findDeadlockedThreads();
    }

    @Override
    protected void appendThreadInfo(ThreadInfo info, StringBuilder sb) {
        int n;
        sb.append("\"").append(info.getThreadName()).append("\"").append(" Id=").append(info.getThreadId()).append(" ").append((Object)info.getThreadState());
        if (info.getLockName() != null) {
            sb.append(" on ").append(info.getLockName());
        }
        if (info.getLockOwnerName() != null) {
            sb.append(" owned by \"").append(info.getLockOwnerName()).append("\" Id=").append(info.getLockOwnerId());
        }
        if (info.isSuspended()) {
            sb.append(" (suspended)");
        }
        if (info.isInNative()) {
            sb.append(" (in native)");
        }
        sb.append('\n');
        StackTraceElement[] stackTrace = info.getStackTrace();
        Object lockInfo = ThreadDumpGeneratorImpl_16.objectCall(info, ThreadInfo_getLockInfo);
        Object[] monitorInfo = (Object[])ThreadDumpGeneratorImpl_16.objectCall(info, ThreadInfo_getLockedMonitors);
        int i = 0;
        while (i < stackTrace.length) {
            StackTraceElement ste = stackTrace[i];
            sb.append("\tat ").append(ste.toString());
            sb.append('\n');
            if (i == 0 && lockInfo != null) {
                Thread.State ts = info.getThreadState();
                switch (ts) {
                    case BLOCKED: {
                        sb.append("\t-  blocked on ").append(lockInfo);
                        sb.append('\n');
                        break;
                    }
                    case WAITING: {
                        sb.append("\t-  waiting on ").append(lockInfo);
                        sb.append('\n');
                        break;
                    }
                    case TIMED_WAITING: {
                        sb.append("\t-  waiting on ").append(lockInfo);
                        sb.append('\n');
                    }
                }
            }
            Object[] objectArray = monitorInfo;
            int n2 = monitorInfo.length;
            n = 0;
            while (n < n2) {
                Object mi = objectArray[n];
                Integer depth = (Integer)ThreadDumpGeneratorImpl_16.objectCall(mi, MonitorInfo_getLockedStackDepth);
                if (depth == i) {
                    sb.append("\t-  locked ").append(mi);
                    sb.append('\n');
                }
                ++n;
            }
            ++i;
        }
        Object[] locks = (Object[])ThreadDumpGeneratorImpl_16.objectCall(info, ThreadInfo_getLockedSynchronizers);
        if (locks.length > 0) {
            sb.append("\n\tNumber of locked synchronizers = ").append(locks.length);
            sb.append('\n');
            Object[] objectArray = locks;
            n = locks.length;
            int n3 = 0;
            while (n3 < n) {
                Object li = objectArray[n3];
                sb.append("\t- ").append(li);
                sb.append('\n');
                ++n3;
            }
        }
        sb.append('\n');
    }

    private static boolean booleanCall(Object object, String methodName) {
        Boolean result = (Boolean)ThreadDumpGeneratorImpl_16.objectCall(object, methodName);
        return result != null ? result : false;
    }

    private static <T> T objectCall(Object object, String methodName) {
        return ThreadDumpGeneratorImpl_16.parameterizedObjectCall(object, methodName, null, null);
    }

    private static <T> T parameterizedObjectCall(Object object, String methodName, Class[] types, Object[] params) {
        if (object == null) {
            throw new NullPointerException("Object is mandatory!");
        }
        try {
            Class<?> clazz = object.getClass();
            String mKey = String.valueOf(clazz.getName()) + "." + methodName;
            Method m = (Method)methods.get(mKey);
            if (m == null) {
                m = object.getClass().getMethod(methodName, types);
                m.setAccessible(true);
                Method anotherMethod = methods.putIfAbsent(mKey, m);
                if (anotherMethod != null) {
                    m = anotherMethod;
                }
            }
            return (T)m.invoke(object, params);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "While invoking method[" + methodName + "] of class[" + object.getClass().getName() + "]", e);
            return null;
        }
    }
}

