/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.topic.client;

import com.hazelcast.client.CallableClientRequest;
import com.hazelcast.client.ClientEndpoint;
import com.hazelcast.client.ClientEngine;
import com.hazelcast.client.SecureRequest;
import com.hazelcast.core.Message;
import com.hazelcast.core.MessageListener;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.security.permission.TopicPermission;
import com.hazelcast.topic.TopicPortableHook;
import com.hazelcast.topic.TopicService;
import com.hazelcast.topic.client.PortableMessage;
import java.io.IOException;
import java.security.Permission;

public class AddMessageListenerRequest
extends CallableClientRequest
implements Portable,
SecureRequest {
    private String name;

    public AddMessageListenerRequest() {
    }

    public AddMessageListenerRequest(String name) {
        this.name = name;
    }

    public Object call() throws Exception {
        TopicService service = (TopicService)this.getService();
        final ClientEngine clientEngine = this.getClientEngine();
        final ClientEndpoint endpoint = this.getEndpoint();
        MessageListener listener = new MessageListener(){

            public void onMessage(Message message) {
                if (endpoint.live()) {
                    Data messageData = clientEngine.toData(message.getMessageObject());
                    PortableMessage portableMessage = new PortableMessage(messageData, message.getPublishTime(), message.getPublishingMember().getUuid());
                    clientEngine.sendResponse(endpoint, portableMessage);
                }
            }
        };
        String registrationId = service.addMessageListener(this.name, listener);
        endpoint.setListenerRegistration("hz:impl:topicService", this.name, registrationId);
        return null;
    }

    @Override
    public String getServiceName() {
        return "hz:impl:topicService";
    }

    @Override
    public int getFactoryId() {
        return TopicPortableHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 2;
    }

    @Override
    public void writePortable(PortableWriter writer) throws IOException {
        writer.writeUTF("n", this.name);
    }

    @Override
    public void readPortable(PortableReader reader) throws IOException {
        this.name = reader.readUTF("n");
    }

    @Override
    public Permission getRequiredPermission() {
        return new TopicPermission(this.name, "listen");
    }
}

