/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the OX Software GmbH. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016-2020 OX Software GmbH.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.ant.data;

import java.util.HashSet;
import java.util.Set;


/**
 * {@link JDK}
 *
 * @author <a href="mailto:marcus.klein@open-xchange.com">Marcus Klein</a>
 */
public class JDK {

    private static final Set<String> exports;

    static {
        exports = new HashSet<String>();
        exports.add("javax.accessibility");
        exports.add("javax.activation");
        exports.add("javax.activity");
        exports.add("javax.annotation");
        exports.add("javax.annotation.processing");
        exports.add("javax.crypto");
        exports.add("javax.crypto.interfaces");
        exports.add("javax.crypto.spec");
        exports.add("javax.imageio");
        exports.add("javax.imageio.event");
        exports.add("javax.imageio.metadata");
        exports.add("javax.imageio.plugins.bmp");
        exports.add("javax.imageio.plugins.jpeg");
        exports.add("javax.imageio.spi");
        exports.add("javax.imageio.stream");
        exports.add("javax.jws");
        exports.add("javax.jws.soap");
        exports.add("javax.lang.model");
        exports.add("javax.lang.model.element");
        exports.add("javax.lang.model.type");
        exports.add("javax.lang.model.util");
        exports.add("javax.management");
        exports.add("javax.management.loading");
        exports.add("javax.management.modelmbean");
        exports.add("javax.management.monitor");
        exports.add("javax.management.openmbean");
        exports.add("javax.management.relation");
        exports.add("javax.management.remote");
        exports.add("javax.management.remote.rmi");
        exports.add("javax.management.timer");
        exports.add("javax.naming");
        exports.add("javax.naming.directory");
        exports.add("javax.naming.event");
        exports.add("javax.naming.ldap");
        exports.add("javax.naming.spi");
        exports.add("javax.net");
        exports.add("javax.net.ssl");
        exports.add("javax.print");
        exports.add("javax.print.attribute");
        exports.add("javax.print.attribute.standard");
        exports.add("javax.print.event");
        exports.add("javax.rmi");
        exports.add("javax.rmi.CORBA");
        exports.add("javax.rmi.ssl");
        exports.add("javax.script");
        exports.add("javax.security.auth");
        exports.add("javax.security.auth.callback");
        exports.add("javax.security.auth.kerberos");
        exports.add("javax.security.auth.login");
        exports.add("javax.security.auth.spi");
        exports.add("javax.security.auth.x500");
        exports.add("javax.security.cert");
        exports.add("javax.security.sasl");
        exports.add("javax.sound.midi");
        exports.add("javax.sound.midi.spi");
        exports.add("javax.sound.sampled");
        exports.add("javax.sound.sampled.spi");
        exports.add("javax.sql");
        exports.add("javax.sql.rowset");
        exports.add("javax.sql.rowset.serial");
        exports.add("javax.sql.rowset.spi");
        exports.add("javax.swing");
        exports.add("javax.swing.border");
        exports.add("javax.swing.colorchooser");
        exports.add("javax.swing.event");
        exports.add("javax.swing.filechooser");
        exports.add("javax.swing.plaf");
        exports.add("javax.swing.plaf.basic");
        exports.add("javax.swing.plaf.metal");
        exports.add("javax.swing.plaf.multi");
        exports.add("javax.swing.plaf.synth");
        exports.add("javax.swing.table");
        exports.add("javax.swing.text");
        exports.add("javax.swing.text.html");
        exports.add("javax.swing.text.html.parser");
        exports.add("javax.swing.text.rtf");
        exports.add("javax.swing.tree");
        exports.add("javax.swing.undo");
        exports.add("javax.tools");
        exports.add("javax.transaction");
        exports.add("javax.transaction.xa");
        exports.add("javax.xml");
        exports.add("javax.xml.bind");
        exports.add("javax.xml.bind.annotation");
        exports.add("javax.xml.bind.annotation.adapters");
        exports.add("javax.xml.bind.attachment");
        exports.add("javax.xml.bind.helpers");
        exports.add("javax.xml.bind.util");
        exports.add("javax.xml.crypto");
        exports.add("javax.xml.crypto.dom");
        exports.add("javax.xml.crypto.dsig");
        exports.add("javax.xml.crypto.dsig.dom");
        exports.add("javax.xml.crypto.dsig.keyinfo");
        exports.add("javax.xml.crypto.dsig.spec");
        exports.add("javax.xml.datatype");
        exports.add("javax.xml.namespace");
        exports.add("javax.xml.parsers");
        exports.add("javax.xml.soap");
        exports.add("javax.xml.stream");
        exports.add("javax.xml.stream.events");
        exports.add("javax.xml.stream.util");
        exports.add("javax.xml.transform");
        exports.add("javax.xml.transform.dom");
        exports.add("javax.xml.transform.sax");
        exports.add("javax.xml.transform.stax");
        exports.add("javax.xml.transform.stream");
        exports.add("javax.xml.validation");
        exports.add("javax.xml.ws");
        exports.add("javax.xml.ws.handler");
        exports.add("javax.xml.ws.handler.soap");
        exports.add("javax.xml.ws.http");
        exports.add("javax.xml.ws.soap");
        exports.add("javax.xml.ws.spi");
        exports.add("javax.xml.ws.wsaddressing");
        exports.add("javax.xml.xpath");
        exports.add("org.ietf.jgss");
        exports.add("org.omg.CORBA");
        exports.add("org.omg.CORBA_2_3");
        exports.add("org.omg.CORBA_2_3.portable");
        exports.add("org.omg.CORBA.DynAnyPackage");
        exports.add("org.omg.CORBA.ORBPackage");
        exports.add("org.omg.CORBA.portable");
        exports.add("org.omg.CORBA.TypeCodePackage");
        exports.add("org.omg.CosNaming");
        exports.add("org.omg.CosNaming.NamingContextExtPackage");
        exports.add("org.omg.CosNaming.NamingContextPackage");
        exports.add("org.omg.Dynamic");
        exports.add("org.omg.DynamicAny");
        exports.add("org.omg.DynamicAny.DynAnyFactoryPackage");
        exports.add("org.omg.DynamicAny.DynAnyPackage");
        exports.add("org.omg.IOP");
        exports.add("org.omg.IOP.CodecFactoryPackage");
        exports.add("org.omg.IOP.CodecPackage");
        exports.add("org.omg.Messaging");
        exports.add("org.omg.PortableInterceptor");
        exports.add("org.omg.PortableInterceptor.ORBInitInfoPackage");
        exports.add("org.omg.PortableServer");
        exports.add("org.omg.PortableServer.CurrentPackage");
        exports.add("org.omg.PortableServer.POAManagerPackage");
        exports.add("org.omg.PortableServer.POAPackage");
        exports.add("org.omg.PortableServer.portable");
        exports.add("org.omg.PortableServer.ServantLocatorPackage");
        exports.add("org.omg.SendingContext");
        exports.add("org.omg.stub.java.rmi");
        exports.add("org.w3c.dom");
        exports.add("org.w3c.dom.bootstrap");
        exports.add("org.w3c.dom.css");
        exports.add("org.w3c.dom.events");
        exports.add("org.w3c.dom.html");
        exports.add("org.w3c.dom.ls");
        exports.add("org.w3c.dom.ranges");
        exports.add("org.w3c.dom.stylesheets");
        exports.add("org.w3c.dom.traversal");
        exports.add("org.w3c.dom.views");
        exports.add("org.w3c.dom.xpath");
        exports.add("org.xml.sax");
        exports.add("org.xml.sax.ext");
        exports.add("org.xml.sax.helpers");
    }

    private JDK() {
        super();
    }

    public static boolean exports(final String packageName) {
        return exports.contains(packageName);
    }
}
