/*
 * Decompiled with CFR 0.152.
 */
package de.kippdata.cria.solrext.searchcomponents;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.handler.component.SearchComponent;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.search.QParser;
import org.apache.solr.search.QParserPlugin;

public class SearchFieldSupplier
extends SearchComponent {
    private final String SEARCH_FIELD = "sf";
    private final String DESCRIPTION = "SearchComponent that modifies a query and adds a search field";
    private final String REF = "$Revision: 1.4 $";
    private String searchField;
    private static final Log log = LogFactory.getLog(SearchFieldSupplier.class);

    public void init(NamedList args) {
        this.searchField = args.get("sf").toString();
        if (this.searchField == null || this.searchField.equals("")) {
            log.error((Object)"[init]: No valid search field given.");
            throw new RuntimeException();
        }
        log.info((Object)("[init]: Search field is '" + this.searchField + "'"));
    }

    public String getDescription() {
        return "SearchComponent that modifies a query and adds a search field";
    }

    public String getSource() {
        return null;
    }

    public String getSourceId() {
        return null;
    }

    public String getVersion() {
        return "$Revision: 1.4 $";
    }

    public void prepare(ResponseBuilder rb) throws IOException {
        String queryString;
        log.debug((Object)"[prepare]: Start");
        SolrQueryRequest request = rb.req;
        SolrParams params = request.getParams();
        String defType = params.get("defType");
        defType = defType == null ? QParserPlugin.DEFAULT_QTYPE : defType;
        log.debug((Object)("[prepare]: defType = " + defType));
        if (params.get("q") != null) {
            log.debug((Object)("[prepare]: Transforming formal fields for query " + params.get("q")));
            String[] qTerms = params.get("q").split("\\s+");
            StringBuffer buf = new StringBuffer();
            for (String s : qTerms) {
                if (!(s.contains(":") || s.equalsIgnoreCase("and") || s.equalsIgnoreCase("or"))) {
                    buf.append(this.searchField + ":" + s + " ");
                    continue;
                }
                buf.append(s + " ");
            }
            queryString = buf.toString().trim();
            log.debug((Object)("[prepare]: Transformed query is '" + queryString + "'"));
        } else {
            queryString = "*:* AND NOT (*:*)";
        }
        rb.setQueryString(queryString);
        try {
            log.debug((Object)("[prepare]: query = " + queryString));
            QParser parser = QParser.getParser((String)queryString, (String)defType, (SolrQueryRequest)request);
            rb.setQuery(parser.getQuery());
            rb.setQparser(parser);
            log.debug((Object)("[prepare]: Query to process = " + parser.getQuery().toString()));
        }
        catch (Exception e) {
            log.warn((Object)"[prepare]: ERROR building query");
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, (Throwable)e);
        }
        log.debug((Object)"[prepare]: Done.");
    }

    public void process(ResponseBuilder arg0) throws IOException {
    }
}

